<?xml version="1.0"?>
<!-- 
NAME
    kupdiret.xsl
DESCRIPTION
    XSLT stylesheet for XML => DDL conversion of ku$_rmgr_plan_direct_t ADTs
NOTES
    Do NOT modify this file under any circumstance. Copy the file
    if you wish to use this stylesheet with an external XML/XSL parser

MODIFIED	MM/DD/YY
    rapayne     11/02/05 - Bug 4715313: Reformat with XMLSpy
    htseng      08/02/02 - add grantee parse param
    htseng      07/26/02 - add more parse params
    htseng      04/03/02 - htseng_rmgr_obj_support
    htseng      04/01/02 - change schema_obj to be base_obj.
    htseng	11/15/01 - Creation 
 -->
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
 <!-- Import required scripts -->
 <xsl:import href="kucommon.xsl"/>
 <!-- Top-level parameters -->
 <xsl:param name="PRETTY">1</xsl:param>
 <xsl:param name="SQLTERMINATOR">1</xsl:param>
 <xsl:param name="EXPORT">1</xsl:param>
 <!-- params for parse -->
 <xsl:param name="PRS_DDL">0</xsl:param>
 <xsl:param name="PRS_DELIM">\{]`</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:param name="PRS_VERB">0</xsl:param>
 <xsl:param name="PRS_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_NAME">0</xsl:param>
 <xsl:param name="PRS_GRANTEE">0</xsl:param>
 <xsl:param name="PRS_GRANTOR">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_TYPE">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_SCHEMA">0</xsl:param>
 <xsl:param name="PRS_BASE_OBJECT_NAME">0</xsl:param>
 <xsl:template match="RMGR_PLAN_DIRECT_T">
  <xsl:call-template name="DoParse">
   <xsl:with-param name="Verb">DBMS_RESOURCE_MANAGER.CREATE_PLAN_DIRECTIVE</xsl:with-param>
   <xsl:with-param name="ObjectType">RMGR_PLAN_DIRECTIVE</xsl:with-param>
   <xsl:with-param name="BaseSchemaNode" select="BASE_OBJ/OWNER_NAME"/>
   <xsl:with-param name="BaseNameNode" select="BASE_OBJ/NAME"/>
   <xsl:with-param name="BaseObjectType" select="BASE_OBJ/TYPE"/>
  </xsl:call-template>
  <xsl:text> BEGIN </xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>   DBMS_RESOURCE_MANAGER.CREATE_PLAN_DIRECTIVE(</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>     plan      => '</xsl:text>
  <xsl:value-of select="BASE_OBJ/NAME"/>
  <xsl:text>',</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>     group_or_subplan   => '</xsl:text>
  <xsl:value-of select="GROUP_OR_SUBPLAN"/>
  <xsl:text>',</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:if test="string-length(COMMENTS)!=0">
   <xsl:text>     comment   => '</xsl:text>
   <xsl:value-of select="COMMENTS"/>
   <xsl:text>',</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="CPU_P1!=0">
   <xsl:text>     cpu_p1   => </xsl:text>
   <xsl:value-of select="CPU_P1"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="CPU_P2!=0">
   <xsl:text>     cpu_p2   => </xsl:text>
   <xsl:value-of select="CPU_P2"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="CPU_P3!=0">
   <xsl:text>     cpu_p3   => </xsl:text>
   <xsl:value-of select="CPU_P3"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="CPU_P4!=0">
   <xsl:text>     cpu_p4   => </xsl:text>
   <xsl:value-of select="CPU_P4"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="CPU_P5!=0">
   <xsl:text>     cpu_p5   => </xsl:text>
   <xsl:value-of select="CPU_P5"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="CPU_P6!=0">
   <xsl:text>     cpu_p6   => </xsl:text>
   <xsl:value-of select="CPU_P6"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="CPU_P7!=0">
   <xsl:text>     cpu_p7   => </xsl:text>
   <xsl:value-of select="CPU_P7"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:if test="CPU_P8!=0">
   <xsl:text>     cpu_p8   => </xsl:text>
   <xsl:value-of select="CPU_P8"/>
   <xsl:text>,</xsl:text>
   <xsl:if test="$PRETTY=1">
    <xsl:text>&#xa;</xsl:text>
   </xsl:if>
  </xsl:if>
  <xsl:text>     parallel_degree_limit_p1  => </xsl:text>
  <xsl:value-of select="PARALLEL_DEGREE_LIMIT_P1"/>
  <xsl:text>,</xsl:text>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text>     active_sess_pool_p1 => </xsl:text>
  <xsl:value-of select="ACTIVE_SESS_POOL_P1"/>
  <xsl:text>)</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
  <xsl:if test="$PRETTY=1">
   <xsl:text>&#xa;</xsl:text>
  </xsl:if>
  <xsl:text> END</xsl:text>
  <xsl:if test="$SQLTERMINATOR=1">
   <xsl:text>;</xsl:text>
  </xsl:if>
 </xsl:template>
</xsl:stylesheet>
