package org.jdesktop.animation.timing.triggers;

import java.util.EventListener;
import org.jdesktop.animation.timing.TimingEvent;
import org.jdesktop.animation.timing.TimingListener;
import org.jdesktop.animation.timing.TimingController;

public class TimingTrigger extends Trigger
{

	private class TimingTriggerListener extends TriggerListener implements TimingListener
	{
		TimingTriggerEvent event;
		
		protected TimingTriggerListener(final TimingController timer, final Trigger.TriggerAction action, final TimingTriggerEvent event) {
			super(timer, action);
			this.event = event;
		}
		
		public void timerStarted(final TimingEvent e) {
			if (this.event == TimingTriggerEvent.START) {
				this.pullTrigger();
			}
		}
		
		public void timerStopped(final TimingEvent e) {
			if (this.event == TimingTriggerEvent.STOP) {
				this.pullTrigger();
			}
		}
		
		public void timerRepeated(final TimingEvent e) {
			if (this.event == TimingTriggerEvent.REPEAT) {
				this.pullTrigger();
			}
		}
	}

    public TimingTrigger(final TimingController timer, final TimingController source, final Trigger.TriggerAction action, final TimingTriggerEvent event) {
        this.setupListener(timer, source, action, event);
    }
    
    public TimingTrigger(final TimingController startTimer, final TimingController source, final TimingTriggerEvent event, final TimingController stopTimer) {
        super(startTimer, source, event, stopTimer);
    }
    
    @Override
    protected void setupListener(final TimingController timer, final Object source, final Trigger.TriggerAction action, final TriggerEvent event) {
        try {
            final TimingTrigger.TimingTriggerListener listener = new TimingTrigger.TimingTriggerListener(timer, action, (TimingTriggerEvent)event);
            this.setupListener(source, (EventListener)listener, "addTimingListener", TimingListener.class);
        }
        catch (Exception e) {
            System.out.println("Exception creating timing listener for object " + source + ": " + e);
        }
    }
}