/*
 * Copyright (c) 2018, Oracle and/or its affiliates. All rights reserved.
 * ORACLE PROPRIETARY/CONFIDENTIAL. Use is subject to license terms.
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 *
 */

package com.sun.javafx.embed.swing;

import java.awt.Component;
import java.awt.dnd.DragGestureEvent;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DragSource;
import java.awt.dnd.DropTarget;
import javafx.embed.swing.SwingNode;

public abstract class FXDnDInterop {
    public abstract Component findComponentAt(Object frame, int x, int y,
                                      boolean ignoreEnabled);

    public abstract boolean isCompEqual(Component c, Object frame);

    public abstract int convertModifiersToDropAction(int modifiers,
                                             int supportedActions);

    public abstract Object createDragSourceContext(DragGestureEvent dge);

    public abstract <T extends DragGestureRecognizer> T
        createDragGestureRecognizer(DragSource ds, Component c, int srcActions,
                DragGestureListener dgl);

    public abstract void addDropTarget(DropTarget dt, SwingNode node);

    public abstract void removeDropTarget(DropTarget dt, SwingNode node);

    public abstract void setNode(SwingNode node);
}
