/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.scope.module;

import java.io.InputStream;
import java.util.Iterator;
import oracle.dbtools.common.query.ResultRow;
import oracle.dbtools.common.query.ResultRows;
import oracle.dbtools.common.service.model.Reference;
import oracle.dbtools.common.service.model.Service;
import oracle.dbtools.common.txn.Transaction;
import oracle.dbtools.common.util.CompoundPrincipal;
import oracle.dbtools.common.util.Iterables;
import oracle.dbtools.common.util.Iterators;
import oracle.dbtools.common.util.Transform;
import oracle.dbtools.common.util.TreeReader;
import oracle.dbtools.rt.home.tenants.TenantEntity;
import oracle.dbtools.rt.home.tenants.TenantIdentifier;
import oracle.dbtools.rt.home.tenants.TenantIdentifiers;
import oracle.dbtools.rt.oauth.OAuthProfile;
import oracle.dbtools.rt.resource.collection.FeedItem;
import oracle.dbtools.rt.resource.collection.tenants.TenantEntityCollectionRequestHandler;
import oracle.dbtools.rt.web.RequestEntity;
import oracle.dbtools.rt.web.ResourceDispatcher;
import oracle.dbtools.scope.module.ModuleScope;
import oracle.dbtools.scope.module.ModuleScopeJSONReader;
import oracle.dbtools.scope.module.ModuleScopesProvider;

@Service(provides={ResourceDispatcher.class, ModuleScopesRequestHandler.class})
public class ModuleScopesRequestHandler
extends TenantEntityCollectionRequestHandler {
    @Reference
    private ModuleScopesProvider moduleScopes;

    public ModuleScopesRequestHandler() {
        super(OAuthProfile.MODULE_SCOPE_URI_TEMPLATES, OAuthProfile.OAUTH_MODULE_SCOPE_JSON);
    }

    @Override
    protected TenantIdentifier create(CompoundPrincipal principal, InputStream content) {
        return super.create(principal, content);
    }

    @Override
    protected TreeReader<TenantEntity> entityGraphReader() {
        return new ModuleScopeJSONReader();
    }

    @Override
    protected Iterator<FeedItem> items(Transaction txn, final RequestEntity request) {
        Iterable moduleScopes = this.moduleScopes.entities(txn, request.principal());
        Iterable items = Iterables.transform(moduleScopes, (Transform)new Transform<ModuleScope, FeedItem>(){

            public FeedItem apply(final ModuleScope moduleScope) {
                return new FeedItem(){

                    @Override
                    public String id() {
                        return TenantIdentifiers.string(request.principal(), moduleScope.id());
                    }

                    @Override
                    public ResultRow item() {
                        return ResultRows.row((String[])new String[]{"module", "scope"}, (Object[])new Object[]{moduleScope.moduleName(), moduleScope.scopeName()});
                    }
                };
            }
        });
        return Iterators.alsoClose(items.iterator(), (Object[])new Object[]{moduleScopes});
    }

    @Override
    protected Transaction transaction(CompoundPrincipal principal) {
        return this.moduleScopes.newTransaction(principal);
    }
}

