/*
 * Decompiled with CFR 0.152.
 */
package oracle.dbtools.rt.web;

import oracle.dbtools.apex.ErrorResponses;
import oracle.dbtools.rt.entity.Entity;
import oracle.dbtools.rt.entity.EntityHeader;

public enum HttpStatusCode implements CharSequence
{
    ACCEPTED(202, "Accepted"),
    BAD_GATEWAY(502, "Bad Gateway"),
    BAD_REQUEST(400, "Bad Request"),
    CONFLICT(409, "Conflict"),
    CREATED(201, "Created"),
    EXPECTATION_FAILED(417, "Expectation Failed"),
    FORBIDDEN(403, "Forbidden"),
    FOUND(302, "Found", false),
    GATEWAY_TIMEOUT(504, "Gateway Timeout"),
    GONE(410, "Gone"),
    HTTP_VERSION_NOT_SUPPORTED(505, "HTTP Version Not Supported"),
    INTERNAL_SERVER_ERROR(500, "Internal Server Error"),
    LENGTH_REQUIRED(411, "Length Required"),
    METHOD_NOT_ACCEPTABLE(406, "Not Acceptable"),
    METHOD_NOT_ALLOWED(405, "Method Not Allowed"),
    MOVED_PERMANENTLY(301, "Moved Permanently", false),
    MULTIPLE_CHOICES(300, "Multiple Choices"),
    NO_CONTENT(204, "No Content", false),
    NON_AUTHORITATIVE(203, "Non-Authoritative Information"),
    NOT_FOUND(404, "Not Found"),
    NOT_IMPLEMENTED(501, "Not Implemented"),
    NOT_MODIFIED(304, "Not Modified", false),
    OK(200, "Ok"),
    PARTIAL_CONTENT(206, "Partial Content"),
    PAYMENT_REQUIRED(402, "Payment Required"),
    PRECONDITION_FAILED(412, "Precondition Failed"),
    PROXY_AUTHENTICATION_REQUIRED(407, "Proxy Authentication Required"),
    REQUEST_ENTITY_TOO_LARGE(413, "Request Entity Too Large"),
    REQUEST_TIMEOUT(408, "Request Timeout"),
    REQUESTED_RANGE_NOT_SATISFIABLE(416, "Requested Range Not Satisfiable"),
    RESET_CONTENT(205, "Reset Content"),
    SEE_OTHER(303, "See Other", false),
    SERVICE_UNAVAILABLE(503, "Service Unavailable"),
    TEMPORARY_REDIRECT(307, "Temporary Redirect", false),
    UNAUTHORIZED(401, "Unauthorized"),
    UNSUPPORTED_MEDIA_TYPE(415, "Unsupported Media Type"),
    URI_TOO_LONG(414, "Request-URI Too Long"),
    USE_PROXY(305, "Use Proxy");

    private final boolean hasBody;
    private final String message;
    private final int statusCode;
    private final String statusCodeText;

    private HttpStatusCode(int statusCode, String message) {
        this(statusCode, message, true);
    }

    private HttpStatusCode(int statusCode, String message, boolean hasBody) {
        this.statusCode = statusCode;
        this.statusCodeText = Integer.toString(statusCode);
        this.message = message;
        this.hasBody = hasBody;
    }

    @Override
    public char charAt(int index) {
        return this.statusCodeText.charAt(index);
    }

    public boolean hasBody() {
        return this.hasBody;
    }

    public boolean isError() {
        return ErrorResponses.isError((int)this.statusCode);
    }

    @Override
    public int length() {
        return this.statusCodeText.length();
    }

    public int statusCode() {
        return this.statusCode;
    }

    @Override
    public CharSequence subSequence(int start, int end) {
        return this.statusCodeText.subSequence(start, end);
    }

    @Override
    public String toString() {
        return this.statusCodeText;
    }

    String message() {
        return this.message;
    }

    public static HttpStatusCode statusCode(CharSequence text) {
        if (text == null) {
            return OK;
        }
        int status = oracle.dbtools.http.HttpStatusCode.statusCode((String)text.toString());
        HttpStatusCode statusCode = HttpStatusCode.valueOf(status);
        return statusCode;
    }

    public static HttpStatusCode valueOf(int statusCode) {
        for (HttpStatusCode status : HttpStatusCode.values()) {
            if (status.statusCode() != statusCode) continue;
            return status;
        }
        return null;
    }

    public static HttpStatusCode statusCode(Entity entity) {
        EntityHeader status = entity.headers().header("X-APEX-STATUS-CODE");
        if (status == null) {
            return OK;
        }
        return HttpStatusCode.statusCode(status.value());
    }
}

