/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.dbUI.util.sql;

import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.Enumeration;
import java.util.Locale;
import oracle.bali.dbUI.constraint.DCArithmeticExpression;
import oracle.bali.dbUI.constraint.DCBetweenExpression;
import oracle.bali.dbUI.constraint.DCBinaryExpression;
import oracle.bali.dbUI.constraint.DCBooleanExpression;
import oracle.bali.dbUI.constraint.DCCollectionExpression;
import oracle.bali.dbUI.constraint.DCComparisonExpression;
import oracle.bali.dbUI.constraint.DCConstant;
import oracle.bali.dbUI.constraint.DCExpression;
import oracle.bali.dbUI.constraint.DCUnaryExpression;
import oracle.bali.dbUI.constraint.DCVariable;
import oracle.bali.dbUI.constraint.DataConstraint;
import oracle.bali.dbUI.constraint.FreeFormDataConstraint;
import oracle.bali.dbUI.db.Column;
import oracle.bali.dbUI.db.DataDescriptor;
import oracle.bali.dbUI.db.OuterJoin;
import oracle.bali.dbUI.db.Relationship;
import oracle.bali.dbUI.db.Table;
import oracle.bali.dbUI.db.TableAlias;
import oracle.bali.dbUI.util.Collection;

public class SQLGenerator {
    private static SQLGenerator _sSQLGenerator;
    private OuterJoin[] _outerjoins;

    public static SQLGenerator getSQLGenerator() {
        if (_sSQLGenerator == null) {
            _sSQLGenerator = new SQLGenerator();
        }
        return _sSQLGenerator;
    }

    public String getSQLString(Column[] columns, DataConstraint constraint, Relationship[] relationships, OuterJoin[] outerJoins) {
        StringBuffer buffer = new StringBuffer();
        this._outerjoins = outerJoins;
        this._getSQLString(buffer, columns, relationships, outerJoins);
        Object sql = buffer.toString();
        int sqlLength = buffer.length();
        buffer = new StringBuffer();
        this.getSQLString(buffer, constraint);
        String where = buffer.toString();
        int whereLength = buffer.length();
        if (sqlLength == 0) {
            sql = where;
        } else if (whereLength != 0) {
            sql = columns != null && columns.length > 0 ? (((String)sql).indexOf("WHERE") == -1 ? (String)sql + " WHERE " + where : (String)sql + " AND " + where) : (String)sql + " AND " + where;
        }
        if (((String)sql).length() == 0) {
            return null;
        }
        return sql;
    }

    protected void getSQLString(StringBuffer buffer, DataConstraint constraint) {
        if (constraint == null) {
            return;
        }
        if (constraint instanceof FreeFormDataConstraint) {
            FreeFormDataConstraint sdc = (FreeFormDataConstraint)constraint;
            buffer.append("( ");
            buffer.append(sdc.getString());
            buffer.append(" )");
            return;
        }
        DataConstraint left = null;
        DataConstraint right = null;
        int operand = -1;
        if (constraint instanceof DCExpression) {
            operand = ((DCExpression)constraint).getOperand();
        }
        if (constraint instanceof DCBinaryExpression) {
            DCBinaryExpression binary = (DCBinaryExpression)constraint;
            left = binary.getConstraint(0);
            right = binary.getConstraint(1);
            if (!(left instanceof DCVariable) && right instanceof DCVariable) {
                DataConstraint temp = left;
                left = right;
                right = temp;
            }
        } else if (constraint instanceof DCUnaryExpression) {
            DCUnaryExpression unary = (DCUnaryExpression)constraint;
            left = unary.getConstraint(0);
        }
        if (constraint instanceof DCVariable) {
            this._getVariableValue(buffer, (DCVariable)constraint);
        } else if (constraint instanceof DCConstant) {
            this._getConstantValue(buffer, (DCConstant)constraint);
        } else if (constraint instanceof DCArithmeticExpression) {
            this._getArithmetic(buffer, left, right, operand);
        } else if (constraint instanceof DCBooleanExpression) {
            this._getBoolean(buffer, (DCBooleanExpression)constraint);
        } else if (constraint instanceof DCUnaryExpression) {
            buffer.append("( NOT ");
            this.getSQLString(buffer, left);
            buffer.append(" )");
        } else if (constraint instanceof DCComparisonExpression) {
            this._getComparison(buffer, left, right, operand);
        } else if (constraint instanceof DCCollectionExpression) {
            this._getCollection(buffer, left, right, operand);
        } else if (constraint instanceof DCBetweenExpression) {
            this._getBetween(buffer, (DCBetweenExpression)constraint);
        }
    }

    private void _getArithmetic(StringBuffer buffer, DataConstraint leftConstraint, DataConstraint rightConstraint, int operand) {
        buffer.append("( ");
        this.getSQLString(buffer, leftConstraint);
        switch (operand) {
            case 1: {
                buffer.append(" + ");
                break;
            }
            case 2: {
                buffer.append(" - ");
                break;
            }
            case 3: {
                buffer.append(" * ");
                break;
            }
            case 4: {
                buffer.append(" / ");
            }
        }
        this.getSQLString(buffer, rightConstraint);
        buffer.append(" )");
    }

    private void _getBoolean(StringBuffer buffer, DCBooleanExpression e) {
        buffer.append("( ");
        int operand = e.getOperand();
        String cond = operand == 1 ? " AND " : " OR ";
        int count = e.getConstraintCount();
        for (int i = 0; i < count - 1; ++i) {
            this.getSQLString(buffer, e.getConstraint(i));
            buffer.append(cond);
        }
        this.getSQLString(buffer, e.getConstraint(count - 1));
        buffer.append(" )");
    }

    private void _getBetween(StringBuffer buffer, DCBetweenExpression e) {
        int operand = e.getOperand();
        String cond = operand == 1 ? " BETWEEN " : " NOT BETWEEN ";
        buffer.append("( ");
        this.getSQLString(buffer, e.getCheckConstraint());
        buffer.append(cond);
        this.getSQLString(buffer, e.getFirstConstraint());
        buffer.append(" AND ");
        this.getSQLString(buffer, e.getSecondConstraint());
        buffer.append(" )");
    }

    private void _getComparison(StringBuffer buffer, DataConstraint leftConstraint, DataConstraint rightConstraint, int operand) {
        buffer.append("( ");
        this.getSQLString(buffer, leftConstraint);
        boolean isNull = false;
        boolean addQuote = false;
        if (rightConstraint instanceof DCConstant) {
            Object value = ((DCConstant)rightConstraint).getValue();
            if (value == null) {
                isNull = true;
            } else if (value instanceof String) {
                addQuote = true;
            }
        }
        switch (operand) {
            case 1: {
                buffer.append(" > ");
                break;
            }
            case 2: {
                buffer.append(" < ");
                break;
            }
            case 3: {
                buffer.append(isNull ? " IS " : " = ");
                break;
            }
            case 4: {
                buffer.append(isNull ? " IS NOT " : " <> ");
                break;
            }
            case 5: {
                buffer.append(" >= ");
                break;
            }
            case 6: {
                buffer.append(" <= ");
            }
        }
        if (addQuote) {
            buffer.append("'");
        }
        this.getSQLString(buffer, rightConstraint);
        if (addQuote) {
            buffer.append("'");
        }
        buffer.append(" )");
    }

    private void _getCollection(StringBuffer buffer, DataConstraint leftConstraint, DataConstraint rightConstraint, int operand) {
        boolean addNot;
        boolean bl = addNot = operand == 2 || operand == 4 || operand == 6;
        if (addNot) {
            buffer.append("( NOT ");
        } else {
            buffer.append("( ");
        }
        this.getSQLString(buffer, leftConstraint);
        switch (operand) {
            case 1: {
                buffer.append(" LIKE '");
                this.getSQLString(buffer, rightConstraint);
                buffer.append("%')");
                break;
            }
            case 2: {
                buffer.append(" LIKE '");
                this.getSQLString(buffer, rightConstraint);
                buffer.append("%')");
                break;
            }
            case 3: {
                buffer.append(" LIKE '%");
                this.getSQLString(buffer, rightConstraint);
                buffer.append("')");
                break;
            }
            case 4: {
                buffer.append(" LIKE '%");
                this.getSQLString(buffer, rightConstraint);
                buffer.append("')");
                break;
            }
            case 5: 
            case 6: {
                if (!(rightConstraint instanceof DCConstant)) break;
                Object value = ((DCConstant)rightConstraint).getValue();
                if (value instanceof String) {
                    buffer.append(" LIKE '%");
                    this.getSQLString(buffer, rightConstraint);
                    buffer.append("%')");
                    break;
                }
                if (!(value instanceof Collection)) break;
                buffer.append(" IN ");
                this.getSQLString(buffer, rightConstraint);
                buffer.append(" )");
            }
        }
    }

    private boolean _isColumnInOuterJoin(Column column) {
        if (this._outerjoins == null) {
            return false;
        }
        for (int i = 0; i < this._outerjoins.length; ++i) {
            if (this._outerjoins[i].getDestination() != column.getTable()) continue;
            return true;
        }
        return false;
    }

    private void _getVariableValue(StringBuffer buffer, DCVariable variable) {
        if (variable == null) {
            return;
        }
        Object v = variable.getVariable();
        if (v instanceof Column) {
            Column c = (Column)v;
            if (!(c.getTable() instanceof TableAlias)) {
                buffer.append(this._getQuotedString(c.getTable().getSchema().getName()));
                buffer.append(".");
            }
            buffer.append(this._getQuotedString(c.getTable().getName()));
            buffer.append(".");
            buffer.append(this._getQuotedString(c.getName()));
            if (this._isColumnInOuterJoin(c)) {
                buffer.append(" (+)");
            }
        } else if (v instanceof DataDescriptor) {
            DataDescriptor d = (DataDescriptor)v;
            buffer.append(d.getName());
        } else if (v != null) {
            buffer.append(v.toString());
        }
    }

    private void _getConstantValue(StringBuffer buffer, DCConstant constant) {
        if (constant == null) {
            return;
        }
        Object value = constant.getValue();
        if (value == null) {
            buffer.append("NULL");
            return;
        }
        if (value instanceof Collection) {
            Enumeration enumer = ((Collection)value).getEnumeration();
            StringBuffer temp = new StringBuffer();
            temp.append("( ");
            while (enumer.hasMoreElements()) {
                temp.append("'");
                temp.append(enumer.nextElement().toString());
                temp.append("', ");
            }
            Object s = temp.toString();
            int index = ((String)s).lastIndexOf(44);
            s = index != -1 ? ((String)s).substring(0, index) + " )" : (String)s + " )";
            buffer.append((String)s);
        } else if (value instanceof Time) {
            SimpleDateFormat f = new SimpleDateFormat("hh:mm:ss");
            buffer.append("'");
            buffer.append(f.format(value));
            buffer.append("'");
        } else if (value instanceof Timestamp) {
            SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy");
            buffer.append("'");
            buffer.append(f.format(value));
            buffer.append("'");
        } else if (value instanceof Date || value instanceof java.util.Date) {
            SimpleDateFormat f = new SimpleDateFormat("dd-MMM-yyyy");
            buffer.append("'");
            buffer.append(f.format(value));
            buffer.append("'");
        } else if (value instanceof String) {
            buffer.append(value.toString());
        } else {
            buffer.append("'");
            buffer.append(value.toString());
            buffer.append("'");
        }
    }

    private void _getRelationshipString(StringBuffer buffer, Relationship[] joins, OuterJoin[] outerjoins) {
        if (joins == null) {
            return;
        }
        StringBuffer temp = new StringBuffer();
        int outerJoinCount = outerjoins == null ? 0 : outerjoins.length;
        for (int i = 0; i < joins.length; ++i) {
            boolean outerJoinOnChild = false;
            boolean outerJoinOnParent = false;
            Relationship join = joins[i];
            int columnCount = join.getColumnCount();
            for (int j = 0; j < columnCount; ++j) {
                Column column = join.getColumn(j);
                Table table = column.getTable();
                Column parent = join.getReferencedColumn(j);
                Table parentTable = parent.getTable();
                int type = join.getRelationshipType();
                if (outerJoinCount > 0) {
                    for (int o = 0; o < outerJoinCount; ++o) {
                        if (outerjoins[o].getSource().equals(table) && outerjoins[o].getDestination().equals(parentTable)) {
                            outerJoinOnParent = true;
                            continue;
                        }
                        if (!outerjoins[o].getSource().equals(parentTable) || !outerjoins[o].getDestination().equals(table)) continue;
                        outerJoinOnChild = true;
                    }
                }
                temp.append("( ");
                if (!(table instanceof TableAlias)) {
                    temp.append(this._getQuotedString(table.getSchema().getName()));
                    temp.append(".");
                }
                temp.append(this._getQuotedString(table.getName()));
                temp.append(".");
                temp.append(this._getQuotedString(column.getName()));
                if (outerJoinOnChild) {
                    temp.append(" (+)");
                }
                this._getTypeString(temp, type);
                if (!(parentTable instanceof TableAlias)) {
                    temp.append(this._getQuotedString(parentTable.getSchema().getName()));
                    temp.append(".");
                }
                temp.append(this._getQuotedString(parentTable.getName()));
                temp.append(".");
                temp.append(this._getQuotedString(parent.getName()));
                if (outerJoinOnParent) {
                    temp.append(" (+)");
                }
                temp.append(" ) AND ");
            }
        }
        String s = temp.toString();
        int index = s.lastIndexOf(" AND ");
        if (index != -1) {
            s = s.substring(0, index);
        }
        buffer.append(s);
    }

    private void _getTypeString(StringBuffer buffer, int type) {
        switch (type) {
            case 0: {
                buffer.append(" = ");
                break;
            }
            case 1: {
                buffer.append(" <> ");
                break;
            }
            case 2: {
                buffer.append(" > ");
                break;
            }
            case 3: {
                buffer.append(" < ");
                break;
            }
            case 5: {
                buffer.append(" >= ");
                break;
            }
            case 4: {
                buffer.append(" <= ");
                break;
            }
        }
    }

    private void _getSQLString(StringBuffer buffer, Column[] columns, Relationship[] joins, OuterJoin[] outerJoins) {
        String fromStr;
        String selectStr;
        int index;
        Object tableName;
        Table table;
        Column column;
        int i;
        if (columns == null || columns.length == 0) {
            return;
        }
        StringBuffer select = new StringBuffer();
        StringBuffer from = new StringBuffer();
        for (i = 0; i < columns.length; ++i) {
            String fullTableName;
            TableAlias alias;
            column = columns[i];
            table = column.getTable();
            TableAlias tableAlias = alias = table instanceof TableAlias ? (TableAlias)table : null;
            if (alias != null) {
                fullTableName = this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(alias.getTable().getName()) + " " + this._getQuotedString(alias.getName());
                tableName = this._getQuotedString(alias.getName());
            } else {
                fullTableName = this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(table.getName());
                tableName = fullTableName;
            }
            if (from.toString().indexOf(fullTableName) == -1) {
                from.append(fullTableName);
                from.append(", ");
            }
            String shortName = column.getName();
            String columnName = (String)tableName + "." + this._getQuotedString(shortName);
            String displayName = column.getDisplayName(Locale.getDefault());
            if (shortName.equals(displayName)) {
                select.append(columnName);
                select.append(", ");
                continue;
            }
            select.append(columnName);
            select.append(" as ");
            select.append(this._getQuotedString(displayName));
            select.append(", ");
        }
        if (joins != null) {
            for (i = 0; i < joins.length; ++i) {
                Relationship join = joins[i];
                column = join.getColumn(0);
                table = column.getTable();
                tableName = table instanceof TableAlias ? this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(((TableAlias)table).getTable().getName()) + " " + this._getQuotedString(table.getName()) : this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(table.getName());
                if (from.toString().indexOf((String)tableName) == -1) {
                    from.append((String)tableName);
                    from.append(", ");
                }
                tableName = (table = (column = join.getReferencedColumn(0)).getTable()) instanceof TableAlias ? this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(((TableAlias)table).getTable().getName()) + " " + this._getQuotedString(table.getName()) : this._getQuotedString(table.getSchema().getName()) + "." + this._getQuotedString(table.getName());
                if (from.toString().indexOf((String)tableName) != -1) continue;
                from.append((String)tableName);
                from.append(", ");
            }
        }
        if ((index = (selectStr = select.toString()).lastIndexOf(44)) != -1) {
            selectStr = selectStr.substring(0, index);
        }
        if ((index = (fromStr = from.toString()).lastIndexOf(44)) != -1) {
            fromStr = fromStr.substring(0, index);
        }
        if (selectStr != "") {
            buffer.append("SELECT ");
            buffer.append(selectStr);
            buffer.append(" FROM ");
            buffer.append(fromStr);
        }
        StringBuffer where = new StringBuffer();
        if (fromStr.indexOf(44) != -1) {
            this._getRelationshipString(where, joins, outerJoins);
        }
        if (buffer.length() == 0) {
            buffer.append(where);
        } else if (where.length() != 0) {
            buffer.append(" WHERE ");
            buffer.append(where.toString());
        }
    }

    private String _getQuotedString(String s) {
        return "\"" + s + "\"";
    }

    protected SQLGenerator() {
    }
}

