/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.library;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import oracle.ide.model.Project;
import oracle.ide.model.ProjectChangeEvent;
import oracle.ide.model.ProjectChangeListener;
import oracle.ide.net.URLPath;
import oracle.javatools.data.ChangeInfo;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.jdeveloper.library.JLibrary;
import oracle.jdeveloper.library.JLibraryManager;
import oracle.jdeveloper.library.ProjectLibraryChangeEvent;
import oracle.jdeveloper.library.ProjectLibraryChangeListener;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.model.TechnologySpecificSupportProvider;
import oracle.jdevimpl.library.LibraryChangeListenerHandler;

public class ProjectChangeSink
extends ProjectChangeListener {
    private final LibraryChangeListenerHandler libraryListenerHandler;
    private static final String ID_PROPERTY = "id";
    private HashMap<Integer, LinkedHashSet<URL>> projects = new HashMap();

    public ProjectChangeSink() {
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/internalDefinitions/libraryDefinitions", (ProjectChangeListener)this);
        Project.addProjectChangeListener((String)"oracle.jdevimpl.config.JProjectLibraries/libraryReferences", (ProjectChangeListener)this);
        this.libraryListenerHandler = new LibraryChangeListenerHandler();
    }

    public void projectClosed(Project project) {
        this.libraryListenerHandler.fireProjectClosed(project);
        this.projects.remove(ProjectChangeSink.getHashKey(project));
        super.projectClosed(project);
    }

    public void projectOpened(Project project) {
        this.libraryListenerHandler.fireProjectOpened(project);
        this.updateCachedClasspath(project);
        super.projectOpened(project);
    }

    private static final Integer getHashKey(Project project) {
        return System.identityHashCode(project);
    }

    private void updateCachedClasspath(Project project) {
        Integer projKey = ProjectChangeSink.getHashKey(project);
        URLPath path = ProjectChangeSink.getRunLibraryPath(project);
        if (path == null) {
            this.projects.remove(projKey);
            return;
        }
        LinkedHashSet currPath = new LinkedHashSet(path.asList());
        this.projects.put(projKey, currPath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void projectPropertiesChanged(ProjectChangeEvent e) {
        Project proj = e.getProject();
        if (proj == null) {
            return;
        }
        try {
            HashSet oldPath;
            LinkedHashMap<String, Integer> delLibs = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> addLibs = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> dels = new LinkedHashMap<String, Integer>();
            LinkedHashMap<String, Integer> adds = new LinkedHashMap<String, Integer>();
            this.processChangeInfos(e.getChangeDetails(), dels, adds, delLibs, addLibs);
            Set<URL> delUrls = this.getClasspathUrls(delLibs.keySet());
            Set<URL> addUrls = this.getClasspathUrls(addLibs.keySet());
            ArrayList<URL> additions = new ArrayList<URL>();
            ArrayList<URL> removals = new ArrayList<URL>();
            for (String str : dels.keySet()) {
                delUrls.add(this.newURL(str));
            }
            for (String str : adds.keySet()) {
                addUrls.add(this.newURL(str));
            }
            if (delUrls.size() > 0) {
                HashSet<URL> newDelUrls = new HashSet<URL>(delUrls.size());
                HashSet currPath = new HashSet(ProjectChangeSink.getRunLibraryPath(proj).asList());
                for (URL url : delUrls) {
                    removals.add(url);
                    if (currPath.contains(url)) continue;
                    newDelUrls.add(url);
                }
                if (newDelUrls.size() != delUrls.size()) {
                    delUrls = newDelUrls;
                }
            }
            if (addUrls.size() > 0 && (oldPath = (HashSet)this.projects.get(ProjectChangeSink.getHashKey(proj))) != null) {
                LinkedHashSet<URL> newAddUrls = new LinkedHashSet<URL>(addUrls.size());
                for (URL url : addUrls) {
                    additions.add(url);
                    if (oldPath.contains(url)) continue;
                    newAddUrls.add(url);
                }
                if (newAddUrls.size() != addUrls.size()) {
                    addUrls = newAddUrls;
                }
            }
            if (additions.size() > 0 || removals.size() > 0) {
                this.libraryListenerHandler.fireLibraryChangeEvent(new ProjectLibraryChangeEvent(proj, new HashSet<URL>(), additions, removals, addUrls, delUrls, addLibs, delLibs));
            }
        }
        finally {
            this.updateCachedClasspath(proj);
        }
    }

    private Set<URL> getClasspathUrls(Collection<String> libIds) {
        LinkedHashSet<URL> set = new LinkedHashSet<URL>();
        for (String id : libIds) {
            JLibrary lib = null;
            try {
                if (id.indexOf(58) != -1) {
                    lib = JLibraryManager.findLibrary(new URL(id));
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (lib == null) {
                lib = JLibraryManager.findLibrary(id);
            }
            if (lib == null || lib.getClassPath() == null) continue;
            set.addAll(lib.getClassPath().asList());
        }
        return set;
    }

    private void processChangeInfos(ChangeInfo[] infos, Map<String, Integer> dels, Map<String, Integer> adds, Map<String, Integer> delLibs, Map<String, Integer> addLibs) {
        block5: for (int i = 0; i < infos.length; ++i) {
            ChangeInfo info = infos[i];
            String[] split = info.getPropertyName().split("/");
            switch (split.length) {
                case 6: {
                    if (!"classPath".equals(split[4])) continue block5;
                    if (3 == info.getChangeType()) {
                        this.removal(info.getOldValueAsString(), dels);
                        continue block5;
                    }
                    if (1 != info.getChangeType()) continue block5;
                    this.addition(info.getNewValueAsString(), dels, adds);
                    continue block5;
                }
                case 4: {
                    this.processClasspathHash(info, dels, adds);
                    continue block5;
                }
                case 3: {
                    this.processReferenceChange(info, delLibs, addLibs);
                    continue block5;
                }
            }
        }
    }

    private void processReferenceChange(ChangeInfo info, Map<String, Integer> delLibs, Map<String, Integer> addLibs) {
        if (3 == info.getChangeType()) {
            HashStructure hash = info.getOldValueAsHashStructure();
            String id = null;
            if (hash != null) {
                id = hash.getString(ID_PROPERTY);
            }
            if (this.mayBeOfInterest(id).booleanValue()) {
                this.removal(id, delLibs);
            }
        } else if (1 == info.getChangeType()) {
            HashStructure hash = info.getNewValueAsHashStructure();
            String id = null;
            if (hash != null) {
                id = hash.getString(ID_PROPERTY);
            }
            if (this.mayBeOfInterest(id).booleanValue()) {
                this.addition(id, delLibs, addLibs);
            }
        }
    }

    protected Boolean mayBeOfInterest(String libraryId) {
        return true;
    }

    private void processClasspathHash(ChangeInfo info, Map<String, Integer> dels, Map<String, Integer> adds) {
        block7: {
            block6: {
                if (3 != info.getChangeType()) break block6;
                HashStructure hash = info.getOldValueAsHashStructure();
                Object o = null;
                if (hash != null) {
                    o = hash.getObject("classPath");
                }
                if (!(o instanceof ListStructure)) break block7;
                ListStructure list = (ListStructure)o;
                for (Object oo : list) {
                    if (!(oo instanceof URL)) continue;
                    this.removal(oo.toString(), dels);
                }
                break block7;
            }
            if (1 == info.getChangeType()) {
                HashStructure hash = info.getNewValueAsHashStructure();
                Object o = null;
                if (hash != null) {
                    o = hash.getObject("classPath");
                }
                if (o instanceof ListStructure) {
                    ListStructure list = (ListStructure)o;
                    for (Object oo : list) {
                        if (!(oo instanceof URL)) continue;
                        this.addition(oo.toString(), dels, adds);
                    }
                }
            }
        }
    }

    private void removal(String key, Map<String, Integer> dels) {
        Integer cnt = dels.get(key);
        cnt = cnt == null ? Integer.valueOf(1) : Integer.valueOf(cnt + 1);
        dels.put(key, cnt);
    }

    private void addition(String key, Map<String, Integer> dels, Map<String, Integer> adds) {
        Integer cnt = dels.get(key);
        if (cnt != null) {
            if (cnt == 1) {
                dels.remove(key);
            } else {
                cnt = cnt - 1;
                dels.put(key, cnt);
            }
        } else {
            cnt = adds.get(key);
            if (cnt == null) {
                adds.put(key, 1);
            } else {
                cnt = cnt + 1;
                adds.put(key, cnt);
            }
        }
    }

    private URL newURL(String strUrl) {
        try {
            return new URL(strUrl);
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(strUrl, e);
        }
    }

    public static URLPath getRunLibraryPath(Project project) {
        URLPath classPath = PathsConfiguration.getInstance(project).getRunClassPath(false, true);
        for (TechnologySpecificSupportProvider provider : PathsConfiguration.getSupportProviders()) {
            URL outputDir = provider.getProjectOutputDirectory(project);
            if (outputDir == null) continue;
            classPath.remove(outputDir);
            break;
        }
        return classPath;
    }

    public void fireLibraryChangeEvent(ProjectLibraryChangeEvent libChangeEvent) {
        this.libraryListenerHandler.fireLibraryChangeEvent(libChangeEvent);
    }

    public void removeListener(ProjectLibraryChangeListener libraryChangeListener) {
        this.libraryListenerHandler.removeListener(libraryChangeListener);
    }

    public void addListener(ProjectLibraryChangeListener libraryChangeListener) {
        this.libraryListenerHandler.addListener(libraryChangeListener);
    }
}

