/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin.wizard;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Collection;
import java.util.Iterator;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.SwingUtilities;
import oracle.bali.ewt.spinBox.NumericSpinBox;
import oracle.bali.share.nls.StringUtils;
import oracle.bali.xml.addin.XMLSchemaBasedWizard;
import oracle.bali.xml.addin.wizard.BaseWizardPage;
import oracle.bali.xml.addin.wizard.SchemaBasedModel;
import oracle.bali.xml.addin.wizard.SchemaBasedModelListener;
import oracle.bali.xml.grammar.ElementDef;
import oracle.bali.xml.grammar.Grammar;
import oracle.bali.xml.grammar.GrammarProvider;
import oracle.bali.xml.gui.swing.util.UIUtils;
import oracle.bali.xml.share.FastMessageFormat;
import oracle.ide.Context;
import oracle.ide.util.IdeUtil;

public class SchemaBasedCustomizerPage
extends BaseWizardPage
implements ItemListener,
ActionListener {
    private static final String UTF8ACTION = "utf8Button";
    private static final String UTF16ACTION = "utf16Button";
    private static final String DEFAULT_ENCODING_ACTION = "DefaultEncodingAction";
    private static final String UTF8ENCODING = "UTF-&8";
    private static final String UTF16ENCODING = "UTF-&16";
    private JComboBox _grammars;
    private JComboBox _elementDef;
    private NumericSpinBox _depth;
    private JCheckBox _reqElems;
    private DefaultComboBoxModel _grammarModel;
    private DefaultComboBoxModel _elementDefModel;

    public SchemaBasedCustomizerPage(Context context, SchemaBasedModel model) {
        super(context, model);
        model.addListener(new CustomizerSchemaBasedModelListener());
    }

    public String getPageTitle() {
        return XMLSchemaBasedWizard.getResource("SCHEMAWIZ.CUSTOMIZER_TITLE");
    }

    @Override
    protected Component getPageComponent() {
        Box pane = Box.createVerticalBox();
        JPanel leftAlignLabelPane = new JPanel(new BorderLayout());
        JLabel l = new JLabel();
        Object text = "<html>" + XMLSchemaBasedWizard.getResource("SCHEMAWIZ.CUSTOMIZER_INSTR") + "</html>";
        l.setText((String)text);
        pane.add(leftAlignLabelPane);
        leftAlignLabelPane.add(l);
        pane.add(Box.createVerticalStrut(5));
        Container masterPane = UIUtils.createLabelFieldContainer();
        JPanel leftAlignMasterPane = new JPanel(new BorderLayout());
        leftAlignMasterPane.add(masterPane);
        pane.add(leftAlignMasterPane);
        this._grammarModel = new DefaultComboBoxModel();
        this._elementDefModel = new DefaultComboBoxModel();
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.TARGET_NAMESPACE");
        JLabel grammarLabel = new JLabel(StringUtils.stripMnemonic((String)text));
        grammarLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._grammars = new JComboBox(this._grammarModel);
        this._grammars.setRenderer(new GrammarComponentCellRenderer());
        this._grammars.addItemListener(this);
        grammarLabel.setLabelFor(this._grammars);
        masterPane.add(grammarLabel);
        masterPane.add(this._grammars);
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ROOT_ELEMENT");
        JLabel elementLabel = new JLabel(StringUtils.stripMnemonic((String)text));
        elementLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._elementDef = new JComboBox(this._elementDefModel);
        this._elementDef.setRenderer(new GrammarComponentCellRenderer());
        elementLabel.setLabelFor(this._elementDef);
        masterPane.add(elementLabel);
        masterPane.add(this._elementDef);
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.DEPTH");
        JLabel depthLabel = new JLabel(StringUtils.stripMnemonic((String)text));
        depthLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        this._depth = new NumericSpinBox(1, 8);
        this._depth.setIntValue(3);
        depthLabel.setLabelFor((Component)this._depth);
        masterPane.add(depthLabel);
        masterPane.add((Component)this._depth);
        JLabel encodingLabel = new JLabel(XMLSchemaBasedWizard.getResource("SCHEMAWIZ.ENCODING"));
        JRadioButton utf8Button = new JRadioButton(StringUtils.stripMnemonic((String)UTF8ENCODING));
        utf8Button.setMnemonic(StringUtils.getMnemonicKeyCode((String)UTF8ENCODING));
        utf8Button.setActionCommand(UTF8ACTION);
        utf8Button.setSelected(true);
        JRadioButton utf16Button = new JRadioButton(StringUtils.stripMnemonic((String)UTF16ENCODING));
        utf16Button.setMnemonic(StringUtils.getMnemonicKeyCode((String)UTF16ENCODING));
        utf16Button.setActionCommand(UTF16ACTION);
        String defaultEncodingLabel = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.DEFAULT_ENCODING");
        defaultEncodingLabel = FastMessageFormat.formatMessage((String)defaultEncodingLabel, (String)IdeUtil.getIdeIanaEncoding());
        JRadioButton jdevDefaultEncoding = new JRadioButton(StringUtils.stripMnemonic((String)defaultEncodingLabel));
        jdevDefaultEncoding.setMnemonic(StringUtils.getMnemonicKeyCode((String)defaultEncodingLabel));
        jdevDefaultEncoding.setActionCommand(DEFAULT_ENCODING_ACTION);
        ButtonGroup radioGroup = new ButtonGroup();
        radioGroup.add(utf8Button);
        radioGroup.add(utf16Button);
        radioGroup.add(jdevDefaultEncoding);
        utf8Button.addActionListener(this);
        utf16Button.addActionListener(this);
        jdevDefaultEncoding.addActionListener(this);
        Box encodingPane = Box.createVerticalBox();
        encodingPane.add(Box.createVerticalStrut(5));
        encodingPane.add(utf8Button);
        encodingPane.add(Box.createVerticalStrut(5));
        encodingPane.add(utf16Button);
        encodingPane.add(Box.createVerticalStrut(5));
        encodingPane.add(jdevDefaultEncoding);
        masterPane.add(encodingLabel);
        masterPane.add(Box.createVerticalStrut(encodingLabel.getPreferredSize().height));
        JPanel encodingLeftAlignPane = new JPanel(new BorderLayout());
        encodingLeftAlignPane.add(Box.createHorizontalStrut(24), "West");
        encodingLeftAlignPane.add((Component)encodingPane, "Center");
        pane.add(encodingLeftAlignPane);
        pane.add(Box.createVerticalStrut(5));
        text = XMLSchemaBasedWizard.getResource("SCHEMAWIZ.GENERATE_REQUIRED");
        this._reqElems = new JCheckBox(StringUtils.stripMnemonic((String)text), false);
        this._reqElems.setMnemonic(StringUtils.getMnemonicKeyCode((String)text));
        JPanel reqLeftAlignPane = new JPanel(new BorderLayout());
        reqLeftAlignPane.add((Component)this._reqElems, "West");
        pane.add(reqLeftAlignPane);
        pane.add(new Box.Filler(new Dimension(0, 0), new Dimension(0, 1000), new Dimension(0, 1000)));
        return pane;
    }

    protected boolean validatePage() {
        SchemaBasedModel model = (SchemaBasedModel)this.getModel();
        model.setGrammar((Grammar)this._grammars.getSelectedItem());
        model.setDocumentRoot((ElementDef)this._elementDef.getSelectedItem());
        model.setDepth(this._depth.getIntValue());
        model.setRequiredElements(this._reqElems.isSelected());
        return true;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        SchemaBasedModel model = (SchemaBasedModel)this.getModel();
        String ac = e.getActionCommand();
        if (UTF8ACTION.equals(ac)) {
            model.setEncoding(StringUtils.stripMnemonic((String)UTF8ENCODING));
        } else if (UTF16ACTION.equals(ac)) {
            model.setEncoding(StringUtils.stripMnemonic((String)UTF16ENCODING));
        } else if (DEFAULT_ENCODING_ACTION.equals(ac)) {
            model.setEncoding(IdeUtil.getIdeIanaEncoding());
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getStateChange() == 1) {
            Grammar g = (Grammar)e.getItem();
            this.updateElementDefs(g);
        }
    }

    protected void updateElementDefs(final Grammar g) {
        new Thread(){

            @Override
            public void run() {
                final Iterator elemDefs = g.getElementDefs().iterator();
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        SchemaBasedCustomizerPage.this._elementDefModel.removeAllElements();
                        while (elemDefs.hasNext()) {
                            ElementDef e = (ElementDef)elemDefs.next();
                            if (e.isAbstract()) continue;
                            SchemaBasedCustomizerPage.this._elementDefModel.addElement(e);
                        }
                    }
                });
            }
        }.start();
    }

    protected void updateGrammars() {
        if (this._grammarModel != null) {
            new Thread(new PopulateGrammarsRunnable(this._grammarModel)).start();
        }
    }

    private class CustomizerSchemaBasedModelListener
    extends SchemaBasedModelListener.SchemaBasedModelAdapter {
        private CustomizerSchemaBasedModelListener() {
        }

        @Override
        public void grammarsChanged() {
            SchemaBasedCustomizerPage.this.updateGrammars();
        }
    }

    public static class GrammarComponentCellRenderer
    extends DefaultListCellRenderer {
        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            Object realValue = null;
            if (value instanceof Grammar) {
                Grammar g = (Grammar)value;
                realValue = g.getTargetNamespace() + "  ";
            } else if (value instanceof ElementDef) {
                ElementDef e = (ElementDef)value;
                realValue = e.getName() + "  ";
            } else if (value != null) {
                realValue = value.toString();
            }
            return super.getListCellRendererComponent((JList<?>)list, realValue, index, isSelected, cellHasFocus);
        }
    }

    public class PopulateGrammarsRunnable
    implements Runnable {
        private final DefaultComboBoxModel _model;

        public PopulateGrammarsRunnable(DefaultComboBoxModel model) {
            this._model = model;
        }

        @Override
        public void run() {
            SchemaBasedModel model = (SchemaBasedModel)SchemaBasedCustomizerPage.this.getModel();
            GrammarProvider grammarProvider = model.getGrammars();
            final Collection grammars = grammarProvider.getGrammars();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    PopulateGrammarsRunnable.this._model.removeAllElements();
                    for (Grammar g : grammars) {
                        Collection elemDefs = g.getElementDefs();
                        if (elemDefs == null) continue;
                        boolean hasElemDef = false;
                        for (ElementDef elemDef : elemDefs) {
                            if (elemDef.isAbstract()) continue;
                            hasElemDef = true;
                            break;
                        }
                        if (!hasElemDef) continue;
                        PopulateGrammarsRunnable.this._model.addElement(g);
                    }
                }
            });
        }
    }
}

