/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.xml.addin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.bali.xml.addin.CheckSyntaxMessage;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXParseException;

public class CheckSyntaxLog
implements ErrorHandler {
    private final List _errors = new ArrayList();
    private final List _warnings = new ArrayList();

    public List getErrors() {
        return Collections.unmodifiableList(this._errors);
    }

    public List getWarnings() {
        return Collections.unmodifiableList(this._warnings);
    }

    public boolean hasErrors() {
        return !this._errors.isEmpty();
    }

    public boolean hasWarnings() {
        return !this._warnings.isEmpty();
    }

    public boolean hasMessages() {
        return this.hasErrors() || this.hasWarnings();
    }

    public void clear() {
        this._errors.clear();
        this._warnings.clear();
    }

    public void error(String shortDescription, int lineNumber, int columnNumber) {
        this.error(shortDescription, null, lineNumber, columnNumber);
    }

    public void error(String shortDescription, String longDescription, int lineNumber, int columnNumber) {
        CheckSyntaxMessage error = new CheckSyntaxMessage(shortDescription, longDescription, lineNumber, columnNumber);
        this._errors.add(error);
    }

    public void warning(String shortDescription, int lineNumber, int columnNumber) {
        this.warning(shortDescription, null, lineNumber, columnNumber);
    }

    public void warning(String shortDescription, String longDescription, int lineNumber, int columnNumber) {
        CheckSyntaxMessage warning = new CheckSyntaxMessage(shortDescription, longDescription, lineNumber, columnNumber);
        this._warnings.add(warning);
    }

    @Override
    public void fatalError(SAXParseException e) {
        this.error(e);
    }

    @Override
    public void error(SAXParseException e) {
        CheckSyntaxMessage error = new CheckSyntaxMessage(e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber());
        this._errors.add(error);
    }

    @Override
    public void warning(SAXParseException e) {
        CheckSyntaxMessage warning = new CheckSyntaxMessage(e.getLocalizedMessage(), e.getLineNumber(), e.getColumnNumber());
        this._warnings.add(warning);
    }
}

