/*
 * Decompiled with CFR 0.152.
 */
package oracle.olapi.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.express.idl.util.XMLWriter;
import oracle.olapi.metadata.BaseMetadataObject;
import oracle.olapi.metadata.BaseMetadataXMLTags;
import oracle.olapi.metadata.MetadataToXMLConverter;
import oracle.olapi.metadata.MetadataXMLFormat;

public final class MetadataToXMLConverterPrior10105
extends MetadataToXMLConverter {
    private Map m_CurrentRoundMap = new HashMap();
    private Map m_PriorRoundsMap = new HashMap();
    private static final Integer NOT_MODIFIED = new Integer(0);
    private static final Integer CHILDREN_MODIFIED = new Integer(1);
    private static final MetadataXMLFormat XML_FORMAT_10G = new MetadataXMLFormat(0, "0.1");
    private boolean m_isForBulkSend = false;

    public boolean isForBulkSend() {
        return this.m_isForBulkSend;
    }

    public void setIsForBulkSend(boolean bl) {
        this.m_isForBulkSend = bl;
    }

    @Override
    protected final boolean addMetadataObjectAndChildren(BaseMetadataObject baseMetadataObject, List list) {
        Object v;
        if (baseMetadataObject == null) {
            return false;
        }
        Object object = this.getCurrentRoundMap().get(baseMetadataObject);
        if (null != object) {
            return object != NOT_MODIFIED;
        }
        object = baseMetadataObject.getCurrentStateForRead(this.getTransaction());
        boolean bl = baseMetadataObject.isModified(object, v = this.getPriorRoundsMap().get(baseMetadataObject), this.getTransaction());
        if (bl) {
            this.getCurrentRoundMap().put(baseMetadataObject, object);
            baseMetadataObject.gatherReferencedSources(list);
        } else {
            this.getCurrentRoundMap().put(baseMetadataObject, NOT_MODIFIED);
        }
        boolean bl2 = baseMetadataObject.addAllChildrenToXMLWriter(this, list);
        if (bl2 && !bl) {
            this.getCurrentRoundMap().put(baseMetadataObject, CHILDREN_MODIFIED);
        }
        if (this.m_isForBulkSend) {
            baseMetadataObject.setInitialPersistenceType((short)2);
        }
        return bl2 || bl;
    }

    @Override
    public void generateXML(XMLWriter xMLWriter) {
        this.setWriter(xMLWriter);
        boolean bl = true;
        for (Map.Entry entry : this.getCurrentRoundMap().entrySet()) {
            BaseMetadataObject baseMetadataObject = (BaseMetadataObject)entry.getKey();
            Object v = entry.getValue();
            if (v == NOT_MODIFIED || v == CHILDREN_MODIFIED) continue;
            if (bl) {
                this.beginElement(BaseMetadataXMLTags.METADATA_TAG);
                this.closeTag();
                bl = false;
            } else {
                this.newLine();
            }
            baseMetadataObject.appendXMLString(this, null);
        }
        if (!bl) {
            this.endElement(BaseMetadataXMLTags.METADATA_TAG);
        }
        this.setWriter(null);
    }

    private Map getPriorRoundsMap() {
        return this.m_PriorRoundsMap;
    }

    private Map getCurrentRoundMap() {
        return this.m_CurrentRoundMap;
    }

    private Object getCurrentState(BaseMetadataObject baseMetadataObject) {
        return this.getCurrentRoundMap().get(baseMetadataObject);
    }

    private Object getPriorState(BaseMetadataObject baseMetadataObject) {
        return this.getPriorRoundsMap().get(baseMetadataObject);
    }

    @Override
    public final void resetState() {
        super.resetState();
        for (Map.Entry entry : this.getCurrentRoundMap().entrySet()) {
            Object v = entry.getValue();
            if (v == NOT_MODIFIED || v == CHILDREN_MODIFIED) continue;
            this.getPriorRoundsMap().put(entry.getKey(), entry.getValue());
        }
        this.getCurrentRoundMap().clear();
    }

    @Override
    public MetadataXMLFormat getXMLFormat() {
        return XML_FORMAT_10G;
    }

    @Override
    boolean isModifiedObject(BaseMetadataObject baseMetadataObject) {
        Object v = this.getCurrentRoundMap().get(baseMetadataObject);
        return v != NOT_MODIFIED && v != CHILDREN_MODIFIED && v != null;
    }
}

