/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.wizard;

import java.awt.Color;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import oracle.bali.ewt.validate.ValidationMessagePane;
import oracle.bali.ewt.wizard.BaseWizard;
import oracle.bali.ewt.wizard.WizardBackgroundHandler;

final class WizardBuilder {
    private static final String _sGRADIENT = "_GRADIENT";
    private static final String _sWIZARD_FLAT_LOOK = "WIZARD_FLAT_LOOK";
    private static final String _sWIZARD_SEAMLESS = "WIZARD_SEAMLESS_BORDER";
    private static final String[] _sPANEL = new String[]{"HEADER", "LOGO", "ROADMAP", "AUXILIARY", "CONTENT", "MESSAGE", "BUTTON"};
    private static final String[] _sPOSITION = new String[]{"TOP_LEFT_CORNER", "TOP_CENTER_EDGE", "TOP_RIGHT_CORNER", "CENTER_LEFT_EDGE", "CENTER", "CENTER_RIGHT_EDGE", "BOTTOM_LEFT_CORNER", "BOTTOM_CENTER_EDGE", "BOTTOM_RIGHT_CORNER"};
    private static final String _sSPLITTER_MODE = "SPLITTER_MODE";
    private static final String _sDIV_LINE_VISIBLE = "SPLITTER_DIVIDER_LINE_VISIBLE";
    private static final String _sVALIDATION_MESSAGE_MODE = "VALIDATION_MESSAGE_MODE";
    private static final String _sVALIDATION_MESSAGE_LABEL_ENABLED = "VALIDATION_MESSAGE_LABEL_ENABLED";
    private static final String _sWIZARD_SIZE_TYPE = "WIZARD_SIZE_TYPE";
    private static final String _sWIZARD_ROADMAP_VISIBLE = "WIZARD_ROADMAP_VISIBLE";
    private static final String _sWIZARD_ROADMAP_ALL_LINKS_ENABLED = "WIZARD_ROADMAP_ALL_LINKS_ENABLED";

    WizardBuilder() {
    }

    public static void build(BaseWizard wizard, URL url, URL baseUrl) {
        InputStream input = null;
        if (url == null) {
            throw new IllegalArgumentException("URL can't be null");
        }
        try {
            String enableAllLinks;
            String roadMapVisible;
            String wizSize;
            String spMode;
            String messageLabelEnabled;
            String seamLess;
            input = url.openStream();
            Properties props = new Properties();
            props.load(input);
            String flatLook = props.getProperty(_sWIZARD_FLAT_LOOK);
            if (flatLook != null) {
                wizard.setFlatLook(Boolean.valueOf(flatLook.trim()));
            }
            if ((seamLess = props.getProperty(_sWIZARD_SEAMLESS)) != null) {
                wizard.__setSeamlessBorder(Boolean.valueOf(seamLess.trim()));
            }
            WizardBackgroundHandler handler = wizard.getBackgroundHandler();
            int noPanels = _sPANEL.length;
            for (int i = 0; i < noPanels; ++i) {
                String panelName = _sPANEL[i];
                WizardBackgroundHandler.Panel panel = WizardBackgroundHandler.findPanel(panelName);
                for (String pos : _sPOSITION) {
                    WizardBackgroundHandler.Position position = WizardBackgroundHandler.findPosition(pos);
                    String imageString = props.getProperty(panelName + "_" + position);
                    if (imageString != null) {
                        if (panelName == _sPANEL[1]) {
                            wizard.__createLogoPanel();
                        }
                        WizardBuilder._setBackgroundImage(baseUrl == null ? null : baseUrl.toString(), imageString, panel, position, handler);
                        continue;
                    }
                    handler.setBackgroundImage(panel, position, null);
                }
                String gradString = props.getProperty(panelName + _sGRADIENT);
                if (gradString != null) {
                    WizardBuilder._setBackgroundGradient(gradString, panel, handler);
                    continue;
                }
                handler.setBackgroundGradient(panel, (WizardBackgroundHandler.GradientType)null, (Color[])null);
            }
            ValidationMessagePane pane = wizard.getValidationMessagePane();
            String messageMode = props.getProperty(_sVALIDATION_MESSAGE_MODE);
            if (messageMode != null && pane != null) {
                if (ValidationMessagePane.MessageMode.valueOf(messageMode.trim()) == ValidationMessagePane.MessageMode.TREE) {
                    pane.setMessageMode(ValidationMessagePane.MessageMode.TREE);
                } else {
                    pane.setMessageMode(ValidationMessagePane.MessageMode.LIST);
                }
            }
            if ((messageLabelEnabled = props.getProperty(_sVALIDATION_MESSAGE_LABEL_ENABLED)) != null && pane != null) {
                pane.setMessageLabelVisible(Boolean.valueOf(messageLabelEnabled.trim()));
            }
            if ((spMode = props.getProperty(_sSPLITTER_MODE)) != null) {
                String divLineVisible = props.getProperty(_sDIV_LINE_VISIBLE);
                boolean lineVisible = divLineVisible == null ? true : Boolean.valueOf(divLineVisible.trim());
                wizard.__setSplitterMode(Boolean.valueOf(spMode.trim()), lineVisible);
            }
            if ((wizSize = props.getProperty(_sWIZARD_SIZE_TYPE)) != null) {
                wizard.setDefaultWizardSize(Integer.valueOf(wizSize.trim()));
            }
            if ((roadMapVisible = props.getProperty(_sWIZARD_ROADMAP_VISIBLE)) != null) {
                wizard.setRoadmapVisible(Boolean.valueOf(roadMapVisible.trim()));
            }
            if ((enableAllLinks = props.getProperty(_sWIZARD_ROADMAP_ALL_LINKS_ENABLED)) != null) {
                wizard.setAllLinksEnabled(Boolean.valueOf(enableAllLinks.trim()));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void _setBackgroundGradient(String gradString, WizardBackgroundHandler.Panel panel, WizardBackgroundHandler handler) {
        String[] args = gradString.split("#");
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            args[i] = args[i].trim();
        }
        WizardBackgroundHandler.GradientType type = WizardBackgroundHandler.findGradientType(args[1]);
        Color first = null;
        Color second = null;
        try {
            first = new Color(Integer.parseInt(args[2], 16));
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        try {
            second = len == 4 ? new Color(Integer.parseInt(args[3], 16)) : null;
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        handler.setBackgroundGradient(panel, type, first, second);
    }

    private static void _setBackgroundImage(String baseUrl, String imageString, WizardBackgroundHandler.Panel panel, WizardBackgroundHandler.Position position, WizardBackgroundHandler handler) {
        String[] args = imageString.split("#");
        int len = args.length;
        for (int i = 0; i < len; ++i) {
            args[i] = args[i].trim();
        }
        WizardBackgroundHandler.Stretch stretch = WizardBackgroundHandler.findStretch(args[2]);
        WizardBackgroundHandler.ImageBoundary bound = len == 4 ? WizardBackgroundHandler.findBoundary(args[3]) : WizardBackgroundHandler.ImageBoundary.PANE;
        String imageUrl = baseUrl == null ? args[1] : baseUrl + args[1];
        handler.setBackgroundImage(panel, position, imageUrl, stretch, bound);
    }
}

