/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.selection;

import java.util.Enumeration;
import java.util.Vector;
import oracle.bali.ewt.selection.Cell;
import oracle.bali.share.collection.Range;
import oracle.bali.share.sort.Comparator;
import oracle.bali.share.sort.Sort;

public final class CellRange
implements Cloneable {
    private Cell _min;
    private Cell _max;
    private static CellRangeComparator _cellRangeComparator;

    public CellRange(int col, int row) {
        this._init(col, row, col, row);
    }

    public CellRange(Cell cell) {
        this._init(cell.column, cell.row, cell.column, cell.row);
    }

    public CellRange(int col1, int row1, int col2, int row2) {
        this._init(col1, row1, col2, row2);
    }

    public CellRange(Cell cell1, Cell cell2) {
        this._init(cell1.column, cell1.row, cell2.column, cell2.row);
    }

    public Object clone() throws CloneNotSupportedException {
        return new CellRange(this.getLowerLimit(), this.getUpperLimit());
    }

    public boolean equals(CellRange cr) {
        return this == cr || cr != null && cr.getLowerLimit().equals(this.getLowerLimit()) && cr.getUpperLimit().equals(this.getUpperLimit());
    }

    public Cell getLowerLimit() {
        return this._min;
    }

    public Cell getUpperLimit() {
        return this._max;
    }

    public final boolean inRange(Cell c) {
        return this.inRange(c.column, c.row);
    }

    public boolean inRange(int column, int row) {
        return row >= this._min.row && row <= this._max.row && column >= this._min.column && column <= this._max.column;
    }

    public String toString() {
        return "[[" + this._min.column + "," + this._min.row + "],[" + this._max.column + "," + this._max.row + "]]";
    }

    public static CellRange[] addCellRanges(CellRange[] ar, CellRange[] br) {
        int m;
        int n = ar == null ? 0 : ar.length;
        int n2 = m = br == null ? 0 : br.length;
        if (n == 0 && m == 0) {
            return null;
        }
        if (m == 0) {
            CellRange[] cr = new CellRange[n];
            System.arraycopy(ar, 0, cr, 0, n);
            return cr;
        }
        if (n == 0) {
            CellRange[] cr = new CellRange[m];
            System.arraycopy(br, 0, cr, 0, m);
            return cr;
        }
        List l = new List();
        l.addArray(ar);
        l.addArray(br);
        Vector<CellRange> holder = new Vector<CellRange>();
        Node node = l.first;
        while (node != null) {
            CellRange a = node.cellRange;
            Node innerNode = node.next;
            while (innerNode != null) {
                CellRange b = innerNode.cellRange;
                CellRange._cellRangeDecompose(a, b, holder);
                if (holder.size() == 0) {
                    l.remove(node);
                    holder.removeAllElements();
                    break;
                }
                if (holder.size() == 1) {
                    CellRange cr = (CellRange)holder.elementAt(0);
                    holder.removeAllElements();
                    if (!cr.equals(a)) {
                        l.add(new Node(cr));
                        l.remove(node);
                        break;
                    }
                } else {
                    l.addVector(holder);
                    l.remove(node);
                    holder.removeAllElements();
                    break;
                }
                innerNode = innerNode.next;
            }
            node = node.next;
        }
        holder.removeAllElements();
        node = l.first;
        while (node != null) {
            holder.addElement(node.cellRange);
            node = node.next;
        }
        Object[] results = new CellRange[holder.size()];
        holder.copyInto(results);
        int z = results.length;
        Sort.qSort((Object[])results, (int)z, (Comparator)CellRange._getCellRangeComparator());
        return results;
    }

    public static CellRange[] subtractCellRanges(CellRange[] a, CellRange[] b) {
        int m;
        int n = a == null ? 0 : a.length;
        int n2 = m = b == null ? 0 : b.length;
        if (n == 0 && m == 0) {
            return null;
        }
        if (n == 0) {
            return null;
        }
        if (m == 0) {
            CellRange[] c = new CellRange[n];
            System.arraycopy(a, 0, c, 0, n);
            return c;
        }
        Vector<CellRange> resultVector = new Vector<CellRange>();
        for (int i = 0; i < n; ++i) {
            resultVector.addElement(a[i]);
        }
        for (int j = 0; j < b.length; ++j) {
            CellRange deleteRange = b[j];
            Vector newVector = new Vector();
            Enumeration e = resultVector.elements();
            while (e.hasMoreElements()) {
                CellRange r = (CellRange)e.nextElement();
                CellRange._cellRangeDecompose(r, deleteRange, newVector);
            }
            resultVector = newVector;
        }
        Object[] results = new CellRange[resultVector.size()];
        resultVector.copyInto(results);
        return results;
    }

    public static boolean cellRangesContain(CellRange[] ranges, int column, int row) {
        if (ranges == null) {
            return false;
        }
        for (int i = 0; i < ranges.length; ++i) {
            if (!ranges[i].inRange(column, row)) continue;
            return true;
        }
        return false;
    }

    public static boolean cellRangesContain(CellRange[] a, CellRange[] b) {
        if (b == null || b.length == 0) {
            return true;
        }
        if (a == null || a.length == 0) {
            return false;
        }
        CellRange[] result = CellRange.subtractCellRanges(b, a);
        return result == null || result.length == 0;
    }

    public static Range[] columnRangesFromCellRanges(CellRange[] cellRanges) {
        Range[] result = null;
        if (cellRanges != null && cellRanges.length > 0) {
            result = new Range[cellRanges.length];
            for (int i = 0; i < cellRanges.length; ++i) {
                result[i] = new Range(cellRanges[i].getLowerLimit().column, cellRanges[i].getUpperLimit().column);
            }
        }
        return result;
    }

    public static Range[] rowRangesFromCellRanges(CellRange[] cellRanges) {
        Range[] result = null;
        if (cellRanges != null && cellRanges.length > 0) {
            result = new Range[cellRanges.length];
            for (int i = 0; i < cellRanges.length; ++i) {
                result[i] = new Range(cellRanges[i].getLowerLimit().row, cellRanges[i].getUpperLimit().row);
            }
        }
        return result;
    }

    private void _init(int mincol, int minrow, int maxcol, int maxrow) {
        int maxr;
        int minr;
        int maxc;
        int minc;
        if (maxcol < mincol) {
            minc = maxcol;
            maxc = mincol;
        } else {
            minc = mincol;
            maxc = maxcol;
        }
        if (maxrow < minrow) {
            minr = maxrow;
            maxr = minrow;
        } else {
            maxr = maxrow;
            minr = minrow;
        }
        this._min = new Cell(minc, minr);
        this._max = maxr == minr && maxc == minc ? this._min : new Cell(maxc, maxr);
    }

    private static CellRange _getValidRect(int x1, int y1, int x2, int y2) {
        if (x1 <= x2 && y1 <= y2) {
            return new CellRange(x1, y1, x2, y2);
        }
        return null;
    }

    private static void _cellRangeDecompose(CellRange t, CellRange d, Vector newVector) {
        Cell a1 = t.getLowerLimit();
        Cell a2 = t.getUpperLimit();
        Cell b1 = d.getLowerLimit();
        Cell b2 = d.getUpperLimit();
        if (a2.column < b1.column || a2.row < b1.row || a1.column > b2.column || a1.row > b2.row) {
            newVector.addElement(new CellRange(a1, a2));
        } else {
            int lowCol = a1.column >= b1.column ? a1.column : b1.column;
            int lowRow = a1.row >= b1.row ? a1.row : b1.row;
            int highCol = a2.column <= b2.column ? a2.column : b2.column;
            int highRow = a2.row <= b2.row ? a2.row : b2.row;
            b1 = new Cell(lowCol, lowRow);
            b2 = new Cell(highCol, highRow);
            CellRange top = CellRange._getValidRect(a1.column, a1.row, a2.column, b1.row - 1);
            CellRange bottom = CellRange._getValidRect(a1.column, b2.row + 1, a2.column, a2.row);
            CellRange left = CellRange._getValidRect(a1.column, b1.row, b1.column - 1, b2.row);
            CellRange right = CellRange._getValidRect(b2.column + 1, b1.row, a2.column, b2.row);
            if (top != null) {
                newVector.addElement(top);
            }
            if (bottom != null) {
                newVector.addElement(bottom);
            }
            if (left != null) {
                newVector.addElement(left);
            }
            if (right != null) {
                newVector.addElement(right);
            }
        }
    }

    private static Comparator _getCellRangeComparator() {
        if (_cellRangeComparator == null) {
            _cellRangeComparator = new CellRangeComparator();
        }
        return _cellRangeComparator;
    }

    private static class List {
        Node first;
        Node last;

        public void addArray(CellRange[] elements) {
            for (int i = 0; i < elements.length; ++i) {
                this.add(new Node(elements[i]));
            }
        }

        public void addVector(Vector elements) {
            for (int i = 0; i < elements.size(); ++i) {
                this.add(new Node((CellRange)elements.elementAt(i)));
            }
        }

        public void add(Node n) {
            if (this.last == null || this.first == null) {
                this.last = n;
                this.first = n;
            } else {
                this.last.next = n;
                n.prev = this.last;
                n.next = null;
                this.last = n;
            }
        }

        public void remove(Node n) {
            if (this.first == null || this.last == null) {
                return;
            }
            if (this.first == n) {
                this.first = this.first.next;
                if (this.first != null) {
                    this.first.prev = null;
                }
            }
            if (this.last == n) {
                this.last = this.last.prev;
                if (this.last != null) {
                    this.last.next = null;
                }
            }
            if (n.prev != null) {
                n.prev.next = n.next;
            }
            if (n.next != null) {
                n.next.prev = n.prev;
            }
        }
    }

    private static class Node {
        CellRange cellRange;
        Node next;
        Node prev;

        public Node(CellRange cr) {
            this.cellRange = cr;
        }
    }

    private static class CellRangeComparator
    implements Comparator {
        private CellRangeComparator() {
        }

        public int compare(Object item1, Object item2) {
            CellRange a = (CellRange)item1;
            CellRange b = (CellRange)item2;
            if (this._cellLT(a.getLowerLimit(), b.getLowerLimit())) {
                return -1;
            }
            if (this._cellGT(a.getLowerLimit(), b.getLowerLimit())) {
                return 1;
            }
            return 0;
        }

        private boolean _cellLT(Cell a, Cell b) {
            return a.row < b.row || a.row == b.row && a.column < b.column;
        }

        private boolean _cellGT(Cell a, Cell b) {
            return a.row > b.row || a.row == b.row && a.column > b.column;
        }
    }
}

