/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.painter;

import java.awt.FontMetrics;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.painter.TextPainter;

public class TruncatingTextPainter
extends TextPainter {
    protected static final String _ELLIPSIS = "...";

    public TruncatingTextPainter() {
    }

    public TruncatingTextPainter(Object dataKey) {
        super(dataKey);
    }

    public TruncatingTextPainter(Object dataKey, boolean supportMnemonics) {
        super(dataKey, supportMnemonics);
    }

    @Override
    protected String getPaintText(PaintContext context, String text, FontMetrics metrics, int availableWidth) {
        int desiredWidth = metrics.stringWidth((String)text);
        if (desiredWidth > availableWidth) {
            int ellipsisWidth = metrics.stringWidth(_ELLIPSIS);
            float alignment = this.getAlignmentX(context);
            if (alignment == 1.0f || alignment != 0.0f && context.getReadingDirection() == 2) {
                int i = 0;
                int length = ((String)text).length();
                for (int exceededWidth = availableWidth - ellipsisWidth - desiredWidth; exceededWidth < 0; exceededWidth += metrics.charWidth(((String)text).charAt(i++))) {
                    if (i != length) continue;
                }
                text = _ELLIPSIS + ((String)text).substring(i);
            } else {
                int i = -1;
                int length = ((String)text).length();
                for (int remainingWidth = availableWidth - ellipsisWidth; remainingWidth > 0 && ++i != length; remainingWidth -= metrics.charWidth(((String)text).charAt(i))) {
                }
                if (i < 0) {
                    i = 0;
                }
                text = ((String)text).substring(0, i) + _ELLIPSIS;
            }
        }
        return text;
    }

    protected static String getEllipsis(PaintContext context) {
        return _ELLIPSIS;
    }
}

