/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.grid.hGrid;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import javax.swing.KeyStroke;
import oracle.bali.ewt.grid.Grid;
import oracle.bali.ewt.grid.StandardGridKeyHandler;
import oracle.bali.ewt.grid.hGrid.HArrayTwoDModel;
import oracle.bali.ewt.grid.hGrid.HDataObject;
import oracle.bali.ewt.model.TwoDModel;
import oracle.bali.ewt.selection.Cell;

public class HGridKeyHandler
extends StandardGridKeyHandler {
    private Grid _grid;

    public HGridKeyHandler(Grid grid) {
        this._grid = grid;
        String left = "LEFT";
        String right = "RIGHT";
        ActionListener listener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                String cmd = e.getActionCommand();
                int fakeKeyCode = "LEFT".equals(cmd) ? 37 : 39;
                KeyEvent key = new KeyEvent(HGridKeyHandler.this._grid, 401, 0L, 0, fakeKeyCode);
                HGridKeyHandler.this.handleKeyEvent(HGridKeyHandler.this._grid, key);
            }
        };
        grid.registerKeyboardAction(listener, "RIGHT", KeyStroke.getKeyStroke(9, 0), 0);
        grid.registerKeyboardAction(listener, "LEFT", KeyStroke.getKeyStroke(9, 1), 0);
    }

    public void dispose() {
        if (this._grid != null) {
            this._grid.unregisterKeyboardAction(KeyStroke.getKeyStroke(9, 0));
            this._grid.unregisterKeyboardAction(KeyStroke.getKeyStroke(9, 1));
        }
    }

    @Override
    protected Cell left(Grid grid, Cell focusCell, KeyEvent e) {
        if (focusCell.column == 0) {
            HDataObject hData;
            HArrayTwoDModel hModel;
            int rowIndex;
            e.consume();
            int focusRow = 0;
            TwoDModel model = grid.getModel();
            if (!(!(model instanceof HArrayTwoDModel) || (rowIndex = (hModel = (HArrayTwoDModel)model).getExpandedIndex(focusCell.row)) == -1 || (hData = (HDataObject)hModel.getData(focusCell.column, focusCell.row)).hasChildren() && hData.isExpanded())) {
                focusRow = hModel.getParentRow(rowIndex);
                if (focusRow == -1) {
                    return null;
                }
                focusRow = hModel.getVisibleIndex(focusRow);
            }
            return new Cell(0, focusRow);
        }
        return super.left(grid, focusCell, e);
    }
}

