/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.graphics;

import java.awt.Color;

public class ColorUtils {
    public static final double NTSC_WEIGHT_RED = 0.299;
    public static final double NTSC_WEIGHT_GREEN = 0.587;
    public static final double NTSC_WEIGHT_BLUE = 0.144;
    public static final int DEFAULT_LIGHTER_CHANGE = 51;
    private static final int _LIGHT_LUMINANCE = 229;
    private static final int _DARK_LUMINANCE = 51;

    public static int getApproximateLuminance(Color color) {
        return (color.getRed() >> 2) + (color.getGreen() >> 1) + (color.getBlue() >> 2);
    }

    public static double getNTSCLuminance(Color color) {
        return (double)color.getRed() * 0.299 + (double)color.getGreen() * 0.587 + (double)color.getBlue() * 0.144;
    }

    public static Color shadeColor(Color baseColor, int change) {
        int realChange;
        if (change < -255 || change > 255) {
            throw new IllegalArgumentException();
        }
        int luminosity = ColorUtils.getApproximateLuminance(baseColor);
        if (change > 0) {
            realChange = luminosity > 229 ? -change >> 1 : (luminosity < 51 ? change + (change >> 2) : change);
        } else if (luminosity < 51) {
            realChange = -change >> 1;
            realChange += realChange >> 1;
        } else {
            realChange = change;
        }
        if (realChange < 0) {
            return new Color(ColorUtils._darkenComponent(baseColor.getRed(), realChange), ColorUtils._darkenComponent(baseColor.getGreen(), realChange), ColorUtils._darkenComponent(baseColor.getBlue(), realChange));
        }
        return new Color(ColorUtils._lightenComponent(baseColor.getRed(), realChange), ColorUtils._lightenComponent(baseColor.getGreen(), realChange), ColorUtils._lightenComponent(baseColor.getBlue(), realChange));
    }

    public static final Color lighterShadeColor(Color baseColor) {
        return ColorUtils.shadeColor(baseColor, 51);
    }

    public static final Color darkerShadeColor(Color baseColor) {
        return ColorUtils.shadeColor(baseColor, -51);
    }

    public static Color cmyToColor(int c, int m, int y) {
        int r = (int)((double)(100 - c) * 2.55);
        int g = (int)((double)(100 - m) * 2.55);
        int b = (int)((double)(100 - y) * 2.55);
        return new Color(r, g, b);
    }

    public static Color hsbToColor(double h, double s, double b) {
        if (h > 360.0 || h < 0.0 || s > 100.0 || s < 0.0 || b > 100.0 || b < 0.0) {
            throw new IllegalArgumentException("Invalid input value");
        }
        return Color.getHSBColor((float)h / 360.0f, (float)s / 100.0f, (float)b / 100.0f);
    }

    public static Color hslToColor(double h, double s, double l) {
        if (h > 360.0 || h < 0.0 || s > 100.0 || s < 0.0 || l > 100.0 || l < 0.0) {
            throw new IllegalArgumentException("Invalid input value");
        }
        int[] retval = ColorUtils.hslToRGB(h, s, l);
        return new Color(retval[0], retval[1], retval[2]);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static Color htmlToColor(String html) {
        int start = 0;
        int end = html.length() - 1;
        int red = 0;
        int blue = 0;
        int green = 0;
        if (html == null || html.length() == 0) {
            return new Color(red, green, blue);
        }
        if (html.charAt(start) == '\'') {
            if (html.charAt(end) != '\'') throw new IllegalArgumentException("Invalid input syntax");
            ++start;
            --end;
        } else if (html.charAt(start) == '\"') {
            if (html.charAt(end) != '\"') throw new IllegalArgumentException("Invalid input syntax");
            ++start;
            --end;
        } else if (html.charAt(start) == '#') {
            ++start;
        }
        switch (end - start) {
            case 4: {
                html = new StringBuffer(html).insert(++end, '0').toString();
            }
            case 5: {
                blue = Integer.parseInt(html.substring(--end, 2 + end--), 16);
            }
            case 3: {
                green = Integer.parseInt(html.substring(--end, 2 + end--), 16);
                red = Integer.parseInt(html.substring(--end, 2 + end--), 16);
                return new Color(red, green, blue);
            }
            case 2: {
                blue = Integer.parseInt(html.substring(end, 1 + end--), 16);
            }
            case 1: {
                green = Integer.parseInt(html.substring(end, 1 + end--), 16);
            }
            case 0: {
                red = Integer.parseInt(html.substring(end, 1 + end--), 16);
                return new Color(red, green, blue);
            }
        }
        return new Color(red, green, blue);
    }

    public static Color rgbToColor(int r, int g, int b) {
        if (r > 255 || r < 0 || g > 255 || g < 0 || b > 255 || b < 0) {
            throw new IllegalArgumentException("Invalid input value");
        }
        return new Color(r, g, b);
    }

    public static int[] colorToCMY(Color c) {
        int red = c.getRed();
        int green = c.getGreen();
        int blue = c.getBlue();
        int cy = (int)(100.0 - (double)red / 2.55);
        int ma = (int)(100.0 - (double)green / 2.55);
        int ye = (int)(100.0 - (double)blue / 2.55);
        int[] retval = new int[]{cy, ma, ye};
        return retval;
    }

    public static double[] colorToHSB(Color c) {
        float[] flarr = null;
        double[] retVal = new double[3];
        flarr = Color.RGBtoHSB(c.getRed(), c.getGreen(), c.getBlue(), flarr);
        retVal[0] = (double)flarr[0] * 360.0;
        retVal[1] = (double)flarr[1] * 100.0;
        retVal[2] = (double)flarr[2] * 100.0;
        return retVal;
    }

    public static double[] colorToHSL(Color c) {
        return ColorUtils.rgbToHSL(c.getRed(), c.getGreen(), c.getBlue());
    }

    public static String colorToHTML(Color c) {
        return "#" + Integer.toHexString(c.getRGB()).substring(2);
    }

    public static int[] colorToRGB(Color c) {
        int[] retVal = new int[]{c.getRed(), c.getGreen(), c.getBlue()};
        return retVal;
    }

    public static double[] rgbToHSL(int red, int green, int blue) {
        double s;
        double r = (double)red / 255.0;
        double g = (double)green / 255.0;
        double b = (double)blue / 255.0;
        double h = 0.0;
        double max = Math.max(r, Math.max(g, b));
        double min = Math.min(r, Math.min(g, b));
        double l = (max + min) / 2.0;
        if (max == min) {
            s = 0.0;
            h = 0.0;
        } else {
            s = l <= 0.5 ? (max - min) / (max + min) : (max - min) / (2.0 - max - min);
            double delta = max - min;
            if (r == max) {
                h = (g - b) / delta;
            } else if (g == max) {
                h = 2.0 + (b - r) / delta;
            } else if (b == max) {
                h = 4.0 + (r - g) / delta;
            }
            h *= 60.0;
            if (h < 0.0) {
                h += 360.0;
            }
        }
        return new double[]{h, s * 100.0, l * 100.0};
    }

    public static int[] hslToRGB(double h, double s, double l) {
        int r;
        int g;
        int b;
        l /= 100.0;
        if ((s /= 100.0) == 0.0) {
            g = b = (int)l * 255;
            r = b;
        } else {
            b = 0;
            g = 0;
            r = 0;
            double m2 = l <= 0.5 ? l * (1.0 + s) : l + s + l * s;
            double m1 = 2.0 * l - m2;
            r = Math.max(0, Math.min(255, (int)(ColorUtils._getValue(m1, m2, h + 120.0) * 255.0)));
            g = Math.max(0, Math.min(255, (int)(ColorUtils._getValue(m1, m2, h) * 255.0)));
            b = Math.max(0, Math.min(255, (int)(ColorUtils._getValue(m1, m2, h - 120.0) * 255.0)));
        }
        int[] retval = new int[]{r, g, b};
        return retval;
    }

    public static Color getTransparentColor(Color base, Color second, int alpha) {
        float Fr = second.getRed();
        float Fg = second.getGreen();
        float Fb = second.getBlue();
        float Br = base.getRed();
        float Bg = base.getGreen();
        float Bb = base.getBlue();
        float A = alpha;
        int Cr = (int)(Fr * A + Br * (255.0f - A) + 127.0f) / 255;
        int Cg = (int)(Fg * A + Bg * (255.0f - A) + 127.0f) / 255;
        int Cb = (int)(Fb * A + Bb * (255.0f - A) + 127.0f) / 255;
        return new Color(Cr, Cg, Cb);
    }

    private static double _getValue(double n1, double n2, double hue) {
        if (hue > 360.0) {
            hue -= 360.0;
        } else if (hue < 0.0) {
            hue += 360.0;
        }
        if (hue < 60.0) {
            return n1 + (n2 - n1) * hue / 60.0;
        }
        if (hue < 180.0) {
            return n2;
        }
        if (hue < 240.0) {
            return n1 + (n2 - n1) * (240.0 - hue) / 60.0;
        }
        return n1;
    }

    private static final int _darkenComponent(int baseComponent, int change) {
        int newComponent = baseComponent + change;
        if (newComponent < 0) {
            newComponent = 0;
        }
        return newComponent;
    }

    private static final int _lightenComponent(int baseComponent, int change) {
        int newComponent = baseComponent + change;
        if (newComponent > 255) {
            newComponent = 255;
        }
        return newComponent;
    }
}

