/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.elaf.windows;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.PrintGraphics;
import java.awt.print.PrinterGraphics;
import javax.swing.UIDefaults;
import javax.swing.plaf.UIResource;
import oracle.bali.ewt.header.Header;
import oracle.bali.ewt.painter.AbstractBorderPainter;
import oracle.bali.ewt.painter.PaintContext;
import oracle.bali.ewt.util.ImmInsets;

public class WindowsPivotHeaderHeaderItemPainter
extends AbstractBorderPainter
implements UIResource {
    private boolean _firstEdge;
    private boolean _lastEdge;
    private boolean _horizontal;
    private static final ImmInsets _sInsets = new ImmInsets(1, 1, 1, 1);

    public WindowsPivotHeaderHeaderItemPainter(boolean horizontal, boolean firstEdge, boolean lastEdge) {
        this._horizontal = horizontal;
        this._firstEdge = firstEdge;
        this._lastEdge = lastEdge;
    }

    @Override
    public int getRepaintFlags(PaintContext context) {
        return super.getRepaintFlags(context) | 2;
    }

    @Override
    protected boolean isBorderTransparent(PaintContext context) {
        return true;
    }

    @Override
    protected ImmInsets getOwnInsets(PaintContext context) {
        return _sInsets;
    }

    @Override
    protected void paintBorder(PaintContext context, Graphics g, int x, int y, int width, int height) {
        Color savedColor = g.getColor();
        Object data = context.getPaintData(Header.KEY_DRAW_RAISED);
        boolean raised = data instanceof Boolean ? (Boolean)data : true;
        Color color = null;
        int state = context.getPaintState();
        if ((state & 1) == 0 && (data = context.getPaintData("headerItemBorderColor")) instanceof Color) {
            color = (Color)data;
        }
        if (this._horizontal) {
            this._paintHorizontalBorder(context, g, x, y, width, height, raised, color);
        } else {
            this._paintVerticalBorder(context, g, x, y, width, height, raised, color);
        }
        if (savedColor != null) {
            g.setColor(savedColor);
        }
    }

    private void _paintVerticalBorder(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised, Color borderColor) {
        boolean printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color shadow = defaults.getColor("controlShadow");
        Color dark = defaults.getColor("darkIntensity");
        Color darkShadow = defaults.getColor("EWTPivot.darkShadow");
        if (borderColor == null) {
            borderColor = (state & 4) == 0 || printing ? darkShadow : shadow;
        }
        if (raised && (state & 2) != 0) {
            g.setColor(dark);
            g.drawLine(x, y, right, y);
            g.drawLine(x, y, x, bottom);
        } else {
            g.setColor(borderColor);
            g.drawLine(right, y, right, bottom);
            g.drawLine(x, bottom, right, bottom);
            if (raised) {
                g.setColor(Color.white);
                g.drawLine(x, y, x, bottom - 1);
                g.drawLine(x, y, right - 1, y);
            }
            if (printing) {
                if (raised) {
                    g.setColor(Color.white);
                }
                if (raised || this._firstEdge) {
                    g.drawLine(x, y, right, y);
                }
                g.drawLine(x, y, x, bottom);
                if (raised) {
                    g.setColor(control);
                }
                g.drawLine(x, bottom, x, bottom);
                g.drawLine(right, y, right, y);
            } else if ((state & 4) == 0) {
                if (raised) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(shadow);
                }
                g.drawLine(x, y, right, y);
                g.drawLine(x, y, x, bottom);
                g.setColor(borderColor);
                g.drawLine(right, y, right, bottom);
                g.drawLine(x, bottom, right, bottom);
            }
        }
    }

    private void _paintHorizontalBorder(PaintContext context, Graphics g, int x, int y, int width, int height, boolean raised, Color borderColor) {
        boolean printing = g instanceof PrintGraphics || g instanceof PrinterGraphics;
        int state = context.getPaintState();
        UIDefaults defaults = context.getPaintUIDefaults();
        int bottom = y + height - 1;
        int right = x + width - 1;
        Color control = defaults.getColor("control");
        Color shadow = defaults.getColor("controlShadow");
        Color dark = defaults.getColor("darkIntensity");
        Color darkShadow = defaults.getColor("EWTPivot.darkShadow");
        if (borderColor == null) {
            borderColor = (state & 4) == 0 ? darkShadow : shadow;
        }
        if (raised && (state & 2) != 0) {
            g.setColor(dark);
            g.drawLine(x, y, right, y);
            g.drawLine(x, y, x, bottom);
        } else {
            g.setColor(borderColor);
            g.drawLine(x, bottom, right, bottom);
            g.drawLine(right, y, right, bottom);
            if (raised) {
                g.setColor(Color.white);
                g.drawLine(x, y, x, bottom - 1);
                g.drawLine(x, y, right - 1, y);
            }
            if (printing) {
                if (raised) {
                    g.setColor(Color.white);
                }
                g.drawLine(x, y, right, y);
                if (raised || this._firstEdge) {
                    g.drawLine(x, y, x, bottom);
                }
                if (raised) {
                    g.setColor(control);
                }
                g.drawLine(x, bottom, x, bottom);
                g.drawLine(right, y, right, y);
            } else if ((state & 4) == 0) {
                if (raised) {
                    g.setColor(Color.white);
                } else {
                    g.setColor(shadow);
                }
                g.drawLine(x, y, right, y);
                g.drawLine(x, y, x, bottom);
                g.setColor(borderColor);
                g.drawLine(right, y, right, bottom);
                g.drawLine(x, bottom, right, bottom);
            }
        }
    }
}

