/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.chooser.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Locale;
import java.util.ResourceBundle;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import oracle.bali.ewt.LWComponent;
import oracle.bali.ewt.chooser.color.CMYComponent;
import oracle.bali.ewt.chooser.color.ColorComponent;
import oracle.bali.ewt.chooser.color.ColorEditor;
import oracle.bali.ewt.chooser.color.HSBComponent;
import oracle.bali.ewt.chooser.color.HSLComponent;
import oracle.bali.ewt.chooser.color.HTMLHexComponent;
import oracle.bali.ewt.chooser.color.ImageComponent;
import oracle.bali.ewt.chooser.color.RGBComponent;
import oracle.bali.ewt.dialog.JEWTDialog;
import oracle.bali.share.nls.LocaleUtils;
import oracle.bali.share.nls.StringUtils;

public class ColorChooserPane
extends LWComponent
implements Accessible {
    public static final String PROPERTY_COLOR = "color";
    public static final String PROPERTY_COLOR_NAME = "colorName";
    public static final int COLOR_PICKER_RGB = 1;
    public static final int COLOR_PICKER_HSB = 2;
    public static final int COLOR_PICKER_HSL = 4;
    public static final int COLOR_PICKER_HTMLHEX = 8;
    public static final int COLOR_PICKER_CMYK = 16;
    public static final int COLOR_PICKER_CMY = 16;
    public static final int BUTTON_OK = 1;
    public static final int BUTTON_CANCEL = 2;
    private static final String _RESOURCE = "oracle.bali.ewt.resource.JEWTBundle";
    private static final String _KEY_TITLE = "COLORCHOOSER.TITLE";
    private static final String _KEY_COLOR_NAME = "COLORCHOOSER.COLOR_NAME";
    private static final int _DEFAULT_PICKERS = 11;
    private Listener _listener = new Listener();
    private JPanel _colorEditorPanel;
    private ColorComponent _colorComponent;
    private ImageComponent _imageComponent = new ImageComponent();
    private HSBComponent _hsbComponent;
    private HSLComponent _hslComponent;
    private RGBComponent _rgbComponent;
    private HTMLHexComponent _htmlComponent;
    private CMYComponent _cmyComponent;
    private JTextField _colorName;
    private JLabel _colorNameLabel;
    private JPanel _colorNameComponent;
    private JPanel _customPanel;
    private ArrayList _customEditors;
    private static final String _COLOR_NAME = "Color_Name_Field";

    public static int showDialog(Component parent, ColorChooserPane pane) {
        return ColorChooserPane.showDialog(parent, pane, null, false);
    }

    public static int showDialog(Component parent, ColorChooserPane pane, String dialogTitle, boolean resizable) {
        if (pane == null) {
            throw new IllegalArgumentException("ColorChooserPane must be non-null");
        }
        Locale l = LocaleUtils.getDefaultableLocale((Component)pane);
        if (dialogTitle == null) {
            ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, l);
            dialogTitle = b.getString(_KEY_TITLE);
        }
        JEWTDialog d = JEWTDialog.createDialog(parent, dialogTitle, 7);
        d.setLocale(l);
        d.setContent(pane);
        d.setCenterOver(parent);
        d.setResizable(resizable);
        int ret = d.runDialog() ? 1 : 2;
        d.dispose();
        return ret;
    }

    public ColorChooserPane() {
        this(Color.black, 11);
    }

    public ColorChooserPane(Color selectedColor, int pickerMask) {
        this._imageComponent.addPropertyChangeListener(this._listener);
        this._colorComponent = new ColorComponent();
        this._colorComponent.addPropertyChangeListener(this._listener);
        this._colorName = new JTextField();
        this._colorName.getDocument().addDocumentListener(this._listener);
        this._colorName.setName(_COLOR_NAME);
        this._colorNameLabel = new JLabel(" ");
        this._colorNameLabel.setLabelFor(this._colorName);
        this._colorNameComponent = new JPanel();
        this._colorNameComponent.setLayout(new BorderLayout(5, 5));
        this._colorNameComponent.add("West", this._colorNameLabel);
        this._colorNameComponent.add("Center", this._colorName);
        this._hsbComponent = new HSBComponent();
        this._hsbComponent.addPropertyChangeListener(this._listener);
        this._hslComponent = new HSLComponent();
        this._hslComponent.addPropertyChangeListener(this._listener);
        this._rgbComponent = new RGBComponent();
        this._rgbComponent.addPropertyChangeListener(this._listener);
        this._htmlComponent = new HTMLHexComponent();
        this._htmlComponent.addPropertyChangeListener(this._listener);
        this._cmyComponent = new CMYComponent();
        this._cmyComponent.addPropertyChangeListener(this._listener);
        this.setLayout(new BorderLayout(5, 5));
        JPanel temp = new JPanel(new BorderLayout(5, 5));
        temp.add("West", this._imageComponent);
        this.add("West", temp);
        FlowLayout f = new FlowLayout();
        f.setHgap(10);
        this._colorEditorPanel = new JPanel(f);
        this._colorEditorPanel.setBorder(new EmptyBorder(3, 3, 3, 3));
        this._colorEditorPanel.add(this._rgbComponent);
        this._colorEditorPanel.add(this._hsbComponent);
        this._colorEditorPanel.add(this._cmyComponent);
        this._colorEditorPanel.add(this._hslComponent);
        JPanel middleRight = new JPanel(new BorderLayout(5, 5));
        middleRight.add("Center", this._colorEditorPanel);
        middleRight.add("North", this._htmlComponent);
        JPanel right = new JPanel(new BorderLayout(5, 5));
        right.add("North", this._colorComponent);
        right.add("Center", middleRight);
        right.add("South", this._colorNameComponent);
        JPanel temp2 = new JPanel(new BorderLayout());
        temp2.add("West", right);
        this.add("Center", temp2);
        this._customPanel = new JPanel(new FlowLayout());
        this.add("South", this._customPanel);
        this.setColorPickerMask(pickerMask);
        this.setColor(selectedColor);
    }

    public void setColor(Color c) {
        if (c == null) {
            c = Color.black;
        }
        this._updateEditors(null, c, this.getColor());
    }

    public Color getColor() {
        return this._imageComponent.getColor();
    }

    public void setOriginalColor(Color color) {
        if (color == null) {
            color = Color.black;
        }
        this._colorComponent.setOriginalColor(color);
        this.revalidate();
    }

    public Color getOriginalColor() {
        return this._colorComponent.getOriginalColor();
    }

    public void setColorName(String name) {
        this._colorName.setText(name);
    }

    public String getColorName() {
        return this._colorName.getText();
    }

    public void setColorNameVisible(boolean visible) {
        this._colorNameComponent.setVisible(visible);
        this.revalidate();
        this.repaint();
    }

    public boolean isColorNameVisible() {
        return this._colorNameComponent.isVisible();
    }

    public void setColorPickerMask(int colorPickerMask) {
        boolean rgb = (colorPickerMask & 1) != 0;
        boolean hsb = (colorPickerMask & 2) != 0;
        boolean hsl = (colorPickerMask & 4) != 0;
        boolean html = (colorPickerMask & 8) != 0;
        boolean cmy = (colorPickerMask & 0x10) != 0;
        Color currentColor = this.getColor();
        this._rgbComponent.setVisible(rgb);
        if (rgb) {
            this._rgbComponent.setColor(currentColor);
        }
        this._hsbComponent.setVisible(hsb);
        if (hsb) {
            this._hsbComponent.setColor(currentColor);
        }
        this._hslComponent.setVisible(hsl);
        if (hsl) {
            this._hslComponent.setColor(currentColor);
        }
        this._htmlComponent.setVisible(html);
        if (html) {
            this._htmlComponent.setColor(currentColor);
        }
        this._cmyComponent.setVisible(cmy);
        if (cmy) {
            this._cmyComponent.setColor(currentColor);
        }
        this._colorEditorPanel.setVisible(rgb || hsb || hsl || cmy);
        this.revalidate();
        this.repaint();
    }

    public int getColorPickerMask() {
        int colorPickers = 0;
        if (this._rgbComponent.isVisible()) {
            colorPickers |= 1;
        }
        if (this._hsbComponent.isVisible()) {
            colorPickers |= 2;
        }
        if (this._hslComponent.isVisible()) {
            colorPickers |= 4;
        }
        if (this._htmlComponent.isVisible()) {
            colorPickers |= 8;
        }
        if (this._cmyComponent.isVisible()) {
            colorPickers |= 0x10;
        }
        return colorPickers;
    }

    public void addCustomColorEditor(ColorEditor editor) {
        if (this._customEditors == null) {
            this._customEditors = new ArrayList(2);
        }
        if (this._customEditors.contains(editor)) {
            return;
        }
        this._customEditors.add(editor);
        this._customPanel.add(editor.getComponent());
        editor.setColor(this.getColor());
        editor.addPropertyChangeListener(this._listener);
        this.revalidate();
    }

    public void removeCustomColorEditor(ColorEditor editor) {
        if (this._customEditors == null) {
            return;
        }
        if (!this._customEditors.contains(editor)) {
            return;
        }
        this._customEditors.remove(editor);
        this._customPanel.remove(editor.getComponent());
        editor.removePropertyChangeListener(this._listener);
        this.revalidate();
    }

    public ColorEditor[] getCustomColorEditors() {
        return this._customEditors == null ? null : this._customEditors.toArray(new ColorEditor[0]);
    }

    public void dispose() {
        if (this._listener == null) {
            return;
        }
        ColorEditor[] editors = this.getCustomColorEditors();
        if (editors != null) {
            int count = editors.length;
            for (int i = 0; i < count; ++i) {
                editors[i].removePropertyChangeListener(this._listener);
            }
        }
        this._listener = null;
        this._colorEditorPanel = null;
        this._colorComponent = null;
        this._imageComponent = null;
        this._hsbComponent = null;
        this._hslComponent = null;
        this._rgbComponent = null;
        this._htmlComponent = null;
        this._cmyComponent = null;
        this._colorName = null;
        this._colorNameLabel = null;
        this._colorNameComponent = null;
        this._customPanel = null;
        this._customEditors = null;
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this._imageComponent.getComponent().setEnabled(enabled);
        this._colorComponent.getComponent().setEnabled(enabled);
        this._colorNameLabel.setEnabled(enabled);
        this._colorName.setEnabled(enabled);
        this._hsbComponent.getComponent().setEnabled(enabled);
        this._hslComponent.getComponent().setEnabled(enabled);
        this._rgbComponent.getComponent().setEnabled(enabled);
        this._htmlComponent.getComponent().setEnabled(enabled);
        this._cmyComponent.getComponent().setEnabled(enabled);
        ColorEditor[] customEditors = this.getCustomColorEditors();
        int count = customEditors == null ? 0 : customEditors.length;
        for (int i = 0; i < count; ++i) {
            customEditors[i].getComponent().setEnabled(enabled);
        }
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this.accessibleContext == null) {
            this.accessibleContext = new Access();
        }
        return this.accessibleContext;
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this._setText(this.getLocale());
    }

    @Override
    public void setLocale(Locale newLocale) {
        super.setLocale(newLocale);
        if (this._colorNameLabel != null) {
            this._setText(newLocale);
        }
    }

    private void _updateEditors(ColorEditor source, Color newColor, Color oldColor) {
        ColorEditor[] editors;
        if (source != this._imageComponent) {
            this._imageComponent.setColor(newColor);
        }
        if (source != this._colorComponent) {
            this._colorComponent.setColor(newColor);
        }
        if (source != this._hsbComponent && this._hsbComponent.getComponent().isVisible()) {
            this._hsbComponent.setColor(newColor);
        }
        if (source != this._hslComponent && this._hslComponent.getComponent().isVisible()) {
            this._hslComponent.setColor(newColor);
        }
        if (source != this._rgbComponent && this._rgbComponent.getComponent().isVisible()) {
            this._rgbComponent.setColor(newColor);
        }
        if (source != this._htmlComponent && this._htmlComponent.getComponent().isVisible()) {
            this._htmlComponent.setColor(newColor);
        }
        if (source != this._cmyComponent && this._cmyComponent.getComponent().isVisible()) {
            this._cmyComponent.setColor(newColor);
        }
        int count = (editors = this.getCustomColorEditors()) == null ? 0 : editors.length;
        for (int i = 0; i < count; ++i) {
            ColorEditor ce = editors[i];
            if (ce == source || !ce.getComponent().isVisible()) continue;
            ce.setColor(newColor);
        }
        this.firePropertyChange(PROPERTY_COLOR, oldColor, newColor);
    }

    private String _getTranslatedString(Locale locale, String key) {
        ResourceBundle b = ResourceBundle.getBundle(_RESOURCE, locale);
        return b.getString(key);
    }

    private void _fireNameChanged(String newName) {
        this.firePropertyChange(PROPERTY_COLOR_NAME, "", newName);
    }

    private void _setText(Locale locale) {
        String translatedText = this._getTranslatedString(locale, _KEY_COLOR_NAME);
        this._colorNameLabel.setText(StringUtils.stripMnemonic((String)translatedText));
        this._colorNameLabel.setDisplayedMnemonic(StringUtils.getMnemonicKeyCode((String)translatedText));
        this._imageComponent.setLocale(locale);
        this._colorComponent.setLocale(locale);
        this._rgbComponent.setLocale(locale);
        this._hsbComponent.setLocale(locale);
        this._hslComponent.setLocale(locale);
        this._cmyComponent.setLocale(locale);
        this._htmlComponent.setLocale(locale);
        ColorEditor[] customEditors = this.getCustomColorEditors();
        int count = customEditors == null ? 0 : customEditors.length;
        for (int i = 0; i < count; ++i) {
            customEditors[i].getComponent().setLocale(locale);
        }
    }

    private class Listener
    implements PropertyChangeListener,
    DocumentListener {
        private Listener() {
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            String name = e.getPropertyName();
            if (ColorChooserPane.PROPERTY_COLOR.equals(name)) {
                ColorEditor source = (ColorEditor)e.getSource();
                ColorChooserPane.this._updateEditors(source, (Color)e.getNewValue(), (Color)e.getOldValue());
            }
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            ColorChooserPane.this._fireNameChanged(ColorChooserPane.this._colorName.getText());
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            ColorChooserPane.this._fireNameChanged(ColorChooserPane.this._colorName.getText());
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            ColorChooserPane.this._fireNameChanged(ColorChooserPane.this._colorName.getText());
        }
    }

    private class Access
    extends JComponent.AccessibleJComponent {
        private Access() {
            super(ColorChooserPane.this);
        }
    }
}

