/*
 * Decompiled with CFR 0.152.
 */
package oracle.bali.ewt.button;

import javax.swing.Icon;
import javax.swing.JButton;
import oracle.bali.share.collection.StringKey;

public class PushButton
extends JButton {
    public static Object LEFTMOST_BUTTON_KEY = new StringKey("EWTLeftmostButton");
    public static Object RIGHTMOST_BUTTON_KEY = new StringKey("EWTRightmostButton");

    public PushButton() {
        this(null, null);
    }

    public PushButton(Icon icon) {
        this(null, icon);
    }

    public PushButton(String text) {
        this(text, null);
    }

    public PushButton(String text, Icon icon) {
        super(text, icon);
    }

    public void setLeftmost(boolean isLeftmost) {
        Boolean b = this._getLeftmost();
        if (b == null || b != isLeftmost) {
            this.putClientProperty(LEFTMOST_BUTTON_KEY, isLeftmost ? Boolean.TRUE : Boolean.FALSE);
            if (b != null || !isLeftmost) {
                this.revalidate();
            }
        }
    }

    public boolean isLeftmost() {
        Boolean b = this._getLeftmost();
        if (b != null) {
            return b;
        }
        return false;
    }

    public void setRightmost(boolean isRightmost) {
        Boolean b = this._getRightmost();
        if (b == null || b != isRightmost) {
            this.putClientProperty(RIGHTMOST_BUTTON_KEY, isRightmost ? Boolean.TRUE : Boolean.FALSE);
            if (b != null || !isRightmost) {
                this.revalidate();
            }
        }
    }

    public boolean isRightmost() {
        Boolean b = this._getRightmost();
        if (b != null) {
            return b;
        }
        return false;
    }

    private Boolean _getRightmost() {
        Object o = this.getClientProperty(RIGHTMOST_BUTTON_KEY);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }

    private Boolean _getLeftmost() {
        Object o = this.getClientProperty(LEFTMOST_BUTTON_KEY);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return null;
    }
}

