/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.webupdate.parser;

import java.util.Iterator;
import java.util.Set;
import javax.ide.util.Version;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import oracle.ideimpl.webupdate.UpdateBundle;
import oracle.ideimpl.webupdate.UpdateCategory;
import oracle.ideimpl.webupdate.UpdateInfo;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public final class UpdateXMLBuilder {
    private DocumentBuilder _builder;

    private DocumentBuilder getDocumentBuilder() throws ParserConfigurationException {
        if (this._builder == null) {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            factory.setValidating(false);
            this._builder = factory.newDocumentBuilder();
        }
        return this._builder;
    }

    public Document createUpdatesDocument() throws ParserConfigurationException {
        Document doc = this.getDocumentBuilder().newDocument();
        Element root = doc.createElementNS("http://xmlns.oracle.com/jdeveloper/updatecenter", "updates");
        root.setAttribute("version", "1.0");
        doc.appendChild(root);
        return doc;
    }

    public void appendUpdateBundle(Document document, UpdateBundle bundle) {
        Set<UpdateInfo> updates = bundle.getUpdates();
        if (updates.size() == 1) {
            this.appendUpdate(document.getDocumentElement(), updates.iterator().next());
        } else {
            Element eBundle = document.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "bundle");
            document.getDocumentElement().appendChild(eBundle);
            this.text(eBundle, "http://xmlns.oracle.com/jdeveloper/update", "name", bundle.getName());
            this.text(eBundle, "http://xmlns.oracle.com/jdeveloper/update", "bundle-url", bundle.getDownloadUrl());
            this.text(eBundle, "http://xmlns.oracle.com/jdeveloper/update", "destination", bundle.getInstallLocation());
            Iterator<UpdateInfo> i = updates.iterator();
            while (i.hasNext()) {
                this.appendUpdate(eBundle, i.next());
            }
        }
    }

    private void appendUpdate(Element parent, UpdateInfo update) {
        UpdateCategory category;
        Document doc = parent.getOwnerDocument();
        Element eUpdate = doc.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "update");
        eUpdate.setAttribute("id", update.getID());
        eUpdate.setAttribute("type", update.getType().name().toLowerCase());
        parent.appendChild(eUpdate);
        this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "name", update.getName());
        this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "version", update.getVersion().toString());
        this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "author", update.getAuthor());
        this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "author-url", update.getAuthorURL());
        this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "description", update.getDescription());
        if (update.getPostStartupHookClass() != null) {
            this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "post-startup-hook", update.getPostStartupHookClass());
        }
        Element eRequirements = doc.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "requirements");
        eUpdate.appendChild(eRequirements);
        for (String id : update.getRequiredIds()) {
            Version min = update.getRequiredMinVersion(id);
            Version max = update.getRequiredMaxVersion(id);
            Element eRequiresExtension = doc.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "requires-extension");
            eRequiresExtension.setAttribute("id", id);
            if (min != null) {
                eRequiresExtension.setAttribute("minVersion", min.toString());
            }
            if (max != null) {
                eRequiresExtension.setAttribute("maxVersion", max.toString());
            }
            eRequirements.appendChild(eRequiresExtension);
        }
        if (update.getClickThroughURL() != null) {
            Element eRequiresAgreement = doc.createElementNS("http://xmlns.oracle.com/jdeveloper/update", "requires-agreement");
            eRequirements.appendChild(eRequiresAgreement);
            eRequiresAgreement.setAttribute("url", update.getClickThroughURL());
        }
        if (update.getPreferredInstallLocation() != null) {
            this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "destination", update.getPreferredInstallLocation());
        }
        if ((category = update.getCategory()) != null && category.isCategorySet()) {
            if (category.getCategoryId() != null) {
                this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "category-id", category.getCategoryId());
            }
            if (category.getCategoryName() != null) {
                this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "category", category.getCategoryName());
            }
        }
        this.text(eUpdate, "http://xmlns.oracle.com/jdeveloper/update", "bundle-url", update.getURL());
    }

    private void text(Element parent, String ns, String element, String text) {
        if (text == null) {
            return;
        }
        Element e = parent.getOwnerDocument().createElementNS(ns, element);
        parent.appendChild(e);
        e.appendChild(parent.getOwnerDocument().createTextNode(text));
    }
}

