/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.JOptionPane;
import oracle.hcs.HCSArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.db.IdentifierElement;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templateview.MultiSelectShuttlePanel;
import oracle.hcs.templates.templateview.TemplateHyperParamMultiSelect;
import oracle.ide.Ide;
import oracle.javatools.dialogs.MessageDialog;

public class TemplateHyperParamMeasureSelection
extends TemplateHyperParamMultiSelect {
    private AnalyticView analyticView;

    public TemplateHyperParamMeasureSelection() {
        this.selectionJOptionPanePropertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                String string = propertyChangeEvent.getPropertyName();
                if (TemplateHyperParamMeasureSelection.this.selectionDialog.isVisible() && propertyChangeEvent.getSource() == TemplateHyperParamMeasureSelection.this.pane && string.equals("value")) {
                    Object object = TemplateHyperParamMeasureSelection.this.pane.getValue();
                    if (object == JOptionPane.UNINITIALIZED_VALUE) {
                        return;
                    }
                    if ((Integer)object == 0) {
                        List<String> list = TemplateHyperParamMeasureSelection.this.multiSelectEditor.getSelectedItems();
                        if (list.size() > 0) {
                            TemplateHyperParamMeasureSelection.this.selectionDialog.setVisible(false);
                        } else {
                            String string2 = HCSArb.get("AV_DATA_VIEWER_NO_MEASURES_SELECTED_ERROR_MSG");
                            String string3 = HCSArb.get("MULTI_MEASURE_SELECTION_ERROR_TITLE");
                            String string4 = null;
                            MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)string3, string4);
                            TemplateHyperParamMeasureSelection.this.pane.setValue(JOptionPane.UNINITIALIZED_VALUE);
                        }
                    } else {
                        TemplateHyperParamMeasureSelection.this.selectionDialog.setVisible(false);
                    }
                }
            }
        };
    }

    @Override
    public ParseNode getPattern() {
        ParseNode parseNode = new ParseNode("measure_selection", null, ParseNode.PatternType.LOOP);
        parseNode.add(new ParseNode("measure_selection", HCSSyntaxType.MEASURE.toString(), ParseNode.PatternType.NONE));
        return parseNode;
    }

    private void setAV(AnalyticView analyticView) {
        List<Object> list = new ArrayList();
        this.analyticView = analyticView;
        this.helpID = null;
        this.editorTitle = this.getTemplateHyperContext().getResources().getString("MULTI_MEASURE_SELECTION_LABEL");
        AVMeasure[] aVMeasureArray = analyticView.getMeasures();
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = this.getTemplateHyperContext().getResources().getString("MULTI_MEASURE_AVAILABLE_MEASURE_LIST_LABEL");
        String string2 = this.getTemplateHyperContext().getResources().getString("MULTI_MEASURE_SELECTED_MEASURE_LIST_LABEL");
        for (AVMeasure aVMeasure : aVMeasureArray) {
            if (aVMeasure.isDerived()) continue;
            String string3 = aVMeasure.getName();
            string3 = String.format("%s.%s", analyticView.getName(), string3);
            arrayList.add(string3);
        }
        this.multiSelectEditor = new MultiSelectShuttlePanel(arrayList, string, string2);
        list = this.getDefaultAVMeasureSelection(analyticView);
        this.setValue(list);
    }

    public AnalyticView getAV() {
        return this.analyticView;
    }

    @Override
    public String getExpression() {
        StringBuilder stringBuilder = new StringBuilder();
        Iterator iterator = this.selections.iterator();
        if (iterator.hasNext()) {
            IdentifierElement identifierElement = new IdentifierElement((String)iterator.next());
            stringBuilder.append(identifierElement.getSecond());
            while (iterator.hasNext()) {
                stringBuilder.append(',');
                identifierElement = new IdentifierElement((String)iterator.next());
                stringBuilder.append(identifierElement.getSecond());
            }
        }
        return stringBuilder.toString();
    }

    public List<String> getDefaultAVMeasureSelection(AnalyticView analyticView) {
        List<AVBaseMeasure> list = analyticView.getStoredAndCalculatedMeasures();
        String string = analyticView.getName();
        ArrayList<String> arrayList = new ArrayList<String>();
        for (AVBaseMeasure aVBaseMeasure : list) {
            if (aVBaseMeasure.isDerived()) continue;
            String string2 = string + "." + aVBaseMeasure.getName();
            arrayList.add(string2);
        }
        return arrayList;
    }

    @Override
    public void init() {
        this.setAV(this.getTemplateContext().getAV());
    }
}

