/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.templates.templateview;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import javax.swing.tree.TreePath;
import oracle.dbtools.db.DBUtil;
import oracle.dbtools.raptor.utils.Connections;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.BaseRunnable;
import oracle.hcs.av.model.AVHierarchy;
import oracle.hcs.dimension.model.AttributeDimension;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.hierarchyviewer.HierarchyET;
import oracle.hcs.hierarchyviewer.HierarchyViewerDialog;
import oracle.hcs.metadata.HCSSchema;
import oracle.hcs.syntaxbuilder.HCSSyntaxType;
import oracle.hcs.templates.syntaxparser.ParseNode;
import oracle.hcs.templates.templatelist.Param;
import oracle.hcs.templates.templateview.QDRData;
import oracle.hcs.templates.templateview.TemplateHyperParam;
import oracle.hcs.tree.model.DefaultNode;
import oracle.hcs.tree.model.HierarchyNodeData;
import oracle.hcs.util.ExceptionUtil;
import oracle.hcs.util.HyperLabel;
import oracle.hcs.util.HyperLabelActionListener;
import oracle.ide.Ide;
import oracle.ide.dialogs.ProgressBar;
import oracle.javatools.dialogs.MessageDialog;

public class TemplateHyperParamHierarchyMembers
extends TemplateHyperParam
implements PropertyChangeListener {
    private static Logger LOG = Logger.getLogger(TemplateHyperParamHierarchyMembers.class.getName());
    private Hierarchy hierarchy;
    private AVHierarchy avHier;
    private HyperLabel membersHyperLabel;
    private QDRData[] qdrs;
    private static final String TEMP_DEFAULT = "'Q1'";
    private static final String LINEAGE = "lineage";
    private HierarchyViewerDialog memberSelectionDialog;
    public static final String DIMENSION_PROPERTY = "dimension";
    private static final ParseNode pattern = new ParseNode("hierarchy_members", HCSSyntaxType.LEVEL.toString(), ParseNode.PatternType.LOOP);

    public TemplateHyperParamHierarchyMembers() {
        this.qdrs = new QDRData[]{new QDRData(this.avHier, "0", "")};
        this.membersHyperLabel = new HyperLabel(TEMP_DEFAULT);
        this.membersHyperLabel.addActionListener(new HyperLabelActionListener(){

            @Override
            public void actionPerformed(Object object, String string) {
                TemplateHyperParamHierarchyMembers.this.showHierarchyMembersDialog();
            }
        });
    }

    @Override
    public Component getComponent() {
        return this.membersHyperLabel;
    }

    private void showHierarchyMembersDialog() {
        Iterator<Hierarchy> iterator;
        Object object;
        String string = HCSArb.getString("DIMENSION_MEMBER_SELECTOR_TITLE");
        Connection connection = this.getTemplateHyperContext().getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        HCSSchema hCSSchema = null;
        String string2 = "";
        if (this.hierarchy != null) {
            hCSSchema = (HCSSchema)this.hierarchy.getSchema();
            string2 = this.hierarchy.getDimensionName();
        } else if (this.avHier != null) {
            hCSSchema = (HCSSchema)this.avHier.getHierarchy().getSchema();
            string2 = this.avHier.getHierarchy().getDimensionName();
        }
        AttributeDimension attributeDimension = hCSSchema.findDimension(string2);
        ArrayList<HierarchyET> arrayList = new ArrayList<HierarchyET>();
        String string3 = this.getBaseTemplateHyperView().getCurrentParameterValues().get(LINEAGE);
        if (!attributeDimension.isFlat()) {
            object = hCSSchema.getHierarchies(attributeDimension);
            iterator = object.iterator();
            while (iterator.hasNext()) {
                Hierarchy hierarchy = iterator.next();
                try {
                    arrayList.add(new HierarchyET(connection, hierarchy));
                }
                catch (SQLException sQLException) {
                    LOG.log(Level.SEVERE, sQLException.getLocalizedMessage(), sQLException);
                }
                catch (IOException iOException) {
                    LOG.log(Level.SEVERE, iOException.getLocalizedMessage(), iOException);
                }
            }
        }
        if (arrayList.size() > 0) {
            try {
                object = "";
                if (this.hierarchy != null) {
                    object = this.hierarchy.getName();
                } else if (this.avHier != null) {
                    object = this.avHier.getName();
                }
                this.loadHierarchyDialog(string, arrayList, (String)object, string3);
            }
            catch (Exception exception) {
                iterator = null;
                MessageDialog.error((Component)this.membersHyperLabel, (Object)HCSArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), (String)ExceptionUtil.getMessageOrStackTrace(exception), iterator);
                LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
            }
        } else {
            object = null;
            MessageDialog.error((Component)this.membersHyperLabel, (Object)HCSArb.get("DIMENSION_MEMBER_SELECTOR_NOT_FOUND"), (String)HCSArb.get("DIMENSION_MEMBER_SELECTOR_HVIEWER_ERROR_TITLE"), (String)object);
        }
    }

    private void loadHierarchyDialog(final String string, final List<HierarchyET> list, final String string2, final String string3) throws Exception {
        BaseRunnable baseRunnable = new BaseRunnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                boolean bl = false;
                Connection connection = TemplateHyperParamHierarchyMembers.this.getTemplateHyperContext().getConnection();
                try {
                    TemplateHyperParamHierarchyMembers.this.memberSelectionDialog = new HierarchyViewerDialog(SwingUtilities.getWindowAncestor(TemplateHyperParamHierarchyMembers.this.membersHyperLabel), string, list, string2, "SELECT_DIMENSION_MEMBERS_MODE", TemplateHyperParamHierarchyMembers.this.qdrs, string3, bl, connection);
                }
                catch (Exception exception) {
                    LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                }
                finally {
                    this.getProgressBar().setDoneStatus();
                }
            }
        };
        String string4 = HCSArb.getString("DATA_VIEWER_INITIALIZING_BUZY_BAR_TITLE");
        ProgressBar progressBar = new ProgressBar((Component)Ide.getMainWindow(), string4, (Runnable)baseRunnable, true);
        progressBar.setCancelable(false);
        baseRunnable.setProgressBar(progressBar);
        progressBar.start("Load Hierarchy Viewer", null);
        if (baseRunnable.getException() != null) {
            throw baseRunnable.getException();
        }
        if (this.memberSelectionDialog != null) {
            this.memberSelectionDialog.setModalityType(Dialog.ModalityType.APPLICATION_MODAL);
            Dimension dimension = new Dimension(350, 400);
            this.memberSelectionDialog.setPreferredSize(dimension);
            this.memberSelectionDialog.setSize(dimension);
            this.memberSelectionDialog.setLocationRelativeTo(this.membersHyperLabel);
            this.memberSelectionDialog.setVisible(true);
            if (this.memberSelectionDialog.isOKSelected()) {
                this.processUserSelection();
            }
        }
    }

    private void processUserSelection() {
        TreePath[] treePathArray = this.memberSelectionDialog.getTree().getSelectionPaths();
        StringBuffer stringBuffer = new StringBuffer();
        if (treePathArray != null) {
            this.qdrs = new QDRData[treePathArray.length];
            int n = 0;
            for (TreePath treePath : treePathArray) {
                Object object = treePath.getLastPathComponent();
                DefaultNode defaultNode = (DefaultNode)object;
                if (!(defaultNode.getUserObject() instanceof HierarchyNodeData)) continue;
                HierarchyNodeData hierarchyNodeData = (HierarchyNodeData)defaultNode.getUserObject();
                stringBuffer.append("'" + hierarchyNodeData.desc + "'");
                stringBuffer.append(",");
                if (this.hierarchy != null) {
                    this.qdrs[n++] = new QDRData(this.hierarchy, hierarchyNodeData.dimKey, hierarchyNodeData.desc);
                }
                if (this.avHier == null) continue;
                this.qdrs[n++] = new QDRData(this.avHier, hierarchyNodeData.dimKey, hierarchyNodeData.desc);
            }
            if (stringBuffer.charAt(stringBuffer.length() - 1) == ',') {
                stringBuffer.deleteCharAt(stringBuffer.length() - 1);
            }
            this.setValue(stringBuffer);
            TreePath[] treePathArray2 = null;
            StringBuffer stringBuffer2 = stringBuffer;
            PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "VALUE_CHANGED", treePathArray2, stringBuffer2);
            this.firePropertyChangeEvent(propertyChangeEvent);
        }
    }

    @Override
    public int getPixelSize(int n) {
        String string = this.membersHyperLabel.getText();
        if (string.length() > 0) {
            return this.membersHyperLabel.getFontMetrics(this.membersHyperLabel.getFont()).stringWidth(string);
        }
        return 100;
    }

    @Override
    public ParseNode getPattern() {
        return pattern;
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getNewValue() instanceof Hierarchy) {
            Hierarchy hierarchy = (Hierarchy)propertyChangeEvent.getNewValue();
            this.setHierarchy(hierarchy);
        } else if (propertyChangeEvent.getNewValue() instanceof AVHierarchy) {
            AVHierarchy aVHierarchy = (AVHierarchy)propertyChangeEvent.getNewValue();
            this.setHierarchy(aVHierarchy);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void setHierarchy(Object object) {
        Object object2;
        if (this.hierarchy == object || this.avHier == object) {
            return;
        }
        if (object instanceof Hierarchy) {
            object2 = (Hierarchy)object;
            this.hierarchy = object2;
            this.avHier = null;
        } else if (object instanceof AVHierarchy) {
            this.avHier = object2 = (AVHierarchy)object;
            this.hierarchy = null;
        }
        object2 = this.getParam();
        if (object2 == null) {
            return;
        }
        String string = ((Param)object2).getDefault();
        Connection connection = this.getTemplateHyperContext().getConnection();
        DBUtil dBUtil = DBUtil.getInstance((Connection)connection);
        this.setValue(TEMP_DEFAULT);
        ResultSet resultSet = null;
        if (!Connections.getInstance().lock(connection)) return;
        try {
            Object object3;
            CharSequence charSequence;
            String string2 = this.getBaseTemplateHyperView().getExpression(string, null);
            resultSet = dBUtil.executeQuery(string2, new ArrayList());
            HashMap<CharSequence, Object> hashMap = new HashMap<CharSequence, Object>();
            if (resultSet != null) {
                while (resultSet.next()) {
                    charSequence = resultSet.getString(1);
                    object3 = resultSet.getString(2);
                    hashMap.put(charSequence, object3);
                }
            }
            if (!hashMap.isEmpty()) {
                Object object4;
                String string3;
                Map.Entry entry;
                charSequence = new StringBuilder();
                object3 = hashMap.entrySet().iterator();
                int n = 0;
                while (object3.hasNext()) {
                    entry = (Map.Entry)object3.next();
                    string3 = (String)entry.getKey();
                    object4 = (String)entry.getValue();
                    if (this.hierarchy != null) {
                        this.qdrs[n] = new QDRData(this.hierarchy, string3, (String)object4);
                    }
                    if (this.avHier != null) {
                        this.qdrs[n] = new QDRData(this.avHier, string3, (String)object4);
                    }
                    ++n;
                    ((StringBuilder)charSequence).append(String.format("'%s',", object4));
                }
                ((StringBuilder)charSequence).deleteCharAt(((StringBuilder)charSequence).lastIndexOf(","));
                this.setValue(((StringBuilder)charSequence).toString());
                entry = null;
                string3 = ((StringBuilder)charSequence).toString();
                object4 = new PropertyChangeEvent(this, "VALUE_CHANGED", entry, string3);
                this.firePropertyChangeEvent((PropertyChangeEvent)object4);
            }
            if (resultSet == null) return;
        }
        catch (Exception exception) {
            try {
                LOG.log(Level.SEVERE, exception.getLocalizedMessage(), exception);
                if (resultSet == null) return;
            }
            catch (Throwable throwable) {
                if (resultSet == null) throw throwable;
                DBUtil.closeResultSet(resultSet);
                Connections.getInstance().unlock(connection);
                throw throwable;
            }
            DBUtil.closeResultSet((ResultSet)resultSet);
            Connections.getInstance().unlock(connection);
            return;
        }
        DBUtil.closeResultSet((ResultSet)resultSet);
        Connections.getInstance().unlock(connection);
        return;
    }

    @Override
    public Object getValue() {
        return this.qdrs;
    }

    @Override
    public String getExpression() {
        return this.membersHyperLabel.getText();
    }

    @Override
    public void setVisible(boolean bl) {
        super.setVisible(bl);
    }

    @Override
    public void setDefault(String string) {
        if (!string.toLowerCase().startsWith("select ")) {
            super.setDefault(string);
        }
    }

    @Override
    public boolean setValue(Object object) {
        this.membersHyperLabel.setText(object.toString());
        return true;
    }
}

