/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.syntax;

import oracle.hcs.syntax.BaseMetadataObjectReference;
import oracle.hcs.syntax.BaseQuery;
import oracle.hcs.syntax.DataType;
import oracle.hcs.syntax.MetadataObjectReference;
import oracle.hcs.syntax.Query;
import oracle.hcs.syntax.SyntaxException;
import oracle.hcs.syntax.SyntaxObject;
import oracle.hcs.syntax.SyntaxObjectVisitor;
import oracle.hcs.syntax.SyntaxPrintingContext;
import oracle.hcs.syntax.TypedExpression;
import oracle.hcs.syntax.ValidationContext;
import oracle.hcs.syntax.metadata.BaseMetadataObject;
import oracle.hcs.syntax.metadata.mdm.MdmQuery;
import oracle.hcs.syntax.metadata.mdm.MdmQueryColumn;
import oracle.hcs.syntax.metadata.mdm.MdmViewColumn;
import oracle.hcs.syntax.parser.ExpParser;

public final class ColumnExpression
extends TypedExpression {
    private BaseQuery m_Query = null;
    private MdmViewColumn m_ViewColumn = null;
    private BaseMetadataObjectReference m_MetadataColumn = null;

    @Override
    void toSyntax(SyntaxPrintingContext syntaxPrintingContext) {
        Object object = this.getQuery().getName();
        if (null != object) {
            object = (String)object + ".";
        }
        object = (String)object + this.getColumnName();
        syntaxPrintingContext.appendIdentifier((String)object);
    }

    MdmQueryColumn getQueryColumn() {
        if (null != this.m_ViewColumn) {
            return this.m_ViewColumn;
        }
        return (MdmQueryColumn)((Object)this.m_MetadataColumn.getBaseMetadataObject());
    }

    @Override
    public SyntaxObject validate(ValidationContext validationContext) {
        if (null != this.m_MetadataColumn) {
            this.m_MetadataColumn = (BaseMetadataObjectReference)validationContext.validate(this.m_MetadataColumn);
        }
        this.m_Query = (BaseQuery)validationContext.validate(this.m_Query);
        if (null != this.m_MetadataColumn && this.m_MetadataColumn.isValid() || null != this.m_ViewColumn) {
            this.setDataType(this.getQueryColumn().getSQLDataType().getDataType());
        } else {
            this.setDataType(DataType.NULL_TYPE);
        }
        return this;
    }

    @Override
    protected boolean checkIfDefinitionIsComplete() {
        if (!this.m_Query.isDefinitionComplete()) {
            return false;
        }
        if (null != this.m_MetadataColumn && !this.m_MetadataColumn.isDefinitionComplete()) {
            return false;
        }
        return super.checkIfDefinitionIsComplete();
    }

    public ColumnExpression(MdmQueryColumn mdmQueryColumn, Query query) {
        ColumnExpression.validateValue(mdmQueryColumn);
        ColumnExpression.validateValue(query);
        if (!(query instanceof BaseQuery)) {
            throw new SyntaxException("BaseQuery Expected");
        }
        this.m_Query = (BaseQuery)query;
        if (mdmQueryColumn instanceof MdmViewColumn) {
            this.m_ViewColumn = (MdmViewColumn)mdmQueryColumn;
        } else {
            BaseMetadataObject baseMetadataObject = mdmQueryColumn.getColumnObject();
            this.m_MetadataColumn = new MetadataObjectReference(baseMetadataObject, MdmQueryColumn.class);
        }
        this.setDataType(mdmQueryColumn.getSQLDataType().getDataType());
        this.initialize();
    }

    public ColumnExpression(ExpParser expParser, BaseMetadataObjectReference baseMetadataObjectReference) {
        this.m_MetadataColumn = baseMetadataObjectReference;
        this.m_Query = new BaseQuery(expParser, expParser.getIDResolver().getUnresolvedMetadataObjectReference(this.m_MetadataColumn.getIdentifier().getParentID(), MdmQuery.class, 2));
        this.initialize();
    }

    @Override
    public Object visit(SyntaxObjectVisitor syntaxObjectVisitor, Object object) {
        return syntaxObjectVisitor.visitColumnExpression(this, object);
    }

    public Query getQuery() {
        return this.m_Query;
    }

    public String getColumnName() {
        if (null != this.m_MetadataColumn) {
            return this.m_MetadataColumn.getName();
        }
        if (null != this.m_ViewColumn) {
            return this.m_ViewColumn.getName();
        }
        return null;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof ColumnExpression)) {
            return false;
        }
        ColumnExpression columnExpression = (ColumnExpression)object;
        return this.getColumnName().equalsIgnoreCase(columnExpression.getColumnName()) && this.getQuery().equals(columnExpression.getQuery());
    }
}

