/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.quickav;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractCellEditor;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableModel;
import oracle.hcs.HCSArb;
import oracle.hcs.hierarchy.model.Hierarchy;
import oracle.hcs.quickav.QuickAVDataTableHelper;
import oracle.hcs.quickav.QuickAVEditableCellRenderer;
import oracle.hcs.util.UIStringUtils;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.table.GenericTable;

public abstract class QuickAVMetadataObjectEditorPanel
extends JPanel {
    private Object metadataObjectList;
    private QuickAVDataTableHelper metadataHelper;
    private GenericTable objectsTable;
    private static final int OBJECT_NAME_COL = 2;
    private static final int OBJECT_ALIAS_COL = 3;
    protected final DBObjectProvider prov;
    private TableModel model;
    private Map<String, String> comboTranslations;
    protected static final String VIEW_NAME_KEY = "VIEW_NAME";
    protected static final String DATA_TYPE_KEY = "DATA_TYPE_KEY";
    private Collection<Hierarchy> allModelHierarchies;

    public QuickAVMetadataObjectEditorPanel(Object object, QuickAVDataTableHelper quickAVDataTableHelper, DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
        this.metadataObjectList = object;
        this.metadataHelper = quickAVDataTableHelper;
        this.comboTranslations = new HashMap<String, String>();
        this.populateComboTranslationsMap(this.getTranslationsList());
        this.model = this.initTableModel();
        this.objectsTable = new GenericTable(this.model);
        HashSet<Integer> hashSet = new HashSet<Integer>();
        hashSet.add(this.getComboBoxIndexColumn());
        QuickAVEditableCellRenderer quickAVEditableCellRenderer = new QuickAVEditableCellRenderer(hashSet);
        this.objectsTable.getColumnModel().getColumn(2).setCellEditor(new MetadataObjectNameCellEditor());
        this.objectsTable.getColumnModel().getColumn(3).setCellEditor(new MetadataObjectNameCellEditor());
        this.objectsTable.getColumnModel().getColumn(2).setCellRenderer(quickAVEditableCellRenderer);
        this.objectsTable.getColumnModel().getColumn(3).setCellRenderer(quickAVEditableCellRenderer);
        this.objectsTable.getColumnModel().getColumn(this.getComboBoxIndexColumn()).setCellRenderer(quickAVEditableCellRenderer);
        this.layoutComponents();
    }

    protected void layoutComponents() {
        this.setLayout(new GridBagLayout());
        this.add((Component)new JScrollPane((Component)this.objectsTable), new GridBagConstraints(0, 0, 1, 1, 0.5, 0.5, 10, 1, new Insets(5, 5, 5, 5), 0, 0));
    }

    protected GenericTable getMetadataObjectsTable() {
        return this.objectsTable;
    }

    public void setAllModelHierarchies(Collection<Hierarchy> collection) {
        this.allModelHierarchies = collection;
    }

    protected Collection<Hierarchy> getAllModelHierarchies() {
        return this.allModelHierarchies;
    }

    public void setMetadataObjectList(Object object) {
        this.metadataObjectList = object;
        this.refreshTableModel(object);
    }

    protected QuickAVDataTableHelper getQuickAVTableDataHelper() {
        return this.metadataHelper;
    }

    protected Object getMetadataObjectList() {
        return this.metadataObjectList;
    }

    protected abstract List<ComboTranslationPairs> getTranslationsList();

    protected void populateComboTranslationsMap(List<ComboTranslationPairs> list) {
        for (ComboTranslationPairs comboTranslationPairs : list) {
            this.comboTranslations.put(comboTranslationPairs.getKey(), comboTranslationPairs.getValue());
        }
    }

    protected String getTranslationKey(String string) {
        for (Map.Entry<String, String> entry : this.comboTranslations.entrySet()) {
            if (!entry.getValue().equals(string)) continue;
            return entry.getKey();
        }
        return "";
    }

    protected String getTranslationValue(String string) {
        return this.comboTranslations.get(string);
    }

    protected abstract void refreshTableModel(Object var1);

    protected abstract TableModel initTableModel();

    protected abstract String getMetadataObjectType();

    protected abstract int getComboBoxIndexColumn();

    private String getObjectActualValue(int n, int n2) {
        return (String)this.model.getValueAt(n, n2);
    }

    protected abstract String getDuplicateNameErrorMessage(String var1);

    public boolean commitCellEdit() {
        if (this.objectsTable.isEditing()) {
            return this.objectsTable.getCellEditor().stopCellEditing();
        }
        return true;
    }

    protected boolean isDuplicatedName(String string, int n) {
        return this.isDuplicate(string, n, 2);
    }

    private boolean isDuplicate(String string, int n, int n2) {
        for (int i = 0; i < this.objectsTable.getRowCount(); ++i) {
            String string2 = (String)this.objectsTable.getValueAt(i, n2);
            if (!string.equals(string2) || i == n) continue;
            return true;
        }
        return false;
    }

    protected boolean nameExists(String string) {
        return false;
    }

    private class MetadataObjectNameCellEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        JTextField cellTextField = new JTextField();
        String oldName;
        String cellValue;
        int row;
        int column;
        String errMsg;
        String errMsgTitle;

        @Override
        public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n, int n2) {
            this.row = n;
            this.column = n2;
            this.oldName = QuickAVMetadataObjectEditorPanel.this.getObjectActualValue(n, n2);
            this.cellTextField.setText((String)object);
            return this.cellTextField;
        }

        @Override
        public Object getCellEditorValue() {
            return this.cellTextField.getText();
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = true;
            try {
                this.cellValue = this.cellTextField.getText();
                QuickAVMetadataObjectEditorPanel.this.prov.validateName(QuickAVMetadataObjectEditorPanel.this.getMetadataObjectType(), this.cellValue);
                bl = true;
            }
            catch (InvalidNameException invalidNameException) {
                bl = false;
                if (this.column == 3) {
                    this.errMsg = HCSArb.get("ATTRIBUTE_DIMENSION_ALIAS_ERROR_NAME");
                    this.errMsgTitle = HCSArb.get("AV_MEASURE_ALIAS_ERROR_TITLE");
                } else if (this.column == 2) {
                    this.errMsg = invalidNameException.getMessage();
                    this.errMsgTitle = HCSArb.get("AV_MEASURE_NAME_ERROR_TITLE");
                }
                this.focusCellWithError();
                return bl;
            }
            this.cellValue = UIStringUtils.normalizeName(this.cellValue, QuickAVMetadataObjectEditorPanel.this.prov);
            if (!this.isCellValueValid()) {
                bl = false;
                this.focusCellWithError();
                return bl;
            }
            this.cellTextField.setText(this.cellValue);
            QuickAVMetadataObjectEditorPanel.this.objectsTable.setValueAt((Object)this.cellValue, this.row, this.column);
            return super.stopCellEditing();
        }

        private void focusCellWithError() {
            this.showErrorMessage(this.errMsg, this.errMsgTitle);
            this.cellTextField.setText(this.cellValue);
            this.cellTextField.select(0, this.cellValue.length());
        }

        private boolean isCellValueValid() {
            String string = QuickAVMetadataObjectEditorPanel.this.getObjectActualValue(this.row, 2);
            String string2 = QuickAVMetadataObjectEditorPanel.this.getObjectActualValue(this.row, 3);
            switch (this.column) {
                case 2: {
                    if (QuickAVMetadataObjectEditorPanel.this.nameExists(this.cellValue)) {
                        this.errMsg = HCSArb.format("QUICK_AV_OBJECT_NAME_VALIDATION_ERROR", this.cellValue);
                        this.errMsgTitle = HCSArb.get("AV_MEASURE_NAME_ERROR_TITLE");
                        return false;
                    }
                    if (QuickAVMetadataObjectEditorPanel.this.isDuplicatedName(this.cellValue, this.row)) {
                        this.errMsg = QuickAVMetadataObjectEditorPanel.this.getDuplicateNameErrorMessage(this.cellValue);
                        this.errMsgTitle = HCSArb.get("AV_MEASURE_NAME_ERROR_TITLE");
                        return false;
                    }
                    if (!QuickAVMetadataObjectEditorPanel.this.isDuplicate(this.cellValue, this.row, 3) || !string.equals(string2)) break;
                    String string3 = String.format("%s_%s", this.cellValue, 1);
                    QuickAVMetadataObjectEditorPanel.this.objectsTable.setValueAt((Object)string3, this.row, 3);
                    break;
                }
                case 3: {
                    if (!QuickAVMetadataObjectEditorPanel.this.isDuplicate(this.cellValue, this.row, 3)) break;
                    this.errMsg = HCSArb.format("ATTRIBUTE_DIMENSION_ALIAS_ERROR_DUPLICATE_NAME", this.cellValue);
                    this.errMsgTitle = HCSArb.get("AV_MEASURE_ALIAS_ERROR_TITLE");
                    return false;
                }
            }
            return true;
        }

        private void showErrorMessage(String string, String string2) {
            MessageDialog.error((Component)QuickAVMetadataObjectEditorPanel.this, (Object)string, (String)string2, null);
            this.cellTextField.setText(this.oldName);
        }
    }

    protected class ComboTranslationPairs {
        private String key;
        private String value;

        public ComboTranslationPairs(String string, String string2) {
            this.key = string;
            this.value = string2;
        }

        public String getKey() {
            return this.key;
        }

        public String getValue() {
            return this.value;
        }
    }
}

