/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.List;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import oracle.hcs.HCSArb;
import oracle.hcs.HCSImagesArb;
import oracle.hcs.av.model.AVBaseMeasure;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.AVMeasureObjectEditorPanel;
import oracle.hcs.db.model.AbstractChildObjectWithDesc;
import oracle.hcs.db.panels.BaseChildTableEditorPanel;
import oracle.hcs.db.source.ColumnIdentifier;
import oracle.hcs.db.source.CompletionColumnMatchProvider;
import oracle.hcs.db.source.MapExpressionCellRenderer;
import oracle.hcs.util.CompletionCellEditor;
import oracle.hcs.util.UIStringUtils;
import oracle.ide.Ide;
import oracle.ide.db.PropertyDisplayRegistry;
import oracle.ideimpl.db.panels.ChildObjectEditorPanel;
import oracle.ideimpl.db.panels.ChildTableEditorPanel;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.dialogs.MessageDialog;
import oracle.javatools.ui.completion.CompletionProvider;
import oracle.javatools.ui.completion.CompletionTextField;
import oracle.javatools.ui.table.GenericTable;

public class AVMeasureTableEditorPanel<C extends AVMeasure, P extends AnalyticView>
extends BaseChildTableEditorPanel<C, P> {
    private final int MEASURE_NAME_COLUMN = 0;
    private final int MAP_EXPRESSION_COLUMN = 1;
    protected final int CAPTION_COLUMN = 2;
    protected final int DESCRIPTION_COLUMN = 3;
    private CompletionColumnMatchProvider sourceCompletionProvider;
    private List<ColumnIdentifier> sourceColumns;
    private JComboBox defaultMeasuresCombo;
    private static final String HELP_ID = "olap_drop_object";
    private MyCellEditor myCellEditor;

    public AVMeasureTableEditorPanel() {
        super("AVMeasureTablePanel");
        this.init();
    }

    public AVMeasureTableEditorPanel(String string) {
        super(string);
        this.init();
    }

    protected boolean useSplitter() {
        return true;
    }

    protected JComponent createSplitPane(Component component, Component component2) {
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add(component2, "North");
        this.addDefaultMeasuresPanel(jPanel);
        JSplitPane jSplitPane = new JSplitPane(this.isHorizontalSplit() ? 1 : 0, component, jPanel);
        jSplitPane.setBorder(new EmptyBorder(0, 0, 0, 0));
        jSplitPane.setDividerLocation(275);
        return jSplitPane;
    }

    private void addDefaultMeasuresPanel(JPanel jPanel) {
        JPanel jPanel2 = new JPanel(new GridBagLayout());
        jPanel2.add((Component)new JLabel(HCSArb.get("AV_DEFAULT_MEASURES_COMBO_LABEL")), new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 17, 2, new Insets(5, 5, 5, 5), 0, 0));
        jPanel2.add((Component)this.defaultMeasuresCombo, new GridBagConstraints(1, 0, 1, 1, 0.5, 0.0, 13, 2, new Insets(5, 5, 7, 5), 0, 0));
        jPanel.add((Component)jPanel2, "South");
    }

    @Override
    protected void init() {
        this.setNameColumnIndex(0);
        PropertyDisplayRegistry propertyDisplayRegistry = PropertyDisplayRegistry.getInstance();
        propertyDisplayRegistry.registerDisplayName("measures", HCSArb.getString("AV_MEASURES"));
    }

    protected String getChildProperty() {
        return "measures";
    }

    protected Class getChildClass() {
        return AVMeasure.class;
    }

    protected ChildObjectEditorPanel createChildPanel() {
        return new AVMeasureObjectEditorPanel();
    }

    @Override
    protected void initialiseComponents() {
        TableColumn tableColumn;
        super.initialiseComponents();
        this.myCellEditor = new MyCellEditor();
        GenericTable genericTable = this.getWrapperTable();
        genericTable.setAutoResizeMode(0);
        int[] nArray = new int[]{150, 150, 130, 130};
        int[] nArray2 = new int[]{75, 75, 75, 75};
        int n = 0;
        for (int n2 : nArray) {
            tableColumn = genericTable.getColumnModel().getColumn(n++);
            tableColumn.setMinWidth(nArray2[n - 1]);
            tableColumn.setPreferredWidth(n2);
        }
        Object object = genericTable.getColumnModel();
        int n3 = this.getNameColumnIndex();
        TableColumn tableColumn2 = object.getColumn(n3);
        tableColumn2.setCellEditor(this.myCellEditor);
        TableColumn tableColumn3 = object.getColumn(3);
        tableColumn3.setCellEditor(this.myCellEditor);
        tableColumn = object.getColumn(2);
        tableColumn.setCellEditor(this.myCellEditor);
        this.sourceColumns = ((AnalyticView)this.getUpdatedObject()).getSourceColumns();
        TableColumn tableColumn4 = object.getColumn(1);
        CompletionTextField completionTextField = new CompletionTextField();
        this.sourceCompletionProvider = new CompletionColumnMatchProvider(completionTextField.getPopupHandler().getInsightList(), this.sourceColumns);
        completionTextField.getPopupHandler().registerInsightProvider((CompletionProvider)this.sourceCompletionProvider);
        tableColumn4.setCellRenderer(new MapExpressionCellRenderer(string -> {
            for (ColumnIdentifier columnIdentifier : this.sourceColumns) {
                if (!columnIdentifier.getIdentifier().equals(string)) continue;
                return columnIdentifier.getColumn();
            }
            return null;
        }));
        tableColumn4.setCellEditor(new CompletionCellEditor(completionTextField, this.sourceCompletionProvider));
    }

    @Override
    protected void initialiseTableComponents() {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        componentWrapperTableModel.addTableModelListener(new TableModelListener(){

            @Override
            public void tableChanged(TableModelEvent tableModelEvent) {
            }
        });
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                AVMeasureTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return AVMeasureTableEditorPanel.this.prov.getExternalName(c.getName());
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic2 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                AVMeasureTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getDescription();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic3 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                AVMeasureTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AbstractChildObjectWithDesc)c).getCaption();
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        this.addColumn(0, HCSArb.get("NAMESPACE_CONFLICT_PANEL_NAME_LABEL"), String.class, nonPropertyColumnLogic);
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic4 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                AVMeasureTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return AVMeasureTableEditorPanel.this.prov.getExternalName(((AVMeasure)c).getMapExpression());
            }

            public boolean isCellEditable(C c) {
                return true;
            }
        };
        this.addColumn(1, HCSArb.get("AV_MEASURES_TABLE_FACT_TABLE_MEAS_COLUMN"), String.class, nonPropertyColumnLogic4);
        this.addColumn(2, HCSArb.get("DESCRIPTION_PANEL_SHORT_LABEL"), String.class, nonPropertyColumnLogic3);
        this.addColumn(3, HCSArb.get("DESCRIPTION_PANEL_DESCRIPTION"), String.class, nonPropertyColumnLogic2);
        ChildTableEditorPanel.NonPropertyColumnLogic nonPropertyColumnLogic5 = new ChildTableEditorPanel.NonPropertyColumnLogic<C>(){

            public void setValueAt(Object object, int n, int n2) {
                AVMeasureTableEditorPanel.this.setRowPropertyValue(object, n, n2);
            }

            public Object getCellValue(C c) {
                return ((AVBaseMeasure)c).isDefaultMeasure();
            }

            public boolean isCellEditable(C c) {
                return !((AVBaseMeasure)c).isDefaultMeasure();
            }
        };
        this.initDefaultMeasuresCombo();
    }

    private void initDefaultMeasuresCombo() {
        this.defaultMeasuresCombo = new JComboBox();
        this.defaultMeasuresCombo.setEditable(false);
        this.refreshDefaultMeasuresComboModel();
        this.defaultMeasuresCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string;
                String string2 = (String)AVMeasureTableEditorPanel.this.defaultMeasuresCombo.getSelectedItem();
                if (!string2.equals(string = ((AnalyticView)AVMeasureTableEditorPanel.this.getUpdatedObject()).getDefaultMeasure())) {
                    AVBaseMeasure aVBaseMeasure;
                    AVBaseMeasure aVBaseMeasure2 = ((AnalyticView)AVMeasureTableEditorPanel.this.getUpdatedObject()).findBaseMeasure(string2);
                    if (aVBaseMeasure2 != null) {
                        AVMeasureTableEditorPanel.this.setDefaultMeasureInObjects(aVBaseMeasure2);
                    }
                    if (string != null && (aVBaseMeasure = ((AnalyticView)AVMeasureTableEditorPanel.this.getUpdatedObject()).findBaseMeasure(string)) != null) {
                        aVBaseMeasure.setDefaultMeasure(null);
                    }
                }
            }
        });
    }

    private void refreshDefaultMeasuresComboModel() {
        DefaultComboBoxModel<String> defaultComboBoxModel = new DefaultComboBoxModel<String>();
        for (AVBaseMeasure aVBaseMeasure : ((AnalyticView)this.getUpdatedObject()).getStoredAndCalculatedMeasures()) {
            String string = aVBaseMeasure.getName();
            defaultComboBoxModel.addElement(string);
        }
        this.defaultMeasuresCombo.setModel(defaultComboBoxModel);
        this.setDefaultMeasuresComboValue(((AnalyticView)this.getUpdatedObject()).getDefaultMeasure());
    }

    private void setDefaultMeasuresComboValue(String string) {
        if (string != null) {
            this.defaultMeasuresCombo.setSelectedItem(string);
        }
    }

    private void setDefaultMeasureInObjects(AVBaseMeasure aVBaseMeasure) {
        String string = aVBaseMeasure.getName();
        aVBaseMeasure.setDefaultMeasure(true);
        ((AnalyticView)this.getUpdatedObject()).setDefaultMeasure(string);
    }

    @Override
    protected void setRowPropertyValue(Object object, int n, int n2) {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        int n3 = componentWrapperTableModel.getRowCount();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        AVMeasure aVMeasure = (AVMeasure)rowInfo.getRowObject();
        switch (n2) {
            case 0: {
                String string = (String)object;
                String string2 = aVMeasure.getName();
                aVMeasure.setName(UIStringUtils.normalizeName(string, this.prov));
                if (aVMeasure.isDefaultMeasure()) {
                    aVMeasure.getAV().setDefaultMeasure(UIStringUtils.normalizeName(string, this.prov));
                    this.setDefaultMeasureInObjects(aVMeasure);
                }
                if (!string2.equals(string)) {
                    this.refreshDefaultMeasuresComboModel();
                }
                if (!this.upcaseNameFlag) break;
                this.updateNameToUppercase(string.toUpperCase(), n, 0);
                this.upcaseNameFlag = false;
                break;
            }
            case 2: {
                String string = (String)object;
                aVMeasure.setCaption(string);
                break;
            }
            case 3: {
                String string = (String)object;
                aVMeasure.setDescription(string);
                break;
            }
            case 1: {
                String string = (String)object;
                String string3 = this.prov.getInternalName(string);
                aVMeasure.setMapExpression(string3);
            }
        }
    }

    @Override
    protected int getNameColumnIndex() {
        return 0;
    }

    @Override
    protected int getCaptionColumnIndex() {
        return 2;
    }

    @Override
    protected int getDescriptionColumnIndex() {
        return 3;
    }

    @Override
    public C newChild() {
        AVMeasure aVMeasure = (AVMeasure)super.newChild();
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        int n = componentWrapperTableModel.getRowCount();
        String string = ((AnalyticView)this.getUpdatedObject()).getDefaultMeasure();
        if (n == 0 && string == null) {
            aVMeasure.getAV().setDefaultMeasure(aVMeasure.getName());
            this.setDefaultMeasureInObjects(aVMeasure);
        }
        aVMeasure.generateDescriptions();
        aVMeasure.setMeasureFormat(null);
        aVMeasure.setNewObject();
        ((AnalyticView)this.getUpdatedObject()).addMeasure(aVMeasure);
        this.refreshDefaultMeasuresComboModel();
        return (C)aVMeasure;
    }

    protected boolean confirmRowCanBeDeleted(int n) {
        ChildTableEditorPanel.ComponentWrapperTableModel componentWrapperTableModel = this.getWrapperTableModel();
        ChildTableEditorPanel.RowInfo rowInfo = componentWrapperTableModel.getRow(n);
        AVMeasure aVMeasure = (AVMeasure)rowInfo.getRowObject();
        AnalyticView analyticView = (AnalyticView)this.getUpdatedObject();
        analyticView.removeMeasure(aVMeasure);
        this.setDefaultMeasureWhenRowDeleted();
        return true;
    }

    private void setDefaultMeasureWhenRowDeleted() {
        List<AVBaseMeasure> list = ((AnalyticView)this.getUpdatedObject()).getStoredAndCalculatedMeasures();
        if (list != null) {
            if (list.size() > 0) {
                boolean bl = false;
                for (AVBaseMeasure aVBaseMeasure : list) {
                    if (!aVBaseMeasure.isDefaultMeasure()) continue;
                    bl = true;
                    break;
                }
                if (!bl) {
                    AVBaseMeasure aVBaseMeasure = list.get(0);
                    this.setDefaultMeasureInObjects(aVBaseMeasure);
                }
            } else {
                ((AnalyticView)this.getUpdatedObject()).setDefaultMeasure(null);
            }
            this.refreshDefaultMeasuresComboModel();
        }
    }

    class MyCellEditor
    extends BaseChildTableEditorPanel.MyBaseCellEditor {
        public MyCellEditor() {
            super(AVMeasureTableEditorPanel.this);
        }

        @Override
        public boolean stopCellEditing() {
            boolean bl = false;
            int n = AVMeasureTableEditorPanel.this.getNameColumnIndex();
            TableColumnModel tableColumnModel = this.jtable.getColumnModel();
            TableColumn tableColumn = tableColumnModel.getColumn(this.column);
            int n2 = tableColumn.getModelIndex();
            if (n2 == n) {
                String string;
                boolean bl2 = true;
                String string2 = null;
                AnalyticView analyticView = ((AVMeasure)this.abstractChildObjectWithDesc).getAV();
                String string3 = this.abstractChildObjectWithDesc.getName();
                String string4 = UIStringUtils.normalizeName(this.cellTextField.getText(), AVMeasureTableEditorPanel.this.prov);
                bl = UIStringUtils.isQuotedName(string4);
                try {
                    AVMeasureTableEditorPanel.this.prov.validateName("MEASURE2", string4);
                }
                catch (InvalidNameException invalidNameException) {
                    string2 = invalidNameException.getMessage();
                    bl2 = false;
                }
                if (bl2 && analyticView.findMeasure(string = AVMeasureTableEditorPanel.this.prov.getInternalName(string4)) != null && !string.equals(string3)) {
                    string2 = HCSArb.format("AV_MEASURE_ERROR_DUPLICATE_NAME", string);
                    bl2 = false;
                }
                if (!bl2) {
                    MessageDialog.error((Component)Ide.getMainWindow(), (Object)string2, (String)HCSArb.get("AV_MEASURE_NAME_ERROR_TITLE"), null);
                    this.cellTextField.setText(string3);
                    return bl2;
                }
                if (!bl) {
                    AVMeasureTableEditorPanel.this.upcaseNameFlag = true;
                }
            }
            return super.stopCellEditing();
        }
    }

    private class DefaultMeasureCellRenderer
    extends DefaultTableCellRenderer {
        DefaultMeasureCellRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            JLabel jLabel = (JLabel)super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            jLabel.setToolTipText(HCSArb.get("DEFAULT_LABEL"));
            if (object != null) {
                if (object == Boolean.TRUE) {
                    jLabel.setIcon(HCSImagesArb.getIcon("SUCCESS_ICON"));
                    jLabel.setText(null);
                    jLabel.setHorizontalAlignment(0);
                } else {
                    jLabel.setIcon(HCSImagesArb.getIcon("UNCHECKED_ICON"));
                    jLabel.setText(null);
                }
            }
            JLabel jLabel2 = jLabel;
            return jLabel2;
        }
    }
}

