/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.av.panels;

import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.TreeSet;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import oracle.hcs.HCSArb;
import oracle.hcs.av.AVPanelLibrary;
import oracle.hcs.av.model.AVMeasure;
import oracle.hcs.av.model.AnalyticView;
import oracle.hcs.av.panels.MeasureFormatsRenderer;
import oracle.hcs.db.DatabaseUtils;
import oracle.hcs.db.model.Classification;
import oracle.hcs.db.panels.ChildObjectEditorPanel2;
import oracle.ide.db.components.ComponentFactory;
import oracle.ide.db.panels.PanelLibrary;
import oracle.ide.panels.TraversalException;
import oracle.ide.util.Namespace;
import oracle.javatools.db.DBObjectProvider;
import oracle.javatools.db.Database;
import oracle.javatools.db.InvalidNameException;
import oracle.javatools.db.SystemObject;
import oracle.javatools.db.diff.DBObjectComparator;

public class AVMeasureObjectEditorPanel<T extends AVMeasure, P extends AnalyticView>
extends ChildObjectEditorPanel2<T, P> {
    private DBObjectProvider prov;
    private TreeSet<AVMeasure> invalidMeasures = new TreeSet(new DBObjectComparator());
    private JComboBox measureFormatsCombo;
    private AVMeasure measure;
    private final String FORMAT_STRING = "FORMAT_STRING";

    public AVMeasureObjectEditorPanel() {
        super("AVMeasureTableEditorPanel", "MEASURE2");
        this.layoutComponents();
    }

    private void loadMeasureData(AVMeasure aVMeasure) {
        String string = aVMeasure.getMeasureFormat();
        DefaultComboBoxModel defaultComboBoxModel = new DefaultComboBoxModel((E[])DatabaseUtils.getMeasureNumericFormats());
        this.measureFormatsCombo.setModel(defaultComboBoxModel);
        if (string != null) {
            boolean bl = false;
            int n = this.measureFormatsCombo.getModel().getSize();
            for (int i = 0; i < n; ++i) {
                Object[] objectArray = (Object[])this.measureFormatsCombo.getModel().getElementAt(i);
                String string2 = (String)objectArray[0];
                if (!string2.equals(string)) continue;
                this.measureFormatsCombo.setSelectedItem(objectArray);
                bl = true;
                break;
            }
            if (!bl) {
                this.measureFormatsCombo.setSelectedItem(string);
            }
        } else {
            this.measureFormatsCombo.setSelectedIndex(0);
        }
        this.validate();
        this.repaint();
    }

    private void initImpl(DBObjectProvider dBObjectProvider) {
        this.prov = dBObjectProvider;
    }

    @Override
    protected void initialisePanel() {
        this.measure = (AVMeasure)this.getChildObject();
        this.initImpl(this.getProvider());
        super.initialisePanel();
        this.measureFormatsCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (AVMeasureObjectEditorPanel.this.measure != null) {
                    String string;
                    String string2 = (String)AVMeasureObjectEditorPanel.this.measureFormatsCombo.getSelectedItem();
                    if (!(string2 = string2.trim()).equals(string = AVMeasureObjectEditorPanel.this.measure.getMeasureFormat())) {
                        if (!string2.equalsIgnoreCase(HCSArb.get("NONE"))) {
                            AVMeasureObjectEditorPanel.this.measure.setMeasureFormat(string2);
                        } else {
                            Classification classification = AVMeasureObjectEditorPanel.this.measure.findClassification("FORMAT_STRING");
                            if (classification != null) {
                                AVMeasureObjectEditorPanel.this.measure.removeClassifications(classification);
                            }
                        }
                    }
                }
            }
        });
        if (this.measure != null) {
            this.loadMeasureData(this.measure);
        }
    }

    public void commit(AVMeasure aVMeasure) throws TraversalException {
        String string = this.prov.getExternalName(aVMeasure.getName());
        try {
            this.prov.validateName("MEASURE2", string);
        }
        catch (InvalidNameException invalidNameException) {
            this.invalidMeasures.add(aVMeasure);
            throw new TraversalException(invalidNameException.getMessage());
        }
        if (this.invalidMeasures.contains(aVMeasure)) {
            this.invalidMeasures.remove(aVMeasure);
        }
        String string2 = this.prov.getInternalName(string);
        if (aVMeasure.isDefaultMeasure()) {
            ((AnalyticView)this.getUpdatedObject()).setDefaultMeasure(string2);
        }
        aVMeasure.setName(string2);
        int n = 0;
        for (AVMeasure aVMeasure2 : ((AnalyticView)this.getUpdatedObject()).getMeasures()) {
            aVMeasure2.setMeasureOrder(Integer.toString(n));
            ++n;
        }
    }

    @Override
    protected void commitPanel() throws TraversalException {
        super.commitPanel();
        AnalyticView analyticView = (AnalyticView)this.getOriginalObject();
        AnalyticView analyticView2 = (AnalyticView)this.getUpdatedObject();
        AVMeasure aVMeasure = (AVMeasure)this.getChildObject();
        String string = aVMeasure.getName();
        this.commit(aVMeasure);
        AnalyticView analyticView3 = aVMeasure.getAV();
        if (analyticView3.findMeasure(aVMeasure.getName()) == null) {
            analyticView3.addMeasure(aVMeasure);
        } else if (!aVMeasure.getName().equals(string)) {
            // empty if block
        }
        if (this.isEditing()) {
            Database database = (Database)this.getProvider();
            Namespace namespace = this.getDataContext();
            PanelLibrary panelLibrary = (PanelLibrary)namespace.find(PanelLibrary.class);
            AVPanelLibrary aVPanelLibrary = (AVPanelLibrary)panelLibrary;
            aVPanelLibrary.reconcileDependencies(database, (SystemObject)analyticView, (SystemObject)analyticView2);
        }
    }

    private void layoutComponents() {
        this.setName(this.getClass().getName());
        ComponentFactory componentFactory = this.getComponentFactory();
        componentFactory.setBasePath(new String[]{"measures"});
        this.measureFormatsCombo = new JComboBox(){

            @Override
            public Object getSelectedItem() {
                Object object = super.getSelectedItem();
                if (object instanceof Object[]) {
                    Object[] objectArray = (Object[])object;
                    return objectArray[0];
                }
                return object;
            }
        };
        this.measureFormatsCombo.setRenderer(new MeasureFormatsRenderer());
        this.measureFormatsCombo.setEditable(true);
        JLabel jLabel = new JLabel(HCSArb.getString("AV_MEASURE_FORMAT_LABEL"));
        jLabel.setName("formatLabel");
        jLabel.setLabelFor(this.measureFormatsCombo);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createTitledBorder(HCSArb.getString("AV_MEASURE_PROPERTIES")));
        int n = 0;
        this.add(jLabel, new GridBagConstraints(0, n, 1, 1, 0.0, 0.0, 17, 0, new Insets(5, 5, 0, 12), 0, 0));
        this.add(this.measureFormatsCombo, new GridBagConstraints(1, n, 1, 1, 1.0, 0.0, 17, 2, new Insets(5, 0, 0, 5), 0, 0));
        ++n;
        this.add(new JPanel(), new GridBagConstraints(1, ++n, 1, 1, 1.0, 1.0, 17, 1, new Insets(5, 0, 0, 5), 0, 0));
    }

    protected void validateObject() throws TraversalException {
    }
}

