/*
 * Decompiled with CFR 0.152.
 */
package oracle.hcs.actions;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JMenuItem;
import oracle.dbtools.raptor.utils.DBObject;
import oracle.hcs.HCSArb;
import oracle.hcs.actions.AbstractModifyHCSObjectAction;
import oracle.hcs.actions.CompileMultipleObjectsAction;
import oracle.hcs.actions.DropCalculatedMeasuresAction;
import oracle.hcs.actions.DropMultipleObjectsAction;
import oracle.hcs.actions.ModifyAnalyticViewsPropertiesAction;
import oracle.hcs.actions.ModifyAttributeDimensionsPropertiesAction;
import oracle.hcs.actions.ModifyCalculatedMeasuresPropertiesAction;
import oracle.hcs.actions.ModifyHierarchiesPropertiesAction;
import oracle.hcs.actions.ModifyMeasuresPropertiesAction;
import oracle.hcs.actions.RenameCalculatedMeasuresAction;
import oracle.hcs.actions.RenameMeasuresAction;
import oracle.ide.Context;
import oracle.ide.controller.ContextMenu;
import oracle.ide.controller.ContextMenuListener;
import oracle.ide.model.Element;

public class MultipleObjectContextMenu
implements ContextMenuListener {
    private static final String CALC_MEASURE = "HCSCALCMEASURE";
    private static final String ANALYTIC_VIEW_MEASURE = "HCSAVMEASURE";
    private List<DBObject> dbObjects;
    private final DropMultipleObjectsAction dropMultipleAction = new DropMultipleObjectsAction();
    private final DropCalculatedMeasuresAction dropCalculatedMeasuresAction = new DropCalculatedMeasuresAction();
    private final RenameMeasuresAction renameMeasuresAction = new RenameMeasuresAction();
    private final RenameCalculatedMeasuresAction renameCalculatedMeasuresAction = new RenameCalculatedMeasuresAction();
    private final ModifyCalculatedMeasuresPropertiesAction modifyCalcMeasuresPropertiesAction = new ModifyCalculatedMeasuresPropertiesAction();
    private final ModifyMeasuresPropertiesAction modifyMeasuresPropertiesAction = new ModifyMeasuresPropertiesAction();
    private final ModifyAttributeDimensionsPropertiesAction modifyAttributeDimensionsPropertiesAction = new ModifyAttributeDimensionsPropertiesAction();
    private final ModifyHierarchiesPropertiesAction modifyHierarchiesPropertiesAction = new ModifyHierarchiesPropertiesAction();
    private final ModifyAnalyticViewsPropertiesAction modifyAnalyticViewPropertiesAction = new ModifyAnalyticViewsPropertiesAction();
    private final CompileMultipleObjectsAction compileMultipleAction = new CompileMultipleObjectsAction();

    public void menuWillShow(ContextMenu contextMenu) {
        this.dbObjects = new ArrayList<DBObject>();
        Element[] elementArray = contextMenu.getContext().getSelection();
        if (elementArray != null && elementArray.length > 0) {
            String string = null;
            for (Element element : elementArray) {
                DBObject dBObject = new DBObject(element);
                String string2 = dBObject.getObjectType();
                if (string2 == null) {
                    return;
                }
                if (string2.equalsIgnoreCase("ATTRIBUTE DIMENSION") || string2.equalsIgnoreCase("HIERARCHY") || string2.equalsIgnoreCase("ANALYTIC VIEW") || string2.equalsIgnoreCase(CALC_MEASURE) || string2.equalsIgnoreCase(ANALYTIC_VIEW_MEASURE)) {
                    if (string == null) {
                        string = string2;
                    } else if (!string.equals(string2)) {
                        return;
                    }
                } else {
                    return;
                }
                this.dbObjects.add(dBObject);
            }
            if (string.equalsIgnoreCase(CALC_MEASURE)) {
                this.addCalculatedMeasuresMenuItems(contextMenu);
            }
            if (string.equalsIgnoreCase(ANALYTIC_VIEW_MEASURE)) {
                this.addAVMeasuresMenuItems(contextMenu);
            }
            if (string.equalsIgnoreCase("ATTRIBUTE DIMENSION")) {
                this.addMultipleMenuItems(contextMenu);
                this.addAttributeDimensionsPropertiesOption(contextMenu);
            }
            if (string.equalsIgnoreCase("HIERARCHY")) {
                this.addMultipleMenuItems(contextMenu);
                this.addHierarchiesPropertiesOption(contextMenu);
            }
            if (string.equalsIgnoreCase("ANALYTIC VIEW")) {
                this.addMultipleMenuItems(contextMenu);
                this.addAnalyticViewPropertiesOption(contextMenu);
            }
        }
    }

    public void menuWillHide(ContextMenu contextMenu) {
    }

    public boolean handleDefaultAction(Context context) {
        return false;
    }

    private void addCalculatedMeasuresMenuItems(ContextMenu contextMenu) {
        JMenuItem jMenuItem;
        if (this.dbObjects.size() > 1) {
            jMenuItem = new JMenuItem(HCSArb.getString("DROP_SELECTED_CALCULATED_MEASURES_MENU"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultipleObjectContextMenu.this.dropCalculatedMeasuresAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                    DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                    MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.dropCalculatedMeasuresAction);
                    MultipleObjectContextMenu.this.dropCalculatedMeasuresAction.launch();
                }
            });
            contextMenu.add((Component)jMenuItem);
        }
        jMenuItem = new JMenuItem(HCSArb.getString("RENAME_MENU_ITEM"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this.renameCalculatedMeasuresAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.renameCalculatedMeasuresAction);
                MultipleObjectContextMenu.this.renameCalculatedMeasuresAction.launch();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(HCSArb.get("MODIFY_OBJECT_PROPERTIES_OPTION"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this.modifyCalcMeasuresPropertiesAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.modifyCalcMeasuresPropertiesAction);
                MultipleObjectContextMenu.this.modifyCalcMeasuresPropertiesAction.launch();
            }
        });
        contextMenu.add((Component)jMenuItem);
        contextMenu.add((Component)jMenuItem2);
    }

    private void addAVMeasuresMenuItems(ContextMenu contextMenu) {
        JMenuItem jMenuItem = new JMenuItem(HCSArb.getString("RENAME_MENU_ITEM"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this.renameMeasuresAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.renameMeasuresAction);
                MultipleObjectContextMenu.this.renameMeasuresAction.launch();
            }
        });
        JMenuItem jMenuItem2 = new JMenuItem(HCSArb.get("MODIFY_OBJECT_PROPERTIES_OPTION"));
        jMenuItem2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this.modifyMeasuresPropertiesAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.modifyMeasuresPropertiesAction);
                MultipleObjectContextMenu.this.modifyMeasuresPropertiesAction.launch();
            }
        });
        contextMenu.add((Component)jMenuItem);
        contextMenu.add((Component)jMenuItem2);
    }

    private void addMultipleMenuItems(ContextMenu contextMenu) {
        if (this.dbObjects.size() > 1) {
            JMenuItem jMenuItem = new JMenuItem(HCSArb.getString("DROP_SELECTED_CALCULATED_MEASURES_MENU"));
            JMenuItem jMenuItem2 = new JMenuItem(HCSArb.getString("COMPILE_SELECTED_MENU"));
            jMenuItem.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultipleObjectContextMenu.this.dropMultipleAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                    DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                    MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.dropMultipleAction);
                    MultipleObjectContextMenu.this.dropMultipleAction.launch();
                }
            });
            jMenuItem2.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    MultipleObjectContextMenu.this.compileMultipleAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                    DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                    MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.compileMultipleAction);
                    MultipleObjectContextMenu.this.compileMultipleAction.launch();
                }
            });
            contextMenu.add((Component)jMenuItem);
            contextMenu.add((Component)jMenuItem2);
        }
    }

    private void addAttributeDimensionsPropertiesOption(ContextMenu contextMenu) {
        JMenuItem jMenuItem = new JMenuItem(HCSArb.get("MODIFY_OBJECT_PROPERTIES_OPTION"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this.modifyAttributeDimensionsPropertiesAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.modifyAttributeDimensionsPropertiesAction);
                MultipleObjectContextMenu.this.modifyAttributeDimensionsPropertiesAction.launch();
            }
        });
        contextMenu.add((Component)jMenuItem);
    }

    private void addHierarchiesPropertiesOption(ContextMenu contextMenu) {
        JMenuItem jMenuItem = new JMenuItem(HCSArb.get("MODIFY_OBJECT_PROPERTIES_OPTION"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this.modifyHierarchiesPropertiesAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.modifyHierarchiesPropertiesAction);
                MultipleObjectContextMenu.this.modifyHierarchiesPropertiesAction.launch();
            }
        });
        contextMenu.add((Component)jMenuItem);
    }

    private void addAnalyticViewPropertiesOption(ContextMenu contextMenu) {
        JMenuItem jMenuItem = new JMenuItem(HCSArb.get("MODIFY_OBJECT_PROPERTIES_OPTION"));
        jMenuItem.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                MultipleObjectContextMenu.this.modifyAnalyticViewPropertiesAction.setSelection(MultipleObjectContextMenu.this.dbObjects);
                DBObject dBObject = MultipleObjectContextMenu.this.dbObjects.get(0);
                MultipleObjectContextMenu.this.setInformationForSchema(dBObject, MultipleObjectContextMenu.this.modifyAnalyticViewPropertiesAction);
                MultipleObjectContextMenu.this.modifyAnalyticViewPropertiesAction.launch();
            }
        });
        contextMenu.add((Component)jMenuItem);
    }

    private void setInformationForSchema(DBObject dBObject, AbstractModifyHCSObjectAction abstractModifyHCSObjectAction) {
        abstractModifyHCSObjectAction.setSchemaName(dBObject.getSchemaName());
        abstractModifyHCSObjectAction.setConnectionName(dBObject.getConnectionName());
    }
}

