/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import oracle.ide.debugger.plugin.breakpoint.MethodDescriptor;
import oracle.ide.runner.DebuggerLocation;
import oracle.javatools.util.Log;
import oracle.jdeveloper.debugger.plugin.tracking.ExecutionTrackerForVirtualMachine;
import oracle.jdevimpl.debugger.DebugObjectFactory;
import oracle.jdevimpl.debugger.evaluator.EvaluatorProxy;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIBreakpointMethodSignature;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataPrimitiveInfo;
import oracle.jdevimpl.debugger.plugin.evaluator.ExpressionEvaluationException;
import oracle.jdevimpl.debugger.support.CodeExecutionBreakpoint;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataArrayInfo;
import oracle.jdevimpl.debugger.support.DebugDataInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugLocation;
import oracle.jdevimpl.debugger.support.DebugStackFrameInfo;
import oracle.jdevimpl.debugger.support.DebugThreadInfo;
import oracle.jdevimpl.debugger.support.DebugVariableInfo;
import oracle.jdevimpl.debugger.support.DebugVirtualMachine;
import oracle.jdevimpl.runner.debug.JDebugger;
import oracle.jdevimpl.runner.debug.ValueExpressionHelper;

public class DebugJDIExecutionTrackingBreakpointMethod
extends DebugJDIBreakpointMethodSignature
implements CodeExecutionBreakpoint {
    private int invocationCounter;
    private ExecutionTrackerForVirtualMachine executionTracker;
    private Log ETLogger = new Log("ETLogger");

    DebugJDIExecutionTrackingBreakpointMethod(DebugJDI debugJDI, MethodDescriptor method) {
        super(debugJDI, method);
        this.setStop(true);
        this.executionTracker = debugJDI.getExecutionTracker(true);
    }

    public void executeAfterStop() {
        this.ETLogger.trace("ETBreakpoint hit at MethodEntry of " + this.getMethodDescriptor().toString());
        DebugThreadInfo thread = this.dj.getCurrentThread();
        DebugStackFrameInfo frame = thread.getStackFrame(0);
        DebugLocation location = frame.getLocation();
        EvaluatorProxy evaluator = (EvaluatorProxy)DebugObjectFactory.create(EvaluatorProxy.class);
        evaluator.setAllowMethodInvocation(true);
        evaluator.setDebugContext((DebugVirtualMachine)this.dj, thread, frame);
        for (MethodDescriptor.Argument argument : this.getMethodDescriptor().getArguments()) {
            Object info = evaluator.evaluate(argument.getName());
            if (info instanceof DebugVariableInfo) {
                DebugVariableInfo dvi = (DebugVariableInfo)info;
                DebugDataInfo data = dvi.getDataInfo();
                if (data instanceof DebugJDIDataPrimitiveInfo) {
                    argument.setValue((Object)data.getValue());
                } else if (data instanceof DebugDataObjectInfo) {
                    DebugDataObjectInfo ddoi = (DebugDataObjectInfo)data;
                    String expression = ValueExpressionHelper.getValueExpression((DebugDataObjectInfo)ddoi);
                    if (expression == null) {
                        argument.setValue((Object)"");
                    } else {
                        Object result = evaluator.evaluate(expression);
                        String resultString = result == null ? "null" : result.toString();
                        argument.setValue((Object)resultString);
                    }
                } else if (data instanceof DebugDataArrayInfo) {
                    DebugDataArrayInfo ddai = (DebugDataArrayInfo)info;
                    DebugClassInfo cinfo = ddai.getArrayElementClassInfo();
                    argument.setValue((Object)(cinfo.getName() + "[" + ddai.getArrayCount() + "]"));
                } else {
                    this.ETLogger.trace("DebugJDIExecutionTrackingBreakpointMethod.executeAfterStop, eval arg doesn't know what to do with " + data);
                }
                this.ETLogger.trace(argument.getName() + " = " + argument.getValue());
                continue;
            }
            if (info instanceof ExpressionEvaluationException) {
                JDebugger.logger.trace(((ExpressionEvaluationException)info).getMessage());
                continue;
            }
            if (info != null) continue;
            argument.setValue(null);
        }
        this.ETLogger.trace("ETBreakpoint notifying listeners of method entry");
        this.executionTracker.trackMethodEntry((DebuggerLocation)location, this.getMethodDescriptor(), this.invocationCounter++);
        if (this.executionTracker.isSteppingFromMethodEntryEnabled()) {
            this.ETLogger.trace("ETBreakpoint turning on background stepping");
            this.executionTracker.startBackgroundStepping();
        }
    }

    public String toString() {
        return "MethodEntryBP for " + this.getMethodDescriptor().getMethodName();
    }
}

