/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.debugger.jdi;

import com.sun.jdi.Field;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.Value;
import java.util.List;
import oracle.jdevimpl.debugger.jdi.DebugJDI;
import oracle.jdevimpl.debugger.jdi.DebugJDIClassInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIDataCompositeInfo;
import oracle.jdevimpl.debugger.jdi.DebugJDIFieldInfo;
import oracle.jdevimpl.debugger.support.DebugClassInfo;
import oracle.jdevimpl.debugger.support.DebugDataObjectInfo;
import oracle.jdevimpl.debugger.support.DebugFieldInfo;

final class DebugJDIDataObjectInfo
extends DebugJDIDataCompositeInfo
implements DebugDataObjectInfo {
    DebugJDIDataObjectInfo(DebugJDI dj, DebugJDIClassInfo clazz, Value value, Object owner) {
        super(dj, clazz, value, owner);
    }

    public int getFieldCount(int classLevel) {
        return this.getFieldCount(classLevel, false, false, false);
    }

    public DebugFieldInfo[] getFields(int classLevel) {
        return this.getFields(classLevel, false, false, false);
    }

    public DebugFieldInfo getField(int classLevel, int index) {
        return this.getField(classLevel, false, false, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal) {
        return this.getFieldCount(classLevel, noFinal, false, false);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal) {
        return this.getFields(classLevel, noFinal, false, false);
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, int index) {
        return this.getField(classLevel, noFinal, false, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic) {
        return this.getFieldCount(classLevel, noFinal, noStatic, false);
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic) {
        return this.getFields(classLevel, noFinal, noStatic, false);
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, int index) {
        return this.getField(classLevel, noFinal, noStatic, false, index);
    }

    public int getFieldCount(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        if (this.value == null || this.clazz == null) {
            return 0;
        }
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.clazz.collectFields(classLevel, (ObjectReference)this.value, noFinal, staticFields, nonNullCompositesOnly);
        return fields.size();
    }

    public DebugFieldInfo[] getFields(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly) {
        this.throwIfExpired();
        if (this.value == null || this.clazz == null) {
            return new DebugFieldInfo[0];
        }
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.clazz.collectFields(classLevel, (ObjectReference)this.value, noFinal, staticFields, nonNullCompositesOnly);
        int size = fields.size();
        ObjectReference or = (ObjectReference)this.value;
        DebugFieldInfo[] array = new DebugFieldInfo[size];
        for (int i = 0; i < size; ++i) {
            array[i] = new DebugJDIFieldInfo(this.dj, (Field)fields.get(i), this.clazz, or);
        }
        return array;
    }

    public DebugFieldInfo getField(int classLevel, boolean noFinal, boolean noStatic, boolean nonNullCompositesOnly, int index) {
        this.throwIfExpired();
        if (this.value == null || this.clazz == null) {
            return null;
        }
        Boolean staticFields = noStatic ? Boolean.FALSE : null;
        List fields = this.clazz.collectFields(classLevel, (ObjectReference)this.value, noFinal, staticFields, nonNullCompositesOnly);
        int size = fields.size();
        if (index < size) {
            ObjectReference or = (ObjectReference)this.value;
            return new DebugJDIFieldInfo(this.dj, (Field)fields.get(index), this.clazz, or);
        }
        return null;
    }

    public boolean canGetFieldByName() {
        return true;
    }

    public DebugFieldInfo getField(String name) {
        Field field;
        this.throwIfExpired();
        if (this.value != null && this.clazz != null && (field = this.clazz.fieldByName(name)) != null) {
            ObjectReference or = (ObjectReference)this.value;
            return new DebugJDIFieldInfo(this.dj, field, this.clazz, or);
        }
        return null;
    }

    public DebugFieldInfo getField(String name, DebugClassInfo declaringClass) {
        Field field;
        this.throwIfExpired();
        if (this.value != null && this.clazz != null && (field = declaringClass != null ? ((DebugJDIClassInfo)declaringClass).fieldByName(name) : this.clazz.fieldByName(name)) != null) {
            ObjectReference or = (ObjectReference)this.value;
            return new DebugJDIFieldInfo(this.dj, field, this.clazz, or);
        }
        return null;
    }

    @Override
    public boolean equals(Object o) {
        if (o instanceof DebugJDIDataObjectInfo) {
            return super.equals(o);
        }
        return false;
    }
}

