/*
 * Decompiled with CFR 0.152.
 */
package oracle.help.common.xml;

import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import oracle.help.common.xml.Parser;
import oracle.help.common.xml.XMLNode;
import oracle.help.common.xml.XMLParseException;
import oracle.help.common.xml.XMLToken;
import oracle.help.common.xml.XMLTokenizer;

public class XMLParser
implements Parser {
    private XMLNode _root;

    public XMLParser(Reader reader) throws XMLParseException {
        XMLTokenizer tokenizer = new XMLTokenizer(reader);
        this._root = new XMLNode();
        XMLNode node = null;
        XMLNode parent = this._root;
        XMLNode realNode = null;
        try {
            XMLToken token;
            block8: while ((token = tokenizer.nextToken()) != null) {
                switch (token.getType()) {
                    case 1: {
                        realNode = node = new XMLNode(token, parent);
                        parent = node;
                        continue block8;
                    }
                    case 2: {
                        if (!parent.getTokenValue().equals(token.getTokenValue())) {
                            throw new XMLParseException("Close tag does not match open tag: Open is " + parent.getTokenValue() + ",Close is " + token.getTokenValue());
                        }
                        parent = parent.getParent();
                        continue block8;
                    }
                    case 3: {
                        if (realNode == null) continue block8;
                        realNode.setString(token.getTokenValue());
                        continue block8;
                    }
                    case 4: 
                    case 5: {
                        realNode = null;
                        continue block8;
                    }
                }
                throw new XMLParseException("Bad token type returned by tokenizer.");
            }
        }
        catch (IOException ioE) {
            throw new XMLParseException("IO Exception thrown by Tokenizer: " + ioE.getMessage());
        }
    }

    @Override
    public XMLNode getRoot() {
        return this._root;
    }

    private void _printRoot() {
        this.getRoot()._printTree("");
    }

    public static void main(String[] args) {
        if (args.length == 0) {
            System.err.println("Usage: java XMLParser <filename>");
            System.exit(1);
        }
        try {
            FileReader reader = new FileReader(args[0]);
            XMLParser parser = new XMLParser(reader);
            parser._printRoot();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

