/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.RSAPublicKeySpec;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.crypto.SecretKey;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHPublicKeySpec;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.core.AlgID;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.DSAParams;
import oracle.security.crypto.core.RSAPublicKey;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;

public class CMSUtils {
    private static Hashtable algoNamemap = null;
    private static Hashtable algoIdmap = null;
    private static Hashtable algoOIDmap = null;
    static final String DEFAULT_RandomGenerator_ALGO = "SHA1PRNG";
    static int AES128_KEYSIZE = 128;
    static int AES192_KEYSIZE = 192;
    static int AES256_KEYSIZE = 256;

    public static byte[] generateSPKI64(X509Certificate cert) throws NoSuchAlgorithmException {
        PublicKey pk = cert.getPublicKey();
        byte[] spki160 = CMSUtils.generateSPKI160(cert);
        byte[] spki64 = new byte[8];
        spki64[0] = (byte)(spki160[12] & 0xF);
        spki64[0] = (byte)(spki64[0] | 0x40);
        System.arraycopy(spki160, 13, spki64, 1, 7);
        return spki64;
    }

    public static byte[] generateSPKI160(X509Certificate cert) throws NoSuchAlgorithmException {
        PublicKey pk = cert.getPublicKey();
        return CMSUtils.generateKeyID(pk);
    }

    static byte[] toBytes(CMSContentInfo contentInfo) throws IOException {
        UnsyncByteArrayOutputStream buff = new UnsyncByteArrayOutputStream();
        contentInfo.output((OutputStream)buff);
        return buff.toByteArray();
    }

    static byte[] getIdentifier(X509Certificate cert) throws NoSuchAlgorithmException, CertificateEncodingException {
        String algoName = CMSUtils.getAlgoName(CMS.md5);
        MessageDigest md = MessageDigest.getInstance(algoName);
        return md.digest(cert.getEncoded());
    }

    static byte[] getKeyChecksum(byte[] key) throws NoSuchAlgorithmException {
        String algoName = CMSUtils.getAlgoName(CMS.sha_1);
        MessageDigest md = MessageDigest.getInstance(algoName);
        byte[] digest = md.digest(key);
        byte[] dig0 = new byte[8];
        System.arraycopy(digest, 0, dig0, 0, 8);
        return dig0;
    }

    static byte[] doORByteArrays(byte[] array1, byte[] array2) {
        int i;
        byte[] or = new byte[array1.length + array2.length];
        for (i = 0; i < array1.length; ++i) {
            or[i] = array1[i];
        }
        i = array1.length;
        int j = 0;
        while (j < array2.length) {
            or[i] = array2[j];
            ++j;
            ++i;
        }
        return or;
    }

    static byte[] reverseArrayOrder(byte[] array) {
        int j = array.length - 1;
        byte[] b = new byte[j + 1];
        for (int i = 0; i < j; ++i, --j) {
            byte back;
            byte front = array[i];
            b[i] = back = array[j];
            b[j] = front;
        }
        return b;
    }

    static byte[] generateRandomBytes(int length) throws NoSuchAlgorithmException {
        byte[] b = new byte[length];
        SecureRandom sr = new SecureRandom();
        sr.nextBytes(b);
        return b;
    }

    private static void setMapping() {
        algoNamemap = new Hashtable();
        algoIdmap = new Hashtable();
        CMSUtils.setAlgoName("SHA1", CMS.sha_1);
        CMSUtils.setAlgoName("SHA-256", CMS.sha_256);
        CMSUtils.setAlgoName("SHA-384", CMS.sha_384);
        CMSUtils.setAlgoName("SHA-512", CMS.sha_512);
        CMSUtils.setAlgoName("MD5", CMS.md5);
        CMSUtils.setAlgoName("MD4", AlgID.md4);
        CMSUtils.setAlgoName("MD2", AlgID.md2);
        CMSUtils.setAlgoName("SHA-1withDSA", CMS.id_dsa_with_sha_1);
        CMSUtils.setAlgoName("MD5withRSA", AlgID.md5WithRSAEncryption);
        CMSUtils.setAlgoName("SHA1withRSA", AlgID.sha_1WithRSAEncryption);
        CMSUtils.setAlgoName("MD2withRSA", AlgID.md2WithRSAEncryption);
        CMSUtils.setAlgoName("SHA1withDSA", CMS.id_dsa_with_sha_1);
        CMSUtils.setAlgoName("SHA256withRSA", CMS.rsaWithSHA256);
        CMSUtils.setAlgoName("SHA384withRSA", CMS.rsaWithSHA384);
        CMSUtils.setAlgoName("SHA512withRSA", CMS.rsaWithSHA512);
        CMSUtils.setAlgoName("SHAwithDSA", CMS.dsaWithSHA);
        CMSUtils.setAlgoName("RSA/ /NoPadding", CMS.rsaEncryption);
        CMSUtils.setAlgoName("RSA", CMS.rsaEncryption);
        CMSUtils.setAlgoName("RSA/ /PKCS1Padding", CMS.rsaEncryption);
        CMSUtils.setAlgoName("DESede/ /PKCS5Padding", CMS.id_alg_CMS3DESwrap);
        CMSUtils.setAlgoName("DESede", CMS.id_alg_CMS3DESwrap);
        CMSUtils.setAlgoName("DES/CBC/PKCS5Padding", AlgID.desCBC);
        CMSUtils.setAlgoName("DES/CBC/NoPadding", AlgID.desCBC);
        CMSUtils.setAlgoName("RC2/ /PKCS5Padding", CMS.id_alg_CMSRC2wrap);
        CMSUtils.setAlgoName("RC2", CMS.id_alg_CMSRC2wrap);
        CMSUtils.setAlgoName("AES128/ /PKCS5Padding", CMS.id_alg_CMSAES128wrap);
        CMSUtils.setAlgoName("AES128", CMS.id_alg_CMSAES128wrap);
        CMSUtils.setAlgoName("AES192/ /PKCS5Padding", CMS.id_alg_CMSAES192wrap);
        CMSUtils.setAlgoName("AES192", CMS.id_alg_CMSAES192wrap);
        CMSUtils.setAlgoName("AES256/ /PKCS5Padding", CMS.id_alg_CMSAES256wrap);
        CMSUtils.setAlgoName("AES256", CMS.id_alg_CMSAES256wrap);
        CMSUtils.setAlgoName("AES", CMS.id_alg_CMSAES128wrap);
        CMSUtils.setAlgoName("DESede/CBC/PKCS5Padding", CMS.des_ede3_cbc);
        CMSUtils.setAlgoName("DESede/CBC/NoPadding", CMS.des_ede3_cbc);
        CMSUtils.setAlgoName("RC2/CBC/PKCS5Padding", CMS.rc2_cbc);
        CMSUtils.setAlgoName("RC2/CBC/NoPadding", CMS.rc2_cbc);
        CMSUtils.setAlgoName("AES128/CBC/PKCS5Padding", CMS.aes128_cbc);
        CMSUtils.setAlgoName("AES192/CBC/PKCS5Padding", CMS.aes192_cbc);
        CMSUtils.setAlgoName("AES256/CBC/PKCS5Padding", CMS.aes256_cbc);
        CMSUtils.setAlgoName("HmacSHA1", CMS.hmac_SHA_1);
    }

    private static void setOIDMapping() {
        algoOIDmap = new Hashtable();
        algoOIDmap.put(CMS.sha_1.getOID(), "SHA-1");
        algoOIDmap.put(CMS.sha_256.getOID(), "SHA-256");
        algoOIDmap.put(CMS.sha_384.getOID(), "SHA-384");
        algoOIDmap.put(CMS.sha_512.getOID(), "SHA-512");
        algoOIDmap.put(CMS.md5.getOID(), "MD5");
        algoOIDmap.put(CMS.id_dsa_with_sha_1.getOID(), "SHA-1withDSA");
        algoOIDmap.put(CMS.rsaWithSHA256.getOID(), "SHA256withRSA");
        algoOIDmap.put(CMS.rsaWithSHA384.getOID(), "SHA384withRSA");
        algoOIDmap.put(CMS.rsaWithSHA512.getOID(), "SHA512withRSA");
        algoOIDmap.put(CMS.dsaWithSHA.getOID(), "SHAwithDSA");
        algoOIDmap.put(CMS.rsaEncryption.getOID(), "RSA/NONE/PKCS1Padding");
        algoOIDmap.put(CMS.id_alg_CMS3DESwrap.getOID(), "DESede");
        algoOIDmap.put(AlgID.desCBC.getOID(), "DES/CBC/NoPadding");
        algoOIDmap.put(CMS.id_alg_CMSRC2wrap.getOID(), "RC2");
        algoOIDmap.put(CMS.id_alg_CMSAES128wrap.getOID(), "AES128");
        algoOIDmap.put(CMS.id_alg_CMSAES192wrap.getOID(), "AES192");
        algoOIDmap.put(CMS.id_alg_CMSAES256wrap.getOID(), "AES256");
        algoOIDmap.put(CMS.des_ede3_cbc.getOID(), "DESede/CBC/NoPadding");
        algoOIDmap.put(CMS.rc2_cbc.getOID(), "RC2/CBC/NoPadding");
        algoOIDmap.put(CMS.aes128_cbc.getOID(), "AES/CBC/NoPadding(128)");
        algoOIDmap.put(CMS.aes192_cbc.getOID(), "AES/CBC/NoPadding(192)");
        algoOIDmap.put(CMS.aes256_cbc.getOID(), "AES/CBC/NoPadding(256)");
        algoOIDmap.put(CMS.hmac_SHA_1.getOID(), "HmacSHA1");
    }

    private static AlgorithmIdentifier setAlgoName(String name, AlgorithmIdentifier oid) {
        algoNamemap.put(oid, name);
        return algoIdmap.put(name.toUpperCase(), oid);
    }

    public static AlgorithmIdentifier getAlgoID(String name) throws NoSuchAlgorithmException {
        AlgorithmIdentifier oid;
        if (algoIdmap == null) {
            CMSUtils.setMapping();
        }
        if ((oid = (AlgorithmIdentifier)algoIdmap.get(name.toUpperCase())) == null) {
            throw new NoSuchAlgorithmException("Algorithm " + name + "not supported");
        }
        return oid;
    }

    public static String getAlgoName(AlgorithmIdentifier oid) throws NoSuchAlgorithmException {
        return CMSUtils.getAlgoName(oid, false);
    }

    public static String getAlgoName(AlgorithmIdentifier oid, boolean removeMode) throws NoSuchAlgorithmException {
        String name;
        if (algoNamemap == null) {
            CMSUtils.setMapping();
        }
        if ((name = (String)algoNamemap.get(oid)) == null) {
            if (algoOIDmap == null) {
                CMSUtils.setOIDMapping();
            }
            if ((name = (String)algoOIDmap.get(oid.getOID())) == null) {
                throw new NoSuchAlgorithmException("Algorithmid " + oid + "is not supported");
            }
            if (removeMode) {
                return CMSUtils.removeMode(name);
            }
            return name;
        }
        if (removeMode) {
            return CMSUtils.removeMode(name);
        }
        return name;
    }

    private static String removeMode(String name) {
        int index = name.indexOf(47);
        String algoName = null;
        if (index != -1) {
            algoName = name.substring(0, index);
            if (algoName.compareTo("AES128") == 0 || algoName.compareTo("AES192") == 0 || algoName.compareTo("AES256") == 0) {
                return "AES";
            }
            return algoName;
        }
        return name;
    }

    public static byte[] generateKeyID(PublicKey key) throws NoSuchAlgorithmException {
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        md.update(key.getEncoded());
        return md.digest();
    }

    static ASN1Object getContents(Key key) {
        if (key instanceof java.security.interfaces.RSAPublicKey) {
            ASN1Sequence s = new ASN1Sequence();
            s.addElement((ASN1Object)new ASN1Integer(((java.security.interfaces.RSAPublicKey)key).getPublicExponent()));
            return s;
        }
        if (key instanceof DSAPublicKey) {
            return new ASN1Integer(((DSAPublicKey)key).getY());
        }
        if (key instanceof DHPublicKey) {
            return new ASN1Integer(((DHPublicKey)key).getY());
        }
        return null;
    }

    public static void setKeyParity(SecretKey key, int parity) {
        if (parity != 1 && parity != 0) {
            throw new IllegalArgumentException("Invalid parity argument");
        }
        byte[] keyBytes = key.getEncoded();
        for (int i = 0; i < keyBytes.length; ++i) {
            byte a = keyBytes[i];
            int b = a >> 7 ^ a >> 6 ^ a >> 5 ^ a >> 4 ^ a >> 3 ^ a >> 2 ^ a >> 1;
            keyBytes[i] = parity == 1 ? (byte)((a | 1) ^ b & 1) : (byte)(a & 0xFE ^ b & 1);
        }
    }

    public static boolean checkKeyParity(SecretKey key, int parity) {
        if (parity != 1 && parity != 0) {
            throw new IllegalArgumentException("Invalid parity argument");
        }
        byte[] keyBytes = key.getEncoded();
        for (int i = 0; i < keyBytes.length; ++i) {
            byte a = keyBytes[i];
            int b = a >> 7 ^ a >> 6 ^ a >> 5 ^ a >> 4 ^ a >> 3 ^ a >> 2 ^ a >> 1 ^ a;
            if ((b & 1) == parity) continue;
            return false;
        }
        return true;
    }

    public static String getSigAlgName(String encId, String digId) {
        if (digId.equals("SHA-256") && encId.equals("RSA")) {
            return "SHA256withRSA";
        }
        if (digId.equals("SHA-384") && encId.equals("RSA")) {
            return "SHA384withRSA";
        }
        if (digId.equals("SHA-512") && encId.equals("RSA")) {
            return "SHA512withRSA";
        }
        String name = null;
        name = digId + "with" + encId;
        return name;
    }

    public static String addPadding(String algoName) {
        String algName = null;
        int index = algoName.indexOf(47);
        if (index != -1) {
            int lindex = algoName.lastIndexOf(47);
            if (index != lindex) {
                algName = algoName.substring(0, lindex) + "/PKCS5Padding";
            }
        } else {
            algName = algoName + "/ /PKCS5Padding";
        }
        return algName;
    }

    public static X509 convertX509(X509Certificate cert) throws CertificateEncodingException {
        try {
            X509 certificate = new X509(cert.getEncoded());
            return certificate;
        }
        catch (IOException ex) {
            throw new CertificateEncodingException("IO EXception occured while encoding the certificate");
        }
    }

    public static Vector toX509Vector(Vector certs) throws CertificateEncodingException {
        boolean i = false;
        Vector<X509> X509Vector = new Vector<X509>();
        if (certs.elementAt(0) instanceof X509) {
            return certs;
        }
        if (certs.elementAt(0) instanceof X509Certificate) {
            Enumeration e = certs.elements();
            while (e.hasMoreElements()) {
                X509Vector.addElement(CMSUtils.convertX509((X509Certificate)e.nextElement()));
            }
        } else {
            throw new CertificateEncodingException("The vector doesnt contain X509 Certificates");
        }
        return X509Vector;
    }

    public static Vector toJCECertVector(Vector certs) throws CertificateException {
        Vector<X509Certificate> JCEVector = new Vector<X509Certificate>();
        if (certs.elementAt(0) instanceof X509Certificate) {
            return certs;
        }
        if (certs.elementAt(0) instanceof X509) {
            Enumeration e = certs.elements();
            while (e.hasMoreElements()) {
                JCEVector.addElement(CMSUtils.toX509JCECertificate((X509)e.nextElement()));
            }
        } else {
            throw new CertificateEncodingException("The vector doesnt contain X509 Certificates");
        }
        return JCEVector;
    }

    public static X509Certificate toX509JCECertificate(X509 cert) throws CertificateException {
        CertificateFactory cf1 = CertificateFactory.getInstance("X.509");
        X509Certificate X509Cert = (X509Certificate)cf1.generateCertificate(new ByteArrayInputStream(cert.getEncoded()));
        return X509Cert;
    }

    public static PublicKey toJCEPublicKey(oracle.security.crypto.core.PublicKey phaoskey) throws NoSuchAlgorithmException, InvalidKeySpecException {
        if (phaoskey instanceof oracle.security.crypto.core.DSAPublicKey) {
            oracle.security.crypto.core.DSAPublicKey pkey = (oracle.security.crypto.core.DSAPublicKey)phaoskey;
            BigInteger y = pkey.getY();
            DSAParams params = pkey.getParams();
            BigInteger p = params.getP();
            BigInteger q = params.getQ();
            BigInteger g = params.getG();
            DSAPublicKeySpec spec = new DSAPublicKeySpec(y, p, q, g);
            KeyFactory kf = KeyFactory.getInstance("DSA");
            return kf.generatePublic(spec);
        }
        if (phaoskey instanceof RSAPublicKey) {
            RSAPublicKey pkey = (RSAPublicKey)phaoskey;
            BigInteger mod = pkey.getModulus();
            BigInteger exp = pkey.getExponent();
            RSAPublicKeySpec spec = new RSAPublicKeySpec(mod, exp);
            KeyFactory kf = KeyFactory.getInstance("RSA");
            return kf.generatePublic(spec);
        }
        if (phaoskey instanceof oracle.security.crypto.core.DHPublicKey) {
            oracle.security.crypto.core.DHPublicKey pkey = (oracle.security.crypto.core.DHPublicKey)phaoskey;
            DHPublicKeySpec kspec = new DHPublicKeySpec(pkey.getY(), pkey.getParams().getP(), pkey.getParams().getQ());
            KeyFactory kf = KeyFactory.getInstance("DH");
            return kf.generatePublic(kspec);
        }
        throw new InvalidKeySpecException();
    }

    static int getKeySize(AlgorithmIdentifier algID) {
        if (algID.equals((Object)CMS.aes128_cbc)) {
            return AES128_KEYSIZE;
        }
        if (algID.equals((Object)CMS.aes192_cbc)) {
            return AES192_KEYSIZE;
        }
        if (algID.equals((Object)CMS.aes256_cbc)) {
            return AES256_KEYSIZE;
        }
        return -1;
    }
}

