/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Vector;
import javax.crypto.Cipher;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import oracle.security.crypto.asn1.ASN1FormatException;
import oracle.security.crypto.asn1.ASN1GenericConstructed;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.Attribute;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.IssuerAndSerialNo;
import oracle.security.crypto.cert.X500Name;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSContentInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.core.AuthenticationException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.StreamableOutputException;
import oracle.security.crypto.util.UnsyncByteArrayOutputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public final class CMSSignerInfo
implements ASN1Object {
    private IssuerAndSerialNo signerIASN;
    private AlgorithmIdentifier digestAlgID;
    private AlgorithmIdentifier digestEncryptionAlgID;
    private AttributeSet authenticatedAttributes;
    private AttributeSet unauthenticatedAttributes;
    private byte[] encryptedDigest;
    private ASN1Integer version;
    private byte[] signerSPKI;
    private ASN1Sequence contents = null;

    public CMSSignerInfo(CMSContentInfo contentInfo, AttributeSet authenticatedAttributes, PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet unauthenticatedAttributes) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException, CertificateEncodingException, IOException {
        this.version = new ASN1Integer(1L);
        if (signerCert == null) {
            throw new IllegalArgumentException("Null Signer Certificate");
        }
        this.signerIASN = new IssuerAndSerialNo(new X509(signerCert.getEncoded()));
        this.digestAlgID = digestAlgID;
        this.digestEncryptionAlgID = digestEncryptionAlgID;
        if (authenticatedAttributes != null) {
            this.authenticatedAttributes = (AttributeSet)authenticatedAttributes.clone();
        }
        if (unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes = (AttributeSet)unauthenticatedAttributes.clone();
        }
        MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID));
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        if (contentInfo.getExposedContent() == null && !contentInfo.getContentType().equals((Object)CMS.id_data)) {
            throw new SignatureException("Content type is not id-data and content is NULL");
        }
        byte[] expContent = contentInfo.getExposedContent();
        if (expContent == null) {
            expContent = new byte[]{};
        }
        byte[] digest = md.digest(expContent);
        byte[] originaldata = expContent;
        if (!contentInfo.getContentType().equals((Object)CMS.id_data) || authenticatedAttributes != null) {
            if (authenticatedAttributes == null) {
                this.authenticatedAttributes = new AttributeSet();
            }
            this.authenticatedAttributes.addAttribute(CMS.id_contentType, (ASN1Object)contentInfo.getContentType());
            this.authenticatedAttributes.addAttribute(CMS.id_messageDigest, (ASN1Object)new ASN1OctetString(digest));
            MessageDigest md1 = MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID));
            digest = md1.digest(Utils.toBytes((Streamable)this.authenticatedAttributes));
            originaldata = Utils.toBytes((Streamable)this.authenticatedAttributes);
        }
        Signature sig = Signature.getInstance(CMSUtils.getSigAlgName(signerKey.getAlgorithm(), CMSUtils.getAlgoName(digestAlgID)));
        sig.initSign(signerKey);
        sig.update(originaldata);
        this.encryptedDigest = sig.sign();
    }

    public CMSSignerInfo(X500Name issuer, BigInteger serialNo, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet authenticatedAttributes, AttributeSet unauthenticatedAttributes, byte[] encryptedDigest) {
        this(new IssuerAndSerialNo(issuer, serialNo), digestAlgID, digestEncryptionAlgID, authenticatedAttributes, unauthenticatedAttributes, encryptedDigest);
    }

    public CMSSignerInfo(X509Certificate cert, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet authenticatedAttributes, AttributeSet unauthenticatedAttributes, byte[] encryptedDigest) throws CertificateEncodingException, IOException {
        this(new IssuerAndSerialNo(new X509(cert.getEncoded())), digestAlgID, digestEncryptionAlgID, authenticatedAttributes, unauthenticatedAttributes, encryptedDigest);
    }

    CMSSignerInfo(IssuerAndSerialNo signerIASN, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet authenticatedAttributes, AttributeSet unauthenticatedAttributes, byte[] encryptedDigest) {
        this.version = new ASN1Integer(1L);
        this.signerIASN = signerIASN;
        this.digestAlgID = digestAlgID;
        this.digestEncryptionAlgID = digestEncryptionAlgID;
        if (authenticatedAttributes != null) {
            this.authenticatedAttributes = (AttributeSet)authenticatedAttributes.clone();
        }
        if (unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes = (AttributeSet)unauthenticatedAttributes.clone();
        }
        this.encryptedDigest = encryptedDigest;
    }

    CMSSignerInfo(byte[] signerSPKI, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet authenticatedAttributes, AttributeSet unauthenticatedAttributes, byte[] encryptedDigest) {
        this.version = new ASN1Integer(3L);
        this.signerSPKI = signerSPKI;
        this.digestAlgID = digestAlgID;
        this.digestEncryptionAlgID = digestEncryptionAlgID;
        if (authenticatedAttributes != null) {
            this.authenticatedAttributes = (AttributeSet)authenticatedAttributes.clone();
        }
        if (unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes = (AttributeSet)unauthenticatedAttributes.clone();
        }
        this.encryptedDigest = encryptedDigest;
    }

    public CMSSignerInfo(InputStream is) throws IOException {
        this.input(is);
    }

    public CMSSignerInfo(CMSContentInfo contentInfo, AttributeSet authenticatedAttributes, PrivateKey signerKey, X509Certificate signerCert, AlgorithmIdentifier digestAlgID, AlgorithmIdentifier digestEncryptionAlgID, AttributeSet unauthenticatedAttributes, boolean use64BitSPKI) throws InvalidKeyException, SignatureException, NoSuchAlgorithmException {
        this.signerSPKI = use64BitSPKI ? CMSUtils.generateSPKI64(signerCert) : CMSUtils.generateSPKI160(signerCert);
        this.digestAlgID = digestAlgID;
        this.digestEncryptionAlgID = digestEncryptionAlgID;
        if (authenticatedAttributes != null) {
            this.authenticatedAttributes = (AttributeSet)authenticatedAttributes.clone();
        }
        if (unauthenticatedAttributes != null) {
            this.unauthenticatedAttributes = (AttributeSet)unauthenticatedAttributes.clone();
        }
        MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID));
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        byte[] expContent = contentInfo.getExposedContent();
        if (expContent == null) {
            expContent = new byte[]{};
        }
        byte[] digest = md.digest(expContent);
        byte[] originaldata = expContent;
        if (!contentInfo.getContentType().equals((Object)CMS.id_data) || authenticatedAttributes != null) {
            if (authenticatedAttributes == null) {
                this.authenticatedAttributes = new AttributeSet();
            }
            this.authenticatedAttributes.addAttribute(CMS.id_contentType, (ASN1Object)contentInfo.getContentType());
            this.authenticatedAttributes.addAttribute(CMS.id_messageDigest, (ASN1Object)new ASN1OctetString(digest));
            MessageDigest md1 = MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID));
            digest = md1.digest(Utils.toBytes((Streamable)this.authenticatedAttributes));
            originaldata = Utils.toBytes((Streamable)this.authenticatedAttributes);
        }
        Signature sig = Signature.getInstance(CMSUtils.getSigAlgName(signerKey.getAlgorithm(), CMSUtils.getAlgoName(digestAlgID)));
        sig.initSign(signerKey);
        sig.update(originaldata);
        this.encryptedDigest = sig.sign();
    }

    IssuerAndSerialNo getIASN() {
        return this.signerIASN;
    }

    byte[] getSPKI() {
        return this.signerSPKI;
    }

    public X500Name getIssuer() {
        if (this.signerIASN != null) {
            return this.signerIASN.getIssuer();
        }
        return null;
    }

    public BigInteger getSerialNo() {
        if (this.signerIASN != null) {
            return this.signerIASN.getSerialNo();
        }
        return null;
    }

    public AttributeSet getSignedAttributes() {
        return this.authenticatedAttributes;
    }

    public AttributeSet getUnsignedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public AttributeSet getAuthenticatedAttributes() {
        return this.authenticatedAttributes;
    }

    public AttributeSet getUnauthenticatedAttributes() {
        return this.unauthenticatedAttributes;
    }

    public void addUnsignedAttribute(Attribute attr) {
        if (attr != null) {
            if (this.unauthenticatedAttributes == null) {
                this.unauthenticatedAttributes = new AttributeSet();
            }
            this.unauthenticatedAttributes.addAttribute(attr);
        }
    }

    public AlgorithmIdentifier getDigestAlgID() {
        return this.digestAlgID;
    }

    public AlgorithmIdentifier getDigestEncryptionAlgID() {
        return this.digestEncryptionAlgID;
    }

    public byte[] getEncryptedDigest() {
        return this.encryptedDigest;
    }

    public boolean isSPKI() {
        return this.signerSPKI != null;
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    public ASN1Integer getVersion() {
        return this.version;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("issuer = \"");
        sb.append(this.getIssuer());
        sb.append("\", serial number = ");
        sb.append(this.getSerialNo());
        sb.append("spki = \"");
        sb.append(Utils.toHexString((byte[])this.getSPKI()) + "\"");
        if (this.authenticatedAttributes != null) {
            sb.append(", " + Utils.plural((int)this.authenticatedAttributes.size(), (String)"authenticated attribute"));
        }
        if (this.unauthenticatedAttributes != null) {
            sb.append(", " + Utils.plural((int)this.unauthenticatedAttributes.size(), (String)"unauthenticated attribute"));
        }
        sb.append(", digest alg OID = " + this.digestAlgID.getOID());
        sb.append(", digest encryption alg OID = " + this.digestEncryptionAlgID.getOID());
        sb.append(", encrypted digest = " + Utils.toHexString((byte[])this.encryptedDigest));
        return sb.toString();
    }

    public int hashCode() {
        try {
            UnsyncByteArrayOutputStream bos = new UnsyncByteArrayOutputStream();
            this.output((OutputStream)bos);
            return new String(bos.toByteArray()).hashCode();
        }
        catch (IOException ex) {
            throw new StreamableOutputException(ex.toString());
        }
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof CMSSignerInfo)) {
            return false;
        }
        return this.hashCode() == ((CMSSignerInfo)obj).hashCode();
    }

    public void verifySignature(CMSContentInfo contentInfo, PublicKey publicKey) throws AuthenticationException, SignatureException {
        if (contentInfo == null) {
            throw new IllegalArgumentException("Null Content Info");
        }
        byte[] exposedContent = contentInfo.getExposedContent();
        if (exposedContent == null && !contentInfo.getContentType().equals((Object)CMS.id_data)) {
            throw new AuthenticationException("Content missing.");
        }
        byte[] digest = null;
        try {
            MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
            digest = exposedContent == null ? md.digest(new byte[0]) : md.digest(exposedContent);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        this.verifySignature(exposedContent, contentInfo.getContentType(), publicKey);
    }

    void verifySignature(byte[] originaldata, ASN1ObjectID contentType, PublicKey publicKey) throws AuthenticationException, SignatureException {
        if (originaldata == null) {
            originaldata = new byte[]{};
        }
        byte[] digest = null;
        try {
            if (this.authenticatedAttributes == null) {
                if (!contentType.equals((Object)CMS.id_data)) {
                    throw new AuthenticationException("Content type is not 'data', but authenticated attributes are missing.");
                }
            } else {
                byte[] digest0;
                ASN1ObjectID announcedContentType;
                try {
                    Vector vals = this.authenticatedAttributes.getAttributeValues(CMS.id_contentType);
                    if (vals == null) {
                        throw new AuthenticationException("The 'contentType' attribute is missing");
                    }
                    if (vals.size() != 1) {
                        throw new AuthenticationException("The 'contentType' attribute is not single valued");
                    }
                    announcedContentType = (ASN1ObjectID)vals.elementAt(0);
                }
                catch (ClassCastException ex) {
                    throw new AuthenticationException("The value of the 'contentType' attribute has the wrong type");
                }
                if (!announcedContentType.equals((Object)contentType)) {
                    throw new AuthenticationException("The value of the 'contentType' attribute is incorrect");
                }
                try {
                    Vector vals = this.authenticatedAttributes.getAttributeValues(CMS.id_messageDigest);
                    if (vals == null) {
                        throw new AuthenticationException("The 'messageDigest' attribute is missing");
                    }
                    if (vals.size() != 1) {
                        throw new AuthenticationException("The 'messageDigest' attribute is not single valued");
                    }
                    digest0 = ((ASN1OctetString)vals.elementAt(0)).getValue();
                }
                catch (ClassCastException ex) {
                    throw new AuthenticationException("The value of the 'messageDigest' attribute has the wrong type");
                }
                MessageDigest md = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
                digest = md.digest(originaldata);
                if (!Utils.areEqual((byte[])digest, (byte[])digest0)) {
                    throw new AuthenticationException("The value of the 'messageDigest' attribute is incorrect");
                }
                MessageDigest md1 = MessageDigest.getInstance(CMSUtils.getAlgoName(this.digestAlgID));
                digest = md1.digest(Utils.toBytes((Streamable)this.authenticatedAttributes));
                originaldata = Utils.toBytes((Streamable)this.authenticatedAttributes);
            }
            Signature sig = Signature.getInstance(CMSUtils.getSigAlgName(publicKey.getAlgorithm(), CMSUtils.getAlgoName(this.digestAlgID)));
            sig.initVerify(publicKey);
            sig.update(originaldata);
            if (!sig.verify(this.encryptedDigest)) {
                throw new AuthenticationException("Signature is invalid");
            }
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    void verifySignature(byte[] originaldata, PublicKey publicKey, SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID) throws AuthenticationException, SignatureException {
        try {
            String algoName = CMSUtils.addPadding(CMSUtils.getAlgoName(contentEncryptionAlgID));
            Cipher outerCipher = Cipher.getInstance(algoName);
            byte[] sigbytes = null;
            outerCipher.init(2, contentEncryptionKey);
            sigbytes = outerCipher.update(this.encryptedDigest);
            Signature sig = Signature.getInstance(CMSUtils.getSigAlgName(publicKey.getAlgorithm(), CMSUtils.getAlgoName(this.digestAlgID)));
            sig.initVerify(publicKey);
            sig.update(originaldata);
            if (!sig.verify(sigbytes)) {
                throw new AuthenticationException("Signature is invalid");
            }
        }
        catch (NoSuchPaddingException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (InvalidKeyException ex) {
            throw new AuthenticationException(ex.toString());
        }
        catch (NoSuchAlgorithmException ex) {
            throw new AuthenticationException(ex.toString());
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void input(InputStream is) throws IOException {
        ASN1SequenceInputStream si = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)si);
        if (!this.version.equals(1) && !this.version.equals(3)) {
            throw new VersionException(this.version.getValue(), 1);
        }
        if (this.version.equals(3)) {
            if (si.getCurrentTag() != 0) {
                throw new IOException("Version 3 SignerInfo Expected Tag [0]");
            }
            si.setCurrentTag(4);
            this.signerSPKI = new ASN1OctetString((InputStream)si).getValue();
        } else {
            this.signerIASN = new IssuerAndSerialNo((InputStream)si);
        }
        this.digestAlgID = new AlgorithmIdentifier((InputStream)si);
        if (si.getCurrentTag() == 0) {
            si.setCurrentTag(17);
            this.authenticatedAttributes = new AttributeSet((InputStream)si);
        } else {
            this.authenticatedAttributes = null;
        }
        this.digestEncryptionAlgID = new AlgorithmIdentifier((InputStream)si);
        this.encryptedDigest = new ASN1OctetString((InputStream)si).getValue();
        if (si.hasMoreData()) {
            if (si.getCurrentTag() != 1) throw new ASN1FormatException("unauthenticatedAttributes with Tag [1] expected");
            si.setCurrentTag(17);
            this.unauthenticatedAttributes = new AttributeSet((InputStream)si);
        } else {
            this.unauthenticatedAttributes = null;
        }
        si.terminate();
        this.update();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            ASN1Sequence seq = new ASN1Sequence();
            if (this.signerSPKI != null) {
                seq.addElement((ASN1Object)new ASN1Integer(3L));
                seq.addElement(ASN1Utils.addImplicitTag((ASN1Object)new ASN1OctetString(this.signerSPKI), (int)0));
            } else {
                seq.addElement((ASN1Object)new ASN1Integer(1L));
                seq.addElement((ASN1Object)this.signerIASN);
            }
            seq.addElement((ASN1Object)this.digestAlgID);
            if (this.authenticatedAttributes != null) {
                ASN1GenericConstructed tagAA = new ASN1GenericConstructed(this.authenticatedAttributes.toASN1Set().elements(), 0);
                tagAA.setEncodingType(2);
                seq.addElement((ASN1Object)tagAA);
            }
            seq.addElement((ASN1Object)this.digestEncryptionAlgID);
            seq.addElement((ASN1Object)new ASN1OctetString(this.encryptedDigest));
            if (this.unauthenticatedAttributes != null) {
                seq.addElement((ASN1Object)new ASN1GenericConstructed(this.unauthenticatedAttributes.toASN1Set().elements(), 1));
            }
            this.contents = seq;
        }
        return this.contents;
    }
}

