/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1ObjectID;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Set;
import oracle.security.crypto.asn1.ASN1Utils;
import oracle.security.crypto.cert.AttributeSet;
import oracle.security.crypto.cert.CRL;
import oracle.security.crypto.cert.X509;
import oracle.security.crypto.cms.CIOutputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSOutputConnector;
import oracle.security.crypto.cms.CMSOutputStream;
import oracle.security.crypto.cms.CMSSignerInfo;
import oracle.security.crypto.cms.CMSSignerInfoSpec;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.OutputGenerationException;
import oracle.security.crypto.util.Streamable;
import oracle.security.crypto.util.Utils;

public class CMSSignedDataOutputStream
extends CMSOutputStream {
    private Hashtable digestTable;
    private Vector certificates;
    private Vector crls;
    private Vector signers;
    private ASN1ObjectID contentType;
    private boolean createExternalSignatures = false;
    private boolean writingToConnector;
    private boolean terminated = false;
    private CIOutputStream content_out;
    private Datacontent originalData;
    private boolean prefaceOutput = false;

    public CMSSignedDataOutputStream(OutputStream out, Vector signers, Vector certificates, Vector crls) throws NoSuchAlgorithmException {
        this(out, signers, certificates, crls, CMS.id_data, false);
    }

    public CMSSignedDataOutputStream(OutputStream out, Vector signers, Vector certificates, Vector crls, ASN1ObjectID contentType) throws NoSuchAlgorithmException {
        this(out, signers, certificates, crls, contentType, false);
    }

    public CMSSignedDataOutputStream(OutputStream out, Vector signers, Vector certificates, Vector crls, ASN1ObjectID contentType, boolean createExternalSignatures) throws NoSuchAlgorithmException {
        super(out);
        this.signers = signers;
        this.certificates = certificates;
        this.crls = crls;
        this.contentType = contentType;
        this.originalData = new Datacontent();
        this.createExternalSignatures = createExternalSignatures;
        this.writingToConnector = false;
        this.initializeDigestTable();
    }

    public CMSSignedDataOutputStream(CMSOutputConnector conn, Vector signers, Vector certificates, Vector crls, ASN1ObjectID contentType) throws NoSuchAlgorithmException {
        this(conn, signers, certificates, crls, contentType, true);
    }

    public CMSSignedDataOutputStream(CMSOutputConnector conn, Vector signers, Vector certificates, Vector crls, ASN1ObjectID contentType, boolean createExternalSignatures) throws NoSuchAlgorithmException {
        super(conn.getOutputStream());
        this.signers = signers;
        this.certificates = certificates;
        this.crls = crls;
        this.contentType = contentType;
        this.originalData = new Datacontent();
        this.createExternalSignatures = createExternalSignatures;
        this.writingToConnector = true;
        this.initializeDigestTable();
    }

    private void initializeDigestTable() throws NoSuchAlgorithmException {
        this.digestTable = new Hashtable();
        Enumeration e = this.signers.elements();
        while (e.hasMoreElements()) {
            AlgorithmIdentifier digestAlgID = ((CMSSignerInfoSpec)e.nextElement()).getDigestAlgID();
            if (this.digestTable.get(digestAlgID) != null) continue;
            this.digestTable.put(digestAlgID, MessageDigest.getInstance(CMSUtils.getAlgoName(digestAlgID)));
        }
    }

    private void ensurePrefaceOutput() throws IOException {
        if (!this.prefaceOutput) {
            if (!this.writingToConnector) {
                ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
                CMS.id_signedData.output(this.out);
                ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
            }
            ASN1Utils.outputHeader((OutputStream)this.out, (int)16, (int)0);
            boolean version1 = true;
            if (this.signers != null) {
                Enumeration e = this.signers.elements();
                while (e.hasMoreElements() && version1) {
                    if (!((CMSSignerInfoSpec)e.nextElement()).isSPKI()) continue;
                    version1 = false;
                }
            }
            if (this.certificates != null) {
                Enumeration k = this.certificates.elements();
                while (k.hasMoreElements() && version1) {
                    Certificate cert = (Certificate)k.nextElement();
                    if (cert instanceof X509Certificate) continue;
                    version1 = false;
                }
            }
            if (!this.contentType.equals((Object)CMS.id_data)) {
                version1 = false;
            }
            if (version1) {
                ASN1Integer.outputValue((OutputStream)this.out, (int)1);
            } else {
                ASN1Integer.outputValue((OutputStream)this.out, (int)3);
            }
            ASN1Set da = new ASN1Set(this.digestTable.keys());
            da.setEncodingType(0);
            da.output(this.out);
            this.content_out = new CIOutputStream(this.out, this.contentType, this.createExternalSignatures);
            this.content_out.writeInitial(this.signers != null && this.signers.size() > 0);
            this.prefaceOutput = true;
        }
    }

    private void writeSDBodyFinal() throws IOException {
        Enumeration e;
        if (this.certificates != null) {
            ASN1Utils.outputHeader((OutputStream)this.out, (int)0, (int)128);
            try {
                e = this.certificates.elements();
                while (e.hasMoreElements()) {
                    new X509(((X509Certificate)e.nextElement()).getEncoded()).output(this.out);
                }
                ASN1Utils.outputEndOfContents((OutputStream)this.out);
            }
            catch (CertificateEncodingException ex) {
                throw new IOException(ex.toString());
            }
        }
        if (this.crls != null) {
            ASN1Utils.outputHeader((OutputStream)this.out, (int)1, (int)128);
            e = this.crls.elements();
            while (e.hasMoreElements()) {
                ((CRL)e.nextElement()).output(this.out);
            }
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
        }
        ASN1Utils.outputHeader((OutputStream)this.out, (int)17, (int)0);
        e = this.signers.elements();
        while (e.hasMoreElements()) {
            byte[] encryptedDigest;
            byte[] digest;
            byte[] datacontent;
            MessageDigest md1;
            CMSSignerInfoSpec signer = (CMSSignerInfoSpec)e.nextElement();
            MessageDigest md = (MessageDigest)this.digestTable.get(signer.getDigestAlgID());
            AttributeSet aA = signer.getAuthenticatedAttributes();
            if (this.contentType.equals((Object)CMS.id_data) && aA == null) {
                try {
                    md1 = MessageDigest.getInstance(CMSUtils.getAlgoName(signer.getDigestAlgID()));
                    datacontent = this.originalData.buffer;
                    digest = md1.digest(datacontent);
                }
                catch (NoSuchAlgorithmException ex) {
                    throw new IOException(ex.toString());
                }
            }
            if (aA == null) {
                aA = new AttributeSet();
            }
            try {
                aA.addAttribute(CMS.id_contentType, (ASN1Object)this.contentType);
                md1 = MessageDigest.getInstance(CMSUtils.getAlgoName(signer.getDigestAlgID()));
                byte[] dig = null;
                dig = this.originalData.buffer == null ? md1.digest(new byte[0]) : md1.digest(this.originalData.buffer);
                aA.addAttribute(CMS.id_messageDigest, (ASN1Object)new ASN1OctetString(dig));
                digest = MessageDigest.getInstance(CMSUtils.getAlgoName(signer.getDigestAlgID())).digest(Utils.toBytes((Streamable)aA));
            }
            catch (NoSuchAlgorithmException ex) {
                throw new IOException(ex.toString());
            }
            datacontent = Utils.toBytes((Streamable)aA);
            PrivateKey signerKey = signer.getSignerKey();
            try {
                Signature sig = Signature.getInstance(CMSUtils.getSigAlgName(signerKey.getAlgorithm(), CMSUtils.getAlgoName(signer.getDigestAlgID())));
                sig.initSign(signerKey);
                sig.update(datacontent);
                encryptedDigest = sig.sign();
            }
            catch (SignatureException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (NoSuchAlgorithmException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            catch (InvalidKeyException ex) {
                throw new OutputGenerationException((Exception)ex);
            }
            CMSSignerInfo si = !signer.isSPKI() ? new CMSSignerInfo(signer.getIASN(), signer.getDigestAlgID(), signer.getDigestEncryptionAlgID(), aA, signer.getUnauthenticatedAttributes(), encryptedDigest) : new CMSSignerInfo(signer.generate160BitSPKI(), signer.getDigestAlgID(), signer.getDigestEncryptionAlgID(), aA, signer.getUnauthenticatedAttributes(), encryptedDigest);
            si.output(this.out);
        }
        ASN1Utils.outputEndOfContents((OutputStream)this.out);
    }

    @Override
    public void terminate() throws IOException {
        Enumeration e = this.digestTable.elements();
        while (e.hasMoreElements()) {
            MessageDigest md = (MessageDigest)e.nextElement();
            md.digest();
        }
        this.ensurePrefaceOutput();
        this.content_out.writeFinal();
        this.writeSDBodyFinal();
        ASN1Utils.outputEndOfContents((OutputStream)this.out);
        if (!this.writingToConnector) {
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
            ASN1Utils.outputEndOfContents((OutputStream)this.out);
        } else {
            ((CMSOutputStream)this.out).terminate();
        }
        this.terminated = true;
    }

    @Override
    public void write(int ch) throws IOException {
        Enumeration e = this.digestTable.elements();
        while (e.hasMoreElements()) {
            MessageDigest md = (MessageDigest)e.nextElement();
            md.update((byte)ch);
            this.originalData.update((byte)ch);
        }
        this.ensurePrefaceOutput();
        this.content_out.write(ch);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        Enumeration e = this.digestTable.elements();
        while (e.hasMoreElements()) {
            MessageDigest md = (MessageDigest)e.nextElement();
            md.update(b, off, len);
            this.originalData.update(b, off, len);
        }
        this.ensurePrefaceOutput();
        this.content_out.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        if (!this.terminated) {
            this.terminate();
        }
        super.close();
    }

    @Override
    public ASN1ObjectID getExposedContentType() {
        return CMS.id_signedData;
    }

    final class Datacontent {
        int len = 0;
        byte[] buffer = null;

        public void update(byte ch) {
            int length = this.len + 1;
            byte[] buffertemp = new byte[length];
            if (this.len != 0) {
                System.arraycopy(this.buffer, 0, buffertemp, 0, this.len);
            }
            buffertemp[this.len] = ch;
            this.buffer = null;
            this.buffer = buffertemp;
            buffertemp = null;
            this.len = length;
        }

        public void update(byte[] buff, int offset, int leng) {
            int length = this.len + leng;
            byte[] buffertemp = new byte[length];
            if (this.len != 0) {
                System.arraycopy(this.buffer, 0, buffertemp, 0, this.len);
            }
            System.arraycopy(buff, offset, buffertemp, this.len, leng);
            this.buffer = null;
            this.buffer = buffertemp;
            buffertemp = null;
            this.len = length;
        }
    }
}

