/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.crypto.cms;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import oracle.security.crypto.asn1.ASN1Date;
import oracle.security.crypto.asn1.ASN1Integer;
import oracle.security.crypto.asn1.ASN1Object;
import oracle.security.crypto.asn1.ASN1OctetString;
import oracle.security.crypto.asn1.ASN1Sequence;
import oracle.security.crypto.asn1.ASN1SequenceInputStream;
import oracle.security.crypto.cms.CMS;
import oracle.security.crypto.cms.CMSKEKRecipientInfoSpec;
import oracle.security.crypto.cms.CMSRecipientInfo;
import oracle.security.crypto.cms.CMSUtils;
import oracle.security.crypto.core.AlgorithmIdentifier;
import oracle.security.crypto.util.InvalidInputException;
import oracle.security.crypto.util.Utils;
import oracle.security.crypto.util.VersionException;

public class CMSKEKRecipientInfo
extends CMSRecipientInfo {
    private ASN1Integer version;
    private AlgorithmIdentifier keyEncryptionAlgID;
    private AlgorithmIdentifier contentEncryptionKeyAlgID;
    private byte[] encryptedKey;
    private CMSKEKRecipientInfoSpec ri;
    private String KeyAlgoName = null;
    private static final byte[] KEY_WRAP_IV = Utils.fromHexString((String)"4adda22c79e82105");
    private ASN1Sequence contents = null;

    public CMSKEKRecipientInfo() {
    }

    public CMSKEKRecipientInfo(byte[] contentEncryptionKey, AlgorithmIdentifier contentEncryptionAlgID, CMSKEKRecipientInfoSpec ri) throws InvalidKeyException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this.keyEncryptionAlgID = ri.getKeyEncryptionAlgID();
        this.version = new ASN1Integer(4L);
        this.ri = ri;
        this.contentEncryptionKeyAlgID = contentEncryptionAlgID;
        this.KeyAlgoName = CMSUtils.getAlgoName(contentEncryptionAlgID);
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMS3DESwrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("DESede")) {
            throw new InvalidKeyException(" Triple DES Key Wrap can only wrap Triple DES Content Encryption Keys");
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSRC2wrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("RC2")) {
            throw new InvalidKeyException(" RC2 Key Wrap can only wrap RC2 Content Encryption Keys");
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES128wrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("AES")) {
            throw new InvalidKeyException(" AES128 Key Wrap can only wrap AES128 Content Encryption Keys");
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES192wrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("AES")) {
            throw new InvalidKeyException(" AES192 Key Wrap can only wrap AES192 Content Encryption Keys");
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES256wrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("AES")) {
            throw new InvalidKeyException(" AES256 Key Wrap can only wrap AES256 Content Encryption Keys");
        }
        if (!(this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMS3DESwrap) || this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSRC2wrap) || this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES128wrap) || this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES192wrap) || this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES256wrap))) {
            throw new InvalidKeyException(" Key Wrap Algorithm Not Supported");
        }
        this.initializeKey(contentEncryptionKey);
    }

    public CMSKEKRecipientInfo(SecretKey contentEncryptionKey, CMSKEKRecipientInfoSpec ri) throws InvalidKeyException, InvalidInputException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this(contentEncryptionKey, CMSUtils.getAlgoID(contentEncryptionKey.getAlgorithm()), ri);
    }

    public CMSKEKRecipientInfo(SecretKey contentEncryptionKey, AlgorithmIdentifier contentEncryptionKeyAlgID, CMSKEKRecipientInfoSpec ri) throws InvalidKeyException, InvalidInputException, NoSuchAlgorithmException, IllegalBlockSizeException, BadPaddingException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        this.keyEncryptionAlgID = ri.getKeyEncryptionAlgID();
        this.version = new ASN1Integer(4L);
        this.ri = ri;
        this.contentEncryptionKeyAlgID = contentEncryptionKeyAlgID;
        this.KeyAlgoName = CMSUtils.getAlgoName(contentEncryptionKeyAlgID);
        this.initialize(contentEncryptionKey);
    }

    void initialize(SecretKey contentEncryptionKey) throws InvalidKeyException, InvalidInputException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        String algo = CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID);
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMS3DESwrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("DESede")) {
            throw new InvalidKeyException(" Triple DES Key Wrap can only wrap Triple DES Content Encryption Keys");
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSRC2wrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("RC2")) {
            throw new InvalidKeyException(" RC2 Key Wrap can only wrap RC2 Content Encryption Keys");
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES128wrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("AES")) {
            throw new InvalidKeyException(" AES128 Key Wrap can only wrap AES128 Content Encryption Keys");
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES192wrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("AES")) {
            throw new InvalidKeyException(" AES192 Key Wrap can only wrap AES192 Content Encryption Keys");
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES256wrap) && !CMSUtils.getAlgoName(this.contentEncryptionKeyAlgID).equals("AES")) {
            throw new InvalidKeyException(" AES256 Key Wrap can only wrap AES256 Content Encryption Keys");
        }
        if (!(this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMS3DESwrap) || this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSRC2wrap) || this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES128wrap) || this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES192wrap) || this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES256wrap))) {
            throw new InvalidKeyException(" Key Wrap Algorithm Not Supported");
        }
        this.KeyAlgoName = contentEncryptionKey.getAlgorithm();
        this.initializeKey(contentEncryptionKey.getEncoded());
    }

    void initializeKey(byte[] keyBytes) throws InvalidKeyException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMS3DESwrap)) {
            this.des3KeyWrap(keyBytes);
        } else if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSRC2wrap)) {
            this.rc2KeyWrap(keyBytes);
        } else if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES128wrap)) {
            this.aesKeyWrap(keyBytes);
        } else if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES192wrap)) {
            this.aesKeyWrap(keyBytes);
        } else if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES256wrap)) {
            this.aesKeyWrap(keyBytes);
        } else {
            throw new NoSuchAlgorithmException("Key Wrap Algorithm not Supported: " + this.keyEncryptionAlgID);
        }
    }

    void des3KeyWrap(byte[] keyBytes) throws InvalidKeyException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        String algoName = CMSUtils.getAlgoName(CMS.des_ede3_cbc);
        SecretKeySpec des3Key = new SecretKeySpec(keyBytes, algoName);
        CMSUtils.setKeyParity(des3Key, 1);
        byte[] CEK = des3Key.getEncoded();
        byte[] ICV = CMSUtils.getKeyChecksum(keyBytes);
        byte[] CEKICV = CMSUtils.doORByteArrays(CEK, ICV);
        byte[] IV = CMSUtils.generateRandomBytes(8);
        Cipher cipher = Cipher.getInstance(CMSUtils.getAlgoName(CMS.des_ede3_cbc));
        IvParameterSpec p = new IvParameterSpec(IV);
        cipher.init(1, (Key)this.ri.getSymmetricKey(), p);
        byte[] TEMP1 = cipher.doFinal(CEKICV);
        byte[] TEMP2 = CMSUtils.doORByteArrays(IV, TEMP1);
        byte[] TEMP3 = CMSUtils.reverseArrayOrder(TEMP2);
        cipher = Cipher.getInstance(CMSUtils.getAlgoName(CMS.des_ede3_cbc));
        IvParameterSpec p1 = new IvParameterSpec(KEY_WRAP_IV);
        cipher.init(1, (Key)this.ri.getSymmetricKey(), p1);
        this.encryptedKey = cipher.doFinal(TEMP3);
        if (this.encryptedKey.length != 40) {
            throw new InvalidKeyException("Wrapped Key is NOT 40 bytes in length");
        }
    }

    byte[] des3KeyUnwrap(SecretKey keyDecryptionKey) throws InvalidKeyException, InvalidInputException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        if (this.ri.getEncryptedKey().length != 40) {
            throw new InvalidInputException(" Wrapped Key MUST be 40 Bytes in Length");
        }
        Cipher cipher = Cipher.getInstance(CMSUtils.getAlgoName(CMS.des_ede3_cbc));
        IvParameterSpec p = new IvParameterSpec(KEY_WRAP_IV);
        cipher.init(2, (Key)keyDecryptionKey, p);
        byte[] TEMP3 = cipher.doFinal(this.ri.getEncryptedKey());
        byte[] TEMP2 = CMSUtils.reverseArrayOrder(TEMP3);
        byte[] IV = new byte[8];
        byte[] TEMP1 = new byte[32];
        System.arraycopy(TEMP2, 0, IV, 0, 8);
        System.arraycopy(TEMP2, 8, TEMP1, 0, 32);
        cipher = Cipher.getInstance(CMSUtils.getAlgoName(CMS.des_ede3_cbc));
        IvParameterSpec p1 = new IvParameterSpec(IV);
        cipher.init(2, (Key)keyDecryptionKey, p1);
        byte[] CEKICV = cipher.doFinal(TEMP1);
        byte[] CEK = new byte[24];
        byte[] ICV = new byte[8];
        System.arraycopy(CEKICV, 0, CEK, 0, 24);
        System.arraycopy(CEKICV, 24, ICV, 0, 8);
        byte[] keyCEK = CMSUtils.getKeyChecksum(CEK);
        if (keyCEK.length != ICV.length) {
            throw new InvalidKeyException("key Checksum Length DOES NOT Match");
        }
        for (int i = 0; i < ICV.length; ++i) {
            if (keyCEK[i] == ICV[i]) continue;
            throw new InvalidKeyException("key Checksum DOES NOT match");
        }
        String algoName = CMSUtils.getAlgoName(CMS.des_ede3_cbc, true);
        SecretKeySpec des3Key = new SecretKeySpec(CEK, algoName);
        if (!CMSUtils.checkKeyParity(des3Key, 1)) {
            throw new InvalidKeyException("key Parity IS NOT Odd");
        }
        return CEK;
    }

    void aesKeyWrap(byte[] keyBytes) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        SecretKeySpec keyToBeWrapped = new SecretKeySpec(keyBytes, 0, keyBytes.length, "AES");
        Cipher c = Cipher.getInstance("AESWrap");
        c.init(3, this.ri.getSymmetricKey());
        this.encryptedKey = c.wrap(keyToBeWrapped);
    }

    byte[] aesKeyUnwrap(SecretKey keyDecryptionKey) throws InvalidKeyException, InvalidInputException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        Cipher c = Cipher.getInstance("AESWrap");
        c.init(4, keyDecryptionKey);
        SecretKey unwrappedKey = (SecretKey)c.unwrap(this.ri.getEncryptedKey(), "AES", 3);
        return unwrappedKey.getEncoded();
    }

    void rc2KeyWrap(byte[] keyBytes) throws InvalidKeyException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        byte[] LCEKPAD;
        byte LENGTH = (byte)keyBytes.length;
        byte[] LCEK = CMSUtils.doORByteArrays(new byte[]{LENGTH}, keyBytes);
        int pad = 8 - LCEK.length % 8;
        if (pad > 0) {
            byte[] PAD = CMSUtils.generateRandomBytes(pad);
            LCEKPAD = CMSUtils.doORByteArrays(LCEK, PAD);
        } else {
            LCEKPAD = LCEK;
        }
        byte[] ICV = CMSUtils.getKeyChecksum(LCEKPAD);
        byte[] LCEKPADICV = CMSUtils.doORByteArrays(LCEKPAD, ICV);
        byte[] IV = CMSUtils.generateRandomBytes(8);
        Cipher cipher = Cipher.getInstance(CMSUtils.getAlgoName(CMS.rc2_cbc));
        IvParameterSpec p = new IvParameterSpec(IV);
        cipher.init(1, (Key)this.ri.getSymmetricKey(), p);
        byte[] TEMP1 = cipher.doFinal(LCEKPADICV);
        byte[] TEMP2 = CMSUtils.doORByteArrays(IV, TEMP1);
        byte[] TEMP3 = CMSUtils.reverseArrayOrder(TEMP2);
        cipher = Cipher.getInstance(CMSUtils.getAlgoName(CMS.rc2_cbc));
        IvParameterSpec p1 = new IvParameterSpec(KEY_WRAP_IV);
        cipher.init(1, (Key)this.ri.getSymmetricKey(), p1);
        this.encryptedKey = cipher.doFinal(TEMP3);
    }

    byte[] rc2KeyUnwrap(SecretKey keyDecryptionKey) throws InvalidKeyException, InvalidInputException, NoSuchAlgorithmException, NoSuchPaddingException, IllegalBlockSizeException, BadPaddingException, InvalidAlgorithmParameterException {
        if (this.ri.getEncryptedKey().length % 8 != 0) {
            throw new InvalidKeyException("Wrapped Key MUST be mulitple of 8 octets in length");
        }
        Cipher cipher = Cipher.getInstance(CMSUtils.getAlgoName(CMS.rc2_cbc));
        IvParameterSpec p = new IvParameterSpec(KEY_WRAP_IV);
        cipher.init(2, (Key)keyDecryptionKey, p);
        byte[] TEMP3 = cipher.doFinal(this.ri.getEncryptedKey());
        byte[] TEMP2 = CMSUtils.reverseArrayOrder(TEMP3);
        byte[] IV = new byte[8];
        byte[] TEMP1 = new byte[TEMP2.length - 8];
        System.arraycopy(TEMP2, 0, IV, 0, 8);
        System.arraycopy(TEMP2, 8, TEMP1, 0, TEMP1.length);
        cipher = Cipher.getInstance(CMSUtils.getAlgoName(CMS.rc2_cbc));
        IvParameterSpec p1 = new IvParameterSpec(IV);
        cipher.init(2, (Key)keyDecryptionKey, p1);
        byte[] LCEKPADICV = cipher.doFinal(TEMP1);
        byte[] LCEKPAD = new byte[LCEKPADICV.length - 8];
        byte[] ICV = new byte[8];
        System.arraycopy(LCEKPADICV, 0, LCEKPAD, 0, LCEKPAD.length);
        System.arraycopy(LCEKPADICV, LCEKPAD.length, ICV, 0, ICV.length);
        byte[] keyChksum = CMSUtils.getKeyChecksum(LCEKPAD);
        if (keyChksum.length != ICV.length) {
            throw new InvalidKeyException("key Checksum Length DOES NOT Match");
        }
        for (int i = 0; i < keyChksum.length; ++i) {
            if (keyChksum[i] == ICV[i]) continue;
            throw new InvalidKeyException("key Checksum DOES NOT match");
        }
        byte length = LCEKPAD[0];
        byte[] CEK = new byte[length];
        System.arraycopy(LCEKPAD, 1, CEK, 0, length);
        if (LCEKPAD.length - length - 1 > 7) {
            throw new InvalidInputException("Padding is too long");
        }
        return CEK;
    }

    public String getContentAuthenticationAlgID() {
        return this.KeyAlgoName;
    }

    public CMSKEKRecipientInfoSpec getRecipientInfoSpec() {
        return this.ri;
    }

    public AlgorithmIdentifier getKeyEncryptionAlgID() {
        return this.keyEncryptionAlgID;
    }

    public byte[] getEncryptedKey() {
        return this.encryptedKey;
    }

    public BigInteger getVersionNumber() {
        return this.version.getValue();
    }

    @Override
    public ASN1Integer getVersion() {
        return this.version;
    }

    public SecretKey getContentEncryptionKey(SecretKey keyDecryptionKey) throws InvalidInputException, InvalidKeyException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMS3DESwrap)) {
            String algoName = CMSUtils.getAlgoName(CMS.des_ede3_cbc, true);
            SecretKeySpec sks = new SecretKeySpec(this.des3KeyUnwrap(keyDecryptionKey), algoName);
            return sks;
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSRC2wrap)) {
            String algoName = CMSUtils.getAlgoName(CMS.rc2_cbc, true);
            SecretKeySpec sks = new SecretKeySpec(this.rc2KeyUnwrap(keyDecryptionKey), algoName);
            return sks;
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES128wrap)) {
            String algoName = CMSUtils.getAlgoName(CMS.aes128_cbc, true);
            SecretKeySpec sks = new SecretKeySpec(this.aesKeyUnwrap(keyDecryptionKey), algoName);
            return sks;
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES192wrap)) {
            String algoName = CMSUtils.getAlgoName(CMS.aes192_cbc, true);
            SecretKeySpec sks = new SecretKeySpec(this.aesKeyUnwrap(keyDecryptionKey), algoName);
            return sks;
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES256wrap)) {
            String algoName = CMSUtils.getAlgoName(CMS.aes256_cbc, true);
            SecretKeySpec sks = new SecretKeySpec(this.aesKeyUnwrap(keyDecryptionKey), algoName);
            return sks;
        }
        throw new InvalidInputException("Unknown Key Wrap Algorithm: " + this.keyEncryptionAlgID);
    }

    public byte[] getContentAuthenticationKey(SecretKey keyDecryptionKey) throws InvalidInputException, InvalidKeyException, NoSuchAlgorithmException, BadPaddingException, IllegalBlockSizeException, NoSuchPaddingException, InvalidAlgorithmParameterException, InvalidKeySpecException {
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMS3DESwrap)) {
            return this.des3KeyUnwrap(keyDecryptionKey);
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSRC2wrap)) {
            return this.rc2KeyUnwrap(keyDecryptionKey);
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES128wrap)) {
            return this.aesKeyUnwrap(keyDecryptionKey);
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES192wrap)) {
            return this.aesKeyUnwrap(keyDecryptionKey);
        }
        if (this.keyEncryptionAlgID.equals((Object)CMS.id_alg_CMSAES256wrap)) {
            return this.aesKeyUnwrap(keyDecryptionKey);
        }
        throw new InvalidInputException("Unknown Key Wrap Algorithm: " + this.keyEncryptionAlgID);
    }

    @Override
    protected void inputRecipientInfo(InputStream is) throws IOException {
        ASN1SequenceInputStream si = new ASN1SequenceInputStream(is);
        this.version = new ASN1Integer((InputStream)si);
        if (!this.version.equals(4)) {
            throw new VersionException(this.version.getValue(), 4);
        }
        ASN1SequenceInputStream si1 = new ASN1SequenceInputStream((InputStream)si);
        byte[] keyIdentifier = new ASN1OctetString((InputStream)si1).getValue();
        Date keyDate = null;
        if (si1.hasMoreData()) {
            keyDate = new ASN1Date((InputStream)si1).getValue();
        }
        ASN1Sequence otherKeyAttrib = null;
        if (si1.hasMoreData()) {
            otherKeyAttrib = new ASN1Sequence((InputStream)si1);
        }
        if (si1.hasMoreData()) {
            throw new IOException("KEKIdentifier Has more then 3 Elements");
        }
        si1.terminate();
        this.keyEncryptionAlgID = new AlgorithmIdentifier((InputStream)si);
        this.encryptedKey = new ASN1OctetString((InputStream)si).getValue();
        this.ri = new CMSKEKRecipientInfoSpec(this.keyEncryptionAlgID, this.encryptedKey);
        if (keyIdentifier != null) {
            this.ri.setKeyIdentifier(keyIdentifier);
        }
        if (keyDate != null) {
            this.ri.setKeyDate(keyDate);
        }
        if (otherKeyAttrib != null) {
            this.ri.setOtherKeyAttribute(otherKeyAttrib);
        }
        si.terminate();
        this.update();
    }

    public void output(OutputStream os) throws IOException {
        this.toASN1Sequence().output(os);
    }

    public int length() {
        return this.toASN1Sequence().length();
    }

    private void update() {
        this.contents = null;
    }

    private ASN1Sequence toASN1Sequence() {
        if (this.contents == null) {
            Date elem1;
            ASN1Sequence seq = new ASN1Sequence();
            seq.addElement((ASN1Object)new ASN1Integer(4L));
            ASN1Sequence kekId = new ASN1Sequence();
            byte[] elem0 = this.ri.getKeyIdentifier();
            if (elem0 != null) {
                kekId.addElement((ASN1Object)new ASN1OctetString(elem0));
            }
            if ((elem1 = this.ri.getKeyDate()) != null) {
                kekId.addElement((ASN1Object)new ASN1Date(elem1, true));
            }
            ASN1Sequence elem2 = this.ri.getOtherKeyAttribute();
            if (elem1 != null) {
                kekId.addElement((ASN1Object)elem2);
            }
            seq.addElement((ASN1Object)kekId);
            seq.addElement((ASN1Object)this.keyEncryptionAlgID);
            seq.addElement((ASN1Object)new ASN1OctetString(this.encryptedKey));
            this.contents = seq;
        }
        return this.contents;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("KEKRecipientInfo\n");
        sb.append("Version: " + this.version.intValue() + "\n");
        sb.append("Wrap AlgID: " + this.keyEncryptionAlgID + "\n");
        return sb.toString();
    }
}

