/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.sdm.graphic;

import ilog.views.IlvApplyObject;
import ilog.views.IlvGraphic;
import ilog.views.IlvLinkImage;
import ilog.views.IlvManager;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.sdm.IlvSDMEngine;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.StringTokenizer;
import oracle.diagram.framework.geom.GeomUtil;
import oracle.diagram.framework.graphic.GraphicConnector;
import oracle.diagram.framework.graphic.GraphicPin;
import oracle.diagram.framework.manager.ManagerUtil;
import oracle.diagram.sdm.graphic.PolyPointsPersisted;

public final class PolyPointsPersistedUtil {
    private static final char SEPARATOR = ',';
    private static final String SEPARATOR_TOKENS = ",";
    private static final String SEGMENT_SEPARATOR_TOKEN = ":";
    private static final StringBuffer BUFFER = new StringBuffer(1024);
    private static final ArrayList<IlvPoint> POINTS = new ArrayList(64);
    private static final IlvPoint[] EMPTY = new IlvPoint[0];

    private PolyPointsPersistedUtil() {
    }

    public static String encodeLinkData(IlvRect rFrom, IlvPoint[] points, IlvRect rTo) {
        IlvPoint src = points[0];
        IlvPoint dst = points[points.length - 1];
        int pointCount = points.length;
        IlvPoint otherPoint = null;
        otherPoint = pointCount > 2 ? points[1] : dst;
        String encodeFrom = PolyPointsPersistedUtil.encodeConnectionPoint(src, otherPoint, rFrom, true);
        otherPoint = pointCount > 2 ? points[pointCount - 2] : src;
        String encodeTo = PolyPointsPersistedUtil.encodeConnectionPoint(otherPoint, dst, rTo, false);
        if (pointCount > 2) {
            IlvPoint[] wayPoints = new IlvPoint[pointCount - 2];
            System.arraycopy(points, 1, wayPoints, 0, wayPoints.length);
            String pointData = PolyPointsPersistedUtil.encodePointData(wayPoints);
            return encodeFrom + SEPARATOR_TOKENS + (String)(pointData.length() != 0 ? pointData + SEPARATOR_TOKENS : "") + encodeTo;
        }
        return encodeFrom + SEPARATOR_TOKENS + encodeTo;
    }

    public static String encodeLinkData(IlvLinkImage link) {
        IlvPoint src = new IlvPoint();
        IlvPoint dst = new IlvPoint();
        link.getConnectionPoints(src, dst, null);
        IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGraphic)link);
        IlvRect rFrom = engine.getRenderer().getLinkConnectionRectangle(engine, link.getFrom(), null);
        IlvRect rTo = engine.getRenderer().getLinkConnectionRectangle(engine, link.getTo(), null);
        IlvGraphic realToGraphic = engine.getGraphic(engine.getModel().getTo(engine.getObject((IlvGraphic)link)), false);
        if (realToGraphic instanceof IlvLinkImage) {
            IlvPoint pinPoint = null;
            GraphicConnector gc = GraphicConnector.findOrCreateConnector(realToGraphic);
            GraphicPin pin = GraphicPin.findPin(link, false);
            if (pin != null) {
                pinPoint = pin.getConnectionPoint();
            } else if (pin == null || pin.getConnector() != gc) {
                for (GraphicPin gcPin : gc.getPins()) {
                    IlvLinkImage gcPinLink = gcPin.getLink();
                    if (gcPinLink.getFrom() != link.getFrom() || engine.getObject((IlvGraphic)gcPinLink) != engine.getObject((IlvGraphic)link)) continue;
                    pin = GraphicPin.findPin(gcPinLink, false);
                    pinPoint = pin.getConnectionPoint();
                    break;
                }
            }
            if (pinPoint != null) {
                dst.setLocation(pinPoint.x, pinPoint.y);
                rTo = null;
            }
        }
        if (link instanceof PolyPointsPersisted) {
            IlvPoint[] wayPoints = ((PolyPointsPersisted)link).getIntermediateLinkPoints();
            IlvPoint[] allPoints = new IlvPoint[wayPoints.length + 2];
            allPoints[0] = src;
            allPoints[allPoints.length - 1] = dst;
            System.arraycopy(wayPoints, 0, allPoints, 1, wayPoints.length);
            return PolyPointsPersistedUtil.encodeLinkData(rFrom, allPoints, rTo);
        }
        return PolyPointsPersistedUtil.encodeLinkData(rFrom, new IlvPoint[]{src, dst}, rTo);
    }

    public static void resolveConnections(IlvSDMEngine engine, Object linkObject, IlvLinkImage link, String data) {
        IlvGraphic toGraphic;
        if (data == null || data.length() == 0) {
            return;
        }
        Object toObject = engine.getModel().getTo(linkObject);
        if (toObject != null && (toGraphic = engine.getGraphic(toObject, true)) != null && toGraphic instanceof IlvLinkImage) {
            int last = data.lastIndexOf(44);
            String encTo = data.substring(last + 1);
            IlvPoint dst = PolyPointsPersistedUtil.decodeConnectionPoint(null, encTo);
            GraphicConnector gc = GraphicConnector.findOrCreateConnector(toGraphic);
            gc.connectLink(link, dst, false, null);
        }
    }

    public static void updatePoints(IlvLinkImage link, String data) {
        if (data == null || data.length() == 0) {
            IlvManager mgr = ManagerUtil.getManager((IlvGraphic)link);
            mgr.applyToObject((IlvGraphic)link, new IlvApplyObject(){

                public void apply(IlvGraphic g, Object o) {
                    ((PolyPointsPersisted)g).setIntermediateLinkPoints(EMPTY);
                }
            }, null, false);
            return;
        }
        int first = data.indexOf(44);
        String encFrom = data.substring(0, first);
        int last = data.lastIndexOf(44);
        String encTo = data.substring(last + 1);
        String pointData = last != first ? data.substring(first + 1, last) : "";
        final IlvPoint[] points = PolyPointsPersistedUtil.decodePointData(pointData);
        IlvSDMEngine engine = IlvSDMEngine.getSDMEngine((IlvGraphic)link);
        IlvRect rFrom = engine.getRenderer().getLinkConnectionRectangle(engine, link.getFrom(), null);
        IlvRect rTo = engine.getRenderer().getLinkConnectionRectangle(engine, link.getTo(), null);
        final IlvPoint src = PolyPointsPersistedUtil.decodeConnectionPoint(rFrom, encFrom);
        final IlvPoint dst = PolyPointsPersistedUtil.decodeConnectionPoint(rTo, encTo);
        IlvManager mgr = ManagerUtil.getManager((IlvGraphic)link);
        mgr.applyToObject((IlvGraphic)link, new IlvApplyObject(){

            public void apply(IlvGraphic g, Object o) {
                IlvLinkImage l = (IlvLinkImage)g;
                ((PolyPointsPersisted)g).setIntermediateLinkPoints(points);
                l.movePoint(0, src.x, src.y, null);
                l.movePoint(l.getPointsCardinal() - 1, dst.x, dst.y, null);
            }
        }, null, false);
    }

    private static String encodePointData(IlvPoint[] points) {
        if (points == null) {
            return "";
        }
        return PolyPointsPersistedUtil.encodePointData(points, 0, points.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodePointData(IlvPoint[] points, int start, int length) {
        if (points == null || points.length == 0) {
            return "";
        }
        StringBuffer stringBuffer = BUFFER;
        synchronized (stringBuffer) {
            BUFFER.setLength(0);
            int isize = start + length;
            for (int i = start; i < isize; ++i) {
                IlvPoint p = points[i];
                if (i > start) {
                    BUFFER.append(',');
                }
                BUFFER.append(Float.toString(p.x));
                BUFFER.append(',');
                BUFFER.append(Float.toString(p.y));
            }
            return BUFFER.toString();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static IlvPoint[] decodePointData(String data) {
        if (data == null || data.length() == 0) {
            return EMPTY;
        }
        ArrayList<IlvPoint> arrayList = POINTS;
        synchronized (arrayList) {
            POINTS.clear();
            StringTokenizer st = new StringTokenizer(data, SEPARATOR_TOKENS);
            int count = 0;
            float x = 0.0f;
            float y = 0.0f;
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (++count % 2 == 1) {
                    x = Float.valueOf(tok).floatValue();
                    continue;
                }
                y = Float.valueOf(tok).floatValue();
                POINTS.add(new IlvPoint(x, y));
            }
            if (count % 2 != 0) {
                POINTS.clear();
                throw new IllegalArgumentException("data must contain an even number of float values to map to IlvPoint");
            }
            IlvPoint[] result = POINTS.toArray(new IlvPoint[POINTS.size()]);
            POINTS.clear();
            return result;
        }
    }

    private static IlvPoint decodeConnectionPoint(IlvRect r, String spec) {
        String id = spec.substring(0, 1);
        String pc = spec.substring(1);
        if ("S".equals(id)) {
            StringTokenizer st = new StringTokenizer(pc, SEGMENT_SEPARATOR_TOKEN);
            float x = Float.valueOf(st.nextToken()).floatValue();
            float y = Float.valueOf(st.nextToken()).floatValue();
            return new IlvPoint(x, y);
        }
        if (r == null) {
            return new IlvPoint(0.0f, 0.0f);
        }
        float percent = Float.parseFloat(pc) / 100.0f;
        if ("L".equals(id)) {
            return new IlvPoint(r.x, r.y + percent * r.height);
        }
        if ("R".equals(id)) {
            return new IlvPoint(r.x + r.width, r.y + percent * r.height);
        }
        if ("T".equals(id)) {
            return new IlvPoint(r.x + percent * r.width, r.y);
        }
        if ("B".equals(id)) {
            return new IlvPoint(r.x + percent * r.width, r.y + r.height);
        }
        throw new IllegalStateException("Invalid spec: " + spec);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String encodeConnectionPoint(IlvPoint p1, IlvPoint p2, IlvRect r, boolean origin) {
        if (r == null) {
            StringBuffer stringBuffer = BUFFER;
            synchronized (stringBuffer) {
                BUFFER.setLength(0);
                BUFFER.append("S");
                BUFFER.append(Float.toString(p2.x));
                BUFFER.append(SEGMENT_SEPARATOR_TOKEN);
                BUFFER.append(Float.toString(p2.y));
                return BUFFER.toString();
            }
        }
        IlvPoint result = new IlvPoint();
        GeomUtil.Intersection side = GeomUtil.getRectangularIntersection((Rectangle2D.Float)r, (Point2D.Float)p1, (Point2D.Float)p2, (Point2D.Float)result);
        if (side == GeomUtil.Intersection.NONE) {
            if (origin) {
                p1 = new IlvPoint((float)r.getCenterX(), (float)r.getCenterY());
            } else {
                p2 = new IlvPoint((float)r.getCenterX(), (float)r.getCenterY());
            }
            side = GeomUtil.getRectangularIntersection((Rectangle2D.Float)r, (Point2D.Float)p1, (Point2D.Float)p2, (Point2D.Float)result);
        }
        switch (side) {
            case LEFT: {
                return "L" + (int)((double)((result.y - r.y) / r.height) * 100.0 + 0.5);
            }
            case RIGHT: {
                return "R" + (int)((double)((result.y - r.y) / r.height) * 100.0 + 0.5);
            }
            case TOP: {
                return "T" + (int)((double)((result.x - r.x) / r.width) * 100.0 + 0.5);
            }
            case BOTTOM: {
                return "B" + (int)((double)((result.x - r.x) / r.width) * 100.0 + 0.5);
            }
        }
        throw new IllegalArgumentException("unable to determine side");
    }
}

