/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.inspector;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.Timer;
import oracle.bali.inspector.multi.MultiObjectModel;
import oracle.bali.inspector.multi.SelectionModel;
import oracle.ide.Context;
import oracle.ide.controller.Command;
import oracle.ide.inspector.IdeMultiObjectModel;
import oracle.ide.inspector.InspectorContext;
import oracle.ide.inspector.PropertySetCommand;
import oracle.ide.model.Element;
import oracle.ide.model.Observer;
import oracle.ide.model.Subject;
import oracle.ide.model.UpdateMessage;

public abstract class AbstractDiagramContextPropertyModel
extends IdeMultiObjectModel {
    protected final boolean _observeIdeSelection;
    protected Subject[] m_subjects;

    protected AbstractDiagramContextPropertyModel() {
        this(false);
    }

    protected AbstractDiagramContextPropertyModel(boolean observeIdeSelection) {
        this._observeIdeSelection = observeIdeSelection;
    }

    public void setContext(Context context) {
        Element[] otherSelection = (Element[])context.getProperty("oracle.diagram.inspector.InspectorSelectionProperty");
        Element[] ideSelection = context.getSelection();
        Integer[] offsets = InspectorContext.getInspectableOffsets((Context)context);
        int otherSelSize = otherSelection != null ? otherSelection.length : 0;
        int selectionSize = this._observeIdeSelection ? ideSelection.length + otherSelSize : otherSelSize;
        LinkedHashSet<Element> selection = new LinkedHashSet<Element>((int)((float)selectionSize / 0.75f));
        HashSet<Element> inspectable = new HashSet<Element>((int)((float)selectionSize / 0.75f));
        if (this._observeIdeSelection) {
            for (Element element : ideSelection) {
                selection.add(element);
            }
            for (Integer n : offsets) {
                inspectable.add(ideSelection[n]);
            }
        }
        if (otherSelection != null) {
            for (Element element : otherSelection) {
                selection.add(element);
                inspectable.add(element);
            }
        }
        Element[] elementArray = selection.toArray(new Element[selection.size()]);
        ArrayList<Integer> insp = new ArrayList<Integer>(selectionSize);
        for (int i = 0; i < elementArray.length; ++i) {
            if (!inspectable.contains(elementArray[i])) continue;
            insp.add(i);
        }
        Context tmpContext = new Context(context);
        tmpContext.setSelection(elementArray);
        InspectorContext.setInspectableOffsets((Context)tmpContext, (Integer[])insp.toArray(new Integer[insp.size()]));
        super.setContext(tmpContext);
        this.m_subjects = new Subject[]{this.createEventCoalesce(Arrays.asList(super.getSubjects()))};
    }

    public Subject[] getSubjects() {
        return this.m_subjects;
    }

    protected final Command createCommand(Object data, int row, int col) {
        Object item;
        Object id = this.getValueAt(row, this.getColumnIndex(COLUMN_ID));
        SelectionModel model = this.getSelectionModel();
        if (model.getSelectedItemCount() == 1 && (item = model.getSelectedItem(0)) instanceof MultiObjectModel) {
            model = ((MultiObjectModel)item).getSelectionModel();
        }
        return this.createCommandImpl(model, id, data, row, col);
    }

    protected Command createCommandImpl(SelectionModel model, Object id, Object data, int row, int col) {
        return id != null ? new PropertySetCommand(model, id, col, data) : null;
    }

    protected EventCoalesce createEventCoalesce(List subjects) {
        return new EventCoalesce(subjects);
    }

    protected static class EventCoalesce
    implements ActionListener,
    Subject,
    Observer {
        private final Timer m_timer;
        private final List m_observers = new ArrayList();
        private final List m_observed;

        public EventCoalesce(List selection) {
            this.m_timer = new Timer(250, this);
            this.m_timer.setRepeats(false);
            this.m_timer.setCoalesce(true);
            this.m_observed = new ArrayList(selection.size());
            for (Element el : selection) {
                if (!(el instanceof Subject)) continue;
                this.m_observed.add(el);
            }
        }

        public void attach(Observer observer) {
            if (!this.m_observers.contains(observer)) {
                if (this.m_observers.isEmpty()) {
                    for (int i = 0; i < this.m_observed.size(); ++i) {
                        ((Subject)this.m_observed.get(i)).attach((Observer)this);
                    }
                }
                this.m_observers.add(observer);
            }
        }

        public void detach(Observer observer) {
            this.m_observers.remove(observer);
            if (this.m_observers.isEmpty()) {
                this.m_timer.stop();
                for (int i = 0; i < this.m_observed.size(); ++i) {
                    ((Subject)this.m_observed.get(i)).detach((Observer)this);
                }
            }
        }

        public void notifyObservers(Object subject, UpdateMessage change) {
            if (this.m_observers.isEmpty()) {
                return;
            }
            Observer[] obs = this.m_observers.toArray(new Observer[this.m_observers.size()]);
            for (int i = 0; i < obs.length; ++i) {
                try {
                    obs[i].update(subject, change);
                    continue;
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }

        public void update(Object observed, UpdateMessage change) {
            this.restartTimer();
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            UpdateMessage.firePropertiesChanged((Subject)this, (PropertyChangeEvent[])new PropertyChangeEvent[0], (Object)this);
        }

        protected void restartTimer() {
            this.m_timer.restart();
        }

        protected List getObservers() {
            return this.m_observers;
        }

        protected List getObserved() {
            return this.m_observed;
        }
    }
}

