/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvManagerView;
import java.awt.Component;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.KeyboardNavigationPlugin;

public class NavigationKeyListener
extends KeyAdapter {
    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (!keyEvent.isConsumed()) {
            IlvManagerView view;
            Component c;
            for (c = keyEvent.getComponent(); !(c instanceof IlvManagerView) && c != null; c = c.getParent()) {
            }
            IlvManagerView ilvManagerView = view = c instanceof IlvManagerView ? (IlvManagerView)c : null;
            if (view == null) {
                return;
            }
            boolean modified = keyEvent.getModifiersEx() != 0;
            switch (keyEvent.getKeyCode()) {
                case 37: {
                    if (modified) break;
                    keyEvent.consume();
                    this.navigate(view, KeyboardNavigationPlugin.Direction.LEFT);
                    break;
                }
                case 39: {
                    if (modified) break;
                    keyEvent.consume();
                    this.navigate(view, KeyboardNavigationPlugin.Direction.RIGHT);
                    break;
                }
                case 38: {
                    if (modified) break;
                    keyEvent.consume();
                    this.navigate(view, KeyboardNavigationPlugin.Direction.UP);
                    break;
                }
                case 40: {
                    if (modified) break;
                    keyEvent.consume();
                    this.navigate(view, KeyboardNavigationPlugin.Direction.DOWN);
                    break;
                }
                case 33: {
                    if (modified) break;
                    keyEvent.consume();
                    this.navigate(view, KeyboardNavigationPlugin.Direction.PARENT);
                    break;
                }
                case 34: {
                    if (modified) break;
                    keyEvent.consume();
                    this.navigate(view, KeyboardNavigationPlugin.Direction.CHILD);
                }
            }
        }
    }

    protected void navigate(IlvManagerView view, KeyboardNavigationPlugin.Direction direction) {
        KeyboardNavigationPlugin knp = PluginUtil.getPlugin(view, KeyboardNavigationPlugin.class);
        if (knp != null) {
            knp.navigate(direction);
        }
    }
}

