/*
 * Decompiled with CFR 0.152.
 */
package oracle.diagram.framework.accessibility;

import ilog.views.IlvGraphic;
import ilog.views.IlvGraphicEnumeration;
import ilog.views.IlvManager;
import ilog.views.IlvManagerView;
import ilog.views.IlvPoint;
import ilog.views.IlvRect;
import ilog.views.IlvTransformer;
import ilog.views.event.ManagerContentChangedEvent;
import ilog.views.event.ManagerContentChangedListener;
import ilog.views.event.ManagerSelectionChangedEvent;
import ilog.views.event.ManagerSelectionListener;
import ilog.views.event.ObjectInsertedEvent;
import ilog.views.event.ObjectRemovedEvent;
import ilog.views.event.ObjectVisibilityChangedEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.IllegalComponentStateException;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import java.util.Timer;
import java.util.TimerTask;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.accessibility.AccessibleExtendedComponent;
import javax.accessibility.AccessibleKeyBinding;
import javax.accessibility.AccessibleRole;
import javax.accessibility.AccessibleSelection;
import javax.accessibility.AccessibleState;
import javax.accessibility.AccessibleStateSet;
import javax.swing.InputVerifier;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import oracle.diagram.core.editor.ScrollManagerViewPlugin;
import oracle.diagram.core.interaction.SelectionChangeNotificationPlugin;
import oracle.diagram.core.plugin.Plugin;
import oracle.diagram.core.plugin.PluginUtil;
import oracle.diagram.framework.accessibility.AccessibleGraphic;
import oracle.diagram.framework.accessibility.AccessibleGraphicPlugin;
import oracle.diagram.framework.accessibility.HCGraphics2D;
import oracle.diagram.framework.view.ViewUtil;

public class AccessibleManagerView
extends IlvManagerView
implements Accessible {
    private final IlvPoint _tmpPt = new IlvPoint();
    private AccessibleViewContext _ac;
    private boolean _isRequestFocusEnabled = true;
    private boolean _ignoreTransformerChangedEvent;
    private boolean inInputVerifier;

    public AccessibleManagerView(IlvManager manager) {
        super(manager);
        this.setMinZoomXFactor(ViewUtil.MIMINUM_SCALE);
        this.setMinZoomYFactor(ViewUtil.MIMINUM_SCALE);
        this.setKeepingAspectRatio(true);
        this.setBackground(Color.WHITE);
        this.setAntialiasing(true);
    }

    @Override
    public AccessibleContext getAccessibleContext() {
        if (this._ac == null) {
            this._ac = new AccessibleViewContext();
        }
        return this._ac;
    }

    public final Accessible getAccessibleGraphic(IlvGraphic g) {
        Accessible a = this.getAccessibleGraphicImpl(g);
        return a;
    }

    protected Accessible getAccessibleGraphicImpl(IlvGraphic g) {
        AccessibleGraphicPlugin agp = this.getPlugin(g, AccessibleGraphicPlugin.class);
        if (agp != null) {
            return agp.getAccessible(g, this);
        }
        return null;
    }

    public <T extends Plugin> T getPlugin(IlvGraphic g, Class<T> key) {
        return PluginUtil.getPlugin(this, g, key);
    }

    protected void managerChanged(IlvManager oldMgr, IlvManager newMgr) {
        if (this._ac != null) {
            this._ac.managerChanged(oldMgr, newMgr);
        }
        super.managerChanged(oldMgr, newMgr);
    }

    public void ensureVisible(IlvRect r) {
        IlvRect test = new IlvRect(r);
        ScrollManagerViewPlugin plugin = PluginUtil.getPlugin(this, ScrollManagerViewPlugin.class);
        if (plugin != null) {
            test.intersection(plugin.getScrollableRect(this));
        }
        super.ensureVisible(test);
    }

    public void ensureVisible(IlvPoint point) {
        ScrollManagerViewPlugin plugin = PluginUtil.getPlugin(this, ScrollManagerViewPlugin.class);
        if (plugin != null && !plugin.getScrollableRect(this).contains((Point2D)point)) {
            return;
        }
        super.ensureVisible(point);
    }

    protected void transformerChanged(IlvTransformer newTransformer, IlvTransformer oldTransformer) {
        IlvTransformer test;
        if (this._ignoreTransformerChangedEvent) {
            this._ignoreTransformerChangedEvent = false;
            return;
        }
        ScrollManagerViewPlugin plugin = PluginUtil.getPlugin(this, ScrollManagerViewPlugin.class);
        if (plugin != null && plugin.constrainViewTransformer(this, test = new IlvTransformer(newTransformer))) {
            this._ignoreTransformerChangedEvent = true;
            this.setTransformer(oldTransformer);
            this.setTransformer(test);
            return;
        }
        super.transformerChanged(newTransformer, oldTransformer);
    }

    public void setRequestFocusEnabled(boolean requestFocusEnabled) {
        this._isRequestFocusEnabled = requestFocusEnabled;
    }

    public boolean isRequestFocusEnabled() {
        return this._isRequestFocusEnabled;
    }

    public void requestFocus() {
        if (this.isRequestFocusEnabled() && this.runInputVerifier()) {
            super.requestFocus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean runInputVerifier() {
        Window window;
        if (this.inInputVerifier) {
            return true;
        }
        Component focOwner = KeyboardFocusManager.getCurrentKeyboardFocusManager().getFocusOwner();
        if (focOwner == null && (window = SwingUtilities.getWindowAncestor((Component)((Object)this))) != null) {
            try {
                Method accessibleMethod = AccessController.doPrivileged(new PrivilegedExceptionAction<Method>(){

                    @Override
                    public Method run() throws Exception {
                        Method method = KeyboardFocusManager.class.getDeclaredMethod("getMostRecentFocusOwner", Window.class);
                        method.setAccessible(true);
                        return method;
                    }
                });
                focOwner = (Component)accessibleMethod.invoke(null, window);
            }
            catch (Exception e) {
                focOwner = null;
            }
        }
        if (focOwner == this) {
            return true;
        }
        if (focOwner == null || !(focOwner instanceof JComponent)) {
            return true;
        }
        JComponent jFocOwner = (JComponent)focOwner;
        InputVerifier inputVerifier = jFocOwner.getInputVerifier();
        if (inputVerifier == null) {
            return true;
        }
        this.inInputVerifier = true;
        try {
            boolean bl = inputVerifier.shouldYieldFocus(jFocOwner);
            return bl;
        }
        finally {
            this.inInputVerifier = false;
        }
    }

    public void repaint(long tm, int x, int y, int width, int height) {
        super.repaint(tm, x, y, width, height);
    }

    public void repaint(IlvRect r) {
        super.repaint(r);
    }

    public void paint(Graphics g) {
        super.paint(HCGraphics2D.get(g));
    }

    protected class AccessibleViewContext
    extends Container.AccessibleAWTContainer
    implements AccessibleSelection,
    AccessibleExtendedComponent {
        private final SelectionListener _selListener;
        private final ManagerContentChangedListener _mgrListener;
        private final PluginController m_pluginController;
        private Accessible _selected;
        private int _selectionCount;
        protected FocusListener _accessibleFocusHandler;
        protected ContainerListener _accessibleContainerHandler;
        private final int VIEW_SELECTION_WAIT = 250;
        private final int ACC_SELECTION_WAIT = 100;

        public AccessibleViewContext() {
            super((Container)((Object)AccessibleManagerView.this));
            this._selListener = new SelectionListener();
            this._mgrListener = new ManagerChangeListener();
            this.m_pluginController = new PluginController();
            this._selected = null;
            this._selectionCount = -1;
            this._accessibleFocusHandler = null;
            this._accessibleContainerHandler = null;
            this.VIEW_SELECTION_WAIT = 250;
            this.ACC_SELECTION_WAIT = 100;
            this.managerChanged(null, AccessibleManagerView.this.getManager());
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
            if (this._accessibleFocusHandler == null) {
                this._accessibleFocusHandler = new AccessibleFocusHandler();
                AccessibleManagerView.this.addFocusListener(this._accessibleFocusHandler);
            }
            if (this._accessibleContainerHandler == null) {
                this._accessibleContainerHandler = new AccessibleContainerHandler();
                AccessibleManagerView.this.addContainerListener(this._accessibleContainerHandler);
            }
            super.addPropertyChangeListener(listener);
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
            if (this._accessibleFocusHandler != null) {
                AccessibleManagerView.this.removeFocusListener(this._accessibleFocusHandler);
                this._accessibleFocusHandler = null;
            }
            if (this._accessibleContainerHandler != null) {
                AccessibleManagerView.this.removeContainerListener(this._accessibleContainerHandler);
                this._accessibleContainerHandler = null;
            }
            super.removePropertyChangeListener(listener);
        }

        protected void managerChanged(IlvManager oldMgr, IlvManager newMgr) {
            if (oldMgr != null) {
                oldMgr.removeManagerTreeSelectionListener((ManagerSelectionListener)this._selListener);
                oldMgr.removeManagerTreeContentChangedListener(this._mgrListener);
            }
            if (newMgr != null) {
                newMgr.addManagerTreeSelectionListener((ManagerSelectionListener)this._selListener);
                newMgr.addManagerTreeContentChangedListener(this._mgrListener);
            }
        }

        @Override
        public AccessibleRole getAccessibleRole() {
            return AccessibleRole.LIST;
        }

        private AccessibleContext getManagerContext() {
            Accessible a = AccessibleManagerView.this.getAccessibleGraphic((IlvGraphic)AccessibleManagerView.this.getManager());
            return a == null ? null : a.getAccessibleContext();
        }

        @Override
        public Accessible getAccessibleAt(Point p) {
            AccessibleManagerView.this._tmpPt.setLocation(p.getX(), p.getY());
            IlvGraphic g = AccessibleManagerView.this.getManager().getObject(AccessibleManagerView.this._tmpPt, (IlvManagerView)AccessibleManagerView.this, false);
            if (g != null) {
                return AccessibleManagerView.this.getAccessibleGraphic(g);
            }
            return AccessibleManagerView.this;
        }

        @Override
        public int getAccessibleIndexInParent() {
            return 0;
        }

        @Override
        public int getAccessibleChildrenCount() {
            AccessibleContext ac = this.getManagerContext();
            int count = ac == null ? 0 : ac.getAccessibleChildrenCount();
            return count;
        }

        @Override
        public Accessible getAccessibleChild(int i) {
            AccessibleContext ac = this.getManagerContext();
            Accessible a = ac == null ? null : ac.getAccessibleChild(i);
            return a;
        }

        @Override
        public Locale getLocale() throws IllegalComponentStateException {
            return AccessibleManagerView.this.getLocale();
        }

        @Override
        public AccessibleSelection getAccessibleSelection() {
            return this;
        }

        @Override
        public AccessibleStateSet getAccessibleStateSet() {
            AccessibleStateSet states = super.getAccessibleStateSet();
            if (AccessibleManagerView.this.isOpaque()) {
                states.add(AccessibleState.OPAQUE);
            }
            return states;
        }

        @Override
        public int getAccessibleSelectionCount() {
            int count;
            this._selectionCount = count = AccessibleManagerView.this.getManager().getSelectedObjectsCount(true);
            this.m_pluginController.selectionAccessed();
            return count;
        }

        @Override
        public Accessible getAccessibleSelection(int i) {
            IlvGraphic g = this.getSelected(i);
            Accessible a = AccessibleManagerView.this.getAccessibleGraphic(g);
            this.m_pluginController.selectionAccessed();
            return a;
        }

        @Override
        public void addAccessibleSelection(int i) {
            IlvGraphic g;
            Accessible a = this.getManagerContext().getAccessibleChild(i);
            IlvGraphic ilvGraphic = g = a instanceof AccessibleGraphic ? ((AccessibleGraphic)a).getGraphic() : null;
            if (g != null) {
                AccessibleManagerView.this.getManager().setSelected(g, true, true);
            }
        }

        @Override
        public void clearAccessibleSelection() {
            AccessibleManagerView.this.getManager().deSelectAll(true, true);
        }

        @Override
        public boolean isAccessibleChildSelected(int i) {
            Accessible a = this.getManagerContext().getAccessibleChild(i);
            AccessibleStateSet ss = a.getAccessibleContext().getAccessibleStateSet();
            return ss.contains(AccessibleState.SELECTED);
        }

        @Override
        public void removeAccessibleSelection(int i) {
            IlvGraphic g;
            Accessible a = this.getManagerContext().getAccessibleChild(i);
            IlvGraphic ilvGraphic = g = a instanceof AccessibleGraphic ? ((AccessibleGraphic)a).getGraphic() : null;
            if (g != null) {
                ((IlvManager)g.getGraphicBag()).setSelected(g, false, true);
            }
        }

        @Override
        public void selectAllAccessibleSelection() {
            AccessibleManagerView.this.getManager().selectAll(false, true);
        }

        protected IlvGraphic getSelected(int i) {
            IlvGraphicEnumeration e = AccessibleManagerView.this.getManager().getSelectedObjects(true);
            while (e.hasMoreElements()) {
                IlvGraphic g = e.nextElement();
                if (i == 0) {
                    return g;
                }
                --i;
            }
            return null;
        }

        AccessibleExtendedComponent getAccessibleExtendedComponent() {
            return this;
        }

        @Override
        public String getToolTipText() {
            return null;
        }

        @Override
        public String getTitledBorderText() {
            return null;
        }

        @Override
        public AccessibleKeyBinding getAccessibleKeyBinding() {
            return null;
        }

        protected class SelectionListener
        implements ManagerSelectionListener,
        ActionListener {
            private final javax.swing.Timer m_selectionTimer = new javax.swing.Timer(100, this);

            public SelectionListener() {
                this.m_selectionTimer.setRepeats(false);
                this.m_selectionTimer.setCoalesce(true);
            }

            public void selectionChanged(ManagerSelectionChangedEvent event) {
                AccessibleViewContext.this.m_pluginController.disablePlugin();
                AccessibleViewContext.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                if (!event.isAdjusting() || event.isAdjustmentEnd()) {
                    this.m_selectionTimer.restart();
                }
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                Accessible newSel;
                AccessibleViewContext.this._selectionCount = -1;
                Accessible oldSel = AccessibleViewContext.this._selected;
                IlvGraphic g = AccessibleViewContext.this.getSelected(0);
                AccessibleViewContext.this._selected = newSel = g == null ? null : AccessibleManagerView.this.getAccessibleGraphic(g);
                AccessibleViewContext.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
                AccessibleViewContext.this.firePropertyChange("AccessibleActiveDescendant", oldSel, newSel);
                AccessibleViewContext.this.firePropertyChange("AccessibleVisibleData", false, true);
                AccessibleViewContext.this.firePropertyChange("AccessibleSelection", false, true);
                AccessibleViewContext.this.m_pluginController.selectionUpdated();
            }
        }

        protected class ManagerChangeListener
        implements ManagerContentChangedListener {
            private boolean _dirty = false;

            protected ManagerChangeListener() {
            }

            public void contentsChanged(ManagerContentChangedEvent event) {
                if (!this._dirty) {
                    if (event.getType() == 1 && !Boolean.TRUE.equals(((ObjectInsertedEvent)event).getGraphicObject().getProperty("Interaction.temporaryGraphic"))) {
                        this._dirty = true;
                    } else if (event.getType() == 2 && !Boolean.TRUE.equals(((ObjectRemovedEvent)event).getGraphicObject().getProperty("Interaction.temporaryGraphic"))) {
                        this._dirty = true;
                    } else if (event.getType() == 8 && !Boolean.TRUE.equals(((ObjectVisibilityChangedEvent)event).getGraphicObject().getProperty("Interaction.temporaryGraphic"))) {
                        this._dirty = true;
                    }
                }
                if ((!event.isAdjusting() || event.getType() == 32) && this._dirty) {
                    AccessibleViewContext.this.firePropertyChange("accessibleInvalidateChildren", null, AccessibleManagerView.this);
                    this._dirty = false;
                }
            }
        }

        private class PluginController
        implements Runnable {
            private boolean m_isDisabled = false;
            private boolean m_isSelectionUpdated = false;
            private final Timer m_waitTimer = new Timer();
            private TimerTask m_task;

            private synchronized boolean isDisabled() {
                return this.m_isDisabled;
            }

            private synchronized void setDisabled(boolean isDisabled) {
                this.m_isDisabled = isDisabled;
            }

            private synchronized void cancelTimer(boolean restart) {
                if (this.m_task != null) {
                    this.m_task.cancel();
                    this.m_task = null;
                }
                if (restart) {
                    this.m_task = new TimerTask(){

                        @Override
                        public void run() {
                            PluginController.this.m_task = null;
                            SwingUtilities.invokeLater(PluginController.this);
                        }
                    };
                    this.m_waitTimer.schedule(this.m_task, 250L);
                }
            }

            public void disablePlugin() {
                if (!this.isDisabled()) {
                    SelectionChangeNotificationPlugin scnp = PluginUtil.getPlugin(AccessibleManagerView.this, SelectionChangeNotificationPlugin.class);
                    scnp.setEnabled(false);
                    this.setDisabled(true);
                }
                this.m_isSelectionUpdated = false;
                this.cancelTimer(false);
            }

            public void selectionAccessed() {
                if (this.isDisabled()) {
                    this.cancelTimer(true);
                }
            }

            public void selectionUpdated() {
                this.m_isSelectionUpdated = true;
                this.selectionAccessed();
            }

            @Override
            public void run() {
                if (this.isDisabled() && this.m_isSelectionUpdated) {
                    SelectionChangeNotificationPlugin scnp = PluginUtil.getPlugin(AccessibleManagerView.this, SelectionChangeNotificationPlugin.class);
                    scnp.setEnabled(true);
                    this.setDisabled(false);
                    this.m_isSelectionUpdated = false;
                }
            }
        }

        protected class AccessibleFocusHandler
        implements FocusListener {
            protected AccessibleFocusHandler() {
            }

            @Override
            public void focusGained(FocusEvent event) {
                AccessibleViewContext.this.firePropertyChange("AccessibleState", null, AccessibleState.FOCUSED);
            }

            @Override
            public void focusLost(FocusEvent event) {
                AccessibleViewContext.this.firePropertyChange("AccessibleState", AccessibleState.FOCUSED, null);
            }
        }

        protected class AccessibleContainerHandler
        implements ContainerListener {
            protected AccessibleContainerHandler() {
            }

            @Override
            public void componentAdded(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleViewContext.this.firePropertyChange("AccessibleChild", null, ((Accessible)((Object)c)).getAccessibleContext());
                }
            }

            @Override
            public void componentRemoved(ContainerEvent e) {
                Component c = e.getChild();
                if (c != null && c instanceof Accessible) {
                    AccessibleViewContext.this.firePropertyChange("AccessibleChild", ((Accessible)((Object)c)).getAccessibleContext(), null);
                }
            }
        }
    }
}

