/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.runner;

import java.awt.Component;
import java.awt.Container;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import oracle.ide.model.Project;
import oracle.ide.model.TechnologyScopeConfiguration;
import oracle.ide.panels.MDDAdapter;
import oracle.ide.panels.MDDEvent;
import oracle.ide.panels.MDDListener;
import oracle.ide.panels.MDDPanel;
import oracle.ide.panels.Navigable;
import oracle.ide.panels.TDialogLauncher;
import oracle.ide.panels.Traversable;
import oracle.ide.runner.Runner;
import oracle.ide.util.Namespace;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.SwingUtils;
import oracle.jdeveloper.runner.RunConfiguration;
import oracle.jdevimpl.runner.RunConfigurationLaunchPanel;
import oracle.jdevimpl.runner.RunConfigurationToolPanel;
import oracle.jdevimpl.runner.RunMgrArb;
import oracle.jdevimpl.runner.res.ExtensionResources;

public class RunConfigurationEditor {
    private final RunConfiguration runConfigurationOriginal;
    private final Project project;
    private final boolean allowEdit;
    private static final String[] mobileTechscopes = new String[]{"ADFMobile", "MAF"};
    private static final List<String> techscopesToSuppressLaunchNavigables = new ArrayList<String>(Arrays.asList(mobileTechscopes));
    private static final List<String> techscopesToSuppressToolNavigables = new ArrayList<String>();
    private static final String RUN_CONFIGURATION_KEY = "run-configuration";

    public RunConfigurationEditor(RunConfiguration runConfigurationOriginal, Project project, boolean allowEdit) {
        this.runConfigurationOriginal = runConfigurationOriginal;
        this.project = project;
        this.allowEdit = allowEdit;
    }

    public boolean showDialog() {
        int index = this.allowEdit ? 17 : 18;
        String title = RunMgrArb.format(index, this.runConfigurationOriginal.getName());
        MDDPanel mddPanel = new MDDPanel(RunConfigurationEditor.getNavigables(this.project));
        mddPanel.addMDDListener((MDDListener)new MDDAdapter(){

            public void traversableEntered(MDDEvent e) {
                Traversable traversable;
                if (!RunConfigurationEditor.this.allowEdit && (traversable = e.getTraversable()) instanceof Container) {
                    RunConfigurationEditor.setPanelEnabled((Container)traversable, false);
                }
            }
        });
        Namespace namespace = new Namespace();
        RunConfiguration runConfigurationCopy = new RunConfiguration();
        this.runConfigurationOriginal.copyTo((Object)runConfigurationCopy);
        RunConfigurationEditor.setRunConfiguration(namespace, runConfigurationCopy);
        TDialogLauncher launcher = new TDialogLauncher((Component)SwingUtils.getMainWindow(), title, (Traversable)mddPanel, namespace);
        mddPanel.expandTree1ToDepth(3);
        launcher.setInitialSize(700, 500);
        if (launcher.showDialog() && this.allowEdit) {
            runConfigurationCopy.copyTo((Object)this.runConfigurationOriginal);
            return true;
        }
        return false;
    }

    private static void setPanelEnabled(Container container, boolean enable) {
        Component[] children = container.getComponents();
        for (int i = 0; i < children.length; ++i) {
            if (!(children[i] instanceof Container) || !children[i].isVisible()) continue;
            try {
                RunConfigurationEditor.setPanelEnabled((Container)children[i], enable);
            }
            catch (Exception exception) {
                // empty catch block
            }
            children[i].setEnabled(enable);
        }
    }

    private static Navigable[] getNavigables(Project project) {
        Navigable[] navigableArray;
        Runner runner = Runner.getRunner();
        Navigable launchNavigable = new Navigable(RunMgrArb.getString(19), RunConfigurationLaunchPanel.class);
        Navigable[] launchChildNavigables = runner.getRunConfigurationLaunchNavigables(project);
        int launchChildNavigablesLength = launchChildNavigables.length;
        for (int i = 0; i < launchChildNavigablesLength; ++i) {
            if (launchChildNavigables[i].getShortLabel().equals(ExtensionResources.get("RUN_CONFIGURATION_MODULE_OPTIONS")) && !RunConfiguration.isJDK9OrLaterProject(project)) continue;
            launchNavigable.addChildNavigable(launchChildNavigables[i]);
        }
        Navigable toolNavigable = new Navigable(RunMgrArb.getString(36), RunConfigurationToolPanel.class);
        Navigable[] toolChildNavigables = runner.getRunConfigurationToolNavigables(project);
        int toolChildNavigablesLength = toolChildNavigables.length;
        for (int i = 0; i < toolChildNavigablesLength; ++i) {
            toolNavigable.addChildNavigable(toolChildNavigables[i]);
        }
        ArrayList<Navigable> topLevelNavigables = new ArrayList<Navigable>();
        TechnologyScopeConfiguration tsConfig = TechnologyScopeConfiguration.getInstance((PropertyStorage)project);
        List<String> tsKeys = Arrays.asList(tsConfig.getTechnologyScope().getTechnologyKeys());
        boolean showLaunch = true;
        for (String string : tsKeys) {
            if (!techscopesToSuppressLaunchNavigables.contains(string)) continue;
            showLaunch = false;
        }
        if (showLaunch) {
            topLevelNavigables.add(launchNavigable);
        }
        boolean showTools = true;
        for (String tsKey : tsKeys) {
            if (!techscopesToSuppressToolNavigables.contains(tsKey)) continue;
            showTools = false;
        }
        if (showTools) {
            topLevelNavigables.add(toolNavigable);
        }
        for (Navigable custom : navigableArray = runner.getRunConfigurationCustomNavigables(project)) {
            topLevelNavigables.add(custom);
        }
        return topLevelNavigables.toArray(new Navigable[topLevelNavigables.size()]);
    }

    public static RunConfiguration getRunConfiguration(Namespace namespace) {
        return (RunConfiguration)((Object)namespace.find(RUN_CONFIGURATION_KEY));
    }

    private static void setRunConfiguration(Namespace namespace, RunConfiguration runConfiguration) {
        namespace.put(RUN_CONFIGURATION_KEY, (Object)runConfiguration);
    }
}

