/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdeveloper.runner;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import oracle.ide.Context;
import oracle.ide.Ide;
import oracle.ide.model.Project;
import oracle.ide.model.SharedPropertiesAdapter;
import oracle.ide.model.SharedPropertiesManager;
import oracle.ide.model.Workspace;
import oracle.ide.net.URLFactory;
import oracle.ide.net.URLPath;
import oracle.ide.util.VersionNumber;
import oracle.ideimpl.macros.MacroUtils;
import oracle.javatools.data.HashStructure;
import oracle.javatools.data.ListStructure;
import oracle.javatools.data.PropertyStorage;
import oracle.javatools.util.Log;
import oracle.jdeveloper.library.JDK;
import oracle.jdeveloper.model.JProjectLibraries;
import oracle.jdeveloper.model.PathsConfiguration;
import oracle.jdeveloper.runner.RunConfigurations;
import oracle.jdeveloper.runner.RunMgrArb;
import oracle.jdevimpl.runner.EnvironmentVariable;
import oracle.jdevimpl.runner.RunConfigurationModuleOptionsPanel;
import oracle.jdevimpl.runner.debug.DebugConfigurationAccessor;

public class RunConfiguration
extends SharedPropertiesAdapter
implements PropertyStorage {
    public static final String RUN_CONFIGURATION_NAME = "name";
    public static final String REMOTE_DEBUGGING_PROFILING = "remoteDebuggingProfiling";
    private Context context;
    private static final SharedPropertiesManager sharedPropertiesManager = SharedPropertiesManager.get();
    public static final String NAME = "name";
    public static final String CUSTOM = "custom";
    public static final String RUN_DIRECTORY_URL = "runDirectoryURL";
    public static final String VM_NAME = "VMName";
    public static final String JAVA_OPTIONS = "javaOptions";
    public static final String TARGET_URL = "targetURL";
    public static final String RUN_ACTIVE_FILE = "runActiveFile";
    public static final String PROGRAM_ARGUMENTS = "programArguments";
    public static final String CONNECTION_NAME = "connectionName";
    public static final String COMPILE_BEFORE_RUN = "compileBeforeRun";
    public static final String COMPILE_PROJECT_ONLY_BEFORE_RUN = "compileProjectOnlyBeforeRun";
    public static final String RUN_ANT_BEFORE_RUN = "runAntBeforeRun";
    public static final String RUN_ANT_BEFORE_COMPILE = "runAntBeforeCompile";
    public static final String CLEAR_LOG_BEFORE_RUN = "clearLogBeforeRun";
    public static final String SAVE_ALL_BEFORE_RUN = "saveAllBeforeRun";
    public static final String LOG_COMMAND = "logCommand";
    public static final String LOG_OUTPUT = "logOutput";
    public static final String LOG_ERROR = "logError";
    public static final String ALLOW_INPUT = "allowInput";
    public static final String LOG_EXIT = "logExit";
    public static final String USE_PROXY = "useProxy";
    public static final String ENV_VARIABLES = "EnvironmentVariables";
    private static final String USE_MODULE_PATH = "useModulePath";
    private static final String USE_PATHSCONFIG_MODULE_PATH = "usePathsConfigModulePath";
    private static final String USE_USER_SUPPLIED_MODULE_PATH = "useUserSuppliedModulePath";
    private static final String USER_SUPPLIED_MODULE_PATH = "userSuppliedModulePath";
    private static final String HAS_ADD_MODULES_OPTION = "hasAddModulesOption";
    private static final String USE_PATHSCONFIG_ADD_MODULES = "usePathsConfigAddModules";
    private static final String USE_USER_SUPPLIED_ADD_MODULES = "useUserSuppliedAddModules";
    private static final String USER_SUPPLIED_ADD_MODULES = "userSuppliedAddModules";
    private static final String MODULE_OPTION = "moduleOption";
    private static final String MODULE_OPTION_DATA = "moduleOptionData";
    private static final String ADD_READS_OPTION = "addReadsOption";
    private static final String ADD_READS_DETAILS_SELECTED = "addReadsDetailsSelected";
    private static final String ADD_READS_OPTION_DATA = "addReadsOptionData";
    private static final String ADD_EXPORTS_OPTION = "addExportsOption";
    private static final String ADD_EXPORTS_DETAILS_SELECTED = "addExportsDetailsSelected";
    private static final String ADD_EXPORTS_OPTION_DATA = "addExportsOptionData";
    private static final String UPGRADE_MODULE_PATH_OPTION = "upgradeModulePathOption";
    private static final String UPGRADE_MODULE_PATH_DATA = "upgradeModulePathData";
    private static final String LIMIT_MODULES_OPTION = "limitModulesOption";
    private static final String LIMIT_MODULES_OPTION_DATA = "limitModulesOptionData";
    private static final String PATCH_MODULE_OPTION = "patchModuleOption";
    private static final String PATCH_MODULE_DETAILS_SELECTED = "patchModulesDetailsSelected";
    private static final String PATCH_MODULE_OPTION_DATA = "patchModuleOptionData";
    private static final String LIST_MODULES_OPTION = "listModulesOption";
    private static final String LIST_MODULES_OPTION_DATA = "listModulesOptionData";
    private static final String SHOW_MODULE_GRAPH_RESOLUTION = "showModuleGraphResolution";
    private static final String DEBUG_MODULE_ACCESS_CHECKS = "debugModuleAccessChecks";
    private static final String TRACE_MODULE_DEFINITION_CHANGES = "traceModuleDefinitionChanges";
    private static final String TRACE_MODULE_DEFINITION_CHANGES_LEVEL = "traceModuleDefinitionChangesLevel";

    public RunConfiguration(HashStructure hash) {
        super(hash);
    }

    public RunConfiguration() {
        super(HashStructure.newInstance());
    }

    public RunConfiguration(RunConfiguration copyFrom, String name, boolean custom) {
        super(HashStructure.newInstance());
        if (copyFrom != null) {
            copyFrom.getProperties().copyTo(this._hash);
        }
        this.setName(name);
        this.setCustom(custom);
    }

    public static RunConfiguration getInstance(PropertyStorage propertyStorage) {
        if (propertyStorage instanceof Project) {
            Project project = (Project)propertyStorage;
            Workspace workspace = project.getWorkspace();
            if (workspace == null) {
                workspace = Ide.getActiveWorkspace();
            }
            Context rcContext = new Context(project.getWorkspace(), project);
            RunConfiguration instance = RunConfigurations.getActiveRunConfiguration(project, workspace, false);
            instance.context = rcContext;
            return instance;
        }
        if (propertyStorage instanceof Workspace) {
            Workspace workspace = (Workspace)propertyStorage;
            Project project = Ide.getActiveProject();
            Context rcContext = new Context(workspace, null);
            RunConfiguration instance = RunConfigurations.getActiveRunConfiguration(project, workspace, true);
            instance.context = rcContext;
            return instance;
        }
        return null;
    }

    @Deprecated
    public static RunConfiguration getRunConfiguration(Project project, String configName) {
        return RunConfiguration.getInstance((PropertyStorage)project);
    }

    public static RunConfiguration createNewInstance(HashStructure hash, String name, boolean isCustom, boolean useWorkspacePropertyStorage) {
        RunConfiguration runConfig;
        RunConfiguration runConfiguration = runConfig = hash == null ? new RunConfiguration() : new RunConfiguration(hash);
        if (name != null) {
            runConfig.setName(name);
        } else if (useWorkspacePropertyStorage) {
            runConfig.setName(RunMgrArb.getString(2));
        } else {
            runConfig.setName(isCustom ? RunMgrArb.getString(1) : RunMgrArb.getString(0));
        }
        runConfig.setCustom(isCustom);
        return runConfig;
    }

    @Deprecated
    public static String getDefaultName() {
        Project project = Ide.getActiveProject();
        if (project == null) {
            project = Ide.getDefaultProject();
        }
        return RunConfiguration.getDefaultName(project);
    }

    public static String getDefaultName(Project project) {
        if (sharedPropertiesManager.isUsingSharedProperties(project, "oracle.jdeveloper.runner.RunConfigurations")) {
            return RunMgrArb.getString(2);
        }
        return RunMgrArb.getString(0);
    }

    public String toString() {
        return this.getName();
    }

    public HashStructure getProperties() {
        return this.getHashStructure();
    }

    public void restoreDefaults() {
        String name = this.getName();
        boolean custom = this.isCustom();
        this.getHashStructure().clear();
        this.setName(name);
        this.setCustom(custom);
    }

    public String getName() {
        return this.getHashStructure().getString("name", "");
    }

    public void setName(String name) {
        if (name == null) {
            name = "";
        }
        this.getHashStructure().putString("name", name);
    }

    public boolean isCustom() {
        return this.getHashStructure().getBoolean(CUSTOM, false);
    }

    public void setCustom(boolean custom) {
        this.getHashStructure().putBoolean(CUSTOM, custom);
    }

    public URL getRunDirectoryURL(boolean expandMacros) {
        URL runDirectoryURL = this.getHashStructure().getURL(RUN_DIRECTORY_URL, null);
        if (runDirectoryURL == null) {
            return null;
        }
        runDirectoryURL = this.absoluteToMacro(runDirectoryURL);
        if (!expandMacros) {
            return runDirectoryURL;
        }
        String pathString = runDirectoryURL.getPath();
        if (pathString != null && MacroUtils.isMacroExpression((String)pathString)) {
            return MacroUtils.expandAndMakeURL((Context)this.getContext(), (String)pathString);
        }
        return runDirectoryURL;
    }

    private URL macroToAbsolute(URL macroURL) {
        if (macroURL == null) {
            return null;
        }
        if (macroURL.getPath().startsWith("${")) {
            String absoluteMacroPath = "/" + macroURL.getPath();
            macroURL = URLFactory.replacePathPart((URL)macroURL, (String)absoluteMacroPath);
        }
        return macroURL;
    }

    private URL absoluteToMacro(URL absoluteURL) {
        if (absoluteURL == null) {
            return null;
        }
        String pathString = absoluteURL.getPath();
        URL macroURL = absoluteURL;
        if (pathString.startsWith("/${")) {
            pathString = pathString.substring(1);
            macroURL = URLFactory.newDirURL((String)".");
            macroURL = URLFactory.replacePathPart((URL)absoluteURL, (String)pathString);
        }
        return macroURL;
    }

    public URL getRunDirectoryURL() {
        return this.getRunDirectoryURL(true);
    }

    public void setRunDirectoryURL(URL runDirectoryURL) {
        if ((runDirectoryURL = this.macroToAbsolute(runDirectoryURL)) == null || runDirectoryURL.getProtocol().equals("file") || runDirectoryURL.getProtocol().equals("macro")) {
            this.getHashStructure().putURL(RUN_DIRECTORY_URL, runDirectoryURL);
        }
    }

    private String getVMName(String defaultValue) {
        return this.getHashStructure().getString(VM_NAME, defaultValue);
    }

    public void setVMName(String vmName) {
        this.getHashStructure().putString(VM_NAME, vmName);
    }

    public String getJavaOptions(boolean expandMacros) {
        String asStored = this.getHashStructure().getString(JAVA_OPTIONS, "");
        if (!expandMacros) {
            return asStored;
        }
        return MacroUtils.expand((Context)this.getContext(), (String)asStored);
    }

    public String getJavaOptions() {
        return this.getJavaOptions(true);
    }

    public void setJavaOptions(String javaOptions) {
        if (javaOptions == null) {
            javaOptions = "";
        }
        this.getHashStructure().putString(JAVA_OPTIONS, javaOptions);
    }

    public URL getTargetURL(boolean expandMacros) {
        if (!expandMacros) {
            return this.getHashStructure().getURL(TARGET_URL);
        }
        String asStored = this.getHashStructure().getString(TARGET_URL);
        if (asStored != null && MacroUtils.isMacroExpression((String)asStored)) {
            return MacroUtils.expandAndMakeURL((Context)this.getContext(), (String)asStored);
        }
        return this.getHashStructure().getURL(TARGET_URL);
    }

    public URL getTargetURL() {
        return this.getTargetURL(true);
    }

    public void setTargetURL(URL targetURL) {
        this.getHashStructure().putURL(TARGET_URL, targetURL);
    }

    public boolean isRunActiveFile() {
        return this.getHashStructure().getBoolean(RUN_ACTIVE_FILE, true);
    }

    public void setRunActiveFile(boolean runActiveFile) {
        this.getHashStructure().putBoolean(RUN_ACTIVE_FILE, runActiveFile);
    }

    public String getProgramArguments(boolean expandMacros) {
        String asStored = this.getHashStructure().getString(PROGRAM_ARGUMENTS, "");
        if (!expandMacros) {
            return asStored;
        }
        return MacroUtils.expand((Context)this.getContext(), (String)asStored);
    }

    public String getProgramArguments() {
        return this.getProgramArguments(true);
    }

    public void setProgramArguments(String programArguments) {
        if (programArguments == null) {
            programArguments = "";
        }
        this.getHashStructure().putString(PROGRAM_ARGUMENTS, programArguments);
    }

    public boolean isRemoteDebuggingProfiling() {
        return this.getHashStructure().getBoolean(REMOTE_DEBUGGING_PROFILING, false);
    }

    public void setRemoteDebuggingProfiling(boolean remoteDebuggingProfiling) {
        this.getHashStructure().putBoolean(REMOTE_DEBUGGING_PROFILING, remoteDebuggingProfiling);
    }

    public String getConnectionName() {
        return this.getHashStructure().getString(CONNECTION_NAME, null);
    }

    public void setConnectionName(String connectionName) {
        this.getHashStructure().putString(CONNECTION_NAME, connectionName);
    }

    public boolean isCompileBeforeRun() {
        return this.getHashStructure().getBoolean(COMPILE_BEFORE_RUN, true);
    }

    public void setCompileBeforeRun(boolean compileBeforeRun) {
        this.getHashStructure().putBoolean(COMPILE_BEFORE_RUN, compileBeforeRun);
    }

    public boolean isCompileProjectOnlyBeforeRun() {
        return this.getHashStructure().getBoolean(COMPILE_PROJECT_ONLY_BEFORE_RUN, false);
    }

    public void setCompileProjectOnlyBeforeRun(boolean compileProjectOnlyBeforeRun) {
        this.getHashStructure().putBoolean(COMPILE_PROJECT_ONLY_BEFORE_RUN, compileProjectOnlyBeforeRun);
    }

    public boolean isRunAntBeforeRun() {
        return this.getHashStructure().getBoolean(RUN_ANT_BEFORE_RUN, false);
    }

    public void setRunAntBeforeRun(boolean runAntBeforeRun) {
        this.getHashStructure().putBoolean(RUN_ANT_BEFORE_RUN, runAntBeforeRun);
    }

    public boolean isRunAntBeforeCompile() {
        return this.getHashStructure().getBoolean(RUN_ANT_BEFORE_COMPILE, true);
    }

    public void setRunAntBeforeCompile(boolean runAntBeforeCompile) {
        this.getHashStructure().putBoolean(RUN_ANT_BEFORE_COMPILE, runAntBeforeCompile);
    }

    public boolean isClearLogBeforeRun() {
        return this.getHashStructure().getBoolean(CLEAR_LOG_BEFORE_RUN, true);
    }

    public void setClearLogBeforeRun(boolean clearLogBeforeRun) {
        this.getHashStructure().putBoolean(CLEAR_LOG_BEFORE_RUN, clearLogBeforeRun);
    }

    public boolean isSaveAllBeforeRun() {
        return this.getHashStructure().getBoolean(SAVE_ALL_BEFORE_RUN, false);
    }

    public void setSaveAllBeforeRun(boolean saveAllBeforeRun) {
        this.getHashStructure().putBoolean(SAVE_ALL_BEFORE_RUN, saveAllBeforeRun);
    }

    public boolean isLogCommand() {
        return this.getHashStructure().getBoolean(LOG_COMMAND, true);
    }

    public void setLogCommand(boolean logCommand) {
        this.getHashStructure().putBoolean(LOG_COMMAND, logCommand);
    }

    public boolean isLogOutput() {
        return this.getHashStructure().getBoolean(LOG_OUTPUT, true);
    }

    public void setLogOutput(boolean logOutput) {
        this.getHashStructure().putBoolean(LOG_OUTPUT, logOutput);
    }

    public boolean isLogError() {
        return this.getHashStructure().getBoolean(LOG_ERROR, true);
    }

    public void setLogError(boolean logError) {
        this.getHashStructure().putBoolean(LOG_ERROR, logError);
    }

    public boolean isAllowInput() {
        return this.getHashStructure().getBoolean(ALLOW_INPUT, false);
    }

    public void setAllowInput(boolean allowInput) {
        this.getHashStructure().putBoolean(ALLOW_INPUT, allowInput);
    }

    public boolean isLogExit() {
        return this.getHashStructure().getBoolean(LOG_EXIT, true);
    }

    public void setLogExit(boolean logExit) {
        this.getHashStructure().putBoolean(LOG_EXIT, logExit);
    }

    public boolean isUseProxy() {
        return this.getHashStructure().getBoolean(USE_PROXY, true);
    }

    public void setUseProxy(boolean useProxy) {
        this.getHashStructure().putBoolean(USE_PROXY, useProxy);
    }

    public String getVMName(JDK jdk) {
        String vmName = null;
        if (jdk != null) {
            int length;
            boolean found = false;
            String defaultVM = null;
            String[] vmChoices = jdk.getInstalledVMs();
            if (vmChoices != null && (length = vmChoices.length) > 0 && (vmName = this.getVMName(defaultVM = vmChoices[0])) != null) {
                for (int i = 0; i < length; ++i) {
                    if (!vmName.equals(vmChoices[i])) continue;
                    found = true;
                    break;
                }
            }
            if (!found && defaultVM != null) {
                return defaultVM;
            }
        }
        if (vmName == null) {
            vmName = this.getVMName("client");
        }
        return vmName;
    }

    public boolean usingOJVM(JDK jdk) {
        String vmName = this.getVMName(jdk);
        return vmName != null && vmName.startsWith("ojvm");
    }

    public boolean usingMinimal(JDK jdk) {
        String vmName = this.getVMName(jdk);
        return vmName != null && vmName.equals("minimal");
    }

    public boolean usingVanilla(JDK jdk) {
        String vmName = this.getVMName(jdk);
        return vmName != null && vmName.equals("vanilla");
    }

    public boolean usingClassic(JDK jdk) {
        String vmName = this.getVMName(jdk);
        return vmName != null && vmName.equals("classic");
    }

    private ListStructure getEnvironmentVariablesAsListStructure() {
        return this.getHashStructure().getListStructure(ENV_VARIABLES);
    }

    public void setEnvironmentVariables(ListStructure envVars) {
        this.getHashStructure().putListStructure(ENV_VARIABLES, envVars);
    }

    public List<EnvironmentVariable> getEnvironmentVariables() {
        ListStructure list = this.getEnvironmentVariablesAsListStructure();
        if (list == null) {
            return Collections.emptyList();
        }
        ArrayList<EnvironmentVariable> evs = new ArrayList<EnvironmentVariable>(list.size());
        for (int i = 0; i < list.size(); ++i) {
            EnvironmentVariable ev = new EnvironmentVariable((HashStructure)list.get(i));
            evs.add(ev);
        }
        return evs;
    }

    public Context getContext() {
        if (this.context == null) {
            this.context = Context.newIdeContext();
        }
        return this.context;
    }

    public String getJavaRemoteDebugPort() {
        DebugConfigurationAccessor debugConfig = DebugConfigurationAccessor.getInstance(this);
        return debugConfig.getJavaRemoteDebugPort();
    }

    public void setJavaRemoteDebugPort(String port) {
        DebugConfigurationAccessor debugConfig = DebugConfigurationAccessor.getInstance(this);
        debugConfig.setJavaRemoteDebugPort(port);
    }

    public boolean isUseModulePath() {
        return this.getHashStructure().getBoolean(USE_MODULE_PATH, true);
    }

    public void setUseModulePath(boolean value) {
        this.getHashStructure().putBoolean(USE_MODULE_PATH, value);
    }

    public boolean isUsePathsConfigModulePath() {
        return this.getHashStructure().getBoolean(USE_PATHSCONFIG_MODULE_PATH, true);
    }

    public void setUsePathsConfigModulePath(boolean use) {
        this.getHashStructure().putBoolean(USE_PATHSCONFIG_MODULE_PATH, use);
    }

    public boolean isUseUserSuppliedModulePath() {
        return this.getHashStructure().getBoolean(USE_USER_SUPPLIED_MODULE_PATH, false);
    }

    public void setUseUserSuppliedModulePath(boolean use) {
        this.getHashStructure().putBoolean(USE_USER_SUPPLIED_MODULE_PATH, use);
    }

    public String getUserSuppliedModulePath() {
        return this.getHashStructure().getString(USER_SUPPLIED_MODULE_PATH);
    }

    public void setUserSuppliedModulePath(String path) {
        this.getHashStructure().putString(USER_SUPPLIED_MODULE_PATH, path);
    }

    public boolean hasAddModulesOption() {
        return this.getHashStructure().getBoolean(HAS_ADD_MODULES_OPTION, true);
    }

    public void setHasAddModulesOption(boolean value) {
        this.getHashStructure().putBoolean(HAS_ADD_MODULES_OPTION, value);
    }

    public boolean isUsePathsConfigAddModules() {
        return this.getHashStructure().getBoolean(USE_PATHSCONFIG_ADD_MODULES, true);
    }

    public void setUsePathsConfigAddModules(boolean use) {
        this.getHashStructure().putBoolean(USE_PATHSCONFIG_ADD_MODULES, use);
    }

    public boolean isUseUserSuppliedAddModules() {
        return this.getHashStructure().getBoolean(USE_USER_SUPPLIED_ADD_MODULES, false);
    }

    public void setUseUserSuppliedAddModules(boolean use) {
        this.getHashStructure().putBoolean(USE_USER_SUPPLIED_ADD_MODULES, use);
    }

    public String getUserSuppliedAddModules() {
        return this.getHashStructure().getString(USER_SUPPLIED_ADD_MODULES);
    }

    public void setUserSuppliedAddModules(String path) {
        this.getHashStructure().putString(USER_SUPPLIED_ADD_MODULES, path);
    }

    public boolean hasModuleOption() {
        return this.getHashStructure().getBoolean(MODULE_OPTION, false);
    }

    public void setHasModuleOption(boolean value) {
        this.getHashStructure().putBoolean(MODULE_OPTION, value);
    }

    public String getModuleOptionData() {
        return this.getHashStructure().getString(MODULE_OPTION_DATA);
    }

    public void setModuleOptionData(String data) {
        this.getHashStructure().putString(MODULE_OPTION_DATA, data);
    }

    public boolean hasAddReadsOption() {
        return this.getHashStructure().getBoolean(ADD_READS_OPTION, false);
    }

    public void setHasAddReadsOption(boolean value) {
        this.getHashStructure().putBoolean(ADD_READS_OPTION, value);
    }

    public List<Boolean> getAddReadsDetailsSelected() {
        ArrayList<Boolean> selections = new ArrayList<Boolean>();
        ListStructure ls = this.getHashStructure().getListStructure(ADD_READS_DETAILS_SELECTED);
        if (ls != null) {
            for (Object o : ls) {
                selections.add((Boolean)o);
            }
        }
        return selections;
    }

    public void setAddReadsDetailsSelected(List<Boolean> selections) {
        ListStructure ls = ListStructure.newInstance();
        ls.addAll(selections);
        this.getHashStructure().putListStructure(ADD_READS_DETAILS_SELECTED, ls);
    }

    public List<String> getAddReadsOptionData() {
        ArrayList<String> addReadsData = new ArrayList<String>();
        ListStructure ls = this.getHashStructure().getListStructure(ADD_READS_OPTION_DATA);
        if (ls == null) {
            return addReadsData;
        }
        for (Object s : ls) {
            addReadsData.add((String)s);
        }
        return addReadsData;
    }

    public void setAddReadsOptionData(List<String> addReadsData) {
        ListStructure ls = ListStructure.newInstance();
        ls.addAll(addReadsData);
        this.getHashStructure().putListStructure(ADD_READS_OPTION_DATA, ls);
    }

    public boolean hasAddExportsOption() {
        return this.getHashStructure().getBoolean(ADD_EXPORTS_OPTION, false);
    }

    public void setHasAddExportsOption(boolean value) {
        this.getHashStructure().putBoolean(ADD_EXPORTS_OPTION, value);
    }

    public List<Boolean> getAddExportsDetailsSelected() {
        ArrayList<Boolean> selections = new ArrayList<Boolean>();
        ListStructure ls = this.getHashStructure().getListStructure(ADD_EXPORTS_DETAILS_SELECTED);
        if (ls != null) {
            for (Object o : ls) {
                selections.add((Boolean)o);
            }
        }
        return selections;
    }

    public void setAddExportsDetailsSelected(List<Boolean> selections) {
        ListStructure ls = ListStructure.newInstance();
        ls.addAll(selections);
        this.getHashStructure().putListStructure(ADD_EXPORTS_DETAILS_SELECTED, ls);
    }

    public List<String> getAddExportsOptionData() {
        ArrayList<String> addExportsData = new ArrayList<String>();
        ListStructure ls = this.getHashStructure().getListStructure(ADD_EXPORTS_OPTION_DATA);
        if (ls == null) {
            return addExportsData;
        }
        for (Object s : ls) {
            addExportsData.add((String)s);
        }
        return addExportsData;
    }

    public void setAddExportsOptionData(List<String> addExportsData) {
        ListStructure ls = ListStructure.newInstance();
        ls.addAll(addExportsData);
        this.getHashStructure().putListStructure(ADD_EXPORTS_OPTION_DATA, ls);
    }

    public boolean hasUpgradeModulePathOption() {
        return this.getHashStructure().getBoolean(UPGRADE_MODULE_PATH_OPTION, false);
    }

    public void setHasUpgradeModulePathOption(boolean value) {
        this.getHashStructure().putBoolean(UPGRADE_MODULE_PATH_OPTION, value);
    }

    public String getUpgradeModulePathOptionData() {
        return this.getHashStructure().getString(UPGRADE_MODULE_PATH_DATA);
    }

    public void setUpgradeModulePathOptionData(String data) {
        this.getHashStructure().putString(UPGRADE_MODULE_PATH_DATA, data);
    }

    public boolean hasLimitModulesOption() {
        return this.getHashStructure().getBoolean(LIMIT_MODULES_OPTION, false);
    }

    public void setHasLimitModulesOption(boolean value) {
        this.getHashStructure().putBoolean(LIMIT_MODULES_OPTION, value);
    }

    public String getLimitModulesOptionData() {
        return this.getHashStructure().getString(LIMIT_MODULES_OPTION_DATA);
    }

    public void setLimitModulesOptionData(String data) {
        this.getHashStructure().putString(LIMIT_MODULES_OPTION_DATA, data);
    }

    public boolean hasPatchModuleOption() {
        return this.getHashStructure().getBoolean(PATCH_MODULE_OPTION, false);
    }

    public void setHasPatchModuleOption(boolean value) {
        this.getHashStructure().putBoolean(PATCH_MODULE_OPTION, value);
    }

    public List<Boolean> getPatchModuleDetailsSelected() {
        ArrayList<Boolean> selections = new ArrayList<Boolean>();
        ListStructure ls = this.getHashStructure().getListStructure(PATCH_MODULE_DETAILS_SELECTED);
        if (ls != null) {
            for (Object o : ls) {
                selections.add((Boolean)o);
            }
        }
        return selections;
    }

    public void setPatchModuleDetailsSelected(List<Boolean> selections) {
        ListStructure ls = ListStructure.newInstance();
        ls.addAll(selections);
        this.getHashStructure().putListStructure(PATCH_MODULE_DETAILS_SELECTED, ls);
    }

    public List<String> getPatchModuleOptionData() {
        ArrayList<String> patchModuleData = new ArrayList<String>();
        ListStructure ls = this.getHashStructure().getListStructure(PATCH_MODULE_OPTION_DATA);
        if (ls == null) {
            return patchModuleData;
        }
        for (Object s : ls) {
            patchModuleData.add((String)s);
        }
        return patchModuleData;
    }

    public void setPatchModuleOptionData(List<String> patchModuleData) {
        ListStructure ls = ListStructure.newInstance();
        ls.addAll(patchModuleData);
        this.getHashStructure().putListStructure(PATCH_MODULE_OPTION_DATA, ls);
    }

    public boolean hasListModulesOption() {
        return this.getHashStructure().getBoolean(LIST_MODULES_OPTION, false);
    }

    public void setHasListModulesOption(boolean value) {
        this.getHashStructure().putBoolean(LIST_MODULES_OPTION, value);
    }

    public String getListModulesOptionData() {
        return this.getHashStructure().getString(LIST_MODULES_OPTION_DATA);
    }

    public void setListModulesOptionData(String data) {
        this.getHashStructure().putString(LIST_MODULES_OPTION_DATA, data);
    }

    public boolean hasShowModuleGraphResolutionOption() {
        return this.getHashStructure().getBoolean(SHOW_MODULE_GRAPH_RESOLUTION, false);
    }

    public void setHasShowModuleGraphResolutionOption(boolean value) {
        this.getHashStructure().putBoolean(SHOW_MODULE_GRAPH_RESOLUTION, value);
    }

    public boolean hasDebugModuleAccessChecksOption() {
        return this.getHashStructure().getBoolean(DEBUG_MODULE_ACCESS_CHECKS, false);
    }

    public void setHasDebugModuleAccessChecksOption(boolean value) {
        this.getHashStructure().putBoolean(DEBUG_MODULE_ACCESS_CHECKS, value);
    }

    public boolean hasTraceModuleDefinitionChangesOption() {
        return this.getHashStructure().getBoolean(TRACE_MODULE_DEFINITION_CHANGES, false);
    }

    public void setHasTraceModuleDefinitionChangesOption(boolean value) {
        this.getHashStructure().putBoolean(TRACE_MODULE_DEFINITION_CHANGES, value);
    }

    public String getTraceModuleDefinitionChangesLevel() {
        return this.getHashStructure().getString(TRACE_MODULE_DEFINITION_CHANGES_LEVEL);
    }

    public void setTraceModuleDefinitionChangesLevel(String level) {
        this.getHashStructure().putString(TRACE_MODULE_DEFINITION_CHANGES_LEVEL, level);
    }

    public String getModulePath() {
        if (!RunConfiguration.isJDK9OrLaterProject(this.getContext().getProject())) {
            return null;
        }
        if (!this.isUseModulePath()) {
            return null;
        }
        StringBuilder result = new StringBuilder();
        if (this.isUsePathsConfigModulePath()) {
            result.append(this.getModulePathFromPathsConfig());
        }
        if (this.isUseUserSuppliedModulePath()) {
            if (result.length() > 0) {
                result.append(System.getProperty("path.separator"));
            }
            result.append(this.getUserSuppliedModulePath());
        }
        return result.toString();
    }

    public static boolean isJDK9OrLaterProject(Project project) {
        JProjectLibraries pl = JProjectLibraries.getInstance((PropertyStorage)project);
        VersionNumber jdkVersion = pl.getJdkVersionNumber();
        return !jdkVersion.isBefore(new VersionNumber("9"));
    }

    public List<String> getModuleOptions() {
        String limits;
        String path;
        List<Boolean> selected;
        String mainModule;
        Log optionsLogger = RunConfigurationModuleOptionsPanel.getLogger();
        ArrayList<String> options = new ArrayList<String>();
        if (!RunConfiguration.isJDK9OrLaterProject(this.getContext().getProject())) {
            return options;
        }
        if (this.hasAddModulesOption()) {
            if (!this.isUsePathsConfigAddModules() && !this.isUseUserSuppliedAddModules()) {
                optionsLogger.trace("--add-modules option enabled but content subitems unselected; option skipped");
            } else {
                List<String> libraryModules;
                StringBuilder addModuleContent = new StringBuilder();
                if (this.isUsePathsConfigAddModules() && (libraryModules = this.getPathsConfigModules()).size() > 0) {
                    for (String name : libraryModules) {
                        addModuleContent.append(name);
                        addModuleContent.append(',');
                    }
                }
                if (this.isUseUserSuppliedAddModules()) {
                    addModuleContent.append(this.getUserSuppliedAddModules());
                } else {
                    int finalCommaPosition = addModuleContent.lastIndexOf(",");
                    if (finalCommaPosition != -1) {
                        addModuleContent.deleteCharAt(finalCommaPosition);
                    }
                }
                if (addModuleContent.length() == 0) {
                    optionsLogger.trace("--add-modules option and content selected, but content is empty, option skipped.");
                } else {
                    options.add("--add-modules");
                    options.add(addModuleContent.toString());
                }
            }
        }
        if (this.hasModuleOption() && (mainModule = this.getModuleOptionData()) != null) {
            options.add("--module");
            options.add(mainModule);
        }
        if (this.hasAddReadsOption()) {
            selected = this.getAddReadsDetailsSelected();
            List<String> addReadsEntries = this.getAddReadsOptionData();
            for (int i = 0; i < addReadsEntries.size(); ++i) {
                if (!selected.get(i).booleanValue()) continue;
                options.add("--add-reads");
                options.add(addReadsEntries.get(i));
            }
        }
        if (this.hasAddExportsOption() && (selected = this.getAddExportsDetailsSelected()) != null) {
            List<String> addExportsEntries = this.getAddExportsOptionData();
            if (addExportsEntries.size() != selected.size()) {
                System.out.println("Mismatch in selection and content size for addExports " + selected.size() + " != " + addExportsEntries.size());
            }
            int max = Math.min(selected.size(), addExportsEntries.size());
            for (int i = 0; i < max; ++i) {
                if (!selected.get(i).booleanValue()) continue;
                options.add("--add-exports");
                options.add(addExportsEntries.get(i));
            }
        }
        if (this.hasUpgradeModulePathOption() && (path = this.getUpgradeModulePathOptionData()) != null) {
            options.add("--upgrade-module-path");
            options.add(path);
        }
        if (this.hasLimitModulesOption() && (limits = this.getLimitModulesOptionData()) != null) {
            options.add("--limit-modules");
            options.add(limits);
        }
        if (this.hasPatchModuleOption()) {
            List<String> patches = this.getPatchModuleOptionData();
            List<Boolean> selected2 = this.getPatchModuleDetailsSelected();
            if (selected2 != null) {
                for (int i = 0; i < patches.size(); ++i) {
                    if (!selected2.get(i).booleanValue()) continue;
                    options.add("--patch-module");
                    options.add(patches.get(i));
                }
            }
        }
        if (this.hasListModulesOption()) {
            options.add("--list-modules");
            String modulesToList = this.getListModulesOptionData();
            if (modulesToList != null) {
                options.add(modulesToList);
            }
        }
        if (this.hasShowModuleGraphResolutionOption()) {
            options.add("-Xdiag;resolver");
        }
        if (this.hasDebugModuleAccessChecksOption()) {
            options.add("-Dsun.reflect.debugModuleAccessChecks");
        }
        if (this.hasTraceModuleDefinitionChangesOption()) {
            String optionSetting = this.getTraceModuleDefinitionChangesLevel();
            options.add(optionSetting);
        }
        return options;
    }

    public String getModulePathFromPathsConfig() {
        if (!RunConfiguration.isJDK9OrLaterProject(this.getContext().getProject())) {
            return null;
        }
        PathsConfiguration pc = PathsConfiguration.getInstance((Project)this.getContext().getProject());
        URLPath modulePath = pc.getModulePath(false, false);
        return modulePath.toString();
    }

    public List<String> getPathsConfigModules() {
        URL[] urls;
        ArrayList<String> modules = new ArrayList<String>();
        Project project = this.getContext().getProject();
        PathsConfiguration pc = PathsConfiguration.getInstance((Project)project);
        URLPath urlpath = pc.getModulePath(false, false);
        for (URL url : urls = urlpath.getEntries()) {
            String moduleName = PathsConfiguration.getModuleName((URL)url);
            if (moduleName == null) continue;
            modules.add(moduleName);
        }
        return modules;
    }
}

