/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.model.common.build.partition;

import java.util.Locale;
import oracle.dmt.dataminer.core.model.CorePartitionsLrb;
import oracle.dmt.dataminer.core.model.common.build.partition.PartitionColumn;

public class Rule {
    private PartitionColumn partitionKey;
    private OPERATORS operator;
    private String value;

    public Rule(PartitionColumn partitionColumn, OPERATORS oPERATORS, String string) {
        this.partitionKey = partitionColumn;
        this.operator = oPERATORS;
        this.value = string;
    }

    public void setPartitionKey(PartitionColumn partitionColumn) {
        this.partitionKey = partitionColumn;
    }

    public PartitionColumn getPartitionKey() {
        return this.partitionKey;
    }

    public void setOperator(OPERATORS oPERATORS) {
        this.operator = oPERATORS;
    }

    public OPERATORS getOperator() {
        return this.operator;
    }

    public void setValue(String string) {
        this.value = string;
    }

    public String getValue() {
        return this.value;
    }

    public static Rule createEmptyRule() {
        return new Rule(null, OPERATORS.EMPTY, "");
    }

    public boolean isComplete() {
        return this.partitionKey != null && this.operator != OPERATORS.EMPTY && this.value != null && !"".equals(this.value);
    }

    public boolean isEmpty() {
        return this.partitionKey == null && this.operator == OPERATORS.EMPTY && (this.value == null || "".equals(this.value));
    }

    public static final class OPERATORS
    extends Enum<OPERATORS> {
        public static final /* enum */ OPERATORS EMPTY = new OPERATORS("", true, true, "", "");
        public static final /* enum */ OPERATORS IS = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_IS"), true, true, "{}", "= ?");
        public static final /* enum */ OPERATORS GREATER_THAN = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_GT"), false, true, "{}", "> ?");
        public static final /* enum */ OPERATORS LESS_THAN = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_LT"), false, true, "{}", "< ?");
        public static final /* enum */ OPERATORS IS_NOT = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_ISNOT"), true, false, "{}", "!= ?");
        public static final /* enum */ OPERATORS CONTAINS = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_CONTAINS"), true, false, "%{}%", "LIKE ?");
        public static final /* enum */ OPERATORS NOT_CONTAINS = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_NOT_CONTAINS"), true, false, "%{}%", "NOT LIKE ?");
        public static final /* enum */ OPERATORS STARTS = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_STARTS"), true, false, "{}%", "LIKE ?");
        public static final /* enum */ OPERATORS NOT_START = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_NOT_STARTS"), true, false, "{}%", "NOT LIKE ?");
        public static final /* enum */ OPERATORS ENDS = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_END"), true, false, "%{}", "LIKE ?");
        public static final /* enum */ OPERATORS NOT_END = new OPERATORS(CorePartitionsLrb.get("FILTER_OPERATOR_NOT_END"), true, false, "%{}", "NOT LIKE ?");
        private String label;
        private boolean isStringOperator;
        private boolean isNumberOperator;
        private String sqlQueryParam;
        private String sqlQueryOperator;
        private static final /* synthetic */ OPERATORS[] $VALUES;

        public static OPERATORS[] values() {
            return (OPERATORS[])$VALUES.clone();
        }

        public static OPERATORS valueOf(String string) {
            return Enum.valueOf(OPERATORS.class, string);
        }

        private OPERATORS(String string2, boolean bl, boolean bl2, String string3, String string4) {
            this.label = string2;
            this.isStringOperator = bl;
            this.isNumberOperator = bl2;
            this.sqlQueryParam = string3;
            this.sqlQueryOperator = string4;
        }

        public String toString() {
            return this.label;
        }

        public boolean isStringOperator() {
            return this.isStringOperator;
        }

        public boolean isNumberOperator() {
            return this.isNumberOperator;
        }

        public String toStringQueryParam(String string) {
            assert (this.isStringOperator()) : "Not a string operator";
            string = string.toUpperCase(Locale.getDefault());
            return this.sqlQueryParam.replace("{}", string);
        }

        public Double toNumberQueryParam(String string) {
            assert (this.isNumberOperator()) : "Not a number Operator";
            return Double.valueOf(string);
        }

        public String getSqlQueryOperator() {
            return this.sqlQueryOperator;
        }

        private static /* synthetic */ OPERATORS[] $values() {
            return new OPERATORS[]{EMPTY, IS, GREATER_THAN, LESS_THAN, IS_NOT, CONTAINS, NOT_CONTAINS, STARTS, NOT_START, ENDS, NOT_END};
        }

        static {
            $VALUES = OPERATORS.$values();
        }
    }
}

