/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.queries.metadata;

import java.sql.SQLException;
import oracle.dmt.dataminer.core.dal.sql.SqlQuery;
import oracle.dmt.dataminer.core.dal.sql.builder.Conditional;
import oracle.dmt.dataminer.core.dal.sql.builder.SqlBuilder;
import oracle.dmt.dataminer.core.dal.sql.mapping.metadata.GetTableColumnDefinitionMapper;
import oracle.dmt.dataminer.core.model.common.ColumnDataRow;
import oracle.dmt.dataminer.core.model.common.DBTableColumns;
import oracle.jdbc.OraclePreparedStatement;

public class GetTableColumnDefinitionQuery
extends SqlQuery<ColumnDataRow, OraclePreparedStatement> {
    private String schema;
    private String tableName;

    public GetTableColumnDefinitionQuery(String string, String string2) {
        super(new GetTableColumnDefinitionMapper());
        this.schema = string;
        this.tableName = string2;
    }

    @Override
    protected String getSQLCommand() {
        SqlBuilder sqlBuilder = new SqlBuilder().select("COLUMN_NAME", "DATA_TYPE", "DATA_LENGTH", "DATA_PRECISION", "DATA_SCALE", "COLUMN_ID").from(DBTableColumns.ALL_TAB_COLUMNS.name()).where(Conditional.equals("OWNER", this.schema), Conditional.equals("TABLE_NAME", this.tableName));
        String string = sqlBuilder.toString();
        return string;
    }

    @Override
    protected void setParameters(OraclePreparedStatement oraclePreparedStatement) throws SQLException {
        oraclePreparedStatement.setStringAtName("OWNER", this.schema);
        oraclePreparedStatement.setStringAtName("TABLE_NAME", this.tableName);
    }
}

