/*
 * Decompiled with CFR 0.152.
 */
package oracle.dmt.dataminer.core.dal.sql.builder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import oracle.dmt.dataminer.core.dal.sql.builder.Distinct;
import oracle.dmt.dataminer.core.utils.StringUtils;

public class SqlBuilder {
    private static final String ALL = " * ";
    private static final String COMMA = ", ";
    private static final String COMMA_NEW_LINE = ",\n       ";
    private static final String WHERE = "WHERE ";
    private static final String AND_NEW_LINE = "\nAND ";
    private static final String ORDER_BY = "ORDER BY ";
    private static final String GROUP_BY = "GROUP BY ";
    private String from;
    private List<String> columns = new ArrayList<String>();
    private List<String> sorting = new ArrayList<String>();
    private List<String> grouping = new ArrayList<String>();
    private List<String> conditions = new ArrayList<String>();
    private Distinct distinct;

    public SqlBuilder select(Distinct distinct) {
        assert (distinct != null) : "Distinct Definition Can Not be Null.";
        this.distinct = distinct;
        return this;
    }

    public SqlBuilder select(String ... stringArray) {
        this.columns.clear();
        this.columns.addAll(Arrays.asList(stringArray));
        return this;
    }

    public SqlBuilder select(List<String> list) {
        this.columns = list;
        return this;
    }

    public SqlBuilder from(String string) {
        assert (StringUtils.isNotEmpty(string)) : "Source Table not Defined.";
        this.from = string;
        return this;
    }

    public SqlBuilder fromSubQuery(String string) {
        assert (StringUtils.isNotEmpty(string)) : "Source Table not Defined.";
        this.from = String.format("(\n%s)", string);
        return this;
    }

    public SqlBuilder where(String ... stringArray) {
        this.conditions.clear();
        this.conditions.addAll(Arrays.asList(stringArray));
        return this;
    }

    public SqlBuilder orderBy(String ... stringArray) {
        this.sorting.clear();
        this.sorting.addAll(Arrays.asList(stringArray));
        return this;
    }

    public SqlBuilder groupBy(String ... stringArray) {
        this.grouping.clear();
        this.grouping.addAll(Arrays.asList(stringArray));
        return this;
    }

    public void clear() {
        this.distinct = null;
        if (this.columns != null) {
            this.columns.clear();
        }
        if (this.sorting != null) {
            this.sorting.clear();
        }
        if (this.grouping != null) {
            this.grouping.clear();
        }
        if (this.conditions != null) {
            this.conditions.clear();
        }
    }

    public String toString() {
        assert (StringUtils.isNotEmpty(this.from)) : "Source Can't be Null.";
        String string = "SELECT {$COLUMNS} \nFROM {$SOURCE} \n{$CONDITIONAL}{$GROUPING}{$SORTING}";
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("COLUMNS", this.getSelectClause());
        hashMap.put("SOURCE", this.from);
        hashMap.put("CONDITIONAL", this.joinClauses(WHERE, AND_NEW_LINE, this.conditions));
        hashMap.put("GROUPING", this.joinClauses(GROUP_BY, COMMA, this.grouping));
        hashMap.put("SORTING", this.joinClauses(ORDER_BY, COMMA, this.sorting));
        String string2 = StringUtils.getReplacedString(string, hashMap);
        return string2;
    }

    private String getSelectClause() {
        if (this.distinct != null) {
            return this.distinct.toString();
        }
        String string = null;
        string = this.columns.isEmpty() ? ALL : String.join((CharSequence)COMMA_NEW_LINE, this.columns);
        return string;
    }

    private String joinClauses(String string, String string2, List<String> list) {
        if (list == null || list.isEmpty()) {
            return "";
        }
        list.removeIf(StringUtils::isEmpty);
        StringBuilder stringBuilder = new StringBuilder(String.join((CharSequence)string2, list));
        if (StringUtils.isEmpty(string) || stringBuilder.length() > 0) {
            stringBuilder.insert(0, string);
            stringBuilder.append("\n");
        }
        return stringBuilder.toString();
    }
}

