/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdevimpl.deploy.hook;

import java.util.logging.Level;
import javax.ide.extension.ElementContext;
import javax.ide.extension.ElementEndContext;
import javax.ide.extension.ElementName;
import javax.ide.extension.ElementStartContext;
import javax.ide.extension.ElementVisitor;
import javax.ide.util.MetaClass;
import oracle.javatools.util.ModelUtil;
import oracle.jdeveloper.deploy.DeploymentModuleFactory;
import oracle.jdeveloper.deploy.meta.MetadataException;
import oracle.jdevimpl.deploy.hook.BaseElementVisitor;
import oracle.jdevimpl.deploy.stripe.DeploymentModuleFactoryStore;
import oracle.jdevimpl.deploy.stripe.LazyDeploymentModuleFactory;

public class DeploymentModuleFactoriesHandler
extends BaseElementVisitor {
    static final ElementName EN_DEPLOYMENT_MODULE_FACTORIES = DeploymentModuleFactoriesHandler.e("deployment-module-factories");
    private DepModFactoryHandler dmFactoryHandler = new DepModFactoryHandler();
    static final String FOR_CLASS = "for-class";
    static final String FACTORY_RULE = "rule";

    public void start(ElementStartContext context) {
        context.registerChildVisitor(DeploymentModuleFactoriesHandler.e("module-factory-class"), (ElementVisitor)this.dmFactoryHandler);
    }

    private class DepModFactoryHandler
    extends ElementVisitor {
        private DepModFactoryHandler() {
        }

        public void start(ElementStartContext context) {
            String rule;
            String interfaceClass = context.getAttributeValue(DeploymentModuleFactoriesHandler.FOR_CLASS);
            if (ModelUtil.hasLength((String)interfaceClass)) {
                context.getScopeData().put(DeploymentModuleFactoriesHandler.FOR_CLASS, interfaceClass);
            }
            if (ModelUtil.hasLength((String)(rule = context.getAttributeValue(DeploymentModuleFactoriesHandler.FACTORY_RULE)))) {
                context.getScopeData().put(DeploymentModuleFactoriesHandler.FACTORY_RULE, rule);
            }
        }

        public void end(ElementEndContext context) {
            String dmFactoryClass = context.getText().trim();
            String forClass = (String)context.getScopeData().get(DeploymentModuleFactoriesHandler.FOR_CLASS);
            String rule = (String)context.getScopeData().get(DeploymentModuleFactoriesHandler.FACTORY_RULE);
            ClassLoader cl = ElementVisitor.getClassLoader((ElementContext)context);
            MetaClass mc = new MetaClass(cl, dmFactoryClass);
            LazyDeploymentModuleFactory factory = new LazyDeploymentModuleFactory((MetaClass<DeploymentModuleFactory>)mc, forClass, rule);
            try {
                DeploymentModuleFactoryStore.getInstance().addFactory(forClass != null ? forClass : Object.class.getName(), factory);
            }
            catch (MetadataException e) {
                context.getLogger().log(Level.SEVERE, "Unable to register module factory", e);
            }
        }
    }
}

