/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.bmc.bastion.model;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonPOJOBuilder;
import com.oracle.bmc.bastion.model.BastionDnsProxyStatus;
import com.oracle.bmc.http.client.internal.ExplicitlySetBmcModel;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

@JsonDeserialize(builder=Builder.class)
@JsonFilter(value="explicitlySetFilter")
public final class CreateBastionDetails
extends ExplicitlySetBmcModel {
    @JsonProperty(value="bastionType")
    private final String bastionType;
    @JsonProperty(value="name")
    private final String name;
    @JsonProperty(value="compartmentId")
    private final String compartmentId;
    @JsonProperty(value="targetSubnetId")
    private final String targetSubnetId;
    @JsonProperty(value="phoneBookEntry")
    private final String phoneBookEntry;
    @JsonProperty(value="staticJumpHostIpAddresses")
    private final List<String> staticJumpHostIpAddresses;
    @JsonProperty(value="clientCidrBlockAllowList")
    private final List<String> clientCidrBlockAllowList;
    @JsonProperty(value="maxSessionTtlInSeconds")
    private final Integer maxSessionTtlInSeconds;
    @JsonProperty(value="dnsProxyStatus")
    private final BastionDnsProxyStatus dnsProxyStatus;
    @JsonProperty(value="freeformTags")
    private final Map<String, String> freeformTags;
    @JsonProperty(value="definedTags")
    private final Map<String, Map<String, Object>> definedTags;

    @Deprecated
    @ConstructorProperties(value={"bastionType", "name", "compartmentId", "targetSubnetId", "phoneBookEntry", "staticJumpHostIpAddresses", "clientCidrBlockAllowList", "maxSessionTtlInSeconds", "dnsProxyStatus", "freeformTags", "definedTags"})
    public CreateBastionDetails(String bastionType, String name, String compartmentId, String targetSubnetId, String phoneBookEntry, List<String> staticJumpHostIpAddresses, List<String> clientCidrBlockAllowList, Integer maxSessionTtlInSeconds, BastionDnsProxyStatus dnsProxyStatus, Map<String, String> freeformTags, Map<String, Map<String, Object>> definedTags) {
        this.bastionType = bastionType;
        this.name = name;
        this.compartmentId = compartmentId;
        this.targetSubnetId = targetSubnetId;
        this.phoneBookEntry = phoneBookEntry;
        this.staticJumpHostIpAddresses = staticJumpHostIpAddresses;
        this.clientCidrBlockAllowList = clientCidrBlockAllowList;
        this.maxSessionTtlInSeconds = maxSessionTtlInSeconds;
        this.dnsProxyStatus = dnsProxyStatus;
        this.freeformTags = freeformTags;
        this.definedTags = definedTags;
    }

    public static Builder builder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder().copy(this);
    }

    public String getBastionType() {
        return this.bastionType;
    }

    public String getName() {
        return this.name;
    }

    public String getCompartmentId() {
        return this.compartmentId;
    }

    public String getTargetSubnetId() {
        return this.targetSubnetId;
    }

    public String getPhoneBookEntry() {
        return this.phoneBookEntry;
    }

    public List<String> getStaticJumpHostIpAddresses() {
        return this.staticJumpHostIpAddresses;
    }

    public List<String> getClientCidrBlockAllowList() {
        return this.clientCidrBlockAllowList;
    }

    public Integer getMaxSessionTtlInSeconds() {
        return this.maxSessionTtlInSeconds;
    }

    public BastionDnsProxyStatus getDnsProxyStatus() {
        return this.dnsProxyStatus;
    }

    public Map<String, String> getFreeformTags() {
        return this.freeformTags;
    }

    public Map<String, Map<String, Object>> getDefinedTags() {
        return this.definedTags;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean includeByteArrayContents) {
        StringBuilder sb = new StringBuilder();
        sb.append("CreateBastionDetails(");
        sb.append("super=").append(super.toString());
        sb.append("bastionType=").append(String.valueOf(this.bastionType));
        sb.append(", name=").append(String.valueOf(this.name));
        sb.append(", compartmentId=").append(String.valueOf(this.compartmentId));
        sb.append(", targetSubnetId=").append(String.valueOf(this.targetSubnetId));
        sb.append(", phoneBookEntry=").append(String.valueOf(this.phoneBookEntry));
        sb.append(", staticJumpHostIpAddresses=").append(String.valueOf(this.staticJumpHostIpAddresses));
        sb.append(", clientCidrBlockAllowList=").append(String.valueOf(this.clientCidrBlockAllowList));
        sb.append(", maxSessionTtlInSeconds=").append(String.valueOf(this.maxSessionTtlInSeconds));
        sb.append(", dnsProxyStatus=").append(String.valueOf((Object)this.dnsProxyStatus));
        sb.append(", freeformTags=").append(String.valueOf(this.freeformTags));
        sb.append(", definedTags=").append(String.valueOf(this.definedTags));
        sb.append(")");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CreateBastionDetails)) {
            return false;
        }
        CreateBastionDetails other = (CreateBastionDetails)((Object)o);
        return Objects.equals(this.bastionType, other.bastionType) && Objects.equals(this.name, other.name) && Objects.equals(this.compartmentId, other.compartmentId) && Objects.equals(this.targetSubnetId, other.targetSubnetId) && Objects.equals(this.phoneBookEntry, other.phoneBookEntry) && Objects.equals(this.staticJumpHostIpAddresses, other.staticJumpHostIpAddresses) && Objects.equals(this.clientCidrBlockAllowList, other.clientCidrBlockAllowList) && Objects.equals(this.maxSessionTtlInSeconds, other.maxSessionTtlInSeconds) && Objects.equals((Object)this.dnsProxyStatus, (Object)other.dnsProxyStatus) && Objects.equals(this.freeformTags, other.freeformTags) && Objects.equals(this.definedTags, other.definedTags) && super.equals((Object)other);
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.bastionType == null ? 43 : this.bastionType.hashCode());
        result = result * 59 + (this.name == null ? 43 : this.name.hashCode());
        result = result * 59 + (this.compartmentId == null ? 43 : this.compartmentId.hashCode());
        result = result * 59 + (this.targetSubnetId == null ? 43 : this.targetSubnetId.hashCode());
        result = result * 59 + (this.phoneBookEntry == null ? 43 : this.phoneBookEntry.hashCode());
        result = result * 59 + (this.staticJumpHostIpAddresses == null ? 43 : this.staticJumpHostIpAddresses.hashCode());
        result = result * 59 + (this.clientCidrBlockAllowList == null ? 43 : this.clientCidrBlockAllowList.hashCode());
        result = result * 59 + (this.maxSessionTtlInSeconds == null ? 43 : this.maxSessionTtlInSeconds.hashCode());
        result = result * 59 + (this.dnsProxyStatus == null ? 43 : this.dnsProxyStatus.hashCode());
        result = result * 59 + (this.freeformTags == null ? 43 : this.freeformTags.hashCode());
        result = result * 59 + (this.definedTags == null ? 43 : this.definedTags.hashCode());
        result = result * 59 + super.hashCode();
        return result;
    }

    @JsonPOJOBuilder(withPrefix="")
    public static class Builder {
        @JsonProperty(value="bastionType")
        private String bastionType;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="compartmentId")
        private String compartmentId;
        @JsonProperty(value="targetSubnetId")
        private String targetSubnetId;
        @JsonProperty(value="phoneBookEntry")
        private String phoneBookEntry;
        @JsonProperty(value="staticJumpHostIpAddresses")
        private List<String> staticJumpHostIpAddresses;
        @JsonProperty(value="clientCidrBlockAllowList")
        private List<String> clientCidrBlockAllowList;
        @JsonProperty(value="maxSessionTtlInSeconds")
        private Integer maxSessionTtlInSeconds;
        @JsonProperty(value="dnsProxyStatus")
        private BastionDnsProxyStatus dnsProxyStatus;
        @JsonProperty(value="freeformTags")
        private Map<String, String> freeformTags;
        @JsonProperty(value="definedTags")
        private Map<String, Map<String, Object>> definedTags;
        @JsonIgnore
        private final Set<String> __explicitlySet__ = new HashSet<String>();

        public Builder bastionType(String bastionType) {
            this.bastionType = bastionType;
            this.__explicitlySet__.add("bastionType");
            return this;
        }

        public Builder name(String name) {
            this.name = name;
            this.__explicitlySet__.add("name");
            return this;
        }

        public Builder compartmentId(String compartmentId) {
            this.compartmentId = compartmentId;
            this.__explicitlySet__.add("compartmentId");
            return this;
        }

        public Builder targetSubnetId(String targetSubnetId) {
            this.targetSubnetId = targetSubnetId;
            this.__explicitlySet__.add("targetSubnetId");
            return this;
        }

        public Builder phoneBookEntry(String phoneBookEntry) {
            this.phoneBookEntry = phoneBookEntry;
            this.__explicitlySet__.add("phoneBookEntry");
            return this;
        }

        public Builder staticJumpHostIpAddresses(List<String> staticJumpHostIpAddresses) {
            this.staticJumpHostIpAddresses = staticJumpHostIpAddresses;
            this.__explicitlySet__.add("staticJumpHostIpAddresses");
            return this;
        }

        public Builder clientCidrBlockAllowList(List<String> clientCidrBlockAllowList) {
            this.clientCidrBlockAllowList = clientCidrBlockAllowList;
            this.__explicitlySet__.add("clientCidrBlockAllowList");
            return this;
        }

        public Builder maxSessionTtlInSeconds(Integer maxSessionTtlInSeconds) {
            this.maxSessionTtlInSeconds = maxSessionTtlInSeconds;
            this.__explicitlySet__.add("maxSessionTtlInSeconds");
            return this;
        }

        public Builder dnsProxyStatus(BastionDnsProxyStatus dnsProxyStatus) {
            this.dnsProxyStatus = dnsProxyStatus;
            this.__explicitlySet__.add("dnsProxyStatus");
            return this;
        }

        public Builder freeformTags(Map<String, String> freeformTags) {
            this.freeformTags = freeformTags;
            this.__explicitlySet__.add("freeformTags");
            return this;
        }

        public Builder definedTags(Map<String, Map<String, Object>> definedTags) {
            this.definedTags = definedTags;
            this.__explicitlySet__.add("definedTags");
            return this;
        }

        public CreateBastionDetails build() {
            CreateBastionDetails model = new CreateBastionDetails(this.bastionType, this.name, this.compartmentId, this.targetSubnetId, this.phoneBookEntry, this.staticJumpHostIpAddresses, this.clientCidrBlockAllowList, this.maxSessionTtlInSeconds, this.dnsProxyStatus, this.freeformTags, this.definedTags);
            for (String explicitlySetProperty : this.__explicitlySet__) {
                model.markPropertyAsExplicitlySet(explicitlySetProperty);
            }
            return model;
        }

        @JsonIgnore
        public Builder copy(CreateBastionDetails model) {
            if (model.wasPropertyExplicitlySet("bastionType")) {
                this.bastionType(model.getBastionType());
            }
            if (model.wasPropertyExplicitlySet("name")) {
                this.name(model.getName());
            }
            if (model.wasPropertyExplicitlySet("compartmentId")) {
                this.compartmentId(model.getCompartmentId());
            }
            if (model.wasPropertyExplicitlySet("targetSubnetId")) {
                this.targetSubnetId(model.getTargetSubnetId());
            }
            if (model.wasPropertyExplicitlySet("phoneBookEntry")) {
                this.phoneBookEntry(model.getPhoneBookEntry());
            }
            if (model.wasPropertyExplicitlySet("staticJumpHostIpAddresses")) {
                this.staticJumpHostIpAddresses(model.getStaticJumpHostIpAddresses());
            }
            if (model.wasPropertyExplicitlySet("clientCidrBlockAllowList")) {
                this.clientCidrBlockAllowList(model.getClientCidrBlockAllowList());
            }
            if (model.wasPropertyExplicitlySet("maxSessionTtlInSeconds")) {
                this.maxSessionTtlInSeconds(model.getMaxSessionTtlInSeconds());
            }
            if (model.wasPropertyExplicitlySet("dnsProxyStatus")) {
                this.dnsProxyStatus(model.getDnsProxyStatus());
            }
            if (model.wasPropertyExplicitlySet("freeformTags")) {
                this.freeformTags(model.getFreeformTags());
            }
            if (model.wasPropertyExplicitlySet("definedTags")) {
                this.definedTags(model.getDefinedTags());
            }
            return this;
        }
    }
}

