/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss.x509;

import java.io.InputStream;
import java.security.PublicKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.List;
import oracle.security.crypto.util.UnsyncByteArrayInputStream;
import oracle.security.crypto.util.Utils;
import oracle.security.xmlsec.keys.retrieval.KeyRetrievalException;
import oracle.security.xmlsec.keys.retrieval.KeyRetriever;
import oracle.security.xmlsec.wss.WSSBinarySecurityToken;
import oracle.security.xmlsec.wss.WSSException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class X509BinarySecurityToken
extends WSSBinarySecurityToken {
    public static final String vt_X509v1 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v1";
    public static final String vt_X509v3 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509v3";
    public static final String vt_X509PKIPathv1 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#X509PKIPathv1";
    public static final String vt_PKCS7 = "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-x509-token-profile-1.0#PKCS7";
    boolean alreadyValidated = false;

    public X509BinarySecurityToken(Element x509BSTElement) {
        super(x509BSTElement);
    }

    public X509BinarySecurityToken(Element x509BSTElement, String systemId) {
        super(x509BSTElement, systemId);
    }

    public X509BinarySecurityToken(Document owner) {
        super(owner, vt_X509v3);
    }

    public X509BinarySecurityToken(Document owner, String valType, String encType) {
        super(owner, valType, encType);
    }

    @Override
    public void setToken(Object obj) {
        if (obj instanceof X509Certificate) {
            try {
                this.setValue(((X509Certificate)obj).getEncoded());
                this.setValueType(vt_X509v3);
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Certificate encoding exception:" + e.getMessage());
            }
        } else if (obj instanceof CertPath) {
            try {
                this.setValue(((CertPath)obj).getEncoded("PkiPath"));
                this.setValueType(vt_X509PKIPathv1);
            }
            catch (CertificateEncodingException e) {
                throw new IllegalArgumentException("Certificate encoding exception:" + e.getMessage());
            }
        } else {
            throw new IllegalArgumentException("Unexpected object type. Expecting  X509Certificate/PKCS7/PKIPath Got:" + obj.getClass().getName());
        }
    }

    public void setToken(X509Certificate cert) {
        try {
            this.setValue(cert.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Can't get certificate bytes");
            ex1.initCause(ex);
            throw ex1;
        }
        this.setValueType(cert.getVersion() == 3 ? vt_X509v3 : vt_X509v1);
    }

    public void setToken(CertPath certPath) throws CertificateEncodingException {
        this.setValue(certPath.getEncoded("PkiPath"));
        this.setValueType(vt_X509PKIPathv1);
    }

    @Override
    public Object getToken() throws WSSException {
        byte[] val = this.getValue();
        String valType = this.getValueType();
        if (valType.equals(vt_X509v3) || this.getValueType().equals(vt_X509v1)) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                return (X509Certificate)cf.generateCertificate((InputStream)new UnsyncByteArrayInputStream(val));
            }
            catch (CertificateException ex) {
                throw new WSSException(ex, WSSException.INVALID_SECURITY_TOKEN);
            }
        }
        if (valType.equals(vt_X509PKIPathv1) || valType.equals(vt_PKCS7)) {
            try {
                CertificateFactory cf = CertificateFactory.getInstance("X.509");
                return cf.generateCertPath((InputStream)new UnsyncByteArrayInputStream(val));
            }
            catch (CertificateException ex) {
                throw new WSSException(ex, WSSException.INVALID_SECURITY_TOKEN);
            }
        }
        throw new WSSException(WSSException.INVALID_SECURITY_TOKEN, "Invalid ValueType" + valType);
    }

    public X509Certificate getX509Certificate() throws WSSException {
        Object obj = this.getToken();
        if (obj instanceof X509Certificate) {
            return (X509Certificate)obj;
        }
        if (obj instanceof CertPath) {
            List<? extends Certificate> certs = ((CertPath)obj).getCertificates();
            if (certs.size() == 0) {
                throw new WSSException(WSSException.INVALID_SECURITY_TOKEN, "No certs in PKIPath");
            }
            X509Certificate cert = (X509Certificate)certs.get(0);
            return cert;
        }
        return null;
    }

    public PublicKey getPublicKey() throws WSSException {
        return this.getX509Certificate().getPublicKey();
    }

    public boolean equals(X509Certificate x509Cert) {
        try {
            return Utils.areEqual((byte[])this.getValue(), (byte[])x509Cert.getEncoded());
        }
        catch (CertificateEncodingException ex) {
            IllegalArgumentException ex1 = new IllegalArgumentException("Can't get certificate bytes");
            ex1.initCause(ex);
            throw ex1;
        }
    }

    public void validate() throws WSSException, KeyRetrievalException {
        if (this.alreadyValidated) {
            return;
        }
        Object obj = this.getToken();
        if (obj instanceof X509Certificate) {
            KeyRetriever.validateCertificate((X509Certificate)((X509Certificate)obj));
        } else if (obj instanceof CertPath) {
            KeyRetriever.validateCertificate((CertPath)((CertPath)obj));
        }
    }
}

