/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import java.io.IOException;
import javax.crypto.SecretKey;
import oracle.security.xmlsec.enc.XEEncryptedKey;
import oracle.security.xmlsec.enc.XEException;
import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLContainer;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReference;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.kerberos.KerberosBinarySecurityToken;
import oracle.security.xmlsec.wss.username.UsernameToken;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;
import oracle.security.xmlsec.wss.util.WSSUtils;
import oracle.security.xmlsec.wss.wsc.WSCDerivedKeyToken;
import oracle.security.xmlsec.wss.wsc.WSCSecurityContextToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class WSSReference
extends WSSElement
implements WSSecurityTokenReferenceType {
    public WSSReference(Element element) {
        super(element);
    }

    public WSSReference(Element element, String systemId) {
        super(element, systemId);
    }

    public WSSReference(Document owner, String uri) {
        super(owner, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Reference");
        this.setAttribute("URI", uri);
    }

    public WSSReference(Document owner, String uri, String valType) {
        this(owner, uri);
        WSSUtils.setTypeAttribute((Element)this.node, "ValueType", valType);
    }

    public void setURI(String uri) {
        this.setAttribute("URI", uri);
    }

    public String getURI() {
        return this.getAttribute("URI");
    }

    public void setValueType(String valType) {
        WSSUtils.setTypeAttribute((Element)this.node, "ValueType", valType);
    }

    public String getValueType() {
        return WSSUtils.getTypeAttribute((Element)this.node, "ValueType");
    }

    @Override
    public QName getName() {
        return new QName("Reference", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        String uri = this.getURI();
        String valType = this.getValueType();
        Node node = null;
        byte[] value = null;
        if (uri.startsWith("#") || uri.length() == 0) {
            String id;
            if (!uri.equals("#xpointer(/)") && uri.length() != 0 && (id = XMLUtils.getIdFromURI((String)uri)) != null) {
                node = XMLUtils.getElementById((Document)this.getOwnerDocument(), (String)id);
            }
        } else {
            if (!XMLUtils.getAllowAllFlag() && !XMLUtils.getExternalRefFlag()) {
                throw new WSSException("External reference cannot be used by default.To use it, change the JVM variable osdt.allow.externalRef to true, but be aware of security risks by using external references");
            }
            XMLContainer result = new XMLContainer(XMLUtils.fixURL((String)uri, (String)this.getSystemId()));
            try {
                node = result.getSubTree();
            }
            catch (IOException ex) {
                node = null;
            }
            catch (SAXException ex) {
                try {
                    value = result.toByteArray();
                }
                catch (IOException iex) {
                    value = null;
                }
            }
        }
        WSSecurityToken token = null;
        try {
            if (node != null) {
                if (node.getLocalName().equals("EncryptedKey") && node.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
                    return null;
                }
                token = WSSTokenUtils.createSecurityToken((Element)node);
            } else if (value != null && valType != null) {
                token = WSSTokenUtils.createBinarySecurityToken(null, valType, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-soap-message-security-1.0#Base64Binary", value);
            }
        }
        catch (WSSException ex) {
            throw new WSSException((Throwable)((Object)ex), WSSException.UNSUPPORTED_SECURITY_TOKEN);
        }
        if (token == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        return token;
    }

    @Override
    public Object getKey() throws WSSException {
        String id;
        String uri = this.getURI();
        Node node = null;
        if ((uri.startsWith("#") || uri.length() == 0) && !uri.equals("#xpointer(/)") && uri.length() != 0 && (id = XMLUtils.getIdFromURI((String)uri)) != null) {
            node = XMLUtils.getElementById((Document)this.getOwnerDocument(), (String)id);
        }
        WSSecurityTokenReference str = null;
        if (this.getParentNode() != null && this.getParentNode().getLocalName() != null && ((Element)this.getParentNode()).getLocalName().equals("SecurityTokenReference")) {
            str = new WSSecurityTokenReference((Element)this.getParentNode());
        }
        SecretKey key = null;
        if (node != null && node.getNodeType() == 1 && node.getLocalName().equals("EncryptedKey") && node.getNamespaceURI().equals("http://www.w3.org/2001/04/xmlenc#")) {
            XEEncryptedKey enc = new XEEncryptedKey((Element)node);
            try {
                key = enc.getKey(null);
            }
            catch (XEException e) {
                throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
            }
        } else if (node != null) {
            WSSecurityToken token = WSSTokenUtils.createSecurityToken((Element)node);
            if (token instanceof UsernameToken) {
                key = ((UsernameToken)token).deriveKey();
            } else if (token instanceof WSCDerivedKeyToken) {
                key = ((WSCDerivedKeyToken)token).deriveKey();
            } else if (token instanceof KerberosBinarySecurityToken) {
                key = ((KerberosBinarySecurityToken)token).getKey();
            } else if (token instanceof WSCSecurityContextToken) {
                key = ((WSCSecurityContextToken)token).getKey();
            }
        }
        if (key == null) {
            throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
        }
        if (str == null) {
            return key;
        }
        return str.computeImpliedDerivedKeys(key);
    }
}

