/*
 * Decompiled with CFR 0.152.
 */
package oracle.security.xmlsec.wss;

import oracle.security.xmlsec.util.QName;
import oracle.security.xmlsec.util.XMLUtils;
import oracle.security.xmlsec.wss.WSSElement;
import oracle.security.xmlsec.wss.WSSException;
import oracle.security.xmlsec.wss.WSSecurityToken;
import oracle.security.xmlsec.wss.WSSecurityTokenReferenceType;
import oracle.security.xmlsec.wss.kerberos.KerberosBinarySecurityToken;
import oracle.security.xmlsec.wss.saml.SAMLAssertionToken;
import oracle.security.xmlsec.wss.username.UsernameToken;
import oracle.security.xmlsec.wss.util.WSSTokenUtils;
import oracle.security.xmlsec.wss.x509.X509BinarySecurityToken;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class WSSEmbedded
extends WSSElement
implements WSSecurityTokenReferenceType {
    public WSSEmbedded(Element element) {
        super(element);
    }

    public WSSEmbedded(Element element, String systemId) {
        super(element, systemId);
    }

    public WSSEmbedded(Document owner) {
        super(owner, "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Embedded");
    }

    public void setSecurityToken(WSSecurityToken token) {
        WSSecurityToken tok = token;
        Document doc = this.getOwnerDocument();
        Document tDoc = token.getNode().getOwnerDocument();
        XMLUtils.removeChildren((Element)((Element)this.node), (String)"*", (String)"*");
        if (doc != tDoc) {
            if (token instanceof UsernameToken) {
                tok = new UsernameToken((Element)doc.importNode(((UsernameToken)token).getNode(), true));
            } else if (token instanceof SAMLAssertionToken) {
                tok = new SAMLAssertionToken((Element)doc.importNode(((SAMLAssertionToken)token).getNode(), true));
            } else if (token instanceof X509BinarySecurityToken) {
                tok = new X509BinarySecurityToken((Element)doc.importNode(((X509BinarySecurityToken)token).getNode(), true));
            } else if (token instanceof KerberosBinarySecurityToken) {
                tok = new KerberosBinarySecurityToken((Element)doc.importNode(((KerberosBinarySecurityToken)token).getNode(), true));
            } else {
                this.appendChild(doc.importNode(((KerberosBinarySecurityToken)token).getNode(), true));
            }
        }
        this.appendChild(tok.getNode());
    }

    @Override
    public WSSecurityToken getSecurityToken() throws WSSException {
        NodeList list = this.getChildElementsByTagName("*");
        if (list.getLength() > 0) {
            try {
                return WSSTokenUtils.createSecurityToken((Element)list.item(0));
            }
            catch (WSSException ex) {
                throw new WSSException((Throwable)((Object)ex), WSSException.UNSUPPORTED_SECURITY_TOKEN);
            }
        }
        return null;
    }

    @Override
    public QName getName() {
        return new QName("Embedded", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", null);
    }

    @Override
    public Object getKey() throws WSSException {
        throw new WSSException(WSSException.SECURITY_TOKEN_UNAVAILABLE);
    }
}

