/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.window;

import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowFocusListener;
import java.awt.event.WindowListener;
import java.awt.event.WindowStateListener;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import oracle.ide.Ide;
import oracle.ide.IdeMainWindow;
import oracle.ide.controls.GlobalMouseDispatcher;
import oracle.ide.model.Displayable;
import oracle.ide.util.GraphicsUtils;
import oracle.ideimpl.resource.IdeImplArb;
import oracle.javatools.controls.nicetable.NiceTable;
import oracle.javatools.controls.nicetable.NiceTableHeaderRenderer;
import oracle.javatools.util.AccessibleUtils;

@Deprecated
public abstract class WindowSelector {
    private static final KeyModifierTracker KEY_MODIFIER_TRACKER = KeyModifierTracker.getInstance();
    private SelectionWindow _selectionWindow;
    private EventHandler _eventHandler;
    private Displayable[] _displayables;
    private int _selectedIndex;

    protected WindowSelector() {
    }

    protected abstract Displayable[] getDisplayables();

    protected abstract void activateSelectedWindow();

    protected void selectNextItem() {
        if (this._displayables == null) {
            this._selectedIndex = 0;
            this._displayables = this.getDisplayables();
        }
        ++this._selectedIndex;
        if (this._selectedIndex >= this._displayables.length) {
            this._selectedIndex = 0;
        }
        this.updateSelection();
    }

    protected void selectPreviousItem() {
        if (this._displayables == null) {
            this._selectedIndex = 0;
            this._displayables = this.getDisplayables();
        }
        --this._selectedIndex;
        if (this._selectedIndex < 0) {
            this._selectedIndex = this._displayables.length - 1;
        }
        this.updateSelection();
    }

    protected void dispose() {
        this._displayables = null;
        if (this._selectionWindow != null) {
            Window owner = this._selectionWindow.getOwner();
            this._selectionWindow.dispose();
            this._selectionWindow = null;
            owner.removeComponentListener(this._eventHandler);
            owner.removeWindowListener(this._eventHandler);
            owner.removeWindowFocusListener(this._eventHandler);
            owner.removeWindowStateListener(this._eventHandler);
            GlobalMouseDispatcher.getInstance().removeMouseListener(this._eventHandler);
            this._eventHandler = null;
        }
    }

    protected int getSelectedIndex() {
        return this._selectedIndex;
    }

    protected int getKeyModifiers() {
        return KEY_MODIFIER_TRACKER.getModifiers();
    }

    private SelectionWindow getSelectionWindow() {
        if (this._selectionWindow == null) {
            assert (this._displayables != null);
            IdeMainWindow mainWindow = Ide.getMainWindow();
            this._eventHandler = new EventHandler(this);
            ((Component)((Object)mainWindow)).addComponentListener(this._eventHandler);
            ((Window)((Object)mainWindow)).addWindowListener(this._eventHandler);
            ((Window)((Object)mainWindow)).addWindowFocusListener(this._eventHandler);
            ((Window)((Object)mainWindow)).addWindowStateListener(this._eventHandler);
            GlobalMouseDispatcher.getInstance().addMouseListener(this._eventHandler);
            this._selectionWindow = SelectionWindow.createWindow((JFrame)((Object)mainWindow), this._displayables, this);
            this._selectionWindow.setVisible(true);
            this._selectionWindow.getContentPane().repaint();
            KEY_MODIFIER_TRACKER.setPostProcessor(this._eventHandler);
        }
        return this._selectionWindow;
    }

    private void updateSelection() {
        if (this.getKeyModifiers() == 0) {
            this.activateSelectedWindow();
        } else {
            this.getSelectionWindow().setSelectedIndex(this._selectedIndex);
        }
    }

    private void selectWindow(MouseEvent e) {
        if (this._selectionWindow != null) {
            this._selectedIndex = this._selectionWindow.getSelectedIndex(e);
            if (this._selectedIndex >= 0) {
                this.activateSelectedWindow();
            }
        }
    }

    private void selectWindow() {
        if (this._selectionWindow != null) {
            this._selectedIndex = this._selectionWindow.getSelectedIndex();
            if (this._selectedIndex >= 0) {
                this.activateSelectedWindow();
            }
        }
    }

    private static final class SelectionWindow
    extends JDialog {
        private static final Border CELL_BORDER = BorderFactory.createEmptyBorder(2, 3, 2, 3);
        private final NiceTable _table;

        public static SelectionWindow createWindow(JFrame owner, Displayable[] displayables, WindowSelector windowSelector) {
            SelectionWindow window = new SelectionWindow(owner, displayables, windowSelector);
            window.pack();
            GraphicsUtils.centerWindowOnComponent((Window)window, (Component)owner);
            return window;
        }

        private SelectionWindow(JFrame owner, Displayable[] displayables, WindowSelector windowSelector) {
            super(owner);
            assert (owner != null);
            assert (displayables.length > 1);
            SelectionTableModel model = new SelectionTableModel(displayables);
            DisplayableCellRenderer cellRenderer = new DisplayableCellRenderer();
            HeaderRenderer headerRenderer = new HeaderRenderer();
            this._table = new NiceTable((TableModel)model);
            this._table.setShowGrid(true);
            this._table.setFont(this._table.getFont().deriveFont(1));
            this._table.setDefaultRenderer(Displayable.class, (TableCellRenderer)cellRenderer);
            this._table.getTableHeader().setDefaultRenderer((TableCellRenderer)((Object)headerRenderer));
            this._table.setColumnSelectorAvailable(false);
            this._table.setRowHeight(this.measureRowHeight(cellRenderer, displayables));
            this._table.autoSizeColumnsToFit();
            Dimension dim = this._table.getPreferredSize();
            this._table.setPreferredScrollableViewportSize(dim);
            JPanel contentPanel = new JPanel(new BorderLayout());
            JScrollPane scrollPane = new JScrollPane((Component)this._table);
            scrollPane.setBorder(BorderFactory.createLineBorder(Color.black));
            contentPanel.add((Component)scrollPane, "Center");
            this.setFocusableWindowState(AccessibleUtils.isAssistiveTechnologySet());
            this.setContentPane(contentPanel);
            this.setUndecorated(true);
            this._table.getAccessibleContext().setAccessibleName(IdeImplArb.getString(94));
            this._table.setSelectionMode(0);
            this._table.getInputMap().put(KeyStroke.getKeyStroke("SPACE"), "pressed");
            this._table.getInputMap().put(KeyStroke.getKeyStroke(10, 0, true), "pressed");
            this._table.getActionMap().put("pressed", new PressAction(windowSelector));
        }

        @Override
        protected JRootPane createRootPane() {
            final SelectionWindow window = this;
            ActionListener actionListener = new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    window.setVisible(false);
                    window.dispatchEvent(new WindowEvent(window, 201));
                }
            };
            JRootPane rootPane = new JRootPane();
            KeyStroke stroke = KeyStroke.getKeyStroke(27, 0);
            rootPane.registerKeyboardAction(actionListener, stroke, 2);
            return rootPane;
        }

        void setSelectedIndex(int selectedIndex) {
            this._table.changeSelection(selectedIndex, 0, false, false);
        }

        int getSelectedIndex() {
            return this._table.getSelectedRow();
        }

        int getSelectedIndex(MouseEvent e) {
            int row = e.getComponent() == this._table ? this._table.rowAtPoint(e.getPoint()) : -1;
            this.setSelectedIndex(row);
            return row;
        }

        private int measureRowHeight(TableCellRenderer tcr, Displayable[] displayables) {
            int maxHeight = 0;
            int i = displayables.length;
            while (i-- > 0) {
                Displayable displayable = displayables[i];
                Component c = tcr.getTableCellRendererComponent((JTable)this._table, displayable, false, false, i, 0);
                int height = (int)c.getPreferredSize().getHeight();
                maxHeight = Math.max(maxHeight, height);
            }
            return maxHeight;
        }

        private static final class SelectionTableModel
        extends AbstractTableModel {
            private static final String[] columns = new String[]{IdeImplArb.getString(82)};
            private final Displayable[] _displayables;

            public SelectionTableModel(Displayable[] displayables) {
                this._displayables = displayables;
            }

            @Override
            public int getColumnCount() {
                return columns.length;
            }

            @Override
            public String getColumnName(int col) {
                return columns[col];
            }

            @Override
            public int getRowCount() {
                return this._displayables != null ? this._displayables.length : 0;
            }

            @Override
            public Object getValueAt(int row, int col) {
                return this._displayables[row];
            }

            public Class getColumnClass(int col) {
                return Displayable.class;
            }
        }

        private static final class DisplayableCellRenderer
        extends DefaultTableCellRenderer {
            private DisplayableCellRenderer() {
            }

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (value instanceof Displayable) {
                    Displayable d = (Displayable)value;
                    this.setIcon(d.getIcon());
                    this.setText(d.getShortLabel());
                    this.setToolTipText(d.getLongLabel());
                }
                this.setBorder(CELL_BORDER);
                return this;
            }
        }

        private static final class HeaderRenderer
        extends NiceTableHeaderRenderer {
            private HeaderRenderer() {
            }

            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                this.setBorder(CELL_BORDER);
                return this;
            }
        }

        private class PressAction
        extends AbstractAction {
            private final WindowSelector _windowSelector;

            public PressAction(WindowSelector windowSelector) {
                this._windowSelector = windowSelector;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                this._windowSelector.selectWindow();
            }
        }
    }

    private static final class EventHandler
    implements Runnable,
    ComponentListener,
    MouseListener,
    WindowListener,
    WindowFocusListener,
    WindowStateListener {
        private final WindowSelector _windowSelector;

        EventHandler(WindowSelector windowSelector) {
            this._windowSelector = windowSelector;
        }

        @Override
        public void run() {
            this._windowSelector.activateSelectedWindow();
        }

        @Override
        public void componentHidden(ComponentEvent e) {
            this.dispose();
        }

        @Override
        public void componentMoved(ComponentEvent e) {
            this.dispose();
        }

        @Override
        public void componentResized(ComponentEvent e) {
            this.dispose();
        }

        @Override
        public void componentShown(ComponentEvent e) {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this._windowSelector.selectWindow(e);
            this.dispose();
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseEntered(MouseEvent e) {
        }

        @Override
        public void mouseExited(MouseEvent e) {
        }

        @Override
        public void mouseReleased(MouseEvent e) {
        }

        @Override
        public void windowClosing(WindowEvent e) {
            this.dispose();
        }

        @Override
        public void windowActivated(WindowEvent e) {
        }

        @Override
        public void windowClosed(WindowEvent e) {
        }

        @Override
        public void windowDeactivated(WindowEvent e) {
        }

        @Override
        public void windowDeiconified(WindowEvent e) {
        }

        @Override
        public void windowIconified(WindowEvent e) {
        }

        @Override
        public void windowOpened(WindowEvent e) {
        }

        @Override
        public void windowLostFocus(WindowEvent e) {
            if (e.getOppositeWindow() != this._windowSelector.getSelectionWindow()) {
                this.dispose();
            }
        }

        @Override
        public void windowGainedFocus(WindowEvent e) {
            if (e.getWindow() == this._windowSelector.getSelectionWindow()) {
                this._windowSelector._selectionWindow._table.requestFocusInWindow();
            }
        }

        @Override
        public void windowStateChanged(WindowEvent e) {
            this.dispose();
        }

        private void dispose() {
            this._windowSelector.dispose();
        }
    }

    private static final class KeyModifierTracker
    implements AWTEventListener {
        private static final KeyModifierTracker INSTANCE = new KeyModifierTracker();
        private static final int MODIFIER_MASK = 910;
        private Runnable _postProcessor;
        private int _keyModifiers;

        private KeyModifierTracker() {
            Toolkit toolkit = Toolkit.getDefaultToolkit();
            toolkit.addAWTEventListener(this, 8L);
        }

        public static KeyModifierTracker getInstance() {
            return INSTANCE;
        }

        public int getModifiers() {
            return this._keyModifiers;
        }

        public void setPostProcessor(Runnable postProcessor) {
            this._postProcessor = postProcessor;
        }

        @Override
        public void eventDispatched(AWTEvent e) {
            KeyEvent keyEvent = (KeyEvent)e;
            int eventID = keyEvent.getID();
            if (eventID == 401 || eventID == 402) {
                this._keyModifiers = keyEvent.getModifiers() & 0x38E;
                if (this._keyModifiers == 0 && this._postProcessor != null && !AccessibleUtils.isAssistiveTechnologySet()) {
                    SwingUtilities.invokeLater(this._postProcessor);
                    this._postProcessor = null;
                }
            }
        }
    }
}

