/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.extension;

import java.io.File;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.ide.extension.ElementVisitor;
import javax.ide.extension.Extension;
import javax.ide.extension.spi.ExtensionLogRecord;
import javax.ide.extension.spi.ExtensionSource;
import javax.ide.extension.spi.LocationAdapter;
import javax.ide.extension.spi.MacroExpander;
import javax.ide.net.URIFactory;
import oracle.ide.ExtensionRegistry;
import oracle.ide.Ide;
import oracle.ide.extension.ExtensionProcessorContext;
import oracle.ide.extension.ExtensionProcessorPlugin;
import oracle.ide.net.URLFileSystem;
import oracle.ideimpl.extension.ExtensionManagerImpl;
import oracle.ideimpl.extension.IDEExtension;
import oracle.ideimpl.extension.LayerCache;
import oracle.ideimpl.extension.LayerReader;
import oracle.ideimpl.extension.LayerRegistrationHook;
import oracle.javatools.icons.OracleIcons;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

class LayerRegistrations {
    private static final Map<Method, LayerRegistrationHook.Tag> m2t = new HashMap<Method, LayerRegistrationHook.Tag>();
    private static final Map<Method, LayerRegistrationHook.Attr> m2a = new HashMap<Method, LayerRegistrationHook.Attr>();
    private static final Map<Method, Object> m2d = new HashMap<Method, Object>();
    private static final Map<Class<? extends Annotation>, Constructor> c2c = new HashMap<Class<? extends Annotation>, Constructor>();

    LayerRegistrations() {
    }

    public static Lookup create(IDEExtension extension, FileObject tagFo, Class<? extends Annotation> ac) {
        return new RegistrationImpl(extension, tagFo, ac).getLookup();
    }

    public static <T extends Annotation> T createAnnotation(FileObject fo, Class<T> ac) {
        long s = LayerCache.TIMERS.nanoTime();
        T r = FoInvocationHandlerImpl.create(fo, ac);
        LayerCache.TIMERS.addCurrentNanos("LReg.FO.ProxyCreation", s);
        LayerCache.TIMERS.incCount("LReg.FO.ProxyCreation.count");
        return r;
    }

    private static LayerRegistrationHook.Attr getAttr(Method method) {
        LayerRegistrationHook.Attr a;
        long s = LayerCache.TIMERS.nanoTime();
        if (!m2a.containsKey(method)) {
            a = method.getAnnotation(LayerRegistrationHook.Attr.class);
            m2a.put(method, a);
        }
        a = m2a.get(method);
        LayerCache.TIMERS.addCurrentNanos("LReg.getAnnotation", s);
        return a;
    }

    private static LayerRegistrationHook.Tag getTag(Method method) {
        LayerRegistrationHook.Tag t;
        long s = LayerCache.TIMERS.nanoTime();
        if (!m2t.containsKey(method)) {
            t = method.getAnnotation(LayerRegistrationHook.Tag.class);
            m2t.put(method, t);
        }
        t = m2t.get(method);
        LayerCache.TIMERS.addCurrentNanos("LReg.getAnnotation", s);
        return t;
    }

    private static Object getDefault(Method method) {
        Object o;
        long s = LayerCache.TIMERS.nanoTime();
        if (!m2d.containsKey(method)) {
            o = method.getDefaultValue();
            m2d.put(method, o);
        }
        o = m2d.get(method);
        LayerCache.TIMERS.addCurrentNanos("LReg.getDefautValue", s);
        return o;
    }

    private static Constructor getConstructor(Class<? extends Annotation> ac, ClassLoader loader) {
        long s = LayerCache.TIMERS.nanoTime();
        Constructor<?> c = c2c.get(ac);
        if (c == null) {
            Class<?> pc = Proxy.getProxyClass(loader, ac);
            try {
                c = pc.getConstructor(InvocationHandler.class);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                // empty catch block
            }
            c2c.put(ac, c);
            LayerCache.TIMERS.incCount("LReg.getConstructor.count");
        }
        LayerCache.TIMERS.addCurrentNanos("LReg.getConstructor", s);
        return c;
    }

    private static class RegistrationImpl
    implements Lookup.Provider {
        private ClassLoader loader;
        private MacroResolver macroResolver;
        private Lookup lookup;
        private static final Object MARKER = new Object();

        RegistrationImpl(IDEExtension extension, FileObject tagFo, Class<? extends Annotation> ac) {
            this.loader = ac.getClassLoader();
            this.macroResolver = new MacroResolver(extension, tagFo);
            Object a = RegistrationImpl.loadAnnotation(ac, tagFo, this);
            this.lookup = Lookups.fixed((Object[])new Object[]{a, extension, new LogSupportImpl(extension)});
        }

        public Lookup getLookup() {
            return this.lookup;
        }

        private static <T extends Annotation> T loadAnnotation(Class<? extends Annotation> ac, FileObject folder, RegistrationImpl reg) {
            ClassLoader cl = ac.getClassLoader();
            long s = LayerCache.TIMERS.nanoTime();
            InvocationHandlerImpl ih = new InvocationHandlerImpl(reg, folder);
            Annotation r = null;
            try {
                r = (Annotation)LayerRegistrations.getConstructor(ac, cl).newInstance(ih);
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
            LayerCache.TIMERS.addCurrentNanos("LReg.proxyCreation", s);
            LayerCache.TIMERS.incCount("LReg.proxyCreation.count");
            return (T)r;
        }

        private static Iterable<FileObject> getChildrenOnPath(RegistrationImpl reg, FileObject folder, String[] path) {
            long s = LayerCache.TIMERS.nanoTime();
            int len = path.length;
            for (int i = 0; i < len - 1; ++i) {
                if ((folder = RegistrationImpl.findChild(folder.getChildren(), path[i])) != null) continue;
                return null;
            }
            ArrayList<FileObject> result = new ArrayList<FileObject>();
            for (FileObject fo : LayerReader.getOrderedChildren(folder)) {
                if (!path[len - 1].equals((String)fo.getAttribute("#T"))) continue;
                result.add(fo);
            }
            LayerCache.TIMERS.addCurrentNanos("LReg.getChildrenOnPath", s);
            return result;
        }

        private static FileObject findChild(FileObject[] fos, String tagName) {
            for (FileObject fo : fos) {
                if (!tagName.equals((String)fo.getAttribute("#T"))) continue;
                return fo;
            }
            return null;
        }

        static Object computeAttributeValue(RegistrationImpl reg, FileObject folder, Method method) throws ClassNotFoundException {
            LayerRegistrationHook.Attr attr = LayerRegistrations.getAttr(method);
            if (attr != null) {
                Class<?> returnType = method.getReturnType();
                if (attr.tag().length > 0) {
                    Iterable<FileObject> fos = RegistrationImpl.getChildrenOnPath(reg, folder, attr.tag());
                    if (fos == null || !fos.iterator().hasNext()) {
                        return method.getDefaultValue();
                    }
                    folder = fos.iterator().next();
                }
                String aname = attr.value();
                long s = LayerCache.TIMERS.nanoTime();
                String result = (String)folder.getAttribute("A." + aname);
                LayerCache.TIMERS.addCurrentNanos("LReg.getAttribute", s);
                if (result == null) {
                    return method.getDefaultValue();
                }
                return RegistrationImpl.createValue(reg, returnType, result, null);
            }
            LayerRegistrationHook.Tag tag = LayerRegistrations.getTag(method);
            if (tag != null) {
                String[] path = tag.value();
                Iterable<FileObject> fos = RegistrationImpl.getChildrenOnPath(reg, folder, path);
                if (fos == null) {
                    return method.getDefaultValue();
                }
                Class<?> returnType = method.getReturnType();
                if (returnType.isArray()) {
                    Class<?> componentType = returnType.getComponentType();
                    LinkedList<Object> items = new LinkedList<Object>();
                    int c = 0;
                    for (FileObject fo : fos) {
                        Object val = RegistrationImpl.createValue(reg, componentType, (String)fo.getAttribute("#C"), fo);
                        items.add(val);
                        ++c;
                    }
                    Object res = Array.newInstance(returnType.getComponentType(), items.size());
                    int ci = 0;
                    for (Object e : items) {
                        Array.set(res, ci++, e);
                    }
                    return res;
                }
                Iterator<FileObject> it = fos.iterator();
                if (!it.hasNext()) {
                    return method.getDefaultValue();
                }
                FileObject fo = it.next();
                return RegistrationImpl.createValue(reg, returnType, (String)fo.getAttribute("#C"), fo);
            }
            return null;
        }

        private static Object createValue(RegistrationImpl reg, Class<?> type, String value, FileObject fo) throws ClassNotFoundException {
            long s = LayerCache.TIMERS.nanoTime();
            if (type.isAnnotation()) {
                return RegistrationImpl.loadAnnotation(type, fo, reg);
            }
            if (type.isEnum()) {
                return Enum.valueOf(type, value.toUpperCase());
            }
            if (type == Class.class) {
                return reg.loader.loadClass(value);
            }
            if (type == Boolean.class || type == Boolean.TYPE) {
                return Boolean.valueOf(value);
            }
            if (type == Integer.class || type == Integer.TYPE) {
                return Integer.valueOf(value);
            }
            if (type == Long.class || type == Long.TYPE) {
                return Long.valueOf(value);
            }
            LayerCache.TIMERS.addCurrentNanos("LReg.createAttr", s);
            s = LayerCache.TIMERS.nanoTime();
            String macroRes = reg.macroResolver.substituteMacros(value);
            if (macroRes != null) {
                macroRes = reg.macroResolver.resolveResAndUri(macroRes);
            }
            LayerCache.TIMERS.addCurrentNanos("LReg.macroResolving", s);
            return macroRes;
        }

        private static class LogSupportImpl
        extends LayerRegistrationHook.LogSupport {
            private IDEExtension extension;

            private LogSupportImpl(IDEExtension extension) {
                this.extension = extension;
            }

            @Override
            public void log(Object object, Level level, String message) {
                this.getLogger().log((LogRecord)new ExtensionLogRecord(level, message, (Extension)this.extension, this.getLineNumber(object)));
            }

            @Override
            public void log(Object object, Level level, String message, Throwable throwable) {
                this.getLogger().log((LogRecord)new ExtensionLogRecord(level, message, (Extension)this.extension, this.getLineNumber(object), throwable));
            }

            private Logger getLogger() {
                ExtensionManagerImpl em = (ExtensionManagerImpl)ExtensionManagerImpl.getExtensionRegistry();
                return em.createExtensionLogger();
            }

            private int getLineNumber(Object object) {
                InvocationHandler ih = Proxy.getInvocationHandler(object);
                if (ih instanceof InvocationHandlerImpl) {
                    FileObject fo = ((InvocationHandlerImpl)ih).folder;
                    return (Integer)fo.getAttribute("location");
                }
                throw new IllegalArgumentException("Object not created by the LayerRegistrations support");
            }
        }

        private static final class InvocationHandlerImpl
        implements InvocationHandler {
            private final RegistrationImpl reg;
            private final FileObject folder;
            private final Map<String, Object> attributes = new HashMap<String, Object>();

            public InvocationHandlerImpl(RegistrationImpl reg, FileObject folder) {
                this.reg = reg;
                this.folder = folder;
            }

            @Override
            public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (!this.attributes.containsKey(method.getName())) {
                    long s = LayerCache.TIMERS.nanoTime();
                    Object result = RegistrationImpl.computeAttributeValue(this.reg, this.folder, method);
                    LayerCache.TIMERS.addCurrentNanos("LReg.computerAttrValue", s);
                    this.attributes.put(method.getName(), result);
                }
                return this.attributes.get(method.getName());
            }
        }
    }

    private static final class FoInvocationHandlerImpl
    implements InvocationHandler {
        private static final Map<Class<? extends Annotation>, ClassInfo> c2i = new HashMap<Class<? extends Annotation>, ClassInfo>();
        private ClassInfo classInfo;
        private final FileObject folder;
        private final Map<String, Object> attributes = new HashMap<String, Object>();

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static <T extends Annotation> T create(FileObject fo, Class<T> ac) {
            ClassInfo ci = null;
            Map<Class<? extends Annotation>, ClassInfo> map = c2i;
            synchronized (map) {
                ci = c2i.get(ac);
                if (ci == null) {
                    ClassLoader loader = ac.getClassLoader();
                    ci = new ClassInfo(ac, loader);
                    c2i.put(ac, ci);
                }
            }
            FoInvocationHandlerImpl ih = new FoInvocationHandlerImpl(fo, ci);
            try {
                return (T)((Annotation)ci.getConstructor().newInstance(ih));
            }
            catch (InstantiationException e) {
                throw new IllegalStateException(e);
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e);
            }
            catch (InvocationTargetException e) {
                throw new IllegalStateException(e);
            }
        }

        private FoInvocationHandlerImpl(FileObject folder, ClassInfo ci) {
            this.folder = folder;
            this.classInfo = ci;
        }

        @Override
        public synchronized Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            String methodName = method.getName();
            if (!this.attributes.containsKey(methodName)) {
                long s = LayerCache.TIMERS.nanoTime();
                Object result = FoInvocationHandlerImpl.computeAttributeValue(this.folder, this.classInfo.getMethodInfo(methodName));
                LayerCache.TIMERS.addCurrentNanos("LReg.FO.computerAttrValue", s);
                LayerCache.TIMERS.incCount("LReg.FO.computerAttrValue.count");
                this.attributes.put(method.getName(), result);
            }
            return this.attributes.get(method.getName());
        }

        static Object computeAttributeValue(FileObject folder, ClassInfo.MethodInfo mi) throws ClassNotFoundException {
            if (mi.attrName != null) {
                long s = LayerCache.TIMERS.nanoTime();
                for (String t : mi.attrTag) {
                    if ((folder = folder.getFileObject(t, null)) != null) continue;
                    LayerCache.TIMERS.addCurrentNanos("LReg.FO.getTag.nf", s);
                    return mi.defaultValue;
                }
                LayerCache.TIMERS.addCurrentNanos("LReg.FO.getTag.f", s);
                s = LayerCache.TIMERS.nanoTime();
                String result = (String)folder.getAttribute(mi.attrName);
                LayerCache.TIMERS.addCurrentNanos("LReg.FO.getAttribute", s);
                if (result == null) {
                    return mi.defaultValue;
                }
                return FoInvocationHandlerImpl.createValue(mi, null, result);
            }
            long s = LayerCache.TIMERS.nanoTime();
            if (mi.tagValue.length > 1) {
                for (int i = 0; i < mi.tagValue.length - 1; ++i) {
                    if ((folder = folder.getFileObject(mi.tagValue[i], null)) != null) continue;
                    return mi.defaultValue;
                }
            }
            LayerCache.TIMERS.addCurrentNanos("LReg.FO.findTag", s);
            String lastElement = mi.tagValue[mi.tagValue.length - 1] + ".";
            if (mi.componentType != null) {
                FileObject tf;
                s = LayerCache.TIMERS.nanoTime();
                LinkedList<Object> items = new LinkedList<Object>();
                int i = 0;
                while ((tf = folder.getFileObject(lastElement + i, null)) != null) {
                    Object val = FoInvocationHandlerImpl.createValue(mi, tf, null);
                    items.add(val);
                    ++i;
                }
                LayerCache.TIMERS.addCurrentNanos("LReg.FO.arrayGetKids", s);
                Object res = Array.newInstance(mi.componentType, items.size());
                int ci = 0;
                s = LayerCache.TIMERS.nanoTime();
                for (Object e : items) {
                    Array.set(res, ci++, e);
                }
                LayerCache.TIMERS.addCurrentNanos("LReg.FO.arrayCreate", s);
                return res;
            }
            s = LayerCache.TIMERS.nanoTime();
            FileObject tf = folder.getFileObject(lastElement + "0", null);
            if (tf == null) {
                return mi.defaultValue;
            }
            LayerCache.TIMERS.addCurrentNanos("LReg.FO.sungleCreate.getKid", s);
            return FoInvocationHandlerImpl.createValue(mi, tf, null);
        }

        private static Object createValue(ClassInfo.MethodInfo mi, FileObject fo, String value) throws ClassNotFoundException {
            long s = LayerCache.TIMERS.nanoTime();
            Object ret = null;
            switch (mi.rType) {
                case STRING: {
                    ret = value;
                    break;
                }
                case ANNOTATION: {
                    ret = LayerRegistrations.createAnnotation(fo, mi.componentType == null ? mi.returnType : mi.componentType);
                    break;
                }
                case ENUM: {
                    ret = Enum.valueOf(mi.componentType == null ? mi.returnType : mi.componentType, value.toUpperCase());
                    break;
                }
                case BOOLEAN: {
                    ret = Boolean.valueOf(value);
                    break;
                }
                case INTEGER: {
                    ret = Integer.valueOf(value);
                    break;
                }
                case LONG: {
                    ret = Long.valueOf(value);
                }
            }
            LayerCache.TIMERS.addCurrentNanos("LReg.FO.CreateReturnValue", s);
            return ret;
        }

        private static class ClassInfo {
            private Constructor constructor;
            private Map<String, MethodInfo> methods;

            ClassInfo(Class<? extends Annotation> ac, ClassLoader loader) {
                long s = LayerCache.TIMERS.nanoTime();
                Class<?> pc = Proxy.getProxyClass(loader, ac);
                try {
                    this.constructor = pc.getConstructor(InvocationHandler.class);
                }
                catch (NoSuchMethodException e) {
                    throw new IllegalStateException(e);
                }
                Method[] annotationMethods = ac.getDeclaredMethods();
                this.methods = new HashMap<String, MethodInfo>(annotationMethods.length);
                for (Method m : annotationMethods) {
                    MethodInfo mi = new MethodInfo(m);
                    this.methods.put(m.getName(), mi);
                }
                LayerCache.TIMERS.incCount("LReg.FO.createClassInfo.count");
                LayerCache.TIMERS.addCurrentNanos("LReg.FO.createClassInfo", s);
            }

            public Constructor getConstructor() {
                return this.constructor;
            }

            public MethodInfo getMethodInfo(String methodName) {
                return this.methods.get(methodName);
            }

            private static class MethodInfo {
                private final Class returnType;
                private final Object defaultValue;
                private final Class componentType;
                private final RType rType;
                private final String attrName;
                private final String[] attrTag;
                private final String[] tagValue;

                private MethodInfo(Method m) {
                    this.returnType = m.getReturnType();
                    this.componentType = this.returnType.isArray() ? this.returnType.getComponentType() : null;
                    this.rType = RType.fromClass(this.componentType == null ? this.returnType : this.componentType);
                    this.defaultValue = m.getDefaultValue();
                    LayerRegistrationHook.Attr a = m.getAnnotation(LayerRegistrationHook.Attr.class);
                    if (a != null) {
                        this.attrName = "A." + a.value();
                        this.attrTag = a.tag();
                        this.tagValue = null;
                    } else {
                        LayerRegistrationHook.Tag t = m.getAnnotation(LayerRegistrationHook.Tag.class);
                        if (t != null) {
                            this.tagValue = t.value();
                            this.attrName = null;
                            this.attrTag = null;
                        } else {
                            throw new IllegalStateException("Method : " + m + "not annotated with either @Attr or @Tag");
                        }
                    }
                }
            }

            private static enum RType {
                STRING,
                BOOLEAN,
                INTEGER,
                LONG,
                ANNOTATION,
                ENUM;


                public static RType fromClass(Class<?> type) {
                    if (String.class == type) {
                        return STRING;
                    }
                    if (type.isAnnotation()) {
                        return ANNOTATION;
                    }
                    if (type.isEnum()) {
                        return ENUM;
                    }
                    if (type == Boolean.class || type == Boolean.TYPE) {
                        return BOOLEAN;
                    }
                    if (type == Integer.class || type == Integer.TYPE) {
                        return INTEGER;
                    }
                    if (type == Long.class || type == Long.TYPE) {
                        return LONG;
                    }
                    throw new IllegalStateException("Unhandled type " + type);
                }
            }
        }
    }

    private static class MacroResolver
    extends MacroExpander {
        private static final String ENV = "env:";
        private static final String ORACLEICONS = "OracleIcons.";
        private Logger logger = Logger.getLogger(MacroResolver.class.getName());
        private IDEExtension extension;
        private LocationAdapter locator;
        ExtensionProcessorContext ecp = new ExtensionProcessorContext(){

            @Override
            public String getExtensionId() {
                return extension.getID();
            }
        };
        private static Map<String, Map<String, String>> _macroMapsByExtension = new HashMap<String, Map<String, String>>();

        MacroResolver(IDEExtension extension, FileObject tagFO) {
            this.extension = extension;
            this.locator = new LayerReader.FakeLocator(tagFO, extension.getSource().getManifestURI().toString());
        }

        private Logger getLogger() {
            return this.logger;
        }

        protected String getMacroValue(String macroName) {
            String result;
            String var;
            String value;
            if ("ide.install.dir".equals(macroName)) {
                return Ide.getOracleHomeDirectory();
            }
            if (macroName != null && macroName.startsWith(ENV) && macroName.length() > ENV.length() && (value = System.getenv(var = macroName.substring(ENV.length()))) != null) {
                return value;
            }
            if (macroName != null && macroName.startsWith(ORACLEICONS) && macroName.length() > ORACLEICONS.length()) {
                String fieldName = macroName.substring(ORACLEICONS.length());
                try {
                    String basePath = "res:/" + OracleIcons.class.getPackage().getName().replace('.', '/') + "/";
                    Field f = OracleIcons.class.getField(fieldName);
                    if (f != null) {
                        return basePath + f.get(null);
                    }
                }
                catch (NoSuchFieldException e) {
                    this.getLogger().log((LogRecord)new ExtensionLogRecord(this.locator, Level.WARNING, "No icon called '" + fieldName + "' exists in OracleIcons."));
                    return null;
                }
                catch (Exception e) {
                    ExtensionLogRecord record = new ExtensionLogRecord(this.locator, Level.SEVERE, "An exception occurred retrieving OracleIcons." + fieldName);
                    record.setThrown(e);
                    this.getLogger().log((LogRecord)record);
                    return null;
                }
            }
            if (macroName.startsWith("ide.extension") && this.extension != null && (result = MacroResolver.getMacroMap((Extension)this.extension).get(macroName)) != null) {
                return result;
            }
            ExtensionManagerImpl emi = (ExtensionManagerImpl)ExtensionRegistry.getExtensionRegistry();
            if (this.extension != null && !emi.getProcessorPlugins().isEmpty()) {
                String baseMacro = macroName;
                int colon = baseMacro.indexOf(58);
                if (colon > 0) {
                    baseMacro = baseMacro.substring(0, colon);
                }
                for (ExtensionProcessorPlugin p : emi.getProcessorPlugins()) {
                    try {
                        Set<String> supported = p.getSupportedMacros(this.ecp);
                        if (!supported.contains(baseMacro)) continue;
                        emi.getLogger().log(Level.CONFIG, "Macro " + macroName + " was expanded by " + p.getClass());
                        return p.expandValue(this.ecp, macroName);
                    }
                    catch (Throwable t) {
                        ExtensionLogRecord r = new ExtensionLogRecord(this.locator, Level.SEVERE, "Exception in " + p.getClass());
                        r.setThrown(t);
                        this.getLogger().log((LogRecord)r);
                    }
                }
            }
            return this.getMacroOriginal(macroName);
        }

        String resolveResAndUri(String text) {
            if (text.startsWith("res:")) {
                return this.resolveResource(text);
            }
            if (text.startsWith("uri:")) {
                return this.resolveUri(text);
            }
            return text;
        }

        protected String getMacroOriginal(String macroName) {
            String resClass = this.extension.getRsBundleClass();
            ResourceBundle bundle = null;
            if (resClass != null) {
                bundle = ElementVisitor.getResourceBundleProvider().getResourceBundle(resClass, Locale.getDefault(), this.extension.getClassLoader());
            }
            if (bundle != null) {
                try {
                    return bundle.getString(macroName);
                }
                catch (MissingResourceException mre) {
                    this.getLogger().log((LogRecord)new ExtensionLogRecord(this.locator, Level.WARNING, mre.getLocalizedMessage().replaceAll("'", "''")));
                    return null;
                }
            }
            if (resClass == null) {
                this.getLogger().log((LogRecord)new ExtensionLogRecord(this.locator, Level.SEVERE, "Unrecognized macro '" + macroName + "' and no rsbundle-class attribute specified."));
            } else {
                this.getLogger().log((LogRecord)new ExtensionLogRecord(this.locator, Level.SEVERE, "Unable to find resource bundle class: " + resClass));
            }
            return null;
        }

        private static Map<String, String> getMacroMap(Extension ext) {
            Map<String, String> macros = _macroMapsByExtension.get(ext.getID());
            if (macros == null) {
                macros = new HashMap<String, String>();
                ExtensionRegistry er = ExtensionRegistry.getExtensionRegistry();
                File installDir = er.getInstallDirectory(ext);
                if (installDir != null) {
                    macros.put("ide.extension.install.home", installDir.getAbsolutePath());
                }
                macros.put("ide.extension.user.home", URLFileSystem.getPlatformPathName((URL)er.getSystemDirectory(ext.getID(), ext.getVersion())));
                _macroMapsByExtension.put(ext.getID(), macros);
            }
            return macros;
        }

        private String resolveUri(String text) {
            if (text.length() > 4) {
                String uriString = text.substring(4);
                ExtensionSource source = this.extension.getSource();
                URI resolved = source.resolvePath((Extension)this.extension, uriString);
                if (resolved == null) {
                    this.getLogger().log((LogRecord)new ExtensionLogRecord(this.locator, Level.WARNING, "Unresolved uri: '" + uriString + "'."));
                    return text;
                }
                return "uri:" + resolved.toString();
            }
            this.getLogger().log((LogRecord)new ExtensionLogRecord(this.locator, Level.SEVERE, "No uri specified."));
            return text;
        }

        private String resolveResource(String text) {
            if (text.length() > 4) {
                String resString = text.substring(4);
                if (resString.charAt(0) == '/' && resString.length() > 1) {
                    ClassLoader cl = this.extension.getClassLoader();
                    URL resUrl = cl.getResource(resString.substring(1));
                    if (resUrl != null) {
                        URI uri = URIFactory.newURI((URL)resUrl);
                        return "uri:" + uri.toString();
                    }
                } else {
                    URL resUrl;
                    ResourceBundle bundle = ElementVisitor.getResourceBundleProvider().getResourceBundle(this.extension.getRsBundleClass(), Locale.getDefault(), this.extension.getClassLoader());
                    if (bundle != null && (resUrl = bundle.getClass().getResource(resString)) != null) {
                        URI uri = URIFactory.newURI((URL)resUrl);
                        return "uri:" + uri.toString();
                    }
                }
                this.getLogger().log((LogRecord)new ExtensionLogRecord(this.locator, Level.SEVERE, "Resource not found: '" + resString + "'."));
                return text;
            }
            this.getLogger().log((LogRecord)new ExtensionLogRecord(this.locator, Level.SEVERE, "No resource specified"));
            return text;
        }
    }
}

