/*
 * Decompiled with CFR 0.152.
 */
package oracle.ideimpl.editor;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.ide.util.MetaClass;
import javax.swing.tree.DefaultMutableTreeNode;
import oracle.ide.Context;
import oracle.ide.ExtensionRegistry;
import oracle.ide.editor.EditorAddin;
import oracle.ide.model.Element;
import oracle.ide.model.Node;
import oracle.ide.util.Assert;
import oracle.ideimpl.editor.DeclarativeDynamicEditorAddin;
import oracle.ideimpl.editor.DeclarativeEditorAddin;
import oracle.ideimpl.editor.DynamicEditorHookRegistration;
import oracle.ideimpl.editor.EditorHook;
import oracle.ideimpl.editor.EditorHookRegistration;
import oracle.javatools.util.WeakCache;

public final class EditorAddinRegistry {
    private final Map<Class, List<EditorAddin>> _registry = new HashMap<Class, List<EditorAddin>>();
    private final List<EditorAddin> _dynamicRegistry = new ArrayList<EditorAddin>();
    private final WeakCache<String, EditorAddin> _declarativeRegistryMap = new WeakCache();
    private final Map<String, EditorAddin> _registeredAddins = new HashMap<String, EditorAddin>();
    private final Set<Class> _registeredEditors = new HashSet<Class>();
    private final Set<Class> _registeredClasses = new HashSet<Class>();

    void unregister(EditorAddin editorAddin) {
        for (List<EditorAddin> addinList : this._registry.values()) {
            addinList.remove(editorAddin);
        }
        for (Class c : this._registry.keySet()) {
            List<EditorAddin> addinList = this._registry.get(c);
            if (!addinList.isEmpty()) continue;
            this._registry.remove(c);
        }
        this.removeFromRegistry(editorAddin);
    }

    void extend(EditorAddin editorAddin, Class[] types) {
        boolean isDefault = editorAddin.isDefault();
        for (Class type : types) {
            List<EditorAddin> list = this._registry.get(type);
            if (list == null) {
                list = new ArrayList<EditorAddin>();
                list.add(editorAddin);
                this._registry.put(type, list);
                this._registeredClasses.add(type);
                continue;
            }
            if (list.contains(editorAddin)) continue;
            if (isDefault) {
                list.add(0, editorAddin);
                continue;
            }
            list.add(editorAddin);
        }
        this.addToRegistry(editorAddin, editorAddin.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void registerDynamic(EditorAddin editorAddin) {
        List<EditorAddin> list = this._dynamicRegistry;
        synchronized (list) {
            this._dynamicRegistry.add(editorAddin);
        }
        this.addToRegistry(editorAddin, editorAddin.getClass().getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregisterDynamic(EditorAddin editorAddin) {
        List<EditorAddin> list = this._dynamicRegistry;
        synchronized (list) {
            this._dynamicRegistry.remove(editorAddin);
        }
        this.removeFromRegistry(editorAddin);
    }

    @Deprecated
    List<EditorAddin> getStaticAddins(Class elementClass) {
        return this.getAddinsImpl(elementClass, null, this.declarativeAddinsFrom(this.declarativeEditors(elementClass)), Collections.emptyList(), null);
    }

    List<EditorAddin> getStaticAddins(String elementClassName) {
        return this.declarativeAddinsFrom(this.declarativeEditors(elementClassName));
    }

    @Deprecated
    Set<Class> getStaticElementTypes() {
        return Collections.unmodifiableSet(this._registeredClasses);
    }

    Collection<String> getStaticElementClassNames() {
        LinkedHashSet<String> elementClassNames = new LinkedHashSet<String>();
        for (EditorHookRegistration editor : EditorAddinRegistry.declarativeEditors()) {
            for (MetaClass nodeClass : editor.getNodeClasses()) {
                elementClassNames.add(nodeClass.getClassName());
            }
        }
        return elementClassNames;
    }

    public List<EditorAddin> getAddins(Context context) {
        Node element = context.getNode();
        Class<?> elementClass = null;
        if (element != null) {
            elementClass = element.getClass();
        }
        List<EditorAddin> addins = this.getAddinsImpl(elementClass, element, this.declarativeAddinsFrom(this.declarativeEditors(elementClass)), this.declarativeDynamicAddinsFrom(this.declarativeDynamicEditors(context)), context);
        this.combineEditorAddinWithID(addins, context);
        return addins;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<EditorAddin, Float> map(Element element, Context context, List<EditorAddin> addins) {
        HashMap<EditorAddin, Float> map = new HashMap<EditorAddin, Float>();
        for (int i = 0; i < addins.size(); ++i) {
            EditorAddin editorAddin = addins.get(i);
            if (editorAddin instanceof DeclarativeDynamicEditorAddin || editorAddin instanceof DeclarativeEditorAddin && !Float.isNaN(editorAddin.getEditorWeight(element))) {
                float declDynWeight = editorAddin.getEditorWeight(element);
                map.put(editorAddin, Float.valueOf(declDynWeight));
                continue;
            }
            map.put(editorAddin, Float.valueOf((float)(0.5 - (double)i * 0.01)));
        }
        List<EditorAddin> list = this._dynamicRegistry;
        synchronized (list) {
            for (EditorAddin editorAddin : this._dynamicRegistry) {
                if (map.containsKey(editorAddin)) continue;
                float editorWeight = Float.NaN;
                if (context != null) {
                    editorWeight = editorAddin.getEditorWeight(element, context);
                }
                if (Float.isNaN(editorWeight)) {
                    editorWeight = editorAddin.getEditorWeight(element);
                }
                if (Float.isNaN(editorWeight)) continue;
                map.put(editorAddin, Float.valueOf(editorWeight));
            }
        }
        return map;
    }

    private List<EditorAddin> merge(List<EditorAddin> staticAddins, List<EditorAddin> declarativeAddins) {
        ArrayList<EditorAddin> merged = new ArrayList<EditorAddin>(staticAddins);
        EditorAddin defaultEditor = null;
        for (EditorAddin e : declarativeAddins) {
            if (e.isDefault() && defaultEditor == null) {
                defaultEditor = e;
            }
            if (merged.contains(e)) {
                merged.remove(e);
            }
            merged.add(0, e);
        }
        if (defaultEditor != null) {
            merged.remove(defaultEditor);
            merged.add(0, defaultEditor);
        }
        ArrayList<String> editorNames = new ArrayList<String>();
        ArrayList<EditorAddin> remove = new ArrayList<EditorAddin>();
        for (EditorAddin e : merged) {
            String editorName = this.editorClassNameFrom(e);
            if (editorNames.contains(editorName)) {
                remove.add(e);
                continue;
            }
            editorNames.add(editorName);
            if (this.isDeclarative(e) || !e.isDefault() || defaultEditor != null) continue;
            defaultEditor = e;
        }
        if (defaultEditor != null) {
            merged.remove(defaultEditor);
            merged.add(0, defaultEditor);
        }
        if (!remove.isEmpty()) {
            merged.removeAll(remove);
        }
        return merged;
    }

    private String editorClassNameFrom(EditorAddin e) {
        if (e instanceof DeclarativeEditorAddin) {
            return ((DeclarativeEditorAddin)e).getEditorMetaClass().getClassName();
        }
        if (e instanceof DeclarativeDynamicEditorAddin) {
            return ((DeclarativeDynamicEditorAddin)e).getEditorMetaClass().getClassName();
        }
        return e.getEditorClass().getName();
    }

    private boolean isDeclarative(EditorAddin e) {
        return e instanceof DeclarativeEditorAddin || e instanceof DeclarativeDynamicEditorAddin;
    }

    List<EditorAddin> getAddins(Element element) {
        Assert.startTiming((String)(this.getClass().getName() + ".getAddins"), null, (boolean)false);
        List<EditorAddin> addins = this.getAddinsImpl(element.getClass(), element, this.declarativeAddinsFrom(this.declarativeEditors(element.getClass())), Collections.emptyList(), null);
        Assert.endTiming((String)(this.getClass().getName() + ".getAddins"), (String)("Building the list of addins for " + element.getShortLabel()), (String)"  ", (boolean)false);
        return addins;
    }

    private List<EditorAddin> getAddinsImpl(Class elementClass, Element element, List<EditorAddin> declarativeAddinsForElementClass, List<EditorAddin> dynamicDeclarativeAddins, Context context) {
        List<EditorAddin> addinList;
        List<EditorAddin> staticAddins;
        if (element != null) {
            element.getAttributes();
        }
        if ((staticAddins = this.getStaticAddinsImpl(elementClass)).isEmpty() && declarativeAddinsForElementClass.isEmpty()) {
            staticAddins = this.getSuperclassStaticAddinsImpl(elementClass);
        }
        if (declarativeAddinsForElementClass.isEmpty() && dynamicDeclarativeAddins.isEmpty()) {
            addinList = staticAddins;
        } else {
            ArrayList<EditorAddin> allDeclarativeAddins = new ArrayList<EditorAddin>();
            allDeclarativeAddins.addAll(declarativeAddinsForElementClass);
            allDeclarativeAddins.addAll(dynamicDeclarativeAddins);
            addinList = this.merge(staticAddins, allDeclarativeAddins);
        }
        final Map<EditorAddin, Float> addins = this.map(element, context, addinList);
        addinList = new ArrayList<EditorAddin>(addins.keySet());
        Collections.sort(addinList, new Comparator<EditorAddin>(){

            @Override
            public int compare(EditorAddin o1, EditorAddin o2) {
                float value1 = ((Float)addins.get(o1)).floatValue();
                float value2 = ((Float)addins.get(o2)).floatValue();
                return Float.compare(value2, value1);
            }
        });
        return addinList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean hasAddins(Element element, Context context) {
        boolean ret = false;
        if (this.hasStaticAddins(element) | this.hasSuperclassStaticAddins(element) | !this.declarativeEditors(element.getClass()).isEmpty()) {
            ret = true;
        } else {
            List<EditorAddin> list = this._dynamicRegistry;
            synchronized (list) {
                for (EditorAddin editorAddin : this._dynamicRegistry) {
                    float editorWeight = Float.NaN;
                    if (context != null) {
                        editorWeight = editorAddin.getEditorWeight(element, context);
                    }
                    if (Float.isNaN(editorWeight)) {
                        editorWeight = editorAddin.getEditorWeight(element);
                    }
                    if (Float.isNaN(editorWeight)) continue;
                    ret = true;
                    break;
                }
            }
        }
        return ret;
    }

    private boolean hasStaticAddins(Element element) {
        Class<?> cls = element.getClass();
        List<EditorAddin> list = this._registry.get(cls);
        return list != null;
    }

    private boolean hasSuperclassStaticAddins(Element element) {
        boolean ret = false;
        Class<?> cls = element.getClass();
        List<EditorAddin> list = this._registry.get(cls);
        for (Class<?> superCls = cls.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
            list = this._registry.get(superCls);
            if (list == null || list.size() == 0) continue;
            ret = true;
            break;
        }
        return ret;
    }

    List<EditorAddin> declarativeAddinsFrom(List<EditorHookRegistration> editors) {
        ArrayList<EditorAddin> addins = new ArrayList<EditorAddin>();
        for (EditorHookRegistration editor : editors) {
            addins.add(new DeclarativeEditorAddin(editor));
        }
        return addins;
    }

    private List<EditorHookRegistration> declarativeEditors(Class cls) {
        String className = "";
        if (cls != null) {
            className = cls.getName();
        }
        return this.declarativeEditors(className);
    }

    List<EditorHookRegistration> declarativeEditors(String className) {
        ArrayList<EditorHookRegistration> editors = new ArrayList<EditorHookRegistration>();
        block0: for (EditorHookRegistration editor : EditorAddinRegistry.declarativeEditors()) {
            for (MetaClass nodeClass : editor.getNodeClasses()) {
                if (!nodeClass.getClassName().equals(className) || editors.contains(editor)) continue;
                editors.add(editor);
                continue block0;
            }
        }
        return editors;
    }

    private static Collection<EditorHookRegistration> declarativeEditors() {
        return EditorAddinRegistry.editorHook().getRegisteredEditors();
    }

    private List<EditorAddin> declarativeDynamicAddinsFrom(List<DynamicEditorHookRegistration> editors) {
        ArrayList<EditorAddin> addins = new ArrayList<EditorAddin>();
        for (DynamicEditorHookRegistration editor : editors) {
            addins.add(new DeclarativeDynamicEditorAddin(editor));
        }
        return addins;
    }

    private List<DynamicEditorHookRegistration> declarativeDynamicEditors(Context context) {
        ArrayList<DynamicEditorHookRegistration> dynamicEditorsForContext = new ArrayList<DynamicEditorHookRegistration>();
        for (DynamicEditorHookRegistration dynamicEditorRegistration : EditorAddinRegistry.declarativeDynamicEditors()) {
            if (!dynamicEditorRegistration.evaluateRule(context)) continue;
            dynamicEditorsForContext.add(dynamicEditorRegistration);
        }
        return dynamicEditorsForContext;
    }

    private static Collection<DynamicEditorHookRegistration> declarativeDynamicEditors() {
        return EditorAddinRegistry.editorHook().getRegisteredDynamicEditors();
    }

    private static EditorHook editorHook() {
        ExtensionRegistry registry = ExtensionRegistry.getExtensionRegistry();
        return (EditorHook)registry.getHook(EditorHook.NAME);
    }

    private List<EditorAddin> getStaticAddinsImpl(Class cls) {
        List<EditorAddin> addins = this._registry.get(cls);
        if (addins == null) {
            addins = Collections.emptyList();
        }
        return addins;
    }

    private List<EditorAddin> getSuperclassStaticAddinsImpl(Class cls) {
        List<EditorAddin> addins = null;
        if (cls == null) {
            return Collections.emptyList();
        }
        for (Class superCls = cls.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
            addins = this._registry.get(superCls);
            if (addins == null || addins.size() == 0) continue;
            this._registry.put(cls, addins);
            break;
        }
        if (addins == null) {
            addins = Collections.emptyList();
        }
        return addins;
    }

    Class getRegisteredElementType(Class cls) {
        if (this._registry.containsKey(cls)) {
            return cls;
        }
        for (Class superCls = cls.getSuperclass(); superCls != null; superCls = superCls.getSuperclass()) {
            if (!this._registry.containsKey(superCls)) continue;
            return superCls;
        }
        return null;
    }

    void dumpRegisteredEditors() {
        HashMap allNodeTypes = new HashMap();
        System.out.println("-------------------- Registered editors");
        for (Class nodeClass : this._registry.keySet()) {
            System.out.println(nodeClass.getName());
            List<EditorAddin> addins = this._registry.get(nodeClass);
            for (int i = 0; i < addins.size(); ++i) {
                EditorAddin editorAddin = addins.get(i);
                Class editorClass = editorAddin.getEditorClass();
                System.out.println("    " + editorAddin.getMenuSpecification().label + " = " + editorClass.getName());
            }
            this.buildNodeTree(nodeClass, allNodeTypes);
        }
        System.out.println("-------------------- Node hierarchy");
        DefaultMutableTreeNode root = (DefaultMutableTreeNode)allNodeTypes.get(Object.class);
        this.recDumpTree(root, "");
    }

    private DefaultMutableTreeNode buildNodeTree(Class cls, HashMap allNodeTypes) {
        DefaultMutableTreeNode node = (DefaultMutableTreeNode)allNodeTypes.get(cls);
        if (node == null) {
            node = new DefaultMutableTreeNode(cls);
            if (cls != Object.class) {
                Class superclass = cls.getSuperclass();
                DefaultMutableTreeNode parentNode = this.buildNodeTree(superclass, allNodeTypes);
                parentNode.add(node);
            }
            allNodeTypes.put(cls, node);
        }
        return node;
    }

    private void recDumpTree(DefaultMutableTreeNode parent, String level) {
        Class cls = (Class)parent.getUserObject();
        System.out.println(level + cls.getName());
        int childCount = parent.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)parent.getChildAt(i);
            this.recDumpTree(child, level + "  ");
        }
    }

    private void addToRegistry(EditorAddin editorAddin, String editorAddinClassName) {
        this._registeredAddins.put(editorAddinClassName, editorAddin);
        Class editorClass = editorAddin.getEditorClass();
        this._registeredEditors.add(editorClass);
    }

    private void removeFromRegistry(EditorAddin editorAddin) {
        Class<?> editorAddinClass = editorAddin.getClass();
        String editorAddinClassName = editorAddinClass.getName();
        this._registeredAddins.remove(editorAddinClassName);
        Class editorClass = editorAddin.getEditorClass();
        this._registeredEditors.remove(editorClass);
    }

    public EditorAddin getRegisteredEditorAddin(String editorAddinClassName) {
        EditorAddin editorAddin = this._registeredAddins.get(editorAddinClassName);
        if (editorAddin == null) {
            editorAddin = (EditorAddin)this._declarativeRegistryMap.get((Object)editorAddinClassName);
        }
        return editorAddin;
    }

    boolean isEditorRegistered(Class editorClass) {
        boolean registered = this._registeredEditors.contains(editorClass);
        if (registered) {
            return true;
        }
        Collection<EditorHookRegistration> editors = EditorAddinRegistry.declarativeEditors();
        for (EditorHookRegistration editor : editors) {
            String editorType;
            String registeredEditorType = editor.getEditorClass().getClassName();
            if (!registeredEditorType.equals(editorType = editorClass.getName())) continue;
            return true;
        }
        Collection<DynamicEditorHookRegistration> dynamicEditors = EditorAddinRegistry.declarativeDynamicEditors();
        for (DynamicEditorHookRegistration editor : dynamicEditors) {
            String editorType;
            String registeredEditorType = editor.getEditorClass().getClassName();
            if (!registeredEditorType.equals(editorType = editorClass.getName())) continue;
            return true;
        }
        return false;
    }

    EditorAddin getEditorAddin(Class editorAddinClass) {
        EditorAddin addin;
        if (this.isEditorRegistered(editorAddinClass) && (addin = this._registeredAddins.get(editorAddinClass)) != null && addin.getEditorClass() == editorAddinClass) {
            return addin;
        }
        return null;
    }

    private void combineEditorAddinWithID(Collection<EditorAddin> editorAddins, Context context) {
        for (EditorAddin editorAddin : editorAddins) {
            this._declarativeRegistryMap.put((Object)EditorAddinRegistry.createDeclarativeEditorAddinUniqueID(editorAddin), (Object)editorAddin);
        }
    }

    public static String createDeclarativeEditorAddinUniqueID(EditorAddin editorAddin) {
        Object uniqueName = null;
        if (editorAddin instanceof DeclarativeEditorAddin) {
            DeclarativeEditorAddin dea = (DeclarativeEditorAddin)editorAddin;
            uniqueName = dea.getClass().getName() + "-" + dea.getEditorMetaClass().getClassName();
        } else if (editorAddin instanceof DeclarativeDynamicEditorAddin) {
            DeclarativeDynamicEditorAddin dea = (DeclarativeDynamicEditorAddin)editorAddin;
            uniqueName = dea.getClass().getName() + "-" + dea.getEditorMetaClass().getClassName();
        } else {
            uniqueName = editorAddin.getClass().getName();
        }
        return uniqueName;
    }
}

